/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.op;

import com.xiaojukeji.kafka.manager.common.bizenum.KafkaFileEnum;
import com.xiaojukeji.kafka.manager.common.constant.Constant;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.pojo.ClusterDO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.ClusterTaskDO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.KafkaFileDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.task.ClusterTaskKafkaFilesVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.task.ClusterTaskMetadataVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.task.ClusterTaskStatusVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.task.ClusterTaskVO;
import com.xiaojukeji.kafka.manager.common.utils.JsonUtils;
import com.xiaojukeji.kafka.manager.common.utils.SpringTool;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.kcm.ClusterTaskService;
import com.xiaojukeji.kafka.manager.kcm.KafkaFileService;
import com.xiaojukeji.kafka.manager.kcm.common.bizenum.ClusterTaskTypeEnum;
import com.xiaojukeji.kafka.manager.kcm.common.entry.ao.ClusterTaskStatus;
import com.xiaojukeji.kafka.manager.kcm.common.entry.dto.AbstractClusterTaskDTO;
import com.xiaojukeji.kafka.manager.kcm.common.entry.dto.ClusterTaskActionDTO;
import com.xiaojukeji.kafka.manager.service.cache.PhysicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.service.ClusterService;
import com.xiaojukeji.kafka.manager.web.converters.ClusterTaskModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"OP-Cluster\u5347\u7ea7\u90e8\u7f72\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/op/"})
public class OpClusterTaskController {
    @Autowired
    private ClusterService clusterService;
    @Autowired
    private KafkaFileService kafkaFileService;
    @Autowired
    private ClusterTaskService clusterTaskService;

    @ApiOperation(value="\u96c6\u7fa4\u4efb\u52a1\u7c7b\u578b", notes="")
    @RequestMapping(value={"cluster-tasks/enums"}, method={RequestMethod.GET})
    @ResponseBody
    public Result getClusterTaskEnums() {
        HashMap<String, Object> enumMap = new HashMap<String, Object>(1);
        enumMap.put("taskType", JsonUtils.toJson(ClusterTaskTypeEnum.class));
        return new Result(enumMap);
    }

    @ApiOperation(value="\u521b\u5efa\u96c6\u7fa4\u4efb\u52a1", notes="")
    @RequestMapping(value={"cluster-tasks"}, method={RequestMethod.POST})
    @ResponseBody
    public Result createTask(@RequestBody AbstractClusterTaskDTO dto) {
        dto.setKafkaRoleBrokerHostMap(PhysicalClusterMetadataManager.getKafkaRoleBrokerHostMap((Long)dto.getClusterId()));
        dto.setKafkaFileBaseUrl(this.kafkaFileService.getDownloadBaseUrl());
        return this.clusterTaskService.createTask(dto, SpringTool.getUserName());
    }

    @ApiOperation(value="\u96c6\u7fa4\u4efb\u52a1\u5217\u8868", notes="")
    @RequestMapping(value={"cluster-tasks"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<ClusterTaskVO>> getTaskList() {
        List doList = this.clusterTaskService.listAll();
        if (ValidateUtils.isNull((Object)doList)) {
            return Result.buildFrom((ResultStatus)ResultStatus.MYSQL_ERROR);
        }
        Map<Long, String> clusterNameMap = this.clusterService.listAll().stream().collect(Collectors.toMap(ClusterDO::getId, ClusterDO::getClusterName, (key1, key2) -> key2));
        return new Result((Object)ClusterTaskModelConverter.convert2ClusterTaskVOList((List)doList, clusterNameMap));
    }

    @ApiOperation(value="\u89e6\u53d1\u96c6\u7fa4\u4efb\u52a1", notes="")
    @RequestMapping(value={"cluster-tasks"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result executeTask(@RequestBody ClusterTaskActionDTO dto) {
        return Result.buildFrom((ResultStatus)this.clusterTaskService.executeTask(dto.getTaskId(), dto.getAction(), dto.getHostname()));
    }

    @ApiOperation(value="\u96c6\u7fa4\u4efb\u52a1\u5143\u4fe1\u606f")
    @RequestMapping(value={"cluster-tasks/{taskId}/metadata"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<ClusterTaskMetadataVO> getTaskMetadata(@PathVariable Long taskId) {
        ClusterTaskDO clusterTaskDO = this.clusterTaskService.getById(taskId);
        if (ValidateUtils.isNull((Object)clusterTaskDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.RESOURCE_NOT_EXIST);
        }
        return new Result((Object)ClusterTaskModelConverter.convert2ClusterTaskMetadataVO((ClusterTaskDO)clusterTaskDO, (ClusterDO)this.clusterService.getById(clusterTaskDO.getClusterId()), (KafkaFileDO)this.kafkaFileService.getFileByFileName(clusterTaskDO.getServerProperties())));
    }

    @ApiOperation(value="\u96c6\u7fa4\u4efb\u52a1\u72b6\u6001", notes="\u6574\u4e2a\u4efb\u52a1\u7684\u72b6\u6001")
    @RequestMapping(value={"cluster-tasks/{taskId}/status"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<ClusterTaskStatusVO> getTaskStatus(@PathVariable Long taskId) {
        Result dtoResult = this.clusterTaskService.getTaskStatus(taskId);
        if (!Constant.SUCCESS.equals(dtoResult.getCode())) {
            return new Result(Integer.valueOf(dtoResult.getCode()), dtoResult.getMessage());
        }
        return new Result((Object)ClusterTaskModelConverter.convert2ClusterTaskStatusVO((ClusterTaskStatus)((ClusterTaskStatus)dtoResult.getData()), (Map)PhysicalClusterMetadataManager.getBrokerHostKafkaRoleMap((Long)((ClusterTaskStatus)dtoResult.getData()).getClusterId())));
    }

    @ApiOperation(value="\u96c6\u7fa4\u4efb\u52a1\u65e5\u5fd7", notes="\u5177\u4f53\u673a\u5668\u7684\u65e5\u5fd7")
    @RequestMapping(value={"cluster-tasks/{taskId}/log"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<String> getTaskLog(@PathVariable Long taskId, @RequestParam(value="hostname") String hostname) {
        return this.clusterTaskService.getTaskLog(taskId, hostname);
    }

    @ApiOperation(value="\u6587\u4ef6\u9009\u62e9", notes="")
    @RequestMapping(value={"cluster-tasks/kafka-files"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<ClusterTaskKafkaFilesVO>> getKafkaFiles(@RequestParam(value="clusterId", required=false) Long clusterId) {
        List kafkaFileDOList = this.kafkaFileService.getKafkaFiles();
        if (ValidateUtils.isEmptyList((List)kafkaFileDOList)) {
            return new Result();
        }
        ArrayList<ClusterTaskKafkaFilesVO> voList = new ArrayList<ClusterTaskKafkaFilesVO>();
        for (KafkaFileDO kafkaFileDO : kafkaFileDOList) {
            if (KafkaFileEnum.SERVER_CONFIG.getCode().equals(kafkaFileDO.getFileType()) && !kafkaFileDO.getClusterId().equals(clusterId)) continue;
            ClusterTaskKafkaFilesVO vo = new ClusterTaskKafkaFilesVO();
            vo.setFileName(kafkaFileDO.getFileName());
            vo.setFileMd5(kafkaFileDO.getFileMd5());
            vo.setFileType(kafkaFileDO.getFileType());
            voList.add(vo);
        }
        return new Result(voList);
    }
}

