/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.op;

import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.expert.AnomalyFlowTopicVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.expert.ExpiredTopicVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.expert.PartitionInsufficientTopicVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.expert.RegionHotTopicVO;
import com.xiaojukeji.kafka.manager.service.service.ClusterService;
import com.xiaojukeji.kafka.manager.service.service.ExpertService;
import com.xiaojukeji.kafka.manager.web.converters.ExpertConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"OP-\u4e13\u5bb6\u670d\u52a1\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/op/"})
public class OpExpertController {
    @Autowired
    private ExpertService expertService;
    @Autowired
    private ClusterService clusterService;

    @ApiOperation(value="\u70ed\u70b9Topic(Region\u5185)", notes="")
    @RequestMapping(value={"expert/regions/hot-topics"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<RegionHotTopicVO>> getRegionHotTopics() {
        return new Result((Object)ExpertConverter.convert2RegionHotTopicVOList((List)this.expertService.getRegionHotTopics()));
    }

    @ApiOperation(value="Topic\u5206\u533a\u4e0d\u8db3", notes="")
    @RequestMapping(value={"expert/topics/insufficient-partitions"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<PartitionInsufficientTopicVO>> getPartitionInsufficientTopics() {
        return new Result((Object)ExpertConverter.convert2PartitionInsufficientTopicVOList((List)this.expertService.getPartitionInsufficientTopics()));
    }

    @ApiOperation(value="Topic\u6d41\u91cf\u5f02\u5e38\u8bca\u65ad", notes="")
    @RequestMapping(value={"expert/topics/anomaly-flow"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<AnomalyFlowTopicVO>> getAnomalyFlowTopics(@RequestParam(value="timestamp") Long timestamp) {
        return new Result((Object)ExpertConverter.convert2AnomalyFlowTopicVOList((List)this.expertService.getAnomalyFlowTopics(timestamp)));
    }

    @ApiOperation(value="\u8fc7\u671fTopic", notes="")
    @RequestMapping(value={"expert/topics/expired"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<ExpiredTopicVO>> getExpiredTopics() {
        return new Result((Object)ExpertConverter.convert2ExpiredTopicVOList((List)this.expertService.getExpiredTopics(), (List)this.clusterService.list()));
    }
}

