/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.op;

import com.xiaojukeji.kafka.manager.bpm.common.entry.apply.gateway.OrderExtensionAddGatewayConfigDTO;
import com.xiaojukeji.kafka.manager.bpm.common.entry.apply.gateway.OrderExtensionDeleteGatewayConfigDTO;
import com.xiaojukeji.kafka.manager.bpm.common.entry.apply.gateway.OrderExtensionModifyGatewayConfigDTO;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.service.gateway.GatewayConfigService;
import com.xiaojukeji.kafka.manager.web.converters.GatewayModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"OP-Gateway\u914d\u7f6e\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
public class OpGatewayConfigController {
    @Autowired
    private GatewayConfigService gatewayConfigService;

    @ApiOperation(value="\u521b\u5efaGateway\u914d\u7f6e", notes="")
    @RequestMapping(value={"gateway-configs"}, method={RequestMethod.POST})
    @ResponseBody
    public Result createGatewayConfig(@RequestBody OrderExtensionAddGatewayConfigDTO dto) {
        if (ValidateUtils.isNull((Object)dto) || !dto.legal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return this.gatewayConfigService.insert(GatewayModelConverter.convert2GatewayConfigDO((OrderExtensionAddGatewayConfigDTO)dto));
    }

    @ApiOperation(value="\u4fee\u6539Gateway\u914d\u7f6e", notes="")
    @RequestMapping(value={"gateway-configs"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result modifyGatewayConfig(@RequestBody OrderExtensionModifyGatewayConfigDTO dto) {
        if (ValidateUtils.isNull((Object)dto) || !dto.legal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return this.gatewayConfigService.updateById(GatewayModelConverter.convert2GatewayConfigDO((OrderExtensionModifyGatewayConfigDTO)dto));
    }

    @ApiOperation(value="\u5220\u9664Gateway\u914d\u7f6e", notes="")
    @RequestMapping(value={"gateway-configs"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Result deleteGatewayConfig(@RequestBody OrderExtensionDeleteGatewayConfigDTO dto) {
        if (ValidateUtils.isNull((Object)dto) || !dto.legal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return this.gatewayConfigService.deleteById(dto.getId());
    }
}

