/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.op;

import com.xiaojukeji.kafka.manager.common.bizenum.TopicReassignActionEnum;
import com.xiaojukeji.kafka.manager.common.constant.Constant;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.dto.op.reassign.ReassignExecDTO;
import com.xiaojukeji.kafka.manager.common.entity.dto.op.reassign.ReassignExecSubDTO;
import com.xiaojukeji.kafka.manager.common.entity.dto.op.reassign.ReassignTopicDTO;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.reassign.ReassignTaskVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.reassign.ReassignTopicStatusVO;
import com.xiaojukeji.kafka.manager.common.utils.SpringTool;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.service.ReassignService;
import com.xiaojukeji.kafka.manager.web.converters.ReassignModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"OP-Topic\u8fc1\u79fb\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/op/"})
public class OpReassignController {
    @Autowired
    private ReassignService reassignService;

    @ApiOperation(value="\u521b\u5efa\u8fc1\u79fb\u4efb\u52a1", notes="")
    @RequestMapping(value={"reassign-tasks"}, method={RequestMethod.POST})
    @ResponseBody
    public Result createReassignTopicTask(@RequestBody List<ReassignTopicDTO> dtoList) {
        if (ValidateUtils.isEmptyList(dtoList)) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        for (ReassignTopicDTO dto : dtoList) {
            if (dto.paramLegal()) continue;
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return Result.buildFrom((ResultStatus)this.reassignService.createTask(dtoList, SpringTool.getUserName()));
    }

    @ApiOperation(value="\u64cd\u4f5c\u8fc1\u79fb\u4efb\u52a1[\u542f\u52a8|\u4fee\u6539|\u53d6\u6d88]", notes="")
    @RequestMapping(value={"reassign-tasks"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result executeReassignTopicTask(@RequestBody ReassignExecDTO dto) {
        if (ValidateUtils.isNull((Object)dto) || !dto.paramLegal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        TopicReassignActionEnum action = TopicReassignActionEnum.getByAction((String)dto.getAction());
        if (ValidateUtils.isNull((Object)action)) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return Result.buildFrom((ResultStatus)this.reassignService.modifyTask(dto, action));
    }

    @ApiOperation(value="\u64cd\u4f5c\u8fc1\u79fb\u5b50\u4efb\u52a1[\u4fee\u6539|\u53d6\u6d88]", notes="")
    @RequestMapping(value={"reassign-tasks/sub-tasks"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result executeReassignTopicTask(@RequestBody ReassignExecSubDTO dto) {
        if (ValidateUtils.isNull((Object)dto) || !dto.paramLegal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return Result.buildFrom((ResultStatus)this.reassignService.modifySubTask(dto));
    }

    @ApiOperation(value="\u8fc1\u79fb\u4efb\u52a1\u5217\u8868", notes="")
    @RequestMapping(value={"reassign-tasks"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<ReassignTaskVO>> getReassignTasks() {
        return new Result((Object)ReassignModelConverter.convert2ReassignTaskVOList((List)this.reassignService.getReassignTaskList()));
    }

    @ApiOperation(value="\u8fc1\u79fb\u4efb\u52a1\u4fe1\u606f", notes="")
    @RequestMapping(value={"reassign-tasks/{taskId}/detail"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<ReassignTaskVO> getReassignTaskDetail(@PathVariable Long taskId) {
        return new Result((Object)ReassignModelConverter.convert2ReassignTaskVO((Long)taskId, (List)this.reassignService.getTask(taskId)));
    }

    @ApiOperation(value="\u8fc1\u79fb\u4efb\u52a1\u72b6\u6001", notes="")
    @RequestMapping(value={"reassign-tasks/{taskId}/status"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<ReassignTopicStatusVO>> getReassignTaskStatus(@PathVariable Long taskId) {
        Result statusResult = this.reassignService.getReassignStatus(taskId);
        if (!Constant.SUCCESS.equals(statusResult.getCode())) {
            return new Result(Integer.valueOf(statusResult.getCode()), statusResult.getMessage());
        }
        return new Result((Object)ReassignModelConverter.convert2ReassignTopicStatusVOList((List)((List)statusResult.getData())));
    }
}

