/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.op;

import com.xiaojukeji.kafka.manager.common.bizenum.RebalanceDimensionEnum;
import com.xiaojukeji.kafka.manager.common.bizenum.TaskStatusEnum;
import com.xiaojukeji.kafka.manager.common.constant.Constant;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.TopicOperationResult;
import com.xiaojukeji.kafka.manager.common.entity.dto.ClusterTopicDTO;
import com.xiaojukeji.kafka.manager.common.entity.dto.op.RebalanceDTO;
import com.xiaojukeji.kafka.manager.common.entity.dto.op.topic.TopicCreationDTO;
import com.xiaojukeji.kafka.manager.common.entity.dto.op.topic.TopicDeletionDTO;
import com.xiaojukeji.kafka.manager.common.entity.dto.op.topic.TopicExpansionDTO;
import com.xiaojukeji.kafka.manager.common.entity.dto.op.topic.TopicModificationDTO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.ClusterDO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.TopicDO;
import com.xiaojukeji.kafka.manager.common.utils.JsonUtils;
import com.xiaojukeji.kafka.manager.common.utils.SpringTool;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.service.AdminService;
import com.xiaojukeji.kafka.manager.service.service.ClusterService;
import com.xiaojukeji.kafka.manager.service.service.TopicManagerService;
import com.xiaojukeji.kafka.manager.service.utils.TopicCommands;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"OP-Utils\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/op/"})
public class OpUtilsController {
    @Autowired
    private ClusterService clusterService;
    @Autowired
    private AdminService adminService;
    @Autowired
    private TopicManagerService topicManagerService;

    @ApiOperation(value="\u521b\u5efaTopic")
    @RequestMapping(value={"utils/topics"}, method={RequestMethod.POST})
    @ResponseBody
    public Result createCommonTopic(@RequestBody TopicCreationDTO dto) {
        Result rc = this.checkParamAndGetClusterDO((ClusterTopicDTO)dto);
        if (rc.getCode() != ResultStatus.SUCCESS.getCode()) {
            return rc;
        }
        Properties properties = dto.getProperties();
        if (ValidateUtils.isNull((Object)properties)) {
            properties = new Properties();
        }
        properties.put("retention.ms", String.valueOf(dto.getRetentionTime()));
        ResultStatus rs = this.adminService.createTopic((ClusterDO)rc.getData(), TopicDO.buildFrom((TopicCreationDTO)dto), dto.getPartitionNum(), dto.getReplicaNum(), dto.getRegionId(), dto.getBrokerIdList(), properties, SpringTool.getUserName(), SpringTool.getUserName());
        return Result.buildFrom((ResultStatus)rs);
    }

    @ApiOperation(value="Topic\u6269\u5206\u533a", notes="")
    @RequestMapping(value={"utils/expand-partitions"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result<List<TopicOperationResult>> expandTopics(@RequestBody List<TopicExpansionDTO> dtoList) {
        if (ValidateUtils.isNull(dtoList) || dtoList.size() > Constant.MAX_TOPIC_OPERATION_SIZE_PER_REQUEST) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        ArrayList<TopicOperationResult> resultList = new ArrayList<TopicOperationResult>();
        for (TopicExpansionDTO dto : dtoList) {
            Result rc = this.checkParamAndGetClusterDO((ClusterTopicDTO)dto);
            if (!Constant.SUCCESS.equals(rc.getCode())) {
                resultList.add(TopicOperationResult.buildFrom((Long)dto.getClusterId(), (String)dto.getTopicName(), (Result)rc));
                continue;
            }
            ResultStatus statusEnum = this.adminService.expandPartitions((ClusterDO)rc.getData(), dto.getTopicName(), dto.getPartitionNum(), dto.getRegionId(), dto.getBrokerIdList(), SpringTool.getUserName());
            resultList.add(TopicOperationResult.buildFrom((Long)dto.getClusterId(), (String)dto.getTopicName(), (ResultStatus)statusEnum));
        }
        for (TopicOperationResult operationResult : resultList) {
            if (Constant.SUCCESS.equals(operationResult.getCode())) continue;
            return Result.buildFrom((ResultStatus)ResultStatus.OPERATION_FAILED, resultList);
        }
        return new Result(resultList);
    }

    @ApiOperation(value="Topic\u5220\u9664", notes="\u5355\u6b21\u4e0d\u5141\u8bb8\u8d85\u8fc710\u4e2aTopic")
    @RequestMapping(value={"utils/topics"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Result<List<TopicOperationResult>> deleteTopics(@RequestBody List<TopicDeletionDTO> dtoList) {
        if (ValidateUtils.isNull(dtoList) || dtoList.size() > Constant.MAX_TOPIC_OPERATION_SIZE_PER_REQUEST) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        String operator = SpringTool.getUserName();
        ArrayList<TopicOperationResult> resultList = new ArrayList<TopicOperationResult>();
        for (TopicDeletionDTO dto : dtoList) {
            Result rc = this.checkParamAndGetClusterDO((ClusterTopicDTO)dto);
            if (rc.getCode() != ResultStatus.SUCCESS.getCode()) {
                resultList.add(TopicOperationResult.buildFrom((Long)dto.getClusterId(), (String)dto.getTopicName(), (Result)rc));
                continue;
            }
            ResultStatus statusEnum = this.adminService.deleteTopic((ClusterDO)rc.getData(), dto.getTopicName(), operator);
            resultList.add(TopicOperationResult.buildFrom((Long)dto.getClusterId(), (String)dto.getTopicName(), (ResultStatus)statusEnum));
        }
        for (TopicOperationResult operationResult : resultList) {
            if (Constant.SUCCESS.equals(operationResult.getCode())) continue;
            return Result.buildFrom((ResultStatus)ResultStatus.OPERATION_FAILED, resultList);
        }
        return new Result(resultList);
    }

    @ApiOperation(value="\u4fee\u6539Topic", notes="")
    @RequestMapping(value={"utils/topics"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result modifyTopic(@RequestBody TopicModificationDTO dto) {
        Result rc = this.checkParamAndGetClusterDO((ClusterTopicDTO)dto);
        if (rc.getCode() != ResultStatus.SUCCESS.getCode()) {
            return rc;
        }
        ClusterDO clusterDO = (ClusterDO)rc.getData();
        Properties properties = dto.getProperties();
        if (ValidateUtils.isNull((Object)properties)) {
            properties = new Properties();
        }
        properties.put("retention.ms", String.valueOf(dto.getRetentionTime()));
        String operator = SpringTool.getUserName();
        ResultStatus rs = TopicCommands.modifyTopicConfig((ClusterDO)clusterDO, (String)dto.getTopicName(), (Properties)properties);
        if (!ResultStatus.SUCCESS.equals((Object)rs)) {
            return Result.buildFrom((ResultStatus)rs);
        }
        this.topicManagerService.modifyTopicByOp(dto.getClusterId(), dto.getTopicName(), dto.getAppId(), dto.getDescription(), operator);
        return new Result();
    }

    @ApiOperation(value="\u4f18\u5148\u526f\u672c\u9009\u4e3e\u72b6\u6001")
    @RequestMapping(value={"utils/rebalance-status"}, method={RequestMethod.GET})
    @ResponseBody
    public Result preferredReplicaElectStatus(@RequestParam(value="clusterId") Long clusterId) {
        ClusterDO clusterDO = this.clusterService.getById(clusterId);
        if (ValidateUtils.isNull((Object)clusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        TaskStatusEnum statusEnum = this.adminService.preferredReplicaElectionStatus(clusterDO);
        return new Result(JsonUtils.toJson((Enum)statusEnum));
    }

    @ApiOperation(value="\u4f18\u5148\u526f\u672c\u9009\u4e3e")
    @RequestMapping(value={"utils/rebalance"}, method={RequestMethod.POST})
    @ResponseBody
    public Result preferredReplicaElect(@RequestBody RebalanceDTO reqObj) {
        if (!reqObj.paramLegal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        ClusterDO clusterDO = this.clusterService.getById(reqObj.getClusterId());
        if (ValidateUtils.isNull((Object)clusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        ResultStatus rs = null;
        if (RebalanceDimensionEnum.CLUSTER.getCode().equals(reqObj.getDimension())) {
            rs = this.adminService.preferredReplicaElection(clusterDO, SpringTool.getUserName());
        } else if (RebalanceDimensionEnum.BROKER.getCode().equals(reqObj.getDimension())) {
            rs = this.adminService.preferredReplicaElection(clusterDO, reqObj.getBrokerId(), SpringTool.getUserName());
        } else if (RebalanceDimensionEnum.TOPIC.getCode().equals(reqObj.getDimension())) {
            rs = this.adminService.preferredReplicaElection(clusterDO, reqObj.getTopicName(), SpringTool.getUserName());
        } else if (RebalanceDimensionEnum.PARTITION.getCode().equals(reqObj.getDimension())) {
            rs = this.adminService.preferredReplicaElection(clusterDO, reqObj.getTopicName(), reqObj.getPartitionId(), SpringTool.getUserName());
        } else {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return Result.buildFrom((ResultStatus)rs);
    }

    private Result<ClusterDO> checkParamAndGetClusterDO(ClusterTopicDTO dto) {
        if (!dto.paramLegal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        ClusterDO clusterDO = this.clusterService.getById(dto.getClusterId());
        if (ValidateUtils.isNull((Object)clusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return new Result((Object)clusterDO);
    }
}

