/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.rd;

import com.xiaojukeji.kafka.manager.account.AccountService;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.dto.rd.AccountDTO;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.AccountVO;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.web.converters.AccountConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"RD-Account\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/rd/"})
public class RdAccountController {
    private static final Logger logger = LoggerFactory.getLogger(RdAccountController.class);
    @Autowired
    private AccountService accountService;

    @ApiOperation(value="\u6dfb\u52a0\u8d26\u53f7", notes="")
    @RequestMapping(value={"accounts"}, method={RequestMethod.POST})
    @ResponseBody
    public Result addAccount(@RequestBody AccountDTO dto) {
        if (!dto.legal() || ValidateUtils.isNull((Object)dto.getPassword())) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        ResultStatus rs = this.accountService.createAccount(AccountConverter.convert2AccountDO((AccountDTO)dto));
        return Result.buildFrom((ResultStatus)rs);
    }

    @ApiOperation(value="\u5220\u9664\u8d26\u53f7", notes="")
    @RequestMapping(value={"accounts"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Result deleteAccount(@RequestParam(value="username") String username) {
        ResultStatus rs = this.accountService.deleteByName(username);
        return Result.buildFrom((ResultStatus)rs);
    }

    @ApiOperation(value="\u4fee\u6539\u8d26\u53f7", notes="")
    @RequestMapping(value={"accounts"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result updateAccount(@RequestBody AccountDTO reqObj) {
        if (!reqObj.legal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        ResultStatus rs = this.accountService.updateAccount(AccountConverter.convert2AccountDO((AccountDTO)reqObj));
        return Result.buildFrom((ResultStatus)rs);
    }

    @ApiOperation(value="\u8d26\u53f7\u5217\u8868", notes="")
    @RequestMapping(value={"accounts"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<AccountVO>> listAccounts() {
        try {
            List accountDOList = this.accountService.list();
            return new Result((Object)AccountConverter.convert2AccountVOList((List)accountDOList));
        }
        catch (Exception e) {
            logger.error("listAccounts@AdminAccountController, list failed.", (Throwable)e);
            return Result.buildFrom((ResultStatus)ResultStatus.MYSQL_ERROR);
        }
    }
}

