/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.rd;

import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.pojo.KafkaBillDO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.LogicalClusterDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.BillStaffDetailVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.BillStaffSummaryVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.BillTopicVO;
import com.xiaojukeji.kafka.manager.common.utils.DateUtils;
import com.xiaojukeji.kafka.manager.common.utils.SpringTool;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.cache.LogicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.service.KafkaBillService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"RD-Bill\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/rd/"})
public class RdBillController {
    @Autowired
    private KafkaBillService kafkaBillService;
    @Autowired
    private LogicalClusterMetadataManager logicalClusterMetadataManager;

    @ApiOperation(value="\u7528\u6237\u8d26\u5355\u6982\u89c8", notes="")
    @RequestMapping(value={"bills/staff-summary"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<BillStaffSummaryVO>> getBillStaffSummary(@RequestParam(value="timestamp") Long timestamp) {
        List kafkaBillDOList = this.kafkaBillService.getByGmtDay(DateUtils.getFormattedDate((Long)timestamp).substring(0, 7));
        if (ValidateUtils.isEmptyList((List)kafkaBillDOList)) {
            return new Result();
        }
        HashMap<String, BillStaffSummaryVO> ldapBillMap = new HashMap<String, BillStaffSummaryVO>();
        for (KafkaBillDO kafkaBillDO : kafkaBillDOList) {
            BillStaffSummaryVO vo = (BillStaffSummaryVO)ldapBillMap.get(kafkaBillDO.getPrincipal());
            if (ValidateUtils.isNull((Object)vo)) {
                vo = new BillStaffSummaryVO();
                vo.setUsername(kafkaBillDO.getPrincipal());
                vo.setTopicNum(Integer.valueOf(0));
                vo.setQuota(Double.valueOf(0.0));
                vo.setCost(Double.valueOf(0.0));
                vo.setGmtMonth(kafkaBillDO.getGmtDay());
                vo.setTimestamp(Long.valueOf(kafkaBillDO.getGmtCreate().getTime()));
                ldapBillMap.put(kafkaBillDO.getPrincipal(), vo);
            }
            vo.setTopicNum(Integer.valueOf(vo.getTopicNum() + 1));
            vo.setQuota(Double.valueOf(vo.getQuota() + kafkaBillDO.getQuota()));
            vo.setCost(Double.valueOf(vo.getCost() + kafkaBillDO.getCost()));
        }
        return new Result(new ArrayList(ldapBillMap.values()));
    }

    @ApiOperation(value="\u7528\u6237\u8d26\u5355\u6982\u89c8", notes="")
    @RequestMapping(value={"bills/{username}/staff-summary"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<BillStaffSummaryVO>> getBillStaffSummary(@PathVariable String username, @RequestParam(value="startTime") Long startTime, @RequestParam(value="endTime") Long endTime) {
        List kafkaBillDOList = this.kafkaBillService.getByPrincipal(username, new Date(startTime), new Date(endTime));
        if (ValidateUtils.isEmptyList((List)kafkaBillDOList)) {
            return new Result();
        }
        TreeMap<String, BillStaffSummaryVO> billMap = new TreeMap<String, BillStaffSummaryVO>();
        for (KafkaBillDO kafkaBillDO : kafkaBillDOList) {
            BillStaffSummaryVO vo = (BillStaffSummaryVO)billMap.get(kafkaBillDO.getGmtDay());
            if (ValidateUtils.isNull((Object)vo)) {
                vo = new BillStaffSummaryVO();
                vo.setUsername(SpringTool.getUserName());
                vo.setTopicNum(Integer.valueOf(0));
                vo.setQuota(Double.valueOf(0.0));
                vo.setCost(Double.valueOf(0.0));
                vo.setGmtMonth(kafkaBillDO.getGmtDay());
                vo.setTimestamp(Long.valueOf(kafkaBillDO.getGmtCreate().getTime()));
                billMap.put(kafkaBillDO.getGmtDay(), vo);
            }
            vo.setTopicNum(Integer.valueOf(vo.getTopicNum() + 1));
            vo.setQuota(Double.valueOf(vo.getQuota() + kafkaBillDO.getQuota()));
            vo.setCost(Double.valueOf(vo.getCost() + kafkaBillDO.getCost()));
        }
        return new Result(new ArrayList(billMap.values()));
    }

    @ApiOperation(value="\u7528\u6237\u8d26\u5355\u8be6\u60c5", notes="")
    @RequestMapping(value={"bills/{username}/staff-detail"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<BillStaffDetailVO> getBillStaffDetail(@PathVariable String username, @RequestParam(value="timestamp") Long timestamp) {
        List kafkaBillDOList = this.kafkaBillService.getByGmtDay(DateUtils.getFormattedDate((Long)timestamp).substring(0, 7));
        if (ValidateUtils.isEmptyList((List)kafkaBillDOList)) {
            return new Result();
        }
        BillStaffDetailVO billStaffDetailVO = new BillStaffDetailVO();
        billStaffDetailVO.setUsername(username);
        billStaffDetailVO.setBillList(new ArrayList());
        Double costSum = 0.0;
        for (KafkaBillDO kafkaBillDO : kafkaBillDOList) {
            if (!kafkaBillDO.getPrincipal().equals(username)) continue;
            BillTopicVO vo = new BillTopicVO();
            vo.setClusterName("unknown");
            LogicalClusterDO logicalClusterDO = this.logicalClusterMetadataManager.getTopicLogicalCluster(kafkaBillDO.getClusterId(), kafkaBillDO.getTopicName());
            if (!ValidateUtils.isNull((Object)logicalClusterDO)) {
                vo.setClusterId(logicalClusterDO.getId());
                vo.setClusterName(logicalClusterDO.getName());
            }
            vo.setTopicName(kafkaBillDO.getTopicName());
            vo.setQuota(kafkaBillDO.getQuota());
            vo.setCost(kafkaBillDO.getCost());
            costSum = costSum + kafkaBillDO.getCost();
            billStaffDetailVO.getBillList().add(vo);
        }
        billStaffDetailVO.setCostSum(costSum);
        return new Result((Object)billStaffDetailVO);
    }
}

