/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.rd;

import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.ao.BrokerBasicDTO;
import com.xiaojukeji.kafka.manager.common.entity.ao.analysis.AnalysisBrokerDTO;
import com.xiaojukeji.kafka.manager.common.entity.metrics.BaseMetrics;
import com.xiaojukeji.kafka.manager.common.entity.metrics.BrokerMetrics;
import com.xiaojukeji.kafka.manager.common.entity.pojo.RegionDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.RealTimeMetricsVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.TopicOverviewVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.broker.AnalysisBrokerVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.broker.BrokerBasicVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.broker.BrokerDiskTopicVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.broker.BrokerMetadataVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.broker.BrokerMetricsVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.broker.BrokerPartitionVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.broker.RdBrokerBasicVO;
import com.xiaojukeji.kafka.manager.common.utils.CopyUtils;
import com.xiaojukeji.kafka.manager.common.utils.ListUtils;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.common.zookeeper.znode.brokers.BrokerMetadata;
import com.xiaojukeji.kafka.manager.service.cache.PhysicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.service.AnalysisService;
import com.xiaojukeji.kafka.manager.service.service.BrokerService;
import com.xiaojukeji.kafka.manager.service.service.RegionService;
import com.xiaojukeji.kafka.manager.service.service.TopicService;
import com.xiaojukeji.kafka.manager.web.converters.BrokerModelConverter;
import com.xiaojukeji.kafka.manager.web.converters.CommonModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"RD-Broker\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/rd/"})
public class RdBrokerController {
    @Autowired
    private BrokerService brokerService;
    @Autowired
    private TopicService topicService;
    @Autowired
    private AnalysisService analysisService;
    @Autowired
    private RegionService regionService;

    @ApiOperation(value="Broker\u5143\u4fe1\u606f")
    @RequestMapping(value={"{clusterId}/brokers/broker-metadata"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<BrokerMetadataVO>> getBrokerMetadataList(@PathVariable Long clusterId) {
        List brokerIdList = PhysicalClusterMetadataManager.getBrokerIdList((Long)clusterId);
        ArrayList<BrokerMetadataVO> brokerMetadataVOList = new ArrayList<BrokerMetadataVO>();
        for (Integer brokerId : brokerIdList) {
            BrokerMetadata brokerMetadata = PhysicalClusterMetadataManager.getBrokerMetadata((Long)clusterId, (Integer)brokerId);
            if (brokerMetadata == null) continue;
            brokerMetadataVOList.add(new BrokerMetadataVO(brokerMetadata.getBrokerId(), brokerMetadata.getHost()));
        }
        return new Result(brokerMetadataVOList);
    }

    @ApiOperation(value="Broker\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"{clusterId}/brokers/{brokerId}/basic-info"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<BrokerBasicVO> getBrokerBasic(@PathVariable Long clusterId, @PathVariable Integer brokerId) {
        BrokerBasicDTO brokerBasicDTO = this.brokerService.getBrokerBasicDTO(clusterId, brokerId);
        if (brokerBasicDTO == null) {
            return Result.buildFrom((ResultStatus)ResultStatus.BROKER_NOT_EXIST);
        }
        BrokerBasicVO brokerBasicVO = new BrokerBasicVO();
        CopyUtils.copyProperties((Object)brokerBasicVO, (Object)brokerBasicDTO);
        return new Result((Object)brokerBasicVO);
    }

    @ApiOperation(value="Broker\u57fa\u672c\u4fe1\u606f\u5217\u8868", notes="")
    @RequestMapping(value={"clusters/{clusterId}/brokers/basic-info"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<RdBrokerBasicVO>> getBrokerBasics(@PathVariable(value="clusterId") Long clusterId) {
        List brokerIdList = PhysicalClusterMetadataManager.getBrokerIdList((Long)clusterId);
        if (ValidateUtils.isEmptyList((List)brokerIdList)) {
            return new Result(new ArrayList());
        }
        List regionDOList = this.regionService.listAll().stream().filter(regionDO -> clusterId.equals(regionDO.getClusterId())).collect(Collectors.toList());
        HashMap<Integer, RegionDO> regionMap = new HashMap<Integer, RegionDO>();
        for (RegionDO regionDO2 : regionDOList) {
            if (ValidateUtils.isNull((Object)regionDO2)) continue;
            for (Integer brokerId : ListUtils.string2IntList((String)regionDO2.getBrokerList())) {
                regionMap.put(brokerId, regionDO2);
            }
        }
        return new Result((Object)BrokerModelConverter.convert2RdBrokerBasicVO((Long)clusterId, (List)brokerIdList, regionMap));
    }

    @ApiOperation(value="BrokerTopic\u4fe1\u606f")
    @RequestMapping(value={"{clusterId}/brokers/{brokerId}/topics"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicOverviewVO>> getBrokerTopics(@PathVariable Long clusterId, @PathVariable Integer brokerId) {
        return new Result((Object)CommonModelConverter.convert2TopicOverviewVOList((Long)clusterId, (List)this.topicService.getTopicOverviewList(clusterId, brokerId)));
    }

    @ApiOperation(value="Broker\u5206\u533a\u4fe1\u606f")
    @RequestMapping(value={"{clusterId}/brokers/{brokerId}/partitions"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<BrokerPartitionVO>> getBrokerPartitions(@PathVariable Long clusterId, @PathVariable Integer brokerId) {
        Map partitionStateMap = this.topicService.getTopicPartitionState(clusterId, brokerId);
        if (ValidateUtils.isNull((Object)partitionStateMap)) {
            return Result.buildFrom((ResultStatus)ResultStatus.BROKER_NOT_EXIST);
        }
        return new Result((Object)BrokerModelConverter.convert2BrokerPartitionVOList((Long)clusterId, (Integer)brokerId, (Map)partitionStateMap));
    }

    @ApiOperation(value="Broker\u5b9e\u65f6\u6d41\u91cf")
    @RequestMapping(value={"{clusterId}/brokers/{brokerId}/metrics"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<RealTimeMetricsVO> getBrokerMetrics(@PathVariable Long clusterId, @PathVariable Integer brokerId) {
        BrokerMetrics brokerMetrics = this.brokerService.getBrokerMetricsFromJmx(clusterId, brokerId, Integer.valueOf(0));
        if (ValidateUtils.isNull((Object)brokerMetrics)) {
            return Result.buildFrom((ResultStatus)ResultStatus.BROKER_NOT_EXIST);
        }
        return new Result((Object)CommonModelConverter.convert2RealTimeMetricsVO((BaseMetrics)brokerMetrics));
    }

    @ApiOperation(value="Broker\u78c1\u76d8\u5206\u533a", notes="")
    @RequestMapping(value={"{clusterId}/brokers/{brokerId}/partitions-location"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<BrokerDiskTopicVO>> getBrokerPartitionsLocation(@PathVariable Long clusterId, @PathVariable Integer brokerId) {
        return new Result((Object)CommonModelConverter.convert2BrokerDiskTopicVOList((List)this.brokerService.getBrokerTopicLocation(clusterId, brokerId)));
    }

    @ApiOperation(value="Broker\u5386\u53f2\u6307\u6807")
    @RequestMapping(value={"{clusterId}/brokers/{brokerId}/metrics-history"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<BrokerMetricsVO>> getBrokerMetricsHistory(@PathVariable Long clusterId, @PathVariable Integer brokerId, @RequestParam(value="startTime") Long startTime, @RequestParam(value="endTime") Long endTime) {
        List metricsList = this.brokerService.getBrokerMetricsFromDB(clusterId, brokerId, new Date(startTime), new Date(endTime));
        return new Result((Object)BrokerModelConverter.convert2BrokerMetricsVOList((List)metricsList));
    }

    @ApiOperation(value="BrokerTopic\u5206\u6790")
    @RequestMapping(value={"{clusterId}/brokers/{brokerId}/analysis"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<AnalysisBrokerVO> getTopicAnalyzer(@PathVariable Long clusterId, @PathVariable Integer brokerId) {
        AnalysisBrokerDTO analysisBrokerDTO = this.analysisService.doAnalysisBroker(clusterId, brokerId);
        return new Result((Object)BrokerModelConverter.convert2AnalysisBrokerVO((AnalysisBrokerDTO)analysisBrokerDTO));
    }

    @ApiOperation(value="Broker\u5220\u9664", notes="\u5220\u9664DB\u4e2d\u7684Broker\u4fe1\u606f")
    @RequestMapping(value={"{clusterId}/brokers"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Result deleteBrokerId(@PathVariable Long clusterId, @RequestParam(value="brokerId") Integer brokerId) {
        return Result.buildFrom((ResultStatus)this.brokerService.delete(clusterId, brokerId));
    }
}

