/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.rd;

import com.xiaojukeji.kafka.manager.common.bizenum.KafkaClientEnum;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ao.ClusterDetailDTO;
import com.xiaojukeji.kafka.manager.common.entity.ao.cluster.ClusterBrokerStatus;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.BrokerOverviewVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.RealTimeMetricsVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.TopicOverviewVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.TopicThrottleVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.cluster.TopicMetadataVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.KafkaControllerVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.cluster.ClusterBrokerStatusVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.cluster.ClusterDetailVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.cluster.ControllerPreferredCandidateVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.cluster.RdClusterMetricsVO;
import com.xiaojukeji.kafka.manager.common.utils.DateUtils;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.cache.PhysicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.service.BrokerService;
import com.xiaojukeji.kafka.manager.service.service.ClusterService;
import com.xiaojukeji.kafka.manager.service.service.RegionService;
import com.xiaojukeji.kafka.manager.service.service.ThrottleService;
import com.xiaojukeji.kafka.manager.service.service.TopicService;
import com.xiaojukeji.kafka.manager.web.converters.ClusterModelConverter;
import com.xiaojukeji.kafka.manager.web.converters.CommonModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"RD-Cluster\u7ef4\u5ea6\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/rd/"})
public class RdClusterController {
    @Autowired
    private ClusterService clusterService;
    @Autowired
    private BrokerService brokerService;
    @Autowired
    private TopicService topicService;
    @Autowired
    private RegionService regionService;
    @Autowired
    private ThrottleService throttleService;

    @ApiOperation(value="\u96c6\u7fa4\u57fa\u672c\u4fe1\u606f\u5217\u8868", notes="\u9ed8\u8ba4\u4e0d\u8981\u8be6\u60c5")
    @RequestMapping(value={"clusters/basic-info"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<ClusterDetailVO>> getClusterBasicInfo(@RequestParam(value="need-detail", required=false) Boolean needDetail) {
        if (ValidateUtils.isNull((Object)needDetail)) {
            needDetail = false;
        }
        return new Result((Object)ClusterModelConverter.convert2ClusterDetailVOList((List)this.clusterService.getClusterDetailDTOList(needDetail)));
    }

    @ApiOperation(value="\u96c6\u7fa4\u57fa\u672c\u4fe1\u606f", notes="\u9ed8\u8ba4\u4e0d\u8981\u8be6\u60c5")
    @RequestMapping(value={"clusters/{clusterId}/basic-info"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<ClusterDetailVO> getClusterBasicInfo(@PathVariable Long clusterId, @RequestParam(value="need-detail", required=false) Boolean needDetail) {
        if (ValidateUtils.isNull((Object)needDetail)) {
            needDetail = false;
        }
        return new Result((Object)ClusterModelConverter.convert2ClusterDetailVO((ClusterDetailDTO)this.clusterService.getClusterDetailDTO(clusterId, needDetail)));
    }

    @ApiOperation(value="\u96c6\u7fa4\u5b9e\u65f6\u6d41\u91cf")
    @RequestMapping(value={"clusters/{clusterId}/metrics"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<RealTimeMetricsVO> getClusterRealTimeMetrics(@PathVariable Long clusterId) {
        return new Result((Object)CommonModelConverter.convert2RealTimeMetricsVO((List)this.brokerService.getBrokerMetricsFromJmx(clusterId, new HashSet(PhysicalClusterMetadataManager.getBrokerIdList((Long)clusterId)), Integer.valueOf(0))));
    }

    @ApiOperation(value="\u96c6\u7fa4\u5386\u53f2\u6d41\u91cf")
    @RequestMapping(value={"clusters/{clusterId}/metrics-history"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<RdClusterMetricsVO>> getClusterMetricsHistory(@PathVariable Long clusterId, @RequestParam(value="startTime") Long startTime, @RequestParam(value="endTime") Long endTime) {
        return new Result((Object)ClusterModelConverter.convert2RdClusterMetricsVOList((List)this.clusterService.getClusterMetricsFromDB(clusterId, DateUtils.long2Date((Long)startTime), DateUtils.long2Date((Long)endTime))));
    }

    @ApiOperation(value="\u96c6\u7fa4Broker\u5217\u8868", notes="")
    @RequestMapping(value={"clusters/{clusterId}/brokers"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<BrokerOverviewVO>> getBrokerOverview(@PathVariable Long clusterId) {
        List regionDOList = this.regionService.getByClusterId(clusterId);
        List brokerOverviewDTOList = this.brokerService.getBrokerOverviewList(clusterId, null);
        return new Result((Object)ClusterModelConverter.convert2BrokerOverviewList((List)brokerOverviewDTOList, (List)regionDOList));
    }

    @ApiOperation(value="\u96c6\u7fa4Broker\u72b6\u6001", notes="\u997c\u72b6\u56fe")
    @RequestMapping(value={"clusters/{clusterId}/brokers-status"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<ClusterBrokerStatusVO> getClusterBrokerStatusVO(@PathVariable Long clusterId) {
        return new Result((Object)ClusterModelConverter.convert2ClusterBrokerStatusVO((ClusterBrokerStatus)this.brokerService.getClusterBrokerStatus(clusterId)));
    }

    @ApiOperation(value="\u96c6\u7fa4Topic\u5217\u8868")
    @RequestMapping(value={"clusters/{clusterId}/topics"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicOverviewVO>> getTopicOverview(@PathVariable Long clusterId) {
        return new Result((Object)CommonModelConverter.convert2TopicOverviewVOList((Long)clusterId, (List)this.topicService.getTopicOverviewList(clusterId, PhysicalClusterMetadataManager.getTopicNameList((Long)clusterId))));
    }

    @ApiOperation(value="\u96c6\u7fa4Controller\u53d8\u66f4\u5386\u53f2")
    @RequestMapping(value={"clusters/{clusterId}/controller-history"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<KafkaControllerVO>> getControllerHistory(@PathVariable Long clusterId) {
        return new Result((Object)ClusterModelConverter.convert2KafkaControllerVOList((List)this.clusterService.getKafkaControllerHistory(clusterId)));
    }

    @ApiOperation(value="\u96c6\u7fa4\u9650\u6d41\u4fe1\u606f")
    @RequestMapping(value={"clusters/{clusterId}/throttles"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicThrottleVO>> getThrottles(@PathVariable Long clusterId) {
        return new Result((Object)ClusterModelConverter.convert2TopicThrottleVOList((List)this.throttleService.getThrottledTopicsFromJmx(clusterId, new HashSet(PhysicalClusterMetadataManager.getBrokerIdList((Long)clusterId)), Arrays.asList(KafkaClientEnum.values()))));
    }

    @ApiOperation(value="\u96c6\u7fa4Topic\u5143\u4fe1\u606f\u5217\u8868", notes="")
    @RequestMapping(value={"clusters/{clusterId}/topic-metadata"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicMetadataVO>> getTopicMetadatas(@PathVariable(value="clusterId") Long clusterId) {
        return new Result((Object)ClusterModelConverter.convert2TopicMetadataVOList((Long)clusterId));
    }

    @ApiOperation(value="Controller\u4f18\u5148\u5019\u9009\u7684Broker", notes="\u6ef4\u6ef4\u5185\u90e8\u5f15\u64ce\u7279\u6027")
    @RequestMapping(value={"clusters/{clusterId}/controller-preferred-candidates"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<ControllerPreferredCandidateVO>> getControllerPreferredCandidates(@PathVariable(value="clusterId") Long clusterId) {
        Result candidateResult = this.clusterService.getControllerPreferredCandidates(clusterId);
        if (candidateResult.failed()) {
            return new Result(Integer.valueOf(candidateResult.getCode()), candidateResult.getMessage());
        }
        return Result.buildSuc((Object)ClusterModelConverter.convert2ControllerPreferredCandidateVOList((List)((List)candidateResult.getData())));
    }
}

