/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.rd;

import com.xiaojukeji.kafka.manager.common.bizenum.KafkaBrokerRoleEnum;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.dto.config.ConfigDTO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.ConfigVO;
import com.xiaojukeji.kafka.manager.common.utils.JsonUtils;
import com.xiaojukeji.kafka.manager.service.service.ConfigService;
import com.xiaojukeji.kafka.manager.web.converters.ConfigConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"RD-Config\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/rd/"})
public class RdConfigController {
    @Autowired
    private ConfigService configService;

    @ApiOperation(value="\u914d\u7f6e\u5217\u8868")
    @RequestMapping(value={"configs"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<ConfigVO>> getConfigList() {
        return new Result((Object)ConfigConverter.convert2ConfigVOList((List)this.configService.listAll()));
    }

    @ApiOperation(value="\u4fee\u6539\u914d\u7f6e")
    @RequestMapping(value={"configs"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result modifyConfig(@RequestBody ConfigDTO dto) {
        if (!dto.paramLegal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return Result.buildFrom((ResultStatus)this.configService.updateByKey(dto));
    }

    @ApiOperation(value="\u65b0\u589e\u914d\u7f6e")
    @RequestMapping(value={"configs"}, method={RequestMethod.POST})
    @ResponseBody
    public Result createConfig(@RequestBody ConfigDTO dto) {
        if (!dto.paramLegal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return Result.buildFrom((ResultStatus)this.configService.insert(dto));
    }

    @ApiOperation(value="\u5220\u9664\u914d\u7f6e")
    @RequestMapping(value={"configs"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Result deleteById(@RequestParam(value="config-key") String configKey) {
        return Result.buildFrom((ResultStatus)this.configService.deleteByKey(configKey));
    }

    @ApiOperation(value="Kafka\u7684\u89d2\u8272\u5217\u8868", notes="")
    @RequestMapping(value={"configs/kafka-roles"}, method={RequestMethod.GET})
    @ResponseBody
    public Result getKafkaBrokerRoleEnum() {
        return new Result(JsonUtils.toJson(KafkaBrokerRoleEnum.class));
    }
}

