/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.rd;

import com.xiaojukeji.kafka.manager.common.bizenum.OffsetLocationEnum;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.pojo.ClusterDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.consumer.ConsumerGroupVO;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.service.ClusterService;
import com.xiaojukeji.kafka.manager.service.service.ConsumerService;
import com.xiaojukeji.kafka.manager.web.converters.ConsumerModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"RD-Consumer\u7ef4\u5ea6\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/rd/"})
public class RdConsumerController {
    @Autowired
    private ConsumerService consumerService;
    @Autowired
    private ClusterService clusterService;

    @ApiOperation(value="\u96c6\u7fa4ConsumerGroup\u5217\u8868", notes="")
    @RequestMapping(value={"{clusterId}/consumer-groups"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<ConsumerGroupVO>> getConsumerGroupList(@PathVariable Long clusterId) {
        return new Result((Object)ConsumerModelConverter.convert2ConsumerGroupVOList((List)this.consumerService.getConsumerGroupList(clusterId)));
    }

    @ApiOperation(value="\u6d88\u8d39\u7ec4\u6d88\u8d39\u7684Topic\u5217\u8868", notes="")
    @RequestMapping(value={"{clusterId}/consumer-groups/{consumerGroup}/topics"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<String>> getConsumerGroupConsumedTopicList(@PathVariable Long clusterId, @PathVariable String consumerGroup, @RequestParam(value="location") String location) {
        ClusterDO clusterDO = this.clusterService.getById(clusterId);
        if (ValidateUtils.isNull((Object)clusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        OffsetLocationEnum offsetLocation = OffsetLocationEnum.getOffsetStoreLocation((String)location.toLowerCase());
        if (ValidateUtils.isNull((Object)offsetLocation)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CG_LOCATION_ILLEGAL);
        }
        return new Result((Object)this.consumerService.getConsumerGroupConsumedTopicList(clusterId, consumerGroup, offsetLocation.location));
    }
}

