/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.rd;

import com.xiaojukeji.kafka.manager.common.bizenum.KafkaFileEnum;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.dto.normal.KafkaFileDTO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.KafkaFileVO;
import com.xiaojukeji.kafka.manager.common.utils.JsonUtils;
import com.xiaojukeji.kafka.manager.common.utils.SpringTool;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.kcm.KafkaFileService;
import com.xiaojukeji.kafka.manager.kcm.component.storage.common.StorageEnum;
import com.xiaojukeji.kafka.manager.service.service.ClusterService;
import com.xiaojukeji.kafka.manager.web.converters.KafkaFileConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"RD-Package\u7ba1\u7406\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/rd/"})
public class RdKafkaFileController {
    @Autowired
    private ClusterService clusterService;
    @Autowired
    private KafkaFileService kafkaFileService;

    @ApiOperation(value="\u6587\u4ef6\u679a\u4e3e\u4fe1\u606f", notes="")
    @RequestMapping(value={"kafka-files/enums"}, method={RequestMethod.GET})
    @ResponseBody
    public Result getKafkaFileEnums() {
        HashMap<String, Object> enumMap = new HashMap<String, Object>(2);
        enumMap.put("fileEnum", JsonUtils.toJson(KafkaFileEnum.class));
        enumMap.put("storageEnum", JsonUtils.toJson(StorageEnum.class));
        return new Result(enumMap);
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6", notes="")
    @RequestMapping(value={"kafka-files"}, method={RequestMethod.POST})
    @ResponseBody
    public Result uploadKafkaFile(KafkaFileDTO dto) {
        if (ValidateUtils.isNull((Object)dto.getModify()) || !dto.getModify().booleanValue()) {
            return Result.buildFrom((ResultStatus)this.kafkaFileService.uploadKafkaFile(dto, SpringTool.getUserName()));
        }
        return Result.buildFrom((ResultStatus)this.kafkaFileService.modifyKafkaFile(dto, SpringTool.getUserName()));
    }

    @ApiOperation(value="\u5220\u9664\u6587\u4ef6", notes="")
    @RequestMapping(value={"kafka-files"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Result deleteKafkaFile(@RequestParam(value="id") Long id) {
        return Result.buildFrom((ResultStatus)this.kafkaFileService.deleteKafkaFile(id));
    }

    @ApiOperation(value="\u6587\u4ef6\u5217\u8868", notes="")
    @RequestMapping(value={"kafka-files"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<KafkaFileVO>> getKafkaFiles() {
        List kafkaFileDOList = this.kafkaFileService.getKafkaFiles();
        return new Result((Object)KafkaFileConverter.convertKafkaFileVOList((List)kafkaFileDOList, (ClusterService)this.clusterService));
    }

    @ApiOperation(value="\u6587\u4ef6\u9884\u89c8", notes="")
    @RequestMapping(value={"kafka-files/{fileId}/config-files"}, method={RequestMethod.GET})
    public Result<String> previewKafkaFile(@PathVariable(value="fileId") Long fileId) {
        return this.kafkaFileService.downloadKafkaConfigFile(fileId);
    }
}

