/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.rd;

import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.dto.rd.LogicalClusterDTO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.LogicalClusterDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.cluster.LogicalClusterVO;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.service.LogicalClusterService;
import com.xiaojukeji.kafka.manager.web.converters.LogicalClusterModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"RD-LogicalCluster\u7ef4\u5ea6\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/rd/"})
public class RdLogicalClusterController {
    @Autowired
    private LogicalClusterService logicalClusterService;

    @ApiOperation(value="\u903b\u8f91\u96c6\u7fa4\u521b\u5efa", notes="")
    @RequestMapping(value={"logical-clusters"}, method={RequestMethod.POST})
    @ResponseBody
    public Result createNew(@RequestBody LogicalClusterDTO dto) {
        if (!dto.legal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return Result.buildFrom((ResultStatus)this.logicalClusterService.createLogicalCluster(LogicalClusterModelConverter.convert2LogicalClusterDO((LogicalClusterDTO)dto)));
    }

    @ApiOperation(value="\u903b\u8f91\u96c6\u7fa4\u5220\u9664", notes="")
    @RequestMapping(value={"logical-clusters"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Result deleteById(@RequestParam(value="id") Long id) {
        return Result.buildFrom((ResultStatus)this.logicalClusterService.deleteById(id));
    }

    @ApiOperation(value="\u903b\u8f91\u96c6\u7fa4\u66f4\u65b0", notes="")
    @RequestMapping(value={"logical-clusters"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result updateById(@RequestBody LogicalClusterDTO dto) {
        if (!dto.legal() || ValidateUtils.isNull((Object)dto.getId())) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return Result.buildFrom((ResultStatus)this.logicalClusterService.updateById(LogicalClusterModelConverter.convert2LogicalClusterDO((LogicalClusterDTO)dto)));
    }

    @ApiOperation(value="\u67e5\u8be2\u903b\u8f91\u96c6\u7fa4\u5217\u8868", notes="")
    @RequestMapping(value={"logical-clusters"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<LogicalClusterVO> getByLogicalClusterId(@RequestParam(value="id") Long physicalClusterId) {
        return new Result((Object)LogicalClusterModelConverter.convert2LogicalClusterVO((LogicalClusterDO)this.logicalClusterService.getById(physicalClusterId)));
    }

    @ApiOperation(value="\u67e5\u8be2\u903b\u8f91\u96c6\u7fa4\u5217\u8868", notes="")
    @RequestMapping(value={"{physicalClusterId}/logical-clusters"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<LogicalClusterVO>> getByPhysicalClusterId(@PathVariable Long physicalClusterId) {
        return new Result((Object)LogicalClusterModelConverter.convert2LogicalClusterVOList((List)this.logicalClusterService.getByPhysicalClusterId(physicalClusterId)));
    }
}

