/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.rd;

import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.dto.rd.OperateRecordDTO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.OperateRecordVO;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.service.OperateRecordService;
import com.xiaojukeji.kafka.manager.web.converters.OperateRecordModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"RD-operate\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/rd/"})
public class RdOperateRecordController {
    private static final int MAX_RECORD_COUNT = 200;
    @Autowired
    private OperateRecordService operateRecordService;

    @ApiOperation(value="\u67e5\u8be2\u64cd\u4f5c\u8bb0\u5f55", notes="")
    @RequestMapping(value={"operate-record"}, method={RequestMethod.POST})
    @ResponseBody
    public Result<List<OperateRecordVO>> geOperateRecords(@RequestBody OperateRecordDTO dto) {
        if (ValidateUtils.isNull((Object)dto) || !dto.legal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        List voList = OperateRecordModelConverter.convert2OperateRecordVOList((List)this.operateRecordService.queryByCondt(dto));
        if (voList.size() > 200) {
            voList = voList.subList(0, 200);
        }
        return new Result((Object)voList);
    }
}

