/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.rd;

import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.dto.rd.RegionDTO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.RegionVO;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.service.RegionService;
import com.xiaojukeji.kafka.manager.web.converters.RegionModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"RD-Region\u7ef4\u5ea6\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/rd/"})
public class RdRegionController {
    @Autowired
    private RegionService regionService;

    @ApiOperation(value="Region\u521b\u5efa", notes="")
    @RequestMapping(value={"regions"}, method={RequestMethod.POST})
    @ResponseBody
    public Result createNew(@RequestBody RegionDTO dto) {
        if (!dto.legal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return Result.buildFrom((ResultStatus)this.regionService.createRegion(RegionModelConverter.convert2RegionDO((RegionDTO)dto)));
    }

    @ApiOperation(value="Region\u5220\u9664", notes="")
    @RequestMapping(value={"regions"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Result deleteById(@RequestParam(value="id") Long id) {
        return Result.buildFrom((ResultStatus)this.regionService.deleteById(id));
    }

    @ApiOperation(value="Region\u66f4\u65b0", notes="")
    @RequestMapping(value={"regions"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result updateRegion(@RequestBody RegionDTO dto) {
        if (!dto.legal() || ValidateUtils.isNull((Object)dto.getId())) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return Result.buildFrom((ResultStatus)this.regionService.updateRegion(RegionModelConverter.convert2RegionDO((RegionDTO)dto)));
    }

    @ApiOperation(value="\u67e5\u8be2Region\u5217\u8868", notes="")
    @RequestMapping(value={"{clusterId}/regions"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<RegionVO>> getRegionList(@PathVariable Long clusterId) {
        return new Result((Object)RegionModelConverter.convert2RegionVOList((List)this.regionService.getByClusterId(clusterId)));
    }
}

