/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.rd;

import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.dto.rd.CustomScheduledTaskDTO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.CustomScheduledTaskVO;
import com.xiaojukeji.kafka.manager.common.utils.SpringTool;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.task.component.AbstractScheduledTask;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"RD-Schedule\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/rd/"})
public class RdScheduledController {
    @ApiOperation(value="\u8c03\u5ea6\u4efb\u52a1\u5217\u8868", notes="")
    @RequestMapping(value={"scheduled-tasks"}, method={RequestMethod.GET})
    public Result<List<CustomScheduledTaskVO>> listAllScheduledTasks() {
        Map beanMap = SpringTool.getBeansOfType(AbstractScheduledTask.class);
        ArrayList<CustomScheduledTaskVO> voList = new ArrayList<CustomScheduledTaskVO>();
        for (Map.Entry entry : beanMap.entrySet()) {
            CustomScheduledTaskVO vo = new CustomScheduledTaskVO();
            vo.setName((String)entry.getKey());
            vo.setCron((Object)((AbstractScheduledTask)entry.getValue()).getCron());
            voList.add(vo);
        }
        return new Result(voList);
    }

    @ApiOperation(value="\u89e6\u53d1\u6267\u884c\u8c03\u5ea6\u4efb\u52a1", response=Result.class)
    @RequestMapping(value={"scheduled-tasks/{scheduledName}/run"}, method={RequestMethod.GET})
    public Result triggerScheduledTask(@PathVariable String scheduledName) {
        AbstractScheduledTask scheduledTask = (AbstractScheduledTask)SpringTool.getBean((String)scheduledName, AbstractScheduledTask.class);
        if (ValidateUtils.isNull((Object)scheduledTask)) {
            return Result.buildFrom((ResultStatus)ResultStatus.RESOURCE_NOT_EXIST);
        }
        scheduledTask.scheduleAllTaskFunction();
        return Result.buildSuc();
    }

    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1\u8c03\u5ea6\u5468\u671f", response=Result.class)
    @RequestMapping(value={"scheduled-tasks"}, method={RequestMethod.PUT})
    public Result modifyScheduledTask(@RequestBody CustomScheduledTaskDTO dto) {
        AbstractScheduledTask scheduledTask = (AbstractScheduledTask)SpringTool.getBean((String)dto.getName(), AbstractScheduledTask.class);
        if (ValidateUtils.isNull((Object)scheduledTask)) {
            return Result.buildFrom((ResultStatus)ResultStatus.RESOURCE_NOT_EXIST);
        }
        if (scheduledTask.modifyCron(dto.getName(), dto.getCron())) {
            return Result.buildSuc();
        }
        return Result.buildFrom((ResultStatus)ResultStatus.OPERATION_FAILED);
    }
}

