/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.rd;

import com.xiaojukeji.kafka.manager.common.constant.Constant;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.ao.RdTopicBasic;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.RdTopicBasicVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.TopicBrokerVO;
import com.xiaojukeji.kafka.manager.common.utils.CopyUtils;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.cache.LogicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.cache.PhysicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.service.TopicManagerService;
import com.xiaojukeji.kafka.manager.service.service.TopicService;
import com.xiaojukeji.kafka.manager.web.converters.TopicModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"RD-Topic\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/rd/"})
public class RdTopicController {
    @Autowired
    private LogicalClusterMetadataManager logicalClusterMetadataManager;
    @Autowired
    private TopicService topicService;
    @Autowired
    private TopicManagerService topicManagerService;

    @ApiOperation(value="TopicBroker\u4fe1\u606f", notes="")
    @RequestMapping(value={"{clusterId}/topics/{topicName}/brokers"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicBrokerVO>> getTopicBrokers(@PathVariable Long clusterId, @PathVariable String topicName, @RequestParam(value="isPhysicalClusterId", required=false) Boolean isPhysicalClusterId) {
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId, isPhysicalClusterId);
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        if (!PhysicalClusterMetadataManager.isTopicExist((Long)physicalClusterId, (String)topicName)) {
            return Result.buildFrom((ResultStatus)ResultStatus.TOPIC_NOT_EXIST);
        }
        return new Result((Object)TopicModelConverter.convert2TopicBrokerVO((Long)physicalClusterId, (List)this.topicService.getTopicBrokerList(physicalClusterId, topicName)));
    }

    @ApiOperation(value="\u67e5\u8be2Topic\u4fe1\u606f", notes="")
    @RequestMapping(value={"{physicalClusterId}/topics/{topicName}/basic-info"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<RdTopicBasicVO> getTopicBasic(@PathVariable Long physicalClusterId, @PathVariable String topicName) {
        Result result = this.topicManagerService.getRdTopicBasic(physicalClusterId, topicName);
        if (!Constant.SUCCESS.equals(result.getCode())) {
            return new Result(Integer.valueOf(result.getCode()), result.getMessage());
        }
        RdTopicBasicVO vo = new RdTopicBasicVO();
        CopyUtils.copyProperties((Object)vo, (Object)result.getData());
        vo.setProperties(((RdTopicBasic)result.getData()).getProperties());
        vo.setRegionNameList(((RdTopicBasic)result.getData()).getRegionNameList());
        return new Result((Object)vo);
    }
}

