/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.thirdpart;

import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.app.AppVO;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.service.gateway.AppService;
import com.xiaojukeji.kafka.manager.web.converters.AppConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5f00\u653e\u63a5\u53e3-App\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/third-part/"})
public class ThirdPartAppController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdPartAppController.class);
    @Autowired
    private AppService appService;

    @ApiOperation(value="\u67e5\u8be2\u8d1f\u8d23\u7684\u5e94\u7528", notes="")
    @RequestMapping(value={"principal-apps/{principal}/basic-info"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<AppVO>> searchPrincipalApps(@PathVariable(value="principal") String principal, @RequestParam(value="system-code") String systemCode) {
        LOGGER.info("search principal-apps, principal:{} systemCode:{}.", (Object)principal, (Object)systemCode);
        if (ValidateUtils.isBlank((String)principal) || ValidateUtils.isBlank((String)systemCode)) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        if (!"kafka-manager".equals(systemCode)) {
            return Result.buildFrom((ResultStatus)ResultStatus.OPERATION_FORBIDDEN);
        }
        return new Result((Object)AppConverter.convert2AppVOList((List)this.appService.getByPrincipal(principal)));
    }
}

