/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.thirdpart;

import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.metrics.BrokerMetrics;
import com.xiaojukeji.kafka.manager.common.entity.pojo.ClusterDO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.RegionDO;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.common.zookeeper.znode.brokers.BrokerMetadata;
import com.xiaojukeji.kafka.manager.openapi.common.vo.BrokerRegionVO;
import com.xiaojukeji.kafka.manager.openapi.common.vo.ThirdPartBrokerOverviewVO;
import com.xiaojukeji.kafka.manager.service.cache.PhysicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.service.BrokerService;
import com.xiaojukeji.kafka.manager.service.service.ClusterService;
import com.xiaojukeji.kafka.manager.service.service.RegionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5f00\u653e\u63a5\u53e3-Broker\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/third-part/"})
public class ThirdPartBrokerController {
    @Autowired
    private BrokerService brokerService;
    @Autowired
    private RegionService regionService;
    @Autowired
    private ClusterService clusterService;

    @ApiOperation(value="Broker\u4fe1\u606f\u6982\u89c8", notes="")
    @RequestMapping(value={"{clusterId}/brokers/{brokerId}/overview"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<ThirdPartBrokerOverviewVO> getBrokerOverview(@PathVariable Long clusterId, @PathVariable Integer brokerId) {
        BrokerMetadata brokerMetadata = PhysicalClusterMetadataManager.getBrokerMetadata((Long)clusterId, (Integer)brokerId);
        if (ValidateUtils.isNull((Object)brokerMetadata)) {
            return Result.buildFrom((ResultStatus)ResultStatus.BROKER_NOT_EXIST);
        }
        BrokerMetrics brokerMetrics = this.brokerService.getBrokerMetricsFromJmx(clusterId, brokerId, Integer.valueOf(108));
        if (ValidateUtils.isNull((Object)brokerMetrics)) {
            return Result.buildFrom((ResultStatus)ResultStatus.OPERATION_FAILED);
        }
        Integer underReplicated = (Integer)brokerMetrics.getSpecifiedMetrics("UnderReplicatedPartitionsValue", Integer.class);
        if (ValidateUtils.isNull((Object)underReplicated)) {
            return Result.buildFrom((ResultStatus)ResultStatus.OPERATION_FAILED);
        }
        return new Result((Object)new ThirdPartBrokerOverviewVO(clusterId, brokerId, Boolean.valueOf(underReplicated.equals(0))));
    }

    @ApiOperation(value="BrokerRegion\u4fe1\u606f", notes="\u6240\u6709\u96c6\u7fa4\u7684")
    @RequestMapping(value={"broker-regions"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<BrokerRegionVO>> getBrokerRegions() {
        ArrayList regionDOList;
        ArrayList clusterDOList = this.clusterService.list();
        if (ValidateUtils.isNull((Object)clusterDOList)) {
            clusterDOList = new ArrayList();
        }
        if (ValidateUtils.isNull((Object)(regionDOList = this.regionService.listAll()))) {
            regionDOList = new ArrayList();
        }
        ArrayList<BrokerRegionVO> voList = new ArrayList<BrokerRegionVO>();
        for (ClusterDO clusterDO : clusterDOList) {
            Map brokerIdRegionMap = this.regionService.convert2BrokerIdRegionMap(regionDOList.stream().filter(elem -> clusterDO.getId().equals(elem.getClusterId())).collect(Collectors.toList()));
            for (Integer brokerId : PhysicalClusterMetadataManager.getBrokerIdList((Long)clusterDO.getId())) {
                RegionDO regionDO;
                BrokerRegionVO vo = new BrokerRegionVO();
                vo.setClusterId(clusterDO.getId());
                vo.setBrokerId(brokerId);
                BrokerMetadata metadata = PhysicalClusterMetadataManager.getBrokerMetadata((Long)clusterDO.getId(), (Integer)brokerId);
                if (!ValidateUtils.isNull((Object)metadata)) {
                    vo.setHostname(metadata.getHost());
                }
                if (!ValidateUtils.isNull((Object)(regionDO = (RegionDO)brokerIdRegionMap.get(brokerId)))) {
                    vo.setRegionName(regionDO.getName());
                }
                voList.add(vo);
            }
        }
        return new Result(voList);
    }
}

