/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.thirdpart;

import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.metrics.BrokerMetrics;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.common.zookeeper.znode.brokers.BrokerMetadata;
import com.xiaojukeji.kafka.manager.service.cache.PhysicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.service.BrokerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5f00\u653e\u63a5\u53e3-Cluster\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/third-part/"})
public class ThirdPartClusterController {
    @Autowired
    private BrokerService brokerService;

    @ApiOperation(value="Broker\u4fe1\u606f\u6982\u89c8", notes="")
    @RequestMapping(value={"{clusterId}/broker-stabled"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<Boolean> checkBrokerStabled(@PathVariable Long clusterId, @RequestParam(value="hostname") String hostname) {
        BrokerMetadata brokerMetadata = PhysicalClusterMetadataManager.getBrokerMetadata((Long)clusterId, (String)hostname);
        if (ValidateUtils.isNull((Object)brokerMetadata)) {
            return Result.buildFrom((ResultStatus)ResultStatus.BROKER_NOT_EXIST);
        }
        BrokerMetrics brokerMetrics = this.brokerService.getBrokerMetricsFromJmx(clusterId, Integer.valueOf(brokerMetadata.getBrokerId()), Integer.valueOf(108));
        if (ValidateUtils.isNull((Object)brokerMetrics)) {
            return Result.buildFrom((ResultStatus)ResultStatus.OPERATION_FAILED);
        }
        Integer underReplicated = (Integer)brokerMetrics.getSpecifiedMetrics("UnderReplicatedPartitionsValue", Integer.class);
        if (ValidateUtils.isNull((Object)underReplicated)) {
            return Result.buildFrom((ResultStatus)ResultStatus.OPERATION_FAILED);
        }
        return new Result((Object)underReplicated.equals(0));
    }
}

