/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.thirdpart;

import com.xiaojukeji.kafka.manager.common.bizenum.ConsumeHealthEnum;
import com.xiaojukeji.kafka.manager.common.bizenum.OffsetLocationEnum;
import com.xiaojukeji.kafka.manager.common.constant.Constant;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.ao.consumer.ConsumerGroup;
import com.xiaojukeji.kafka.manager.common.entity.pojo.ClusterDO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.gateway.AuthorityDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.consumer.ConsumerGroupDetailVO;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.openapi.ThirdPartService;
import com.xiaojukeji.kafka.manager.openapi.common.dto.ConsumeHealthDTO;
import com.xiaojukeji.kafka.manager.openapi.common.dto.OffsetResetDTO;
import com.xiaojukeji.kafka.manager.openapi.common.vo.ConsumeHealthVO;
import com.xiaojukeji.kafka.manager.service.service.ClusterService;
import com.xiaojukeji.kafka.manager.service.service.ConsumerService;
import com.xiaojukeji.kafka.manager.service.service.gateway.AppService;
import com.xiaojukeji.kafka.manager.service.service.gateway.AuthorityService;
import com.xiaojukeji.kafka.manager.web.converters.ConsumerModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5f00\u653e\u63a5\u53e3-Consumer\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/third-part/"})
public class ThirdPartConsumeController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdPartConsumeController.class);
    @Autowired
    private AppService appService;
    @Autowired
    private ClusterService clusterService;
    @Autowired
    private ConsumerService consumerService;
    @Autowired
    private AuthorityService authorityService;
    @Autowired
    private ThirdPartService thirdPartService;
    private static final List<String> WHITE_SYS_CODES_LIST = Arrays.asList("kafka-manager");

    @ApiOperation(value="\u6d88\u8d39\u7ec4\u5065\u5eb7", notes="\u6d88\u8d39\u7ec4\u662f\u5426\u5065\u5eb7")
    @RequestMapping(value={"clusters/consumer-health"}, method={RequestMethod.POST})
    @ResponseBody
    public Result<ConsumeHealthVO> checkConsumeHealth(@RequestBody ConsumeHealthDTO dto) {
        LOGGER.info("");
        if (ValidateUtils.isNull((Object)dto) || !dto.paramLegal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        Result subEnumResult = null;
        for (String topicName : dto.getTopicNameList()) {
            subEnumResult = this.thirdPartService.checkConsumeHealth(dto.getClusterId(), topicName, dto.getConsumerGroup(), dto.getMaxDelayTime());
            if (Constant.SUCCESS.equals(subEnumResult.getCode())) continue;
            return new Result(Integer.valueOf(subEnumResult.getCode()), subEnumResult.getMessage());
        }
        if (ValidateUtils.isNull(subEnumResult)) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return new Result((Object)new ConsumeHealthVO(((ConsumeHealthEnum)subEnumResult.getData()).getCode()));
    }

    @ApiOperation(value="\u91cd\u7f6e\u6d88\u8d39\u7ec4", notes="")
    @RequestMapping(value={"consumers/offsets"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result<List<Result>> resetOffsets(@RequestBody OffsetResetDTO dto) {
        List resultList;
        LOGGER.info("rest offset, req:{}.", (Object)dto);
        if (ValidateUtils.isNull((Object)dto) || !dto.legal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        ClusterDO clusterDO = this.clusterService.getById(dto.getClusterId());
        if (ValidateUtils.isNull((Object)clusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        if (!WHITE_SYS_CODES_LIST.contains(dto.getSystemCode())) {
            if (!this.appService.verifyAppIdByPassword(dto.getAppId(), dto.getPassword())) {
                return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
            }
            AuthorityDO authority = this.authorityService.getAuthority(dto.getClusterId(), dto.getTopicName(), dto.getAppId());
            if (ValidateUtils.isNull((Object)authority) || (authority.getAccess() & 1) <= 0) {
                authority = this.authorityService.getAuthority(dto.getClusterId(), "*", dto.getAppId());
            }
            if (authority == null || (authority.getAccess() & 1) <= 0) {
                return Result.buildFrom((ResultStatus)ResultStatus.USER_WITHOUT_AUTHORITY);
            }
        }
        if (ValidateUtils.isNull((Object)(resultList = this.thirdPartService.resetOffsets(clusterDO, dto)))) {
            return Result.buildFrom((ResultStatus)ResultStatus.OPERATION_FAILED);
        }
        for (Result result : resultList) {
            if (Constant.SUCCESS.equals(result.getCode())) continue;
            return Result.buildFrom((ResultStatus)ResultStatus.OPERATION_FAILED);
        }
        return new Result((Object)resultList);
    }

    @ApiOperation(value="\u67e5\u8be2\u6d88\u8d39\u7ec4\u7684\u6d88\u8d39\u8be6\u60c5", notes="")
    @RequestMapping(value={"{physicalClusterId}/consumers/{consumerGroup}/topics/{topicName}/consume-details"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<ConsumerGroupDetailVO>> getConsumeDetail(@PathVariable Long physicalClusterId, @PathVariable String consumerGroup, @PathVariable String topicName, @RequestParam(value="location") String location) {
        if (ValidateUtils.isNull((Object)location)) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        ClusterDO clusterDO = this.clusterService.getById(physicalClusterId);
        if (ValidateUtils.isNull((Object)clusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        OffsetLocationEnum offsetStoreLocation = OffsetLocationEnum.getOffsetStoreLocation((String)(location = location.toLowerCase()));
        if (ValidateUtils.isNull((Object)offsetStoreLocation)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CG_LOCATION_ILLEGAL);
        }
        ConsumerGroup consumeGroup = new ConsumerGroup(clusterDO.getId(), consumerGroup, offsetStoreLocation);
        try {
            List consumeDetailDTOList = this.consumerService.getConsumeDetail(clusterDO, topicName, consumeGroup);
            return new Result((Object)ConsumerModelConverter.convert2ConsumerGroupDetailVO((String)topicName, (String)consumerGroup, (String)location, (List)consumeDetailDTOList));
        }
        catch (Exception e) {
            LOGGER.error("get consume detail failed, consumerGroup:{}.", (Object)consumeGroup, (Object)e);
            return Result.buildFrom((ResultStatus)ResultStatus.OPERATION_FAILED);
        }
    }
}

