/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.thirdpart;

import com.xiaojukeji.kafka.manager.common.bizenum.RebalanceDimensionEnum;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.dto.op.RebalanceDTO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.ClusterDO;
import com.xiaojukeji.kafka.manager.common.utils.SpringTool;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.service.AdminService;
import com.xiaojukeji.kafka.manager.service.service.ClusterService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5f00\u653e\u63a5\u53e3-OP\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/third-part/"})
public class ThirdPartOpController {
    @Autowired
    private AdminService adminService;
    @Autowired
    private ClusterService clusterService;

    @ApiOperation(value="\u4f18\u5148\u526f\u672c\u9009\u4e3e")
    @RequestMapping(value={"op/rebalance"}, method={RequestMethod.POST})
    @ResponseBody
    public Result preferredReplicaElect(@RequestBody RebalanceDTO reqObj) {
        if (!reqObj.paramLegal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        ClusterDO clusterDO = this.clusterService.getById(reqObj.getClusterId());
        if (ValidateUtils.isNull((Object)clusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        ResultStatus rs = null;
        if (RebalanceDimensionEnum.CLUSTER.getCode().equals(reqObj.getDimension())) {
            rs = this.adminService.preferredReplicaElection(clusterDO, SpringTool.getUserName());
        } else if (RebalanceDimensionEnum.BROKER.getCode().equals(reqObj.getDimension())) {
            rs = this.adminService.preferredReplicaElection(clusterDO, reqObj.getBrokerId(), SpringTool.getUserName());
        } else if (RebalanceDimensionEnum.TOPIC.getCode().equals(reqObj.getDimension())) {
            rs = this.adminService.preferredReplicaElection(clusterDO, reqObj.getTopicName(), SpringTool.getUserName());
        } else if (RebalanceDimensionEnum.PARTITION.getCode().equals(reqObj.getDimension())) {
            rs = this.adminService.preferredReplicaElection(clusterDO, reqObj.getTopicName(), reqObj.getPartitionId(), SpringTool.getUserName());
        } else {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return Result.buildFrom((ResultStatus)rs);
    }
}

