/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.thirdpart;

import com.xiaojukeji.kafka.manager.common.bizenum.TopicOffsetChangedEnum;
import com.xiaojukeji.kafka.manager.common.constant.Constant;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.metrics.BaseMetrics;
import com.xiaojukeji.kafka.manager.common.entity.pojo.ClusterDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.RealTimeMetricsVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.cluster.TopicMetadataVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.consumer.ConsumerGroupVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicAuthorizedAppVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicRequestTimeDetailVO;
import com.xiaojukeji.kafka.manager.common.utils.DateUtils;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.common.zookeeper.znode.brokers.TopicMetadata;
import com.xiaojukeji.kafka.manager.openapi.common.vo.TopicOffsetChangedVO;
import com.xiaojukeji.kafka.manager.openapi.common.vo.TopicStatisticMetricsVO;
import com.xiaojukeji.kafka.manager.service.cache.PhysicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.service.ClusterService;
import com.xiaojukeji.kafka.manager.service.service.ConsumerService;
import com.xiaojukeji.kafka.manager.service.service.TopicManagerService;
import com.xiaojukeji.kafka.manager.service.service.TopicService;
import com.xiaojukeji.kafka.manager.web.converters.CommonModelConverter;
import com.xiaojukeji.kafka.manager.web.converters.ConsumerModelConverter;
import com.xiaojukeji.kafka.manager.web.converters.TopicModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5f00\u653e\u63a5\u53e3-Topic\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/third-part/"})
public class ThirdPartTopicController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdPartTopicController.class);
    @Autowired
    private TopicService topicService;
    @Autowired
    private ClusterService clusterService;
    @Autowired
    private ConsumerService consumerService;
    @Autowired
    private TopicManagerService topicManagerService;

    @ApiOperation(value="Topic\u5143\u4fe1\u606f", notes="LogX\u8c03\u7528")
    @RequestMapping(value={"clusters/{clusterId}/topics/{topicName}/metadata"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<TopicMetadataVO> getTopicMetadata(@PathVariable Long clusterId, @PathVariable String topicName) {
        TopicMetadata topicMetadata = PhysicalClusterMetadataManager.getTopicMetadata((Long)clusterId, (String)topicName);
        if (ValidateUtils.isNull((Object)topicMetadata)) {
            return Result.buildFrom((ResultStatus)ResultStatus.TOPIC_NOT_EXIST);
        }
        TopicMetadataVO vo = new TopicMetadataVO();
        vo.setTopicName(topicMetadata.getTopic());
        vo.setPartitionNum(Integer.valueOf(topicMetadata.getPartitionNum()));
        return new Result((Object)vo);
    }

    @ApiOperation(value="Topic\u6d41\u91cf\u7edf\u8ba1\u4fe1\u606f", notes="")
    @RequestMapping(value={"{physicalClusterId}/topics/{topicName}/statistic-metrics"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<TopicStatisticMetricsVO> getTopicStatisticMetrics(@PathVariable Long physicalClusterId, @PathVariable String topicName, @RequestParam(value="latest-day") Integer latestDay) {
        try {
            return new Result((Object)new TopicStatisticMetricsVO(this.topicManagerService.getTopicMaxAvgBytesIn(physicalClusterId, topicName, new Date(DateUtils.getDayStarTime((int)(-1 * latestDay))), new Date(), Integer.valueOf(1))));
        }
        catch (Exception e) {
            LOGGER.error("get topic statistic metrics failed, clusterId:{} topicName:{} latestDay:{}.", new Object[]{physicalClusterId, topicName, latestDay, e});
            return Result.buildFrom((ResultStatus)ResultStatus.MYSQL_ERROR);
        }
    }

    @ApiOperation(value="Topic\u662f\u5426\u6709\u6d41\u91cf", notes="")
    @RequestMapping(value={"{physicalClusterId}/topics/{topicName}/offset-changed"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<TopicOffsetChangedVO> checkTopicExpired(@PathVariable Long physicalClusterId, @PathVariable String topicName, @RequestParam(value="latest-time") Long latestTime) {
        Result enumResult = this.topicService.checkTopicOffsetChanged(physicalClusterId, topicName, latestTime);
        if (!Constant.SUCCESS.equals(enumResult.getCode())) {
            return new Result(Integer.valueOf(enumResult.getCode()), enumResult.getMessage());
        }
        return new Result((Object)new TopicOffsetChangedVO(((TopicOffsetChangedEnum)enumResult.getData()).getCode()));
    }

    @ApiOperation(value="Topic\u5b9e\u65f6\u6d41\u91cf\u4fe1\u606f", notes="")
    @RequestMapping(value={"{physicalClusterId}/topics/{topicName}/metrics"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<RealTimeMetricsVO> getTopicMetrics(@PathVariable Long physicalClusterId, @PathVariable String topicName) {
        return new Result((Object)CommonModelConverter.convert2RealTimeMetricsVO((BaseMetrics)this.topicService.getTopicMetricsFromJMX(physicalClusterId, topicName, Integer.valueOf(0), Boolean.valueOf(true))));
    }

    @ApiOperation(value="Topic\u5b9e\u65f6\u8bf7\u6c42\u8017\u65f6\u4fe1\u606f", notes="")
    @RequestMapping(value={"{physicalClusterId}/topics/{topicName}/request-time"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicRequestTimeDetailVO>> getTopicRequestMetrics(@PathVariable Long physicalClusterId, @PathVariable String topicName) {
        BaseMetrics metrics = this.topicService.getTopicMetricsFromJMX(physicalClusterId, topicName, Integer.valueOf(205), Boolean.valueOf(false));
        return new Result((Object)TopicModelConverter.convert2TopicRequestTimeDetailVOList((BaseMetrics)metrics));
    }

    @ApiOperation(value="\u67e5\u8be2Topic\u7684\u6d88\u8d39\u7ec4\u5217\u8868", notes="")
    @RequestMapping(value={"{physicalClusterId}/topics/{topicName}/consumer-groups"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<ConsumerGroupVO>> getConsumeDetail(@PathVariable Long physicalClusterId, @PathVariable String topicName) {
        ClusterDO clusterDO = this.clusterService.getById(physicalClusterId);
        if (ValidateUtils.isNull((Object)clusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return new Result((Object)ConsumerModelConverter.convert2ConsumerGroupVOList((List)this.consumerService.getConsumerGroupList(physicalClusterId, topicName)));
    }

    @ApiOperation(value="Topic\u5e94\u7528\u4fe1\u606f", notes="")
    @RequestMapping(value={"{physicalClusterId}/topics/{topicName}/apps"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicAuthorizedAppVO>> getTopicAppIds(@PathVariable Long physicalClusterId, @PathVariable String topicName) {
        return new Result((Object)TopicModelConverter.convert2TopicAuthorizedAppVOList((List)this.topicManagerService.getTopicAuthorizedApps(physicalClusterId, topicName)));
    }
}

