/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.converters;

import com.xiaojukeji.kafka.manager.common.entity.pojo.ClusterDO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.ClusterTaskDO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.KafkaFileDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.task.ClusterTaskMetadataVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.task.ClusterTaskStatusVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.task.ClusterTaskSubStatusVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.task.ClusterTaskVO;
import com.xiaojukeji.kafka.manager.common.utils.ListUtils;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.kcm.common.bizenum.ClusterTaskSubStateEnum;
import com.xiaojukeji.kafka.manager.kcm.common.entry.ao.ClusterTaskStatus;
import com.xiaojukeji.kafka.manager.kcm.common.entry.ao.ClusterTaskSubStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ClusterTaskModelConverter {
    public static List<ClusterTaskVO> convert2ClusterTaskVOList(List<ClusterTaskDO> doList, Map<Long, String> clusterNameMap) {
        if (ValidateUtils.isEmptyList(doList)) {
            return new ArrayList<ClusterTaskVO>();
        }
        ArrayList<ClusterTaskVO> voList = new ArrayList<ClusterTaskVO>();
        for (ClusterTaskDO clusterTaskDO : doList) {
            ClusterTaskVO vo = new ClusterTaskVO();
            vo.setTaskId(clusterTaskDO.getId());
            vo.setTaskType(clusterTaskDO.getTaskType());
            vo.setClusterId(clusterTaskDO.getClusterId());
            vo.setClusterName(clusterNameMap.getOrDefault(clusterTaskDO.getClusterId(), ""));
            vo.setStatus(clusterTaskDO.getTaskStatus());
            vo.setOperator(clusterTaskDO.getOperator());
            vo.setCreateTime(Long.valueOf(clusterTaskDO.getCreateTime().getTime()));
            voList.add(vo);
        }
        return voList;
    }

    public static ClusterTaskMetadataVO convert2ClusterTaskMetadataVO(ClusterTaskDO clusterTaskDO, ClusterDO clusterDO, KafkaFileDO kafkaFileDO) {
        if (ValidateUtils.isNull((Object)clusterTaskDO)) {
            return null;
        }
        ClusterTaskMetadataVO vo = new ClusterTaskMetadataVO();
        vo.setTaskId(clusterTaskDO.getId());
        vo.setClusterId(clusterTaskDO.getClusterId());
        vo.setClusterName(ValidateUtils.isNull((Object)clusterDO) ? "" : clusterDO.getClusterName());
        vo.setHostList(ListUtils.string2StrList((String)clusterTaskDO.getHostList()));
        vo.setPauseHostList(ListUtils.string2StrList((String)clusterTaskDO.getPauseHostList()));
        vo.setRollbackHostList(ListUtils.string2StrList((String)clusterTaskDO.getRollbackHostList()));
        vo.setRollbackPauseHostList(ListUtils.string2StrList((String)clusterTaskDO.getRollbackPauseHostList()));
        vo.setKafkaPackageName(clusterTaskDO.getKafkaPackage());
        vo.setKafkaPackageMd5(clusterTaskDO.getKafkaPackageMd5());
        vo.setServerPropertiesFileId(ValidateUtils.isNull((Object)kafkaFileDO) ? null : kafkaFileDO.getId());
        vo.setServerPropertiesName(clusterTaskDO.getServerProperties());
        vo.setServerPropertiesMd5(clusterTaskDO.getServerPropertiesMd5());
        vo.setOperator(clusterTaskDO.getOperator());
        vo.setGmtCreate(Long.valueOf(clusterTaskDO.getCreateTime().getTime()));
        return vo;
    }

    public static ClusterTaskStatusVO convert2ClusterTaskStatusVO(ClusterTaskStatus clusterTaskStatus, Map<String, List<String>> hostRoleMap) {
        if (ValidateUtils.isNull((Object)clusterTaskStatus)) {
            return null;
        }
        ClusterTaskStatusVO clusterTaskStatusVO = new ClusterTaskStatusVO();
        clusterTaskStatusVO.setTaskId(clusterTaskStatus.getTaskId());
        if (ValidateUtils.isNull((Object)clusterTaskStatus.getStatus())) {
            clusterTaskStatusVO.setStatus(null);
        } else {
            clusterTaskStatusVO.setStatus(clusterTaskStatus.getStatus().getCode());
        }
        clusterTaskStatusVO.setRollback(clusterTaskStatus.getRollback());
        clusterTaskStatusVO.setSumCount(Integer.valueOf(clusterTaskStatus.getSubStatusList().size()));
        clusterTaskStatusVO.setSuccessCount(Integer.valueOf(0));
        clusterTaskStatusVO.setFailedCount(Integer.valueOf(0));
        clusterTaskStatusVO.setRunningCount(Integer.valueOf(0));
        clusterTaskStatusVO.setWaitingCount(Integer.valueOf(0));
        clusterTaskStatusVO.setSubTaskStatusList(new ArrayList());
        for (ClusterTaskSubStatus elem : clusterTaskStatus.getSubStatusList()) {
            ClusterTaskSubStatusVO vo = new ClusterTaskSubStatusVO();
            vo.setHostname(elem.getHostname());
            vo.setStatus(elem.getStatus().getCode());
            vo.setKafkaRoles(ListUtils.strList2String((List)hostRoleMap.getOrDefault(elem.getHostname(), new ArrayList())));
            vo.setGroupId(elem.getGroupNum());
            if (ClusterTaskSubStateEnum.WAITING.equals((Object)elem.getStatus())) {
                clusterTaskStatusVO.setWaitingCount(Integer.valueOf(clusterTaskStatusVO.getWaitingCount() + 1));
            } else if (ClusterTaskSubStateEnum.RUNNING.equals((Object)elem.getStatus()) || ClusterTaskSubStateEnum.KILLING.equals((Object)elem.getStatus())) {
                clusterTaskStatusVO.setRunningCount(Integer.valueOf(clusterTaskStatusVO.getRunningCount() + 1));
            } else if (ClusterTaskSubStateEnum.FAILED.equals((Object)elem.getStatus()) || ClusterTaskSubStateEnum.TIMEOUT.equals((Object)elem.getStatus()) || ClusterTaskSubStateEnum.CANCELED.equals((Object)elem.getStatus()) || ClusterTaskSubStateEnum.IGNORED.equals((Object)elem.getStatus()) || ClusterTaskSubStateEnum.KILL_FAILED.equals((Object)elem.getStatus())) {
                clusterTaskStatusVO.setFailedCount(Integer.valueOf(clusterTaskStatusVO.getFailedCount() + 1));
            } else if (ClusterTaskSubStateEnum.SUCCEED.equals((Object)elem.getStatus())) {
                clusterTaskStatusVO.setSuccessCount(Integer.valueOf(clusterTaskStatusVO.getSuccessCount() + 1));
            }
            clusterTaskStatusVO.getSubTaskStatusList().add(vo);
        }
        return clusterTaskStatusVO;
    }
}

