/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.converters;

import com.xiaojukeji.kafka.manager.common.entity.ao.TopicDiskLocation;
import com.xiaojukeji.kafka.manager.common.entity.ao.topic.TopicOverview;
import com.xiaojukeji.kafka.manager.common.entity.metrics.BaseMetrics;
import com.xiaojukeji.kafka.manager.common.entity.metrics.BrokerMetrics;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.RealTimeMetricsVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.TopicOverviewVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.broker.BrokerDiskTopicVO;
import com.xiaojukeji.kafka.manager.common.utils.CopyUtils;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.utils.MetricsConvertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommonModelConverter {
    public static RealTimeMetricsVO convert2RealTimeMetricsVO(List<BrokerMetrics> dataList) {
        if (ValidateUtils.isNull(dataList)) {
            return null;
        }
        BaseMetrics baseMetrics = MetricsConvertUtils.merge2BaseMetricsByAdd(dataList);
        return CommonModelConverter.convert2RealTimeMetricsVO((BaseMetrics)baseMetrics);
    }

    public static RealTimeMetricsVO convert2RealTimeMetricsVO(BaseMetrics metrics) {
        if (ValidateUtils.isNull((Object)metrics)) {
            return null;
        }
        RealTimeMetricsVO vo = new RealTimeMetricsVO();
        vo.setByteIn(Arrays.asList((Double)metrics.getSpecifiedMetrics("BytesInPerSecMeanRate", Double.class), (Double)metrics.getSpecifiedMetrics("BytesInPerSecOneMinuteRate", Double.class), (Double)metrics.getSpecifiedMetrics("BytesInPerSecFiveMinuteRate", Double.class), (Double)metrics.getSpecifiedMetrics("BytesInPerSecFifteenMinuteRate", Double.class)));
        vo.setByteOut(Arrays.asList((Double)metrics.getSpecifiedMetrics("BytesOutPerSecMeanRate", Double.class), (Double)metrics.getSpecifiedMetrics("BytesOutPerSecOneMinuteRate", Double.class), (Double)metrics.getSpecifiedMetrics("BytesOutPerSecFiveMinuteRate", Double.class), (Double)metrics.getSpecifiedMetrics("BytesOutPerSecFifteenMinuteRate", Double.class)));
        vo.setMessageIn(Arrays.asList((Double)metrics.getSpecifiedMetrics("MessagesInPerSecMeanRate", Double.class), (Double)metrics.getSpecifiedMetrics("MessagesInPerSecOneMinuteRate", Double.class), (Double)metrics.getSpecifiedMetrics("MessagesInPerSecFiveMinuteRate", Double.class), (Double)metrics.getSpecifiedMetrics("MessagesInPerSecFifteenMinuteRate", Double.class)));
        vo.setByteRejected(Arrays.asList((Double)metrics.getSpecifiedMetrics("BytesRejectedPerSecMeanRate", Double.class), (Double)metrics.getSpecifiedMetrics("BytesRejectedPerSecOneMinuteRate", Double.class), (Double)metrics.getSpecifiedMetrics("BytesRejectedPerSecFiveMinuteRate", Double.class), (Double)metrics.getSpecifiedMetrics("BytesRejectedPerSecFifteenMinuteRate", Double.class)));
        vo.setFailedProduceRequest(Arrays.asList((Double)metrics.getSpecifiedMetrics("FailedProduceRequestsPerSecMeanRate", Double.class), (Double)metrics.getSpecifiedMetrics("FailedProduceRequestsPerSecOneMinuteRate", Double.class), (Double)metrics.getSpecifiedMetrics("FailedProduceRequestsPerSecFiveMinuteRate", Double.class), (Double)metrics.getSpecifiedMetrics("FailedProduceRequestsPerSecFifteenMinuteRate", Double.class)));
        vo.setFailedFetchRequest(Arrays.asList((Double)metrics.getSpecifiedMetrics("FailedFetchRequestsPerSecMeanRate", Double.class), (Double)metrics.getSpecifiedMetrics("FailedFetchRequestsPerSecOneMinuteRate", Double.class), (Double)metrics.getSpecifiedMetrics("FailedFetchRequestsPerSecFiveMinuteRate", Double.class), (Double)metrics.getSpecifiedMetrics("FailedFetchRequestsPerSecFifteenMinuteRate", Double.class)));
        vo.setTotalProduceRequest(Arrays.asList((Double)metrics.getSpecifiedMetrics("TotalProduceRequestsPerSecMeanRate", Double.class), (Double)metrics.getSpecifiedMetrics("TotalProduceRequestsPerSecOneMinuteRate", Double.class), (Double)metrics.getSpecifiedMetrics("TotalProduceRequestsPerSecFiveMinuteRate", Double.class), (Double)metrics.getSpecifiedMetrics("TotalProduceRequestsPerSecFifteenMinuteRate", Double.class)));
        vo.setTotalFetchRequest(Arrays.asList((Double)metrics.getSpecifiedMetrics("TotalFetchRequestsPerSecMeanRate", Double.class), (Double)metrics.getSpecifiedMetrics("TotalFetchRequestsPerSecOneMinuteRate", Double.class), (Double)metrics.getSpecifiedMetrics("TotalFetchRequestsPerSecFiveMinuteRate", Double.class), (Double)metrics.getSpecifiedMetrics("TotalFetchRequestsPerSecFifteenMinuteRate", Double.class)));
        return vo;
    }

    public static List<TopicOverviewVO> convert2TopicOverviewVOList(Long clusterId, List<TopicOverview> dtoList) {
        if (ValidateUtils.isEmptyList(dtoList)) {
            return new ArrayList<TopicOverviewVO>();
        }
        ArrayList<TopicOverviewVO> voList = new ArrayList<TopicOverviewVO>();
        for (TopicOverview dto : dtoList) {
            TopicOverviewVO vo = new TopicOverviewVO();
            CopyUtils.copyProperties((Object)vo, (Object)dto);
            vo.setClusterId(clusterId);
            voList.add(vo);
        }
        return voList;
    }

    public static List<BrokerDiskTopicVO> convert2BrokerDiskTopicVOList(List<TopicDiskLocation> locationList) {
        if (ValidateUtils.isEmptyList(locationList)) {
            return new ArrayList<BrokerDiskTopicVO>();
        }
        ArrayList<BrokerDiskTopicVO> voList = new ArrayList<BrokerDiskTopicVO>();
        for (TopicDiskLocation location : locationList) {
            BrokerDiskTopicVO vo = new BrokerDiskTopicVO();
            vo.setClusterId(location.getClusterId());
            vo.setTopicName(location.getTopicName());
            vo.setBrokerId(location.getBrokerId());
            vo.setDiskName(location.getDiskName());
            vo.setLeaderPartitions(location.getLeaderPartitions());
            vo.setFollowerPartitions(location.getFollowerPartitions());
            vo.setUnderReplicated(location.getUnderReplicated());
            vo.setNotUnderReplicatedPartitions(location.getUnderReplicatedPartitions());
            voList.add(vo);
        }
        return voList;
    }
}

