/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.converters;

import com.xiaojukeji.kafka.manager.common.entity.ao.consumer.ConsumeDetailDTO;
import com.xiaojukeji.kafka.manager.common.entity.ao.consumer.ConsumerGroup;
import com.xiaojukeji.kafka.manager.common.entity.ao.consumer.ConsumerGroupSummary;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.consumer.ConsumerGroupDetailVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.consumer.ConsumerGroupSummaryVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.consumer.ConsumerGroupVO;
import com.xiaojukeji.kafka.manager.common.utils.ListUtils;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConsumerModelConverter {
    public static List<ConsumerGroupDetailVO> convert2ConsumerGroupDetailVO(String topicName, String consumeGroup, String location, List<ConsumeDetailDTO> consumeDetailDTOList) {
        if (consumeDetailDTOList == null || consumeDetailDTOList.isEmpty()) {
            return new ArrayList<ConsumerGroupDetailVO>();
        }
        ArrayList<ConsumerGroupDetailVO> consumerGroupDetailVOList = new ArrayList<ConsumerGroupDetailVO>();
        for (ConsumeDetailDTO consumeDetailDTO : consumeDetailDTOList) {
            ConsumerGroupDetailVO consumerGroupDetailVO = new ConsumerGroupDetailVO();
            consumerGroupDetailVO.setTopicName(topicName);
            consumerGroupDetailVO.setConsumerGroup(consumeGroup);
            consumerGroupDetailVO.setLocation(location);
            consumerGroupDetailVO.setPartitionId(consumeDetailDTO.getPartitionId());
            consumerGroupDetailVO.setClientId(consumeDetailDTO.getConsumerId());
            consumerGroupDetailVO.setConsumeOffset(consumeDetailDTO.getConsumeOffset());
            consumerGroupDetailVO.setPartitionOffset(consumeDetailDTO.getOffset());
            if (consumeDetailDTO.getOffset() != null && consumeDetailDTO.getConsumeOffset() != null) {
                consumerGroupDetailVO.setLag(Long.valueOf(consumeDetailDTO.getOffset() - consumeDetailDTO.getConsumeOffset()));
            }
            consumerGroupDetailVOList.add(consumerGroupDetailVO);
        }
        return consumerGroupDetailVOList;
    }

    public static List<ConsumerGroupVO> convert2ConsumerGroupVOList(List<ConsumerGroup> consumerGroupList) {
        if (ValidateUtils.isEmptyList(consumerGroupList)) {
            return Collections.emptyList();
        }
        ArrayList<ConsumerGroupVO> consumerGroupVOList = new ArrayList<ConsumerGroupVO>();
        for (ConsumerGroup consumerGroup : consumerGroupList) {
            ConsumerGroupVO vo = new ConsumerGroupVO();
            vo.setConsumerGroup(consumerGroup.getConsumerGroup());
            vo.setAppIds("");
            vo.setLocation(consumerGroup.getOffsetStoreLocation().location);
            consumerGroupVOList.add(vo);
        }
        return consumerGroupVOList;
    }

    public static List<ConsumerGroupSummaryVO> convert2ConsumerGroupSummaryVOList(List<ConsumerGroupSummary> summaryList) {
        if (ValidateUtils.isEmptyList(summaryList)) {
            return Collections.emptyList();
        }
        ArrayList<ConsumerGroupSummaryVO> voList = new ArrayList<ConsumerGroupSummaryVO>();
        for (ConsumerGroupSummary consumerGroupSummary : summaryList) {
            ConsumerGroupSummaryVO vo = new ConsumerGroupSummaryVO();
            vo.setConsumerGroup(consumerGroupSummary.getConsumerGroup());
            vo.setAppIds(ListUtils.strList2String((List)consumerGroupSummary.getAppIdList()));
            vo.setLocation(consumerGroupSummary.getOffsetStoreLocation().location);
            vo.setState(consumerGroupSummary.getState());
            voList.add(vo);
        }
        return voList;
    }
}

