/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.converters;

import com.xiaojukeji.kafka.manager.bpm.common.entry.apply.gateway.OrderExtensionAddGatewayConfigDTO;
import com.xiaojukeji.kafka.manager.bpm.common.entry.apply.gateway.OrderExtensionModifyGatewayConfigDTO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.gateway.GatewayConfigDO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.gateway.KafkaAclDO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.gateway.KafkaUserDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.gateway.KafkaAclVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.gateway.KafkaUserVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.GatewayConfigVO;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import java.util.ArrayList;
import java.util.List;

public class GatewayModelConverter {
    public static List<KafkaAclVO> convert2KafkaAclVOList(List<KafkaAclDO> doList) {
        if (ValidateUtils.isNull(doList)) {
            return new ArrayList<KafkaAclVO>();
        }
        ArrayList<KafkaAclVO> voList = new ArrayList<KafkaAclVO>();
        for (KafkaAclDO kafkaAclDO : doList) {
            KafkaAclVO vo = new KafkaAclVO();
            vo.setTopicName(kafkaAclDO.getTopicName());
            vo.setTimestamp(Long.valueOf(kafkaAclDO.getCreateTime().getTime()));
            vo.setAccess(kafkaAclDO.getAccess());
            vo.setUsername(kafkaAclDO.getAppId());
            vo.setOperation(kafkaAclDO.getOperation());
            voList.add(vo);
        }
        return voList;
    }

    public static List<KafkaUserVO> convert2KafkaUserVOList(List<KafkaUserDO> doList) {
        if (ValidateUtils.isNull(doList)) {
            return new ArrayList<KafkaUserVO>();
        }
        ArrayList<KafkaUserVO> voList = new ArrayList<KafkaUserVO>();
        for (KafkaUserDO kafkaUserDO : doList) {
            KafkaUserVO vo = new KafkaUserVO();
            vo.setUsername(kafkaUserDO.getAppId());
            vo.setPassword(kafkaUserDO.getPassword());
            vo.setTimestamp(Long.valueOf(kafkaUserDO.getCreateTime().getTime()));
            vo.setUserType(kafkaUserDO.getUserType());
            vo.setOperation(kafkaUserDO.getOperation());
            voList.add(vo);
        }
        return voList;
    }

    public static List<GatewayConfigVO> convert2GatewayConfigVOList(List<GatewayConfigDO> doList) {
        if (ValidateUtils.isNull(doList)) {
            return new ArrayList<GatewayConfigVO>();
        }
        ArrayList<GatewayConfigVO> voList = new ArrayList<GatewayConfigVO>();
        for (GatewayConfigDO configDO : doList) {
            GatewayConfigVO vo = new GatewayConfigVO();
            vo.setId(configDO.getId());
            vo.setType(configDO.getType());
            vo.setName(configDO.getName());
            vo.setValue(configDO.getValue());
            vo.setVersion(configDO.getVersion());
            vo.setCreateTime(configDO.getCreateTime());
            vo.setModifyTime(configDO.getModifyTime());
            voList.add(vo);
        }
        return voList;
    }

    public static GatewayConfigDO convert2GatewayConfigDO(OrderExtensionAddGatewayConfigDTO configDTO) {
        GatewayConfigDO configDO = new GatewayConfigDO();
        configDO.setType(configDO.getType());
        configDO.setName(configDO.getName());
        configDO.setValue(configDO.getValue());
        return configDO;
    }

    public static GatewayConfigDO convert2GatewayConfigDO(OrderExtensionModifyGatewayConfigDTO configDTO) {
        GatewayConfigDO configDO = new GatewayConfigDO();
        configDO.setId(configDO.getId());
        configDO.setType(configDO.getType());
        configDO.setName(configDO.getName());
        configDO.setValue(configDO.getValue());
        return configDO;
    }
}

