/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.converters;

import com.xiaojukeji.kafka.manager.common.entity.pojo.MonitorRuleDO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.gateway.AppDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.app.AppSummaryVO;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.monitor.common.entry.Alert;
import com.xiaojukeji.kafka.manager.monitor.common.entry.Metric;
import com.xiaojukeji.kafka.manager.monitor.common.entry.NotifyGroup;
import com.xiaojukeji.kafka.manager.monitor.common.entry.Silence;
import com.xiaojukeji.kafka.manager.monitor.common.entry.dto.MetricPoint;
import com.xiaojukeji.kafka.manager.monitor.common.entry.dto.MonitorRuleDTO;
import com.xiaojukeji.kafka.manager.monitor.common.entry.vo.MonitorAlertDetailVO;
import com.xiaojukeji.kafka.manager.monitor.common.entry.vo.MonitorAlertVO;
import com.xiaojukeji.kafka.manager.monitor.common.entry.vo.MonitorMetricPoint;
import com.xiaojukeji.kafka.manager.monitor.common.entry.vo.MonitorMetricVO;
import com.xiaojukeji.kafka.manager.monitor.common.entry.vo.MonitorNotifyGroupVO;
import com.xiaojukeji.kafka.manager.monitor.common.entry.vo.MonitorRuleDetailVO;
import com.xiaojukeji.kafka.manager.monitor.common.entry.vo.MonitorSilenceVO;
import com.xiaojukeji.kafka.manager.monitor.common.monitor.MonitorAlertDetail;
import java.util.ArrayList;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class MonitorRuleConverter {
    public static MonitorRuleDetailVO convert2MonitorRuleDetailVO(MonitorRuleDO monitorRuleDO, MonitorRuleDTO monitorRuleDTO, AppDO appDO) {
        MonitorRuleDetailVO vo = new MonitorRuleDetailVO();
        vo.setId(monitorRuleDO.getId());
        vo.setName(monitorRuleDO.getName());
        vo.setOperator(monitorRuleDO.getOperator());
        vo.setCreateTime(Long.valueOf(monitorRuleDO.getCreateTime().getTime()));
        vo.setModifyTime(Long.valueOf(monitorRuleDO.getModifyTime().getTime()));
        vo.setMonitorRule(monitorRuleDTO);
        if (ValidateUtils.isNull((Object)appDO)) {
            return vo;
        }
        AppSummaryVO appSummaryVO = new AppSummaryVO();
        appSummaryVO.setAppId(appDO.getAppId());
        appSummaryVO.setName(appDO.getName());
        appSummaryVO.setPrincipals(appDO.getPrincipals());
        vo.setAppSummary(appSummaryVO);
        return vo;
    }

    public static List<MonitorAlertVO> convert2MonitorAlertVOList(List<Alert> alertList) {
        if (ValidateUtils.isNull(alertList)) {
            return new ArrayList<MonitorAlertVO>();
        }
        ArrayList<MonitorAlertVO> voList = new ArrayList<MonitorAlertVO>();
        for (Alert alert : alertList) {
            voList.add(MonitorRuleConverter.convert2MonitorAlertVO((Alert)alert));
        }
        return voList;
    }

    public static MonitorAlertDetailVO convert2MonitorAlertDetailVO(MonitorAlertDetail monitorAlertDetail) {
        MonitorAlertDetailVO monitorAlertDetailVO = new MonitorAlertDetailVO();
        monitorAlertDetailVO.setMonitorAlert(MonitorRuleConverter.convert2MonitorAlertVO((Alert)monitorAlertDetail.getAlert()));
        monitorAlertDetailVO.setMonitorMetric(MonitorRuleConverter.convert2MonitorMetricVO((Metric)monitorAlertDetail.getMetric()));
        return monitorAlertDetailVO;
    }

    private static MonitorAlertVO convert2MonitorAlertVO(Alert alert) {
        if (ValidateUtils.isNull((Object)alert)) {
            return null;
        }
        MonitorAlertVO vo = new MonitorAlertVO();
        vo.setAlertId(alert.getId());
        vo.setMonitorId(alert.getMonitorId());
        vo.setMonitorName(alert.getStrategyName());
        vo.setMonitorPriority(alert.getPriority());
        vo.setAlertStatus(Integer.valueOf("alert".equals(alert.getType()) ? 0 : 1));
        vo.setStartTime(Long.valueOf(alert.getStartTime() * 1000L));
        vo.setEndTime(Long.valueOf(alert.getEndTime() * 1000L));
        vo.setMetric(alert.getMetric());
        vo.setValue(alert.getValue());
        vo.setPoints(alert.getPoints());
        vo.setGroups(alert.getGroups());
        vo.setInfo(alert.getInfo());
        return vo;
    }

    private static MonitorMetricVO convert2MonitorMetricVO(Metric metric) {
        MonitorMetricVO vo = new MonitorMetricVO();
        vo.setMetric(metric.getMetric());
        vo.setStep(metric.getStep());
        vo.setValues(new ArrayList());
        vo.setComparison(metric.getComparison());
        vo.setDelta(metric.getDelta());
        vo.setOrigin(metric.getOrigin());
        for (MetricPoint metricPoint : metric.getValues()) {
            vo.getValues().add(new MonitorMetricPoint(metricPoint.getTimestamp(), metricPoint.getValue()));
        }
        return vo;
    }

    public static List<MonitorSilenceVO> convert2MonitorSilenceVOList(MonitorRuleDO monitorRuleDO, List<Silence> silenceList) {
        if (ValidateUtils.isNull(silenceList)) {
            return new ArrayList<MonitorSilenceVO>();
        }
        ArrayList<MonitorSilenceVO> voList = new ArrayList<MonitorSilenceVO>();
        for (Silence silence : silenceList) {
            voList.add(MonitorRuleConverter.convert2MonitorSilenceVO((MonitorRuleDO)monitorRuleDO, (Silence)silence));
        }
        return voList;
    }

    public static MonitorSilenceVO convert2MonitorSilenceVO(MonitorRuleDO monitorRuleDO, Silence silence) {
        if (ValidateUtils.isNull((Object)silence)) {
            return null;
        }
        MonitorSilenceVO vo = new MonitorSilenceVO();
        vo.setSilenceId(silence.getSilenceId());
        vo.setMonitorId(monitorRuleDO.getId());
        vo.setMonitorName(monitorRuleDO.getName());
        vo.setStartTime(silence.getBeginTime());
        vo.setEndTime(silence.getEndTime());
        vo.setDescription(silence.getDescription());
        return vo;
    }

    public static List<MonitorNotifyGroupVO> convert2MonitorNotifyGroupVOList(List<NotifyGroup> notifyGroupList) {
        if (ValidateUtils.isEmptyList(notifyGroupList)) {
            return new ArrayList<MonitorNotifyGroupVO>();
        }
        ArrayList<MonitorNotifyGroupVO> voList = new ArrayList<MonitorNotifyGroupVO>();
        for (NotifyGroup notifyGroup : notifyGroupList) {
            MonitorNotifyGroupVO vo = new MonitorNotifyGroupVO();
            vo.setId(notifyGroup.getId());
            vo.setName(notifyGroup.getName());
            vo.setComment(notifyGroup.getComment());
            voList.add(vo);
        }
        return voList;
    }
}

