/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.converters;

import com.xiaojukeji.kafka.manager.bpm.common.OrderResult;
import com.xiaojukeji.kafka.manager.bpm.common.entry.BaseOrderDetailData;
import com.xiaojukeji.kafka.manager.common.entity.ao.account.Account;
import com.xiaojukeji.kafka.manager.common.entity.pojo.OrderDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.AccountVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.order.OrderResultVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.order.OrderVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.order.detail.OrderDetailBaseVO;
import com.xiaojukeji.kafka.manager.common.utils.CopyUtils;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class OrderConverter {
    public static List<OrderVO> convert2OrderVOList(List<OrderDO> orderDOList) {
        if (orderDOList == null || orderDOList.isEmpty()) {
            return new ArrayList<OrderVO>();
        }
        ArrayList<OrderVO> orderVOList = new ArrayList<OrderVO>();
        for (OrderDO orderDO : orderDOList) {
            OrderVO orderVO = OrderConverter.convert2OrderVO((OrderDO)orderDO);
            if (ValidateUtils.isNull((Object)orderVO)) continue;
            orderVOList.add(orderVO);
        }
        return orderVOList;
    }

    public static OrderVO convert2OrderVO(OrderDO orderDO) {
        if (ValidateUtils.isNull((Object)orderDO)) {
            return null;
        }
        OrderVO orderVO = new OrderVO();
        CopyUtils.copyProperties((Object)orderVO, (Object)orderDO);
        orderVO.setGmtTime(orderDO.getGmtCreate());
        return orderVO;
    }

    public static OrderDetailBaseVO convert2DetailBaseVO(BaseOrderDetailData baseDTO) {
        OrderDetailBaseVO baseVO = new OrderDetailBaseVO();
        if (ValidateUtils.isNull((Object)baseDTO)) {
            return baseVO;
        }
        CopyUtils.copyProperties((Object)baseVO, (Object)baseDTO);
        baseVO.setDetail((Object)baseDTO.getDetail());
        AccountVO accountVO = new AccountVO();
        CopyUtils.copyProperties((Object)accountVO, (Object)baseDTO.getApplicant());
        if (!ValidateUtils.isNull((Object)baseDTO.getApplicant()) && !ValidateUtils.isNull((Object)baseDTO.getApplicant().getAccountRoleEnum())) {
            accountVO.setRole(baseDTO.getApplicant().getAccountRoleEnum().getRole());
        }
        baseVO.setApplicant(accountVO);
        ArrayList<AccountVO> approverList = new ArrayList<AccountVO>();
        for (Account account : baseDTO.getApproverList()) {
            AccountVO approver = new AccountVO();
            CopyUtils.copyProperties((Object)approver, (Object)account);
            if (!ValidateUtils.isNull((Object)account.getAccountRoleEnum())) {
                approver.setRole(account.getAccountRoleEnum().getRole());
            }
            approverList.add(approver);
        }
        baseVO.setApproverList(approverList);
        return baseVO;
    }

    public static List<OrderResultVO> convert2OrderResultVOList(List<OrderResult> orderResultList) {
        if (ValidateUtils.isEmptyList(orderResultList)) {
            return Collections.emptyList();
        }
        ArrayList<OrderResultVO> voList = new ArrayList<OrderResultVO>();
        for (OrderResult orderResult : orderResultList) {
            OrderResultVO vo = new OrderResultVO();
            vo.setId(orderResult.getId());
            vo.setResult(orderResult.getResult());
            voList.add(vo);
        }
        return voList;
    }
}

