/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.converters;

import com.xiaojukeji.kafka.manager.common.bizenum.TaskStatusReassignEnum;
import com.xiaojukeji.kafka.manager.common.entity.ao.reassign.ReassignStatus;
import com.xiaojukeji.kafka.manager.common.entity.pojo.ReassignTaskDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.reassign.ReassignPartitionStatusVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.reassign.ReassignTaskVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.op.reassign.ReassignTopicStatusVO;
import com.xiaojukeji.kafka.manager.common.utils.DateUtils;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.common.zookeeper.znode.ReassignmentElemData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import kafka.common.TopicAndPartition;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReassignModelConverter {
    public static List<ReassignTopicStatusVO> convert2ReassignTopicStatusVOList(List<ReassignStatus> dtoList) {
        if (ValidateUtils.isNull(dtoList)) {
            return new ArrayList<ReassignTopicStatusVO>();
        }
        ArrayList<ReassignTopicStatusVO> voList = new ArrayList<ReassignTopicStatusVO>();
        for (ReassignStatus elem : dtoList) {
            ReassignTopicStatusVO vo = new ReassignTopicStatusVO();
            vo.setSubTaskId(elem.getSubTaskId());
            vo.setClusterId(elem.getClusterId());
            vo.setClusterName(elem.getClusterName());
            vo.setTopicName(elem.getTopicName());
            vo.setStatus(elem.getStatus());
            vo.setCompletedPartitionNum(Integer.valueOf(0));
            vo.setRealThrottle(elem.getRealThrottle());
            vo.setMaxThrottle(elem.getMaxThrottle());
            vo.setMinThrottle(elem.getMinThrottle());
            vo.setTotalPartitionNum(Integer.valueOf(elem.getReassignList().size()));
            vo.setReassignList(new ArrayList());
            if (ValidateUtils.isNull((Object)elem.getReassignStatusMap())) {
                elem.setReassignStatusMap(new HashMap());
            }
            for (ReassignmentElemData elemData : elem.getReassignList()) {
                ReassignPartitionStatusVO partitionStatusVO = new ReassignPartitionStatusVO();
                partitionStatusVO.setPartitionId(elemData.getPartition());
                partitionStatusVO.setDestReplicaIdList(elemData.getReplicas());
                TaskStatusReassignEnum reassignEnum = (TaskStatusReassignEnum)elem.getReassignStatusMap().get(new TopicAndPartition(elem.getTopicName(), elemData.getPartition().intValue()));
                if (!ValidateUtils.isNull((Object)reassignEnum)) {
                    partitionStatusVO.setStatus(reassignEnum.getCode());
                }
                if (!ValidateUtils.isNull((Object)reassignEnum) && TaskStatusReassignEnum.isFinished((Integer)reassignEnum.getCode()).booleanValue()) {
                    vo.setCompletedPartitionNum(Integer.valueOf(vo.getCompletedPartitionNum() + 1));
                }
                vo.getReassignList().add(partitionStatusVO);
            }
            voList.add(vo);
        }
        return voList;
    }

    public static List<ReassignTaskVO> convert2ReassignTaskVOList(List<ReassignTaskDO> doList) {
        if (ValidateUtils.isEmptyList(doList)) {
            return new ArrayList<ReassignTaskVO>();
        }
        TreeMap doMap = new TreeMap(Collections.reverseOrder());
        for (ReassignTaskDO elem : doList) {
            List subDOList = doMap.getOrDefault(elem.getTaskId(), new ArrayList());
            subDOList.add(elem);
            doMap.put(elem.getTaskId(), subDOList);
        }
        ArrayList<ReassignTaskVO> voList = new ArrayList<ReassignTaskVO>();
        for (Long taskId : doMap.keySet()) {
            voList.add(ReassignModelConverter.convert2ReassignTaskVO((Long)taskId, (List)((List)doMap.get(taskId))));
        }
        return voList;
    }

    public static ReassignTaskVO convert2ReassignTaskVO(Long taskId, List<ReassignTaskDO> doList) {
        if (ValidateUtils.isEmptyList(doList)) {
            return null;
        }
        ReassignTaskVO vo = new ReassignTaskVO();
        vo.setTaskName(String.format("%s \u6570\u636e\u8fc1\u79fb\u4efb\u52a1", DateUtils.getFormattedDate((Long)taskId)));
        vo.setTaskId(taskId);
        vo.setTotalTopicNum(Integer.valueOf(doList.size()));
        vo.setBeginTime(Long.valueOf(0L));
        vo.setEndTime(Long.valueOf(0L));
        Integer completedTopicNum = 0;
        HashSet<Integer> statusSet = new HashSet<Integer>();
        for (ReassignTaskDO elem : doList) {
            vo.setGmtCreate(Long.valueOf(elem.getGmtCreate().getTime()));
            vo.setOperator(elem.getOperator());
            vo.setDescription(elem.getDescription());
            if (TaskStatusReassignEnum.isFinished((Integer)elem.getStatus()).booleanValue()) {
                completedTopicNum = completedTopicNum + 1;
                statusSet.add(elem.getStatus());
                vo.setEndTime(Long.valueOf(Math.max(elem.getGmtModify().getTime(), vo.getEndTime())));
            } else {
                statusSet.add(elem.getStatus());
            }
            vo.setBeginTime(Long.valueOf(elem.getBeginTime().getTime()));
        }
        if (statusSet.contains(TaskStatusReassignEnum.RUNNING.getCode())) {
            vo.setStatus(TaskStatusReassignEnum.RUNNING.getCode());
            vo.setEndTime(null);
        } else if (statusSet.contains(TaskStatusReassignEnum.RUNNABLE.getCode())) {
            vo.setStatus(TaskStatusReassignEnum.RUNNABLE.getCode());
            vo.setEndTime(null);
        } else if (statusSet.contains(TaskStatusReassignEnum.NEW.getCode()) && statusSet.size() == 1) {
            vo.setStatus(TaskStatusReassignEnum.NEW.getCode());
            vo.setEndTime(null);
        } else if (statusSet.contains(TaskStatusReassignEnum.CANCELED.getCode()) && statusSet.size() == 1) {
            vo.setStatus(TaskStatusReassignEnum.CANCELED.getCode());
        } else if (statusSet.contains(TaskStatusReassignEnum.SUCCEED.getCode()) && statusSet.size() == 1) {
            vo.setStatus(TaskStatusReassignEnum.SUCCEED.getCode());
        } else if (statusSet.contains(TaskStatusReassignEnum.FAILED.getCode())) {
            vo.setStatus(TaskStatusReassignEnum.FAILED.getCode());
        } else {
            vo.setStatus(TaskStatusReassignEnum.UNKNOWN.getCode());
            vo.setEndTime(null);
        }
        vo.setCompletedTopicNum(completedTopicNum);
        return vo;
    }
}

