/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.converters;

import com.xiaojukeji.kafka.manager.common.entity.ao.topic.TopicAppData;
import com.xiaojukeji.kafka.manager.common.entity.ao.topic.TopicBasicDTO;
import com.xiaojukeji.kafka.manager.common.entity.ao.topic.TopicBrokerDTO;
import com.xiaojukeji.kafka.manager.common.entity.ao.topic.TopicBusinessInfo;
import com.xiaojukeji.kafka.manager.common.entity.ao.topic.TopicConnection;
import com.xiaojukeji.kafka.manager.common.entity.ao.topic.TopicMetricsDTO;
import com.xiaojukeji.kafka.manager.common.entity.ao.topic.TopicPartitionDTO;
import com.xiaojukeji.kafka.manager.common.entity.metrics.BaseMetrics;
import com.xiaojukeji.kafka.manager.common.entity.metrics.TopicMetrics;
import com.xiaojukeji.kafka.manager.common.entity.pojo.ClusterDO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.TopicMetricsDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.TopicBusinessInfoVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicAuthorizedAppVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicBasicVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicBrokerRequestTimeVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicConnectionVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicDataSampleVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicMetricVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicMyAppVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicPartitionVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicRequestTimeDetailVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicRequestTimeVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.TopicBrokerVO;
import com.xiaojukeji.kafka.manager.common.utils.CopyUtils;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.utils.MetricsConvertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class TopicModelConverter {
    public static TopicBasicVO convert2TopicBasicVO(TopicBasicDTO dto, ClusterDO clusterDO, Long logicalClusterId) {
        TopicBasicVO vo = new TopicBasicVO();
        vo.setClusterId(logicalClusterId);
        vo.setAppId(dto.getAppId());
        vo.setAppName(dto.getAppName());
        vo.setPartitionNum(dto.getPartitionNum());
        vo.setReplicaNum(dto.getReplicaNum());
        vo.setPrincipals(dto.getPrincipals());
        vo.setRetentionTime(dto.getRetentionTime());
        vo.setCreateTime(dto.getCreateTime());
        vo.setModifyTime(dto.getModifyTime());
        vo.setScore(dto.getScore());
        vo.setTopicCodeC(dto.getTopicCodeC());
        vo.setDescription(dto.getDescription());
        vo.setBootstrapServers("");
        vo.setRegionNameList(dto.getRegionNameList());
        if (!ValidateUtils.isNull((Object)clusterDO)) {
            vo.setBootstrapServers(clusterDO.getBootstrapServers());
        }
        vo.setRegionNameList(dto.getRegionNameList());
        return vo;
    }

    public static List<TopicPartitionVO> convert2TopicPartitionVOList(List<TopicPartitionDTO> dtoList) {
        ArrayList<TopicPartitionVO> voList = new ArrayList<TopicPartitionVO>();
        for (TopicPartitionDTO dto : dtoList) {
            TopicPartitionVO vo = new TopicPartitionVO();
            CopyUtils.copyProperties((Object)vo, (Object)dto);
            if (!ValidateUtils.isNull((Object)dto.getBeginningOffset()) && !ValidateUtils.isNull((Object)dto.getEndOffset())) {
                vo.setMsgNum(Long.valueOf(dto.getEndOffset() - dto.getBeginningOffset()));
            }
            vo.setReplicaBrokerIdList(dto.getReplicaBrokerIdList());
            vo.setIsrBrokerIdList(dto.getIsrBrokerIdList());
            voList.add(vo);
        }
        return voList;
    }

    public static List<TopicRequestTimeVO> convert2TopicRequestTimeMetricsVOList(List<TopicMetricsDO> metricsList) {
        ArrayList<TopicRequestTimeVO> voList = new ArrayList<TopicRequestTimeVO>();
        for (TopicMetricsDO elem : metricsList) {
            TopicRequestTimeVO vo = new TopicRequestTimeVO();
            TopicMetrics metrics = MetricsConvertUtils.convert2TopicMetrics((TopicMetricsDO)elem);
            vo.setProduceRequestTimeMean(metrics.getSpecifiedMetrics("ProduceTotalTimeMsMean"));
            vo.setProduceRequestTime50thPercentile(metrics.getSpecifiedMetrics("ProduceTotalTimeMs50thPercentile"));
            vo.setProduceRequestTime75thPercentile(metrics.getSpecifiedMetrics("ProduceTotalTimeMs75thPercentile"));
            vo.setProduceRequestTime95thPercentile(metrics.getSpecifiedMetrics("ProduceTotalTimeMs95thPercentile"));
            vo.setProduceRequestTime99thPercentile(metrics.getSpecifiedMetrics("ProduceTotalTimeMs99thPercentile"));
            vo.setFetchRequestTimeMean(metrics.getSpecifiedMetrics("FetchConsumerTotalTimeMsMean"));
            vo.setFetchRequestTime50thPercentile(metrics.getSpecifiedMetrics("FetchConsumerTotalTimeMs50thPercentile"));
            vo.setFetchRequestTime75thPercentile(metrics.getSpecifiedMetrics("FetchConsumerTotalTimeMs75thPercentile"));
            vo.setFetchRequestTime95thPercentile(metrics.getSpecifiedMetrics("FetchConsumerTotalTimeMs95thPercentile"));
            vo.setFetchRequestTime99thPercentile(metrics.getSpecifiedMetrics("FetchConsumerTotalTimeMs99thPercentile"));
            vo.setGmtCreate(metrics.getSpecifiedMetrics("CreateTime", Long.class));
            voList.add(vo);
        }
        return voList;
    }

    public static List<TopicRequestTimeDetailVO> convert2TopicRequestTimeDetailVOList(BaseMetrics metrics) {
        if (ValidateUtils.isNull((Object)metrics)) {
            return new ArrayList<TopicRequestTimeDetailVO>();
        }
        TopicRequestTimeDetailVO produceVO = new TopicRequestTimeDetailVO();
        produceVO.setRequestTimeType("RequestProduceTime");
        produceVO.setRequestQueueTimeMs(metrics.getSpecifiedMetrics("ProduceRequestQueueTimeMs99thPercentile"));
        produceVO.setResponseQueueTimeMs(metrics.getSpecifiedMetrics("ProduceResponseQueueTimeMs99thPercentile"));
        produceVO.setResponseSendTimeMs(metrics.getSpecifiedMetrics("ProduceResponseSendTimeMs99thPercentile"));
        produceVO.setLocalTimeMs(metrics.getSpecifiedMetrics("ProduceLocalTimeMs99thPercentile"));
        produceVO.setThrottleTimeMs(metrics.getSpecifiedMetrics("ProduceThrottleTimeMs99thPercentile"));
        produceVO.setRemoteTimeMs(metrics.getSpecifiedMetrics("ProduceRemoteTimeMs99thPercentile"));
        produceVO.setTotalTimeMs(metrics.getSpecifiedMetrics("ProduceTotalTimeMs99thPercentile"));
        TopicRequestTimeDetailVO fetchVO = new TopicRequestTimeDetailVO();
        fetchVO.setRequestTimeType("RequestFetchTime");
        fetchVO.setRequestQueueTimeMs(metrics.getSpecifiedMetrics("FetchConsumerRequestQueueTimeMs99thPercentile"));
        fetchVO.setResponseQueueTimeMs(metrics.getSpecifiedMetrics("FetchConsumerResponseQueueTimeMs99thPercentile"));
        fetchVO.setResponseSendTimeMs(metrics.getSpecifiedMetrics("FetchConsumerResponseSendTimeMs99thPercentile"));
        fetchVO.setLocalTimeMs(metrics.getSpecifiedMetrics("FetchConsumerLocalTimeMs99thPercentile"));
        fetchVO.setThrottleTimeMs(metrics.getSpecifiedMetrics("FetchConsumerThrottleTimeMs99thPercentile"));
        fetchVO.setRemoteTimeMs(metrics.getSpecifiedMetrics("FetchConsumerRemoteTimeMs99thPercentile"));
        fetchVO.setTotalTimeMs(metrics.getSpecifiedMetrics("FetchConsumerTotalTimeMs99thPercentile"));
        return Arrays.asList(produceVO, fetchVO);
    }

    public static List<TopicRequestTimeDetailVO> convert2TopicRequestTimeDetailVOList(BaseMetrics metrics, String percentile) {
        if (ValidateUtils.isNull((Object)metrics)) {
            return new ArrayList<TopicRequestTimeDetailVO>();
        }
        TopicRequestTimeDetailVO produceVO = new TopicRequestTimeDetailVO();
        produceVO.setRequestTimeType("RequestProduceTime");
        TopicModelConverter.fillTopicProduceTime((TopicRequestTimeDetailVO)produceVO, (BaseMetrics)metrics, (String)percentile);
        TopicRequestTimeDetailVO fetchVO = new TopicRequestTimeDetailVO();
        fetchVO.setRequestTimeType("RequestFetchTime");
        TopicModelConverter.fillTopicFetchTime((TopicRequestTimeDetailVO)fetchVO, (BaseMetrics)metrics, (String)percentile);
        TopicMetrics topicMetrics = (TopicMetrics)metrics;
        if (!ValidateUtils.isEmptyList((List)topicMetrics.getBrokerMetricsList())) {
            ArrayList brokerProduceTimeList = new ArrayList();
            ArrayList brokerFetchTimeList = new ArrayList();
            topicMetrics.getBrokerMetricsList().forEach(brokerMetrics -> {
                TopicBrokerRequestTimeVO topicBrokerProduceReq = new TopicBrokerRequestTimeVO();
                topicBrokerProduceReq.setClusterId(brokerMetrics.getClusterId());
                topicBrokerProduceReq.setBrokerId(brokerMetrics.getBrokerId());
                TopicRequestTimeDetailVO brokerProduceVO = new TopicRequestTimeDetailVO();
                brokerProduceVO.setRequestTimeType("BrokerRequestProduceTime");
                TopicModelConverter.fillTopicProduceTime((TopicRequestTimeDetailVO)brokerProduceVO, (BaseMetrics)brokerMetrics, (String)percentile);
                topicBrokerProduceReq.setBrokerRequestTime(brokerProduceVO);
                TopicBrokerRequestTimeVO topicBrokerFetchReq = new TopicBrokerRequestTimeVO();
                topicBrokerFetchReq.setClusterId(brokerMetrics.getClusterId());
                topicBrokerFetchReq.setBrokerId(brokerMetrics.getBrokerId());
                TopicRequestTimeDetailVO brokerFetchVO = new TopicRequestTimeDetailVO();
                brokerProduceVO.setRequestTimeType("BrokerRequestFetchTime");
                TopicModelConverter.fillTopicFetchTime((TopicRequestTimeDetailVO)brokerFetchVO, (BaseMetrics)brokerMetrics, (String)percentile);
                topicBrokerFetchReq.setBrokerRequestTime(brokerFetchVO);
                brokerProduceTimeList.add(topicBrokerProduceReq);
                brokerFetchTimeList.add(topicBrokerFetchReq);
            });
            produceVO.setBrokerRequestTimeList(brokerProduceTimeList);
            fetchVO.setBrokerRequestTimeList(brokerFetchTimeList);
        }
        return Arrays.asList(produceVO, fetchVO);
    }

    public static List<TopicConnectionVO> convert2TopicConnectionVOList(List<TopicConnection> connectionDTOList) {
        if (ValidateUtils.isNull(connectionDTOList)) {
            return new ArrayList<TopicConnectionVO>();
        }
        ArrayList<TopicConnectionVO> voList = new ArrayList<TopicConnectionVO>();
        for (TopicConnection dto : connectionDTOList) {
            TopicConnectionVO vo = new TopicConnectionVO();
            CopyUtils.copyProperties((Object)vo, (Object)dto);
            voList.add(vo);
        }
        return voList;
    }

    public static List<TopicBrokerVO> convert2TopicBrokerVO(Long physicalClusterId, List<TopicBrokerDTO> dtoList) {
        ArrayList<TopicBrokerVO> voList = new ArrayList<TopicBrokerVO>();
        for (TopicBrokerDTO dto : dtoList) {
            TopicBrokerVO vo = new TopicBrokerVO();
            vo.setClusterId(physicalClusterId);
            CopyUtils.copyProperties((Object)vo, (Object)dto);
            vo.setLeaderPartitionIdList(dto.getLeaderPartitionIdList());
            vo.setPartitionIdList(dto.getPartitionIdList());
            voList.add(vo);
        }
        return voList;
    }

    public static List<TopicDataSampleVO> convert2TopicDataSampleVOList(List<String> dataList) {
        if (ValidateUtils.isNull(dataList)) {
            return new ArrayList<TopicDataSampleVO>();
        }
        ArrayList<TopicDataSampleVO> voList = new ArrayList<TopicDataSampleVO>();
        for (String data : dataList) {
            TopicDataSampleVO topicDataSampleVO = new TopicDataSampleVO();
            topicDataSampleVO.setValue(data);
            voList.add(topicDataSampleVO);
        }
        return voList;
    }

    public static List<TopicMetricVO> convert2TopicMetricsVOList(List<TopicMetricsDO> dataList) {
        if (ValidateUtils.isNull(dataList)) {
            return new ArrayList<TopicMetricVO>();
        }
        ArrayList<TopicMetricVO> voList = new ArrayList<TopicMetricVO>();
        for (TopicMetricsDO data : dataList) {
            TopicMetricVO vo = new TopicMetricVO();
            TopicMetrics metrics = MetricsConvertUtils.convert2TopicMetrics((TopicMetricsDO)data);
            if (ValidateUtils.isNull((Object)metrics)) continue;
            vo.setBytesInPerSec((Object)metrics.getBytesInPerSecOneMinuteRate(null));
            vo.setBytesOutPerSec((Object)metrics.getBytesOutPerSecOneMinuteRate(null));
            vo.setBytesRejectedPerSec((Object)metrics.getBytesRejectedPerSecOneMinuteRate(null));
            vo.setMessagesInPerSec((Object)metrics.getMessagesInPerSecOneMinuteRate(null));
            vo.setTotalProduceRequestsPerSec((Object)metrics.getTotalProduceRequestsPerSecOneMinuteRate(null));
            vo.setGmtCreate(Long.valueOf(data.getGmtCreate().getTime()));
            voList.add(vo);
        }
        return voList;
    }

    public static List<TopicMetricVO> convert2TopicMetricVOList(List<TopicMetricsDTO> dataList) {
        if (ValidateUtils.isNull(dataList)) {
            return new ArrayList<TopicMetricVO>();
        }
        ArrayList<TopicMetricVO> voList = new ArrayList<TopicMetricVO>();
        for (TopicMetricsDTO data : dataList) {
            TopicMetricVO vo = new TopicMetricVO();
            CopyUtils.copyProperties((Object)vo, (Object)data);
            voList.add(vo);
        }
        return voList;
    }

    public static List<TopicAuthorizedAppVO> convert2TopicAuthorizedAppVOList(List<TopicAppData> dtoList) {
        if (ValidateUtils.isEmptyList(dtoList)) {
            return new ArrayList<TopicAuthorizedAppVO>();
        }
        ArrayList<TopicAuthorizedAppVO> voList = new ArrayList<TopicAuthorizedAppVO>();
        for (TopicAppData topicAppDTO : dtoList) {
            TopicAuthorizedAppVO vo = new TopicAuthorizedAppVO();
            CopyUtils.copyProperties((Object)vo, (Object)topicAppDTO);
            voList.add(vo);
        }
        return voList;
    }

    public static List<TopicMyAppVO> convert2TopicMineAppVOList(List<TopicAppData> dtoList) {
        if (ValidateUtils.isEmptyList(dtoList)) {
            return new ArrayList<TopicMyAppVO>();
        }
        ArrayList<TopicMyAppVO> voList = new ArrayList<TopicMyAppVO>();
        for (TopicAppData elem : dtoList) {
            TopicMyAppVO vo = new TopicMyAppVO();
            vo.setAppId(elem.getAppId());
            vo.setAppName(elem.getAppName());
            vo.setAppPrincipals(elem.getAppPrincipals());
            vo.setProduceQuota(elem.getProduceQuota());
            vo.setConsumerQuota(elem.getConsumerQuota());
            vo.setAccess(elem.getAccess());
            voList.add(vo);
        }
        return voList;
    }

    public static TopicBusinessInfoVO convert2TopicBusinessInfoVO(TopicBusinessInfo topicBusinessInfo) {
        if (ValidateUtils.isNull((Object)topicBusinessInfo)) {
            return null;
        }
        TopicBusinessInfoVO topicBusinessInfoVO = new TopicBusinessInfoVO();
        CopyUtils.copyProperties((Object)topicBusinessInfoVO, (Object)topicBusinessInfo);
        return topicBusinessInfoVO;
    }

    private static void fillTopicProduceTime(TopicRequestTimeDetailVO produceVO, BaseMetrics metrics, String thPercentile) {
        produceVO.setRequestQueueTimeMs(metrics.getSpecifiedMetrics("ProduceRequestQueueTimeMs" + thPercentile));
        produceVO.setResponseQueueTimeMs(metrics.getSpecifiedMetrics("ProduceResponseQueueTimeMs" + thPercentile));
        produceVO.setResponseSendTimeMs(metrics.getSpecifiedMetrics("ProduceResponseSendTimeMs" + thPercentile));
        produceVO.setLocalTimeMs(metrics.getSpecifiedMetrics("ProduceLocalTimeMs" + thPercentile));
        produceVO.setThrottleTimeMs(metrics.getSpecifiedMetrics("ProduceThrottleTimeMs" + thPercentile));
        produceVO.setRemoteTimeMs(metrics.getSpecifiedMetrics("ProduceRemoteTimeMs" + thPercentile));
        produceVO.setTotalTimeMs(metrics.getSpecifiedMetrics("ProduceTotalTimeMs" + thPercentile));
    }

    private static void fillTopicFetchTime(TopicRequestTimeDetailVO fetchVO, BaseMetrics metrics, String thPercentile) {
        fetchVO.setRequestQueueTimeMs(metrics.getSpecifiedMetrics("FetchConsumerRequestQueueTimeMs" + thPercentile));
        fetchVO.setResponseQueueTimeMs(metrics.getSpecifiedMetrics("FetchConsumerResponseQueueTimeMs" + thPercentile));
        fetchVO.setResponseSendTimeMs(metrics.getSpecifiedMetrics("FetchConsumerResponseSendTimeMs" + thPercentile));
        fetchVO.setLocalTimeMs(metrics.getSpecifiedMetrics("FetchConsumerLocalTimeMs" + thPercentile));
        fetchVO.setThrottleTimeMs(metrics.getSpecifiedMetrics("FetchConsumerThrottleTimeMs" + thPercentile));
        fetchVO.setRemoteTimeMs(metrics.getSpecifiedMetrics("FetchConsumerRemoteTimeMs" + thPercentile));
        fetchVO.setTotalTimeMs(metrics.getSpecifiedMetrics("FetchConsumerTotalTimeMs" + thPercentile));
    }
}

