/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.inteceptor;

import com.codahale.metrics.Timer;
import com.xiaojukeji.kafka.manager.common.annotations.ApiLevel;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.ao.api.ApiCount;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.web.metrics.MetricsRegistry;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class WebMetricsInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebMetricsInterceptor.class);
    private static final Map<Integer, ApiCount> API_COUNT_MAP = new ConcurrentHashMap();
    private static final String PointCut = "execution(* com.xiaojukeji.kafka.manager.web.api..*.*(..))";

    public WebMetricsInterceptor(@Value(value="${server.tomcat.max-threads}") int maxThreads) {
        API_COUNT_MAP.put(1, new ApiCount(1, Integer.valueOf(Integer.MAX_VALUE), new AtomicInteger(0)));
        API_COUNT_MAP.put(2, new ApiCount(2, Integer.valueOf(maxThreads / 4), new AtomicInteger(0)));
        API_COUNT_MAP.put(3, new ApiCount(3, Integer.valueOf(maxThreads / 8), new AtomicInteger(0)));
        API_COUNT_MAP.put(4, new ApiCount(4, Integer.valueOf(maxThreads / 4), new AtomicInteger(0)));
    }

    @Pointcut(value="execution(* com.xiaojukeji.kafka.manager.web.api..*.*(..))")
    public void pointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcut()")
    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        ApiCount apiCount;
        long beginTime = System.currentTimeMillis();
        int apiLevel = 4;
        MethodSignature msig = (MethodSignature)proceedingJoinPoint.getSignature();
        String methodName = msig.getName();
        Object target = proceedingJoinPoint.getTarget();
        Method currentMethod = target.getClass().getMethod(methodName, msig.getParameterTypes());
        ApiLevel annotation = currentMethod.getAnnotation(ApiLevel.class);
        if (!ValidateUtils.isNull((Object)annotation)) {
            apiLevel = annotation.level();
        }
        if (ValidateUtils.isNull((Object)(apiCount = (ApiCount)API_COUNT_MAP.get(apiLevel)))) {
            apiCount = (ApiCount)API_COUNT_MAP.get(4);
        }
        Object methodResult = null;
        try {
            if (apiCount.incAndCheckIsOverFlow().booleanValue()) {
                Object object = this.returnErrorDirect(methodName, apiCount);
                return object;
            }
            methodResult = proceedingJoinPoint.proceed();
        }
        catch (Throwable t) {
            LOGGER.error("error occurred when proceed method:{}.", (Object)methodName, (Object)t);
        }
        finally {
            apiCount.decPresentNum();
            this.metricsRecord(methodName, beginTime);
        }
        return methodResult;
    }

    private Object returnErrorDirect(String methodName, ApiCount apiCount) {
        LOGGER.warn("api limiter, methodName:{}, apiLevel:{}, currentNum:{}, maxNum:{}, return directly.", new Object[]{methodName, apiCount.getApiLevel(), apiCount.getCurrentNum(), apiCount.getMaxNum()});
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        String uri = attributes.getRequest().getRequestURI();
        if (uri.contains("/gateway/api/v1/")) {
            return Result.buildFailure((String)"api limited");
        }
        return new Result((Object)ResultStatus.OPERATION_FORBIDDEN);
    }

    private void metricsRecord(String methodName, long startTime) {
        long costTime = System.currentTimeMillis() - startTime;
        String metricsName = methodName.substring(0, 1).toUpperCase() + methodName.substring(1) + "-Timer";
        Timer apiTimer = MetricsRegistry.newTimer((String)metricsName);
        apiTimer.update(costTime, TimeUnit.MILLISECONDS);
        Timer sumTimer = MetricsRegistry.newTimer((String)"All_Timer");
        sumTimer.update(costTime, TimeUnit.MILLISECONDS);
    }
}

