/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.xiaojukeji.kafka.manager.common.utils.factory.DefaultThreadFactory;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MetricsRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"API_METRICS_LOGGER");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#");
    private static final ScheduledExecutorService PRINT_API_METRICS_THREAD = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("PrintApiMetricsThread"));
    private static final MetricRegistry METRIC_REGISTRY = new MetricRegistry();

    @PostConstruct
    public void init() {
        PRINT_API_METRICS_THREAD.scheduleAtFixedRate(() -> {
            try {
                this.printTimerMetrics();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public static Timer newTimer(String metricName) {
        return METRIC_REGISTRY.timer(metricName);
    }

    private synchronized void printTimerMetrics() {
        SortedMap timerMap = METRIC_REGISTRY.getTimers();
        for (Map.Entry entry : timerMap.entrySet()) {
            Snapshot snapshot = ((Timer)entry.getValue()).getSnapshot();
            LOGGER.info("type=TIMER, name={}-Count, value={}, unit=event", entry.getKey(), (Object)((Timer)entry.getValue()).getCount());
            LOGGER.info("type=TIMER, name={}-MeanRate, value={}, unit=qps", entry.getKey(), (Object)DECIMAL_FORMAT.format(((Timer)entry.getValue()).getMeanRate()));
            LOGGER.info("type=TIMER, name={}-M1Rate, value={}, unit=qps", entry.getKey(), (Object)DECIMAL_FORMAT.format(((Timer)entry.getValue()).getOneMinuteRate()));
            LOGGER.info("type=TIMER, name={}-M5Rate, value={}, unit=qps", entry.getKey(), (Object)DECIMAL_FORMAT.format(((Timer)entry.getValue()).getFiveMinuteRate()));
            LOGGER.info("type=TIMER, name={}-M15Rate, value={}, unit=qps", entry.getKey(), (Object)DECIMAL_FORMAT.format(((Timer)entry.getValue()).getFifteenMinuteRate()));
            LOGGER.info("type=TIMER, name={}-Min, value={}, unit=ms", entry.getKey(), (Object)this.convertUnitFromNs2Ms((double)snapshot.getMin()));
            LOGGER.info("type=TIMER, name={}-Max, value={}, unit=ms", entry.getKey(), (Object)this.convertUnitFromNs2Ms((double)snapshot.getMax()));
            LOGGER.info("type=TIMER, name={}-Mean, value={}, unit=ms", entry.getKey(), (Object)this.convertUnitFromNs2Ms(snapshot.getMean()));
            LOGGER.info("type=TIMER, name={}-StdDev, value={}, unit=ms", entry.getKey(), (Object)this.convertUnitFromNs2Ms(snapshot.getStdDev()));
            LOGGER.info("type=TIMER, name={}-50thPercentile, value={}, unit=ms", entry.getKey(), (Object)this.convertUnitFromNs2Ms(snapshot.getMedian()));
            LOGGER.info("type=TIMER, name={}-75thPercentile, value={}, unit=ms", entry.getKey(), (Object)this.convertUnitFromNs2Ms(snapshot.get75thPercentile()));
            LOGGER.info("type=TIMER, name={}-95thPercentile, value={}, unit=ms", entry.getKey(), (Object)this.convertUnitFromNs2Ms(snapshot.get95thPercentile()));
            LOGGER.info("type=TIMER, name={}-98thPercentile, value={}, unit=ms", entry.getKey(), (Object)this.convertUnitFromNs2Ms(snapshot.get98thPercentile()));
            LOGGER.info("type=TIMER, name={}-99thPercentile, value={}, unit=ms", entry.getKey(), (Object)this.convertUnitFromNs2Ms(snapshot.get99thPercentile()));
            LOGGER.info("type=TIMER, name={}-999thPercentile, value={}, unit=ms", entry.getKey(), (Object)this.convertUnitFromNs2Ms(snapshot.get999thPercentile()));
        }
    }

    private String convertUnitFromNs2Ms(double value) {
        return DECIMAL_FORMAT.format(value / 1000000.0);
    }
}

