/*
 * Decompiled with CFR 0.152.
 */
package com.ch1a.flatworld;

import com.ch1a.flatworld.FWConfig;
import net.minecraft.block.Block;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemFlattening
extends Item {
    private int posX;
    private int posY;
    private int posZ;
    private boolean itemUseFlag;
    private World world;
    private Block block;
    private BlockPos pos;
    private EntityPlayer player;

    public ItemFlattening(FMLPreInitializationEvent event) {
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77655_b("flatworld");
        this.func_77656_e(Item.ToolMaterial.EMERALD.func_77997_a());
        GameRegistry.registerItem((Item)this, (String)"flatworld");
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"AAA", "ABA", " B ", Character.valueOf('A'), Items.field_151045_i, Character.valueOf('B'), Items.field_151055_y});
        if (event.getSide().isClient()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("com.ch1a.flatworld:flatworld", "inventory"));
        }
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (FWConfig.useReloadConfig) {
            FWConfig.reloadConfig();
        }
        this.itemUseFlag = false;
        this.world = world;
        this.player = player;
        this.posX = pos.func_177958_n();
        this.posY = pos.func_177956_o();
        this.posZ = pos.func_177952_p();
        int radius = FWConfig.radius;
        if (facing == EnumFacing.SOUTH) {
            this.setRange(-radius, radius, 0, radius, -radius, 0);
        } else if (facing == EnumFacing.NORTH) {
            this.setRange(-radius, radius, 0, radius, 0, radius);
        } else if (facing == EnumFacing.WEST) {
            this.setRange(0, radius, 0, radius, -radius, radius);
        } else if (facing == EnumFacing.EAST) {
            this.setRange(-radius, 0, 0, radius, -radius, radius);
        } else if (facing == EnumFacing.UP && FWConfig.allowDestroyDown) {
            this.setRange(-radius, radius, -radius, 0, -radius, radius);
        } else if (facing == EnumFacing.DOWN && FWConfig.allowDestroyUp) {
            this.setRange(-radius, radius, 0, radius, -radius, radius);
        }
        if (this.itemUseFlag) {
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        return true;
    }

    private void setRange(int initX, int postX, int initY, int postY, int initZ, int postZ) {
        for (int x = initX; x <= postX; ++x) {
            for (int y = initY; y <= postY; ++y) {
                for (int z = initZ; z <= postZ; ++z) {
                    this.pos = new BlockPos(this.posX + x, this.posY + y, this.posZ + z);
                    this.block = this.world.func_180495_p(this.pos).func_177230_c();
                    this.checkDestroy();
                }
            }
        }
    }

    private void checkDestroy() {
        if (FWConfig.useBlackList && this.checkList(FWConfig.blackList)) {
            return;
        }
        if (FWConfig.useWhiteList && !this.checkList(FWConfig.whiteList)) {
            return;
        }
        if (!FWConfig.allowDestroyY0 && this.pos.func_177956_o() == 0) {
            return;
        }
        this.destroy();
    }

    private void destroy() {
        int num = this.player.field_71068_ca / 10 + 1;
        for (int i = 0; i < num; ++i) {
            this.checkDropItem();
            if (!FWConfig.useChangeDropByLevel) break;
        }
        this.world.func_175698_g(this.pos);
        this.itemUseFlag = true;
    }

    private void checkDropItem() {
        if (!FWConfig.allowItemDrop) {
            return;
        }
        if (!FWConfig.allowDropInCreative && this.player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (FWConfig.useDropBlackList && this.checkList(FWConfig.dropBlackList)) {
            return;
        }
        if (FWConfig.useDropWhiteList && !this.checkList(FWConfig.dropWhiteList)) {
            return;
        }
        this.itemDrop();
    }

    private void itemDrop() {
        if (FWConfig.useCollectItem) {
            if (!this.player.field_71071_by.func_70441_a(new ItemStack(this.block))) {
                this.block.func_176226_b(this.world, this.player.func_180425_c(), this.world.func_180495_p(this.pos), 0);
            }
        } else {
            this.block.func_176226_b(this.world, this.pos, this.world.func_180495_p(this.pos), 0);
        }
    }

    private boolean checkList(String[] strings) {
        for (String blockName : strings) {
            if (Block.func_149684_b((String)blockName) != this.block) continue;
            return true;
        }
        return false;
    }
}

