/*
 * Decompiled with CFR 0.152.
 */
package com.ch1a.flatworld;

import com.ch1a.flatworld.FWConfig;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemFlattening
extends Item {
    private int blockX;
    private int blockY;
    private int blockZ;
    private int posX;
    private int posY;
    private int posZ;
    private boolean itemUseFlag;
    private World world;
    private Block block;
    private EntityPlayer player;

    public ItemFlattening(FMLPreInitializationEvent event) {
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77655_b("flatworld");
        this.func_111206_d("com.ch1a.flatworld:fwitem");
        this.func_77656_e(Item.ToolMaterial.EMERALD.func_77997_a());
        GameRegistry.registerItem((Item)this, (String)"flatworld");
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"AAA", "ABA", " B ", Character.valueOf('A'), Items.field_151045_i, Character.valueOf('B'), Items.field_151055_y});
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int posX, int posY, int posZ, int facing, float hitX, float hitY, float hitZ) {
        if (FWConfig.useReloadConfig) {
            FWConfig.reloadConfig();
        }
        this.itemUseFlag = false;
        this.world = world;
        this.player = player;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        int radius = FWConfig.radius;
        if (facing == 3) {
            this.setRange(-radius, radius, 0, radius, -radius, 0);
        } else if (facing == 2) {
            this.setRange(-radius, radius, 0, radius, 0, radius);
        } else if (facing == 4) {
            this.setRange(0, radius, 0, radius, -radius, radius);
        } else if (facing == 5) {
            this.setRange(-radius, 0, 0, radius, -radius, radius);
        } else if (facing == 1 && FWConfig.allowDestroyDown) {
            this.setRange(-radius, radius, -radius, 0, -radius, radius);
        } else if (facing == 0 && FWConfig.allowDestroyUp) {
            this.setRange(-radius, radius, 0, radius, -radius, radius);
        }
        if (this.itemUseFlag) {
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        return true;
    }

    private void setRange(int initX, int postX, int initY, int postY, int initZ, int postZ) {
        for (int x = initX; x <= postX; ++x) {
            for (int y = initY; y <= postY; ++y) {
                for (int z = initZ; z <= postZ; ++z) {
                    this.blockX = this.posX + x;
                    this.blockY = this.posY + y;
                    this.blockZ = this.posZ + z;
                    this.block = this.world.func_147439_a(this.blockX, this.blockY, this.blockZ);
                    this.checkDestroy();
                }
            }
        }
    }

    private void checkDestroy() {
        if (FWConfig.useBlackList && this.checkList(FWConfig.blackList)) {
            return;
        }
        if (FWConfig.useWhiteList && !this.checkList(FWConfig.whiteList)) {
            return;
        }
        if (!FWConfig.allowDestroyY0 && this.blockY == 0) {
            return;
        }
        this.destroy();
    }

    private void destroy() {
        int num = this.player.field_71068_ca / 10 + 1;
        for (int i = 0; i < num; ++i) {
            this.checkDropItem();
            if (!FWConfig.useChangeDropByLevel) break;
        }
        this.world.func_147468_f(this.blockX, this.blockY, this.blockZ);
        this.itemUseFlag = true;
    }

    private void checkDropItem() {
        if (!FWConfig.allowItemDrop) {
            return;
        }
        if (!FWConfig.allowDropInCreative && this.player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (FWConfig.useDropBlackList && this.checkList(FWConfig.dropBlackList)) {
            return;
        }
        if (FWConfig.useDropWhiteList && !this.checkList(FWConfig.dropWhiteList)) {
            return;
        }
        this.itemDrop();
    }

    private void itemDrop() {
        if (FWConfig.useCollectItem) {
            if (!this.player.field_71071_by.func_70441_a(new ItemStack(this.block))) {
                this.block.func_149697_b(this.world, (int)this.player.field_70165_t, (int)this.player.field_70163_u, (int)this.player.field_70161_v, 0, 0);
            }
        } else {
            this.block.func_149697_b(this.world, this.blockX, this.blockY, this.blockZ, 0, 0);
        }
    }

    private boolean checkList(String[] strings) {
        for (String blockName : strings) {
            if (Block.func_149684_b((String)blockName) != this.block) continue;
            return true;
        }
        return false;
    }
}

