/*
 * Decompiled with CFR 0.152.
 */
package com.ch1a.flatworld;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;

public class Config {
    private File configFile;
    private HashMap<String, String> configMap = new HashMap();

    public Config(String fileName) {
        this.configFile = new File("config" + File.separator + fileName + ".cfg");
    }

    public void save() {
        try {
            File configDir = new File("config");
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            if (!this.configFile.exists()) {
                this.configFile.createNewFile();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.configFile));
            for (String str : this.configMap.keySet()) {
                bufferedWriter.write(str + "=" + this.configMap.get(str));
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.configFile));
            String fileStr = bufferedReader.readLine();
            while (fileStr != null) {
                String[] str = fileStr.split("=");
                this.configMap.put(str[0], str[1]);
                fileStr = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public <K, V> void setValue(K keyName, V value) {
        this.configMap.put(keyName.toString(), value.toString());
    }

    public <K, V> void setValue(K keyName, V[] value) {
        String string = value[0].toString();
        int num = value.length;
        for (int i = 1; i < num; ++i) {
            string = string + "," + value[i];
        }
        this.setValue(keyName, string);
    }

    public <K> String getString(K keyName) {
        return this.configMap.get(keyName.toString());
    }

    public <K> boolean getBoolean(K keyName) {
        return "true".equals(this.getString(keyName));
    }

    public <K> int getInt(K keyName) {
        return Integer.parseInt(this.getString(keyName));
    }

    public <K> String[] getStringArray(K keyName) {
        return this.configMap.get(keyName.toString()).split(",");
    }
}

