<?php

    /***************************************************************\
    |                                                               |
    |   开单大师 - 专业的房产ERP管理                                  |
    |                                                               |
    |   © 2019 http://www.kaidandashi.com All rights reserved.      |
    |                                                               |
    |   开单大师由淮南市银泰软件科技有限公司提供技术                    |
    |                                                               |
    |   QQ:984784483                                                |
    |                                                               |
    \***************************************************************/

    namespace Admin\Controller;
    use Think\Controller;
    use Think\Model;
    class RbacController extends CommonController {
        //岗位列表
        public function Role(){
            $is_rbac = _rbac_btn_show(18,0);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $sousuo=I('rolefl');
            $condition="where gongsiid = 10000";
            if ($sousuo == '全部') {//搜索
                $condition.="";
            }elseif($sousuo){
                $condition.=" and rolefl = $sousuo";
            }
            $Model = new \Think\Model();
            $count=$Model->query("select count(*) from __ROLE__ {$condition}");
            $Page=new \Think\Page($count['0']['count(*)'],30);
            $show=$Page->show();
            $list="select * from __ROLE__ {$condition} order by rolefl asc,xsshunxu asc limit ".$Page->firstRow.','.$Page->listRows;
            $Role=M('role')->query($list);
            $this->assign('firstRow',$Page->firstRow);
            $this->assign('role',$Role);
            $this->assign('count',$count);
            $this->assign('page',$show);
            $this->rolefl=M('Peizhi')->where(array('pzming'=>'rolefl','zhuangtai'=>1))->order('xsshunxu asc')->select();
            $this->display();
        }
    	//用户列表  node_id=17
        public function index(){
            if (I('is_ajax')) {
                /*权限控制开始*/
                $map = "where gongsiid=".session('gongsiid');
                $x = _rbac_lists_where(17,0);
                if ($x && $x != "all" && $x != "me") {
                    $map .= " and bumen in ({$x})";
                } elseif ($x == "me") {
                    $map .= " and id=".session('uid');
                } elseif ($x == false) {
                    $map .= " and id=0";
                }
                /*权限控制结束*/
                $status = I('status');
                $shijian = I('shijian');
                $tree = new \Org\Util\Tree();
                $bumen = I("bumen",0,'intval');
                $result = M('bumen')->order(array("sort" => "ASC"))->select();
                if ($status == 1) {
                    $map .= " and status=0";
                } else {
                    $map .= " and status=1";
                }
                if ($sousuo) {
                    $map .= " and (dianhua like '%$sousuo%' or pinyinjs like '%$sousuo%' or ygmingcheng like '%$sousuo%' or ygbianhao like '%$sousuo%')";
                }
                if ($bumen) {
                    $arr_string = _rbac_bumen_array($result,$bumen);
                    $arr_string[] = $bumen;
                    $string = implode(',',$arr_string);
                    $map .= " and bumen in ($string)";
                }
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                if ($field && $order) {
                    $yhpx = "order by ".$field." ".$order;
                } else {
                    $yhpx = "order by id asc";
                }
                $Model = new \Think\Model();
                $count = $Model->query("select count(*) from __YONGHU__ {$map}");
                $Page = new \Think\Page($count['0']['count(*)'],$limit);
                $list = "select * from __YONGHU__ {$map} ".$yhpx." limit ".$Page->firstRow.','.$Page->listRows;
                $data = $Model->query($list);
                foreach ($data as $key => $value) {
                    $data[$key]['logintime'] = $value['logintime'] ? date('Y-m-d H:i:s',$value['logintime']) : "——";
                    $data[$key]['logintime'] = $value['logintime'] ? date('Y-m-d H:i:s',$value['logintime']) : "——";
                    $data[$key]['lock1'] = $value['lock1'] ? "已停用" : "已启用";
                    $data[$key]['bmming'] = zym($value['bumen'],5);
                    if (C("RBAC_SUPERADMIN") == $value['dianhua']) {
                        $data[$key]['remark'] = "超级管理员";
                    } else {
                        $data[$key]['remark'] = get_yh_role($value['id'],2);
                    }
                    switch ($value['xingbie']) {
                        case '1':
                            $data[$key]['xingbie'] = "男";
                            break;
                        case '2':
                            $data[$key]['xingbie'] = "女";
                            break;
                        default:
                            $data[$key]['xingbie'] = "未知";
                            break;
                    }
                    if ($value['status'] == 0) {
                        $is_rbachy = _rbac_btn_show(518,0,$value['id']);
                        $data[$key]['rbachy'] = $is_rbachy ? 1 : 0;
                    } else {
                        if (C("RBAC_SUPERADMIN") != $value['dianhua']) {
                            if ($value['lock1']) {
                                $is_rbacqy = _rbac_btn_show(192,0,$value['id']);
                                $data[$key]['rbacqy'] = $is_rbacqy ? 1 : 0;
                            } else {
                                $is_rbacty = _rbac_btn_show(190,0,$value['id']);
                                $data[$key]['rbacty'] = $is_rbacty ? 1 : 0;
                            }
                        }
                    }
                    $is_rbacgx = _rbac_btn_show(106,0,$value['adduid']);
                    $is_rbaczy = _rbac_btn_show(414,0,$value['adduid']);
                    $is_rbacsc = _rbac_btn_show(108,0,$value['adduid']);
                    $data[$key]['rbacgx'] = $is_rbacgx ? 1 : 0;
                    $data[$key]['rbaczy'] = $is_rbaczy ? 1 : 0;
                    $data[$key]['rbacsc'] = $is_rbacsc ? 1 : 0;
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count['0']['count(*)'],
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $select_categorys = bumen_option( $bumen, 17);
                $this->assign("select_categorys", $select_categorys);
                $this->display();
            }
        }
        public function stopUser(){
            $is_rbac = _rbac_btn_show(190,0,I('id',0,'intval'));
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $id=I('id');
            $yh=M('yonghu')->where(array('id'=>$id))->find();
            $xiugai.="停用员工[".$yh['ygmingcheng']."]";
            if(M('yonghu')->where(array('id'=>$id))->setField('lock1',1)){
                $data_rizhi['zy_type']=8;
                $data_rizhi['uid']=session("uid");
                $data_rizhi['addtime']=time();
                $data_rizhi['cz_type']=21;
                $data_rizhi['zy_id']=I('id');
                $data_rizhi['neirong']=$xiugai;
                M('rizhi')->add($data_rizhi);
                $this->success('已停用');
            }else{
                $this->error('停用失败');
            }
        }
        public function startUser(){
            $is_rbac = _rbac_btn_show(192,0,I('id',0,'intval'));
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $id=I('id');
            $yh=M('yonghu')->where(array('id'=>$id))->find();
            $xiugai.="启用员工[".$yh['ygmingcheng']."]";
            if(M('yonghu')->where(array('id'=>$id))->setField('lock1',0)){
                $data_rizhi['zy_type']=8;
                $data_rizhi['uid']=session("uid");
                $data_rizhi['addtime']=time();
                $data_rizhi['cz_type']=22;
                $data_rizhi['zy_id']=I('id');
                $data_rizhi['neirong']=$xiugai;
                M('rizhi')->add($data_rizhi);
                $this->success('已启用');
            }else{
                $this->error('启用失败');
            }
        }
        //添加岗位
        public function addRole(){
            $is_rbac = _rbac_btn_show(99,0);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                //防止重复提交
                $yonghu=M('yonghu');
                if (!$yonghu->autoCheckToken($_POST)) {
                    $this->error('请不要重复添加');
                }
                if (session('gongsiid')=="") {
                    $this->error('请重新登录');
                }
                if (I('status')) {
                    $status=1;
                } else {
                    $status=0;
                }
                $data['status']=$status;
                $data['remark']=I('remark');
                $data['rolefl']=I('rolefl');
                $data['miaoshu']=I('miaoshu');
                $data['xsshunxu']=I('xsshunxu');
                $data['gongsiid']=session('gongsiid');
                $isok=M('Role')->add($data);
                if ($isok) {
                    $this->success('添加成功');
                }else{
                    $this->error('添加失败');
                }
            }else{
                $this->rolefl=M('Peizhi')->where(array('pzming'=>'rolefl','zhuangtai'=>1))->order('xsshunxu asc')->select();
                $this->display();
            }
        }
        //更新岗位
        public function editRole(){
            $is_rbac = _rbac_btn_show(101,0);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                if (I('status')) {
                    $status=1;
                } else {
                    $status=0;
                }
                $data['status']=$status;
                $data['remark']=I('remark');
                $data['rolefl']=I('rolefl');
                $data['miaoshu']=I('miaoshu');
                $data['xsshunxu']=I('xsshunxu');
                $data['gongsiid']=session('gongsiid');
                $isok=M('Role')->where(array('id'=>I('id')))->save($data);
                if ($isok) {
                    $this->success('更新成功');
                }else{
                    $this->error('更新失败');
                }
            }else{
                $this->role=M('Role')->where(array('id'=>I('id')))->find();
                $this->rolefl=M('Peizhi')->where(array('pzming'=>'rolefl','zhuangtai'=>1))->order('xsshunxu asc')->select();
                $this->display();
            }
        }
        //删除岗位
        public function delRole(){
            $is_rbac = _rbac_btn_show(103,0);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $isok=M('Role')->where(array('id'=>I('id')))->delete();
            if ($isok) {
                $this->success('删除成功');
            }else{
                $this->error('删除失败');
            }
        }
        //添加用户
        public function addUser(){
            $is_rbac = _rbac_node_show(104);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $bumen=I('bumen');
                $role=I('role_id');
                if (session('username') != C('RBAC_SUPERADMIN')) {
                    $kxrole=yhkxrole(0,2);
                    if (!in_array($role,$kxrole)) {
                        $this->error('异常错误！');
                    }
                }
                $tjbmsz=bumen_idsz(104);
                if (!in_array($bumen,$tjbmsz) && $tjbmsz[0] != "all"){
                    $this->error('异常错误！');
                }
                if(!preg_match("/^(13[0-9]|14[579]|15[0-3,5-9]|16[6]|17[0135678]|18[0-9]|19[189])\d{8}$/",I('dianhua'))){  
                    $this->error('电话号码格式不正确!'); 
                }
                if (I('dianhua')) {
                    $user1=M('yonghu')->where(array('dianhua' =>I('dianhua'),'gongsiid'=>session('gongsiid')))->find();
                    if ($user1) {
                        $this->error('手机号已被使用');
                    }
                }else{
                    $this->error('手机号不能为空');
                }
                if (I('ygbianhao')) {
                    $user2=M('yonghu')->where(array('ygbianhao' =>I('ygbianhao'),'gongsiid'=>session('gongsiid')))->find();
                    if ($user2) {
                        $this->error('员工编号已被使用');
                    }
                }
                if (I('xingbie') == 1) {
                    $xingbie = 1;
                } elseif (I('xingbie') == 2) {
                    $xingbie = 2;
                } else {
                    $xingbie = 0;
                }
                $user = array(
                    'gongsiid'=>session('gongsiid'),
                    'ygmingcheng'=>I('ygmingcheng'),
                    'pinyinjs'=>I('pinyinjs'),
                    'dianhua'=>I('dianhua'),
                    'ygbianhao'=>I('ygbianhao'),
                    'xingbie'=>$xingbie,
                    'bumen'=>I('bumen'),
                    'mima'=>I('mima','','md5'),
                    'logintime'=>time(),
                    'loginip'=>get_client_ip(),
                );
                for ($i=1; $i < 7; $i++) { 
                    $user['company'.$i]=0;
                }
                $bumen_find = M('bumen')->where(array('id'=>I('bumen')))->find();
                $u = $bumen_find['level'];
                $user['company'.$bumen_find['level']]=$bumen_find['id'];
                for ($i=0; $i < $u; $i++) { 
                    $bumen_find = M('bumen')->where(array('id'=>$bumen_find['parentid']))->find();
                    if ($bumen_find['bmming']) {
                        $user['company'.$bumen_find['level']]=$bumen_find['id'];
                    }
                }
                $isok=M('yonghu')->add($user);
                if ($isok) {
                    $data_role =  array(
                        'role_id'=>$role,
                        'user_id'=>$isok
                    );
                    M('role_user')->add($data_role);
                    $this->success('添加成功');
                }else{
                    $this->error('添加失败');
                }
            }else{
                if (session('username') == C('RBAC_SUPERADMIN')) {
                    $this->role=M('role')->where(array('gongsiid'=>session('gongsiid')))->order('rolefl asc,xsshunxu asc')->select();
                } else {
                    $this->role=yhkxrole(0,1,0);
                }
                $parentid = I("get.parentid",0,'intval');
                $select_categorys = bumen_option( $parentid, 104);
                $this->assign("select_categorys", $select_categorys);
                $this->display();
            }
        }
        //更新用户
        public function editUser(){
            $id=I('id',0,'intval');
            $is_rbac = _rbac_btn_show(106,0,$id);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $et = I('edittype');
            switch ($et) {
                case '1':
                    if (!IS_POST) {$this->redirect('Rbac/edituser');}
                    $role_id=M('role_user')->where(array('user_id'=>$id))->getField('role_id');
                    $yh=M('yonghu')->where(array('id'=>$id))->find();
                    $User=M("Yonghu");
                    if (I('xingbie') == 1) {
                        $xingbie = 1;
                    } elseif (I('xingbie') == 2) {
                        $xingbie = 2;
                    } else {
                        $xingbie = 0;
                    }
                    $data['ygmingcheng']=I('ygmingcheng');
                    $data['pinyinjs']=I('pinyinjs');
                    $data['bumen']=I('bumen');
                    $data['ygbianhao']=I('ygbianhao');
                    $data['xingbie']=$xingbie;
                    if (I('ygbianhao')) {
                        $user2=M('yonghu')->where(array('ygbianhao' =>I('ygbianhao'),'gongsiid'=>session('gongsiid'),'id<>'.$id))->find();
                        if ($user2) {
                            $this->error('员工编号已被使用');
                        }
                    }
                    $data1 = array(
                        'user_id'=>$id,
                        'role_id'=>I('role')
                    );
                    if ($yh['ygmingcheng']==I('ygmingcheng') && $yh['pinyinjs']==I('pinyinjs') && $yh['bumen']==I('bumen') && $role_id==I('role') && $yh['ygbianhao']==I('ygbianhao') && $yh['xingbie']==$xingbie) {
                        $this->error('没有数据被更新');
                    }
                    $xiugai.="修改[".$yh['ygmingcheng']."]的信息为：";
                    if ($yh['ygmingcheng']!=I('ygmingcheng') && ($yh['ygmingcheng']==true || I('ygmingcheng')==true)) {
                        $xiugai.="用户名称：[".$yh['ygmingcheng']."]=>[".I('ygmingcheng')."];";
                    }
                    if ($yh['pinyinjs']!=I('pinyinjs') && ($yh['pinyinjs']==true || I('pinyinjs')==true)) {
                        $xiugai.="拼音检索：[".$yh['pinyinjs']."]=>[".I('pinyinjs')."];";
                    }
                    if ($yh['ygbianhao']!=I('ygbianhao') && ($yh['ygbianhao']==true || I('ygbianhao')==true)) {
                        $xiugai.="员工编号：[".$yh['ygbianhao']."]=>[".I('ygbianhao')."];";
                    }
                    if ($yh['xingbie']!=$xingbie && ($yh['xingbie']==true || $xingbie==true)) {
                        if ($yh['xingbie'] == 1) {
                            $xb = "男";
                        } elseif ($yh['xingbie'] == 2) {
                            $xb = "女";
                        } else {
                            $xb = "未知";
                        }
                        if ($xingbie == 1) {
                            $xb1 = "男";
                        } elseif ($xingbie == 2) {
                            $xb1 = "女";
                        } else {
                            $xb1 = "未知";
                        }
                        $xiugai.="性别:[".$xb."]=>[".$xb1."];";
                    }
                    if (I('bumen')!=$yh['bumen'] && ($yh['bumen']==true || I('bumen')==true)) {
                        $xiugai.=get_xgbm($yh['bumen'],I('bumen'),'bumen');
                    }
                    if (I('role')!=$role_id && ($role_id==true || I('role')==true)) {
                        $xiugai.=get_xgjs($role_id,I('role'),'role');
                    }
                    $data_rizhi=array(
                        'zy_type'=>8,
                        'uid'=>session('uid'),
                        'addtime'=>time(),
                        'cz_type'=>2,
                        'zy_id'=>$id,
                        'neirong'=>$xiugai,
                    );
                    for ($i=1; $i < 7; $i++) { 
                        $data['company'.$i]=0;
                    }
                    $bumen_find = M('bumen')->where(array('id'=>I('bumen')))->find();
                    $u = $bumen_find['level'];
                    $data['company'.$bumen_find['level']]=$bumen_find['id'];
                    for ($i=0; $i < $u; $i++) { 
                        $bumen_find = M('bumen')->where(array('id'=>$bumen_find['parentid']))->find();
                        if ($bumen_find['bmming']) {
                            $data['company'.$bumen_find['level']]=$bumen_find['id'];
                        }
                    }
                    $ues=$User->where(array('id'=>$id))->save($data);
                    M('role_user')->where(array('user_id'=>$id))->delete();
                    $isok=M('role_user')->add($data1);
                    if ($ues or $isok){
                        M('rizhi')->add($data_rizhi);
                        $this->success('更新成功');
                    }else{
                        $this->error('更新失败');
                    }
                    break;
                case '2':
                    if (!IS_POST) {$this->redirect('Rbac/edituser');}
                    $uid = $id;
                    $mima = trim(I('mima'));
                    $isok = $mima==''? false : M('yonghu')->where(array('id'=>$uid))->setField(array('mima' =>md5($mima)));
                    if ($isok) {
                        $this->success('密码已重置为：'.$mima);
                    }else{
                        $this->error('密码未更改');
                    }
                    break;
                case '3':
                    if (!IS_POST) {$this->redirect('Rbac/edituser');}
                    $uid = $id;
                    $keyid = trim(I('keyid'));
                    if ($keyid=='') {
                        $this->error('加密锁ID不能为空');
                    }
                    $id = M('yonghu')->where(array('keyid'=>$keyid))->field('id')->find();
                    $isok = $id>0? false : M('yonghu')->where(array('id'=>$uid))->setField(array('keyid' =>$keyid));
                    if ($isok) {
                        $this->success('更新成功');
                    }else{
                        $this->error('加密锁ID未更改或已存在');
                    }
                    break;
                default:
                    $user=M('Yonghu')->where(array('id'=>I('id')))->find();
                    $this->user=$user;
                    $this->role=yhkxrole(0,1);
                    $this->role_id=get_yh_role($id,1);
                    $bumen = $user['bumen'];
                    $select_categorys = bumen_option( $bumen, 106);
                    $this->assign("select_categorys", $select_categorys);
                    $this->display();
                break;
            }
        }
        //删除用户
        public function delUser(){
            $is_rbac = _rbac_btn_show(108,0,I('id',0,'intval'));
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $id=I('id');
            $yh=M('yonghu')->where(array('id'=>$id))->find();
            $xiugai.="删除员工[".$yh['ygmingcheng']."]";
            $fyshu=M('fangyuan')->where(array('weihurenid'=>$id))->count();
            $kyshu=M('keyuan')->where(array('weihurenid'=>$id))->count();
            if ($fyshu || $kyshu) {
                $this->error('请先转移数据!');
            }
            $isok=M('yonghu')->where(array('id'=>$id))->setField('status',0);
            if ($isok){
                $data_rizhi['zy_type']=8;
                $data_rizhi['uid']=session("uid");
                $data_rizhi['addtime']=time();
                $data_rizhi['cz_type']=8;
                $data_rizhi['zy_id']=I('id');
                $data_rizhi['neirong']=$xiugai;
                M('rizhi')->add($data_rizhi);
                $this->success('删除成功');
            }else{
                $this->error('删除失败');
            }
        }
        //恢复用户
        public function huifuUser(){
            $id=I('id');
            $is_rbac = _rbac_btn_show(518,0,$id);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $yh=M('yonghu')->where(array('id'=>$id))->find();
            $xiugai.="恢复员工[".$yh['ygmingcheng']."]";
            $dp=M('Yonghu');
            $isok=$dp->where(array('id'=>$id))->setField('status',1);
            if ($isok){
                $data_rizhi['zy_type']=8;
                $data_rizhi['uid']=session("uid");
                $data_rizhi['addtime']=time();
                $data_rizhi['cz_type']=24;
                $data_rizhi['zy_id']=I('id');
                $data_rizhi['neirong']=$xiugai;
                M('rizhi')->add($data_rizhi);
                $this->success('恢复成功');
            }else{
                $this->error('恢复失败');
            }
        }
        //配置权限
        public function access(){
            $is_rbac = _rbac_node_show(113);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $access1 = htmlspecialchars_decode(I('access'));
                $access2 = json_decode($access1,true);
                $access = array_unique(array_filter($access2));
                $rid = $access['rid'];
                $db = M('access');
                //清空原权限
                $db->where(array('role_id'=>$rid))->delete();
                //组合新权限
                unset($access['rid']);
                unset($access['__hash__']);
                $data = array();
                foreach ($access as $v) {
                    if ($v != "") {
                        $tmp = explode('_', $v);
                        if ($tmp[0] != 0) {
                            $data[]=array(
                            'role_id'=>$rid,
                            'node_id'=>$tmp[0],
                            'level'=>3,
                            'fanwei'=>$tmp[1],
                            'zhuangtai'=>$tmp[2],
                           );
                        }
                    }
                }
                $node = M('node')->where(array('level'=>array('in','1,2')))->select();
                foreach ($node as $v) {
                    $data[]=array(
                        'role_id'=>$rid,
                        'node_id'=>$v['id'],
                        'level'=>$v['level'],
                        'fanwei'=>0,
                        'zhuangtai'=>0,
                    );
                }
                //插入新权限
                if ($db->addALL($data)) {
                    $this->success('修改成功');
                }else{
                    $this->error('修改失败');
                }
            } else {
                $rid = I('rid',0,'intval');
                $arr = M('node_set')->where(array('status'=>1))->order(array("sort" => "ASC"))->select();
                foreach ($arr as $key => $value) {
                    $arr[$key]['pid'] = $value['parentid'];
                }
                $access = M('access')->where(array('level'=>3,'role_id'=>$rid))->select();
                $result = [];
                foreach($access as $k=>$v){
                    $result[$v['node_id']][] = $v;
                }
                $arr = node_merge($arr,null,0);
                foreach ($arr as $k1 => $v1) {
                    if ($v1['is_sign']) {
                        foreach ($v1['child'] as $k2 => $v2) {
                            $arr[$k1]['child'][$k2]['config'] = $result[$v2['node_id']];
                        }
                    } else {
                        foreach ($v1['child'] as $k2 => $v2) {
                            foreach ($v2['child'] as $key => $value) {
                                $arr[$k1]['child'][$k2]['child'][$key]['config'] = $result[$value['node_id']];
                            }
                        }
                    }
                }
                $this->categorys = $arr;
                $this->fyzhuangtai=get_peizhi('zhuangtai',0,1);
                $this->kyzhuangtai=get_peizhi('khzhuangtai',0,1);
                $this->bumen_arr_level = get_options('bumen_options','bumen_array');
                $this->rid=$rid;
                $this->display('access2');
            }
        }
        public function Bumen(){
            $is_rbac = _rbac_node_show(115);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $map['gongsiid']=session('gongsiid');
            $Data=M('bumen');
            $result = $Data->where($map)->order(array("id" => "ASC"))->select();
            $xiao = $result;
            $tree = new \Org\Util\Tree();
            $tree->icon = array('&nbsp;&nbsp;&nbsp;│ ', '&nbsp;&nbsp;&nbsp;├─ ', '&nbsp;&nbsp;&nbsp;└─ ');
            $tree->nbsp = '&nbsp;&nbsp;&nbsp;';
            $newmenus=array();
            foreach ($result as $m){
                $newmenus[$m['id']]=$m;
            }
            $bumen_option_value_arr = get_options('bumen_options','bumen_array');
            $sc=new AjaxController();
            foreach ($result as $n=> $r) {
                $result[$n]['level_s'] = $bumen_option_value_arr[$sc->get_level($r['id'], $newmenus)];
                $result[$n]['str_manage'] = '<if condition="_rbac_node_show(116,0)"><a href="javascript:;" class="layui-btn layui-btn-normal layui-btn-mini" onclick="layer_show(\'添加部门\',\''.U('addBumen',array('parentid'=>$r['id'])).'\',\'480\',\'480\')" style="text-decoration:none"><i class="Hui-iconfont">&#xe604;</i> 添加</a></if>';
                $result[$n]['str_manage'] .='&nbsp;&nbsp;&nbsp;<if condition="_rbac_node_show(118,0)"><a href="javascript:;" class="layui-btn layui-btn-warm layui-btn-mini" onclick="layer_show(\'更新部门\',\''.U('editbumen',array('id'=>$r['id'])).'\',\'480\',\'480\')" style="text-decoration:none"><i class="Hui-iconfont">&#xe6df;</i> 编辑</a></if>';
                $result[$n]['str_manage'] .='&nbsp;&nbsp;&nbsp;<if condition="_rbac_node_show(120,0)"><a href="javascript:;" class="layui-btn layui-btn-warm layui-btn-mini" onclick="admin_bumen_del(this,\''.$r['id'].'\')" style="text-decoration:none;background: red;"><i class="Hui-iconfont">&#xe6df;</i> 删除</a></if>';
            }
            $tree->init($result);
            $str = "<tr id='node-\$id' \$parentid_node style='\$style'>
                        <td style='padding-left:20px;'>\$id</td>
                        <td>\$level-\$level_s</td>
                        <td>\$spacer\$bmming</td>
                        <td>\$bmdianhua</td>
                        <td>\$str_manage</td>
                    </tr>";
            $categorys = $tree->get_tree(0, $str);
            $this->assign("categorys", $categorys);
            $this->display();
        }
        public function addBumen(){
            $is_rbac = _rbac_node_show(116);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $s = count(get_options('bumen_options','bumen_array'));
                $data['parentid']=I('parentid',0,'intval');
                $level = M('bumen')->where(array('id'=>$data['parentid']))->getField('level');
                if ($s<=$level) {
                    $this->error('此部门已是最后一级部门，不能添加子部门。');
                }
                if ($level > 5) {
                    $this->error('当前部门的级别超出六级');
                }
                $data['level']=$level+1;//重要的等级
                $data['cjshijian']=time();
                $data['bmming']=I('bmming');
                $data['bmdianhua']=I('bmdianhua');
                $data['bmdizhi']=I('bmdizhi');
                $data['gongsiid']=session('gongsiid');
                if(M('bumen')->add($data)){
                    $this->success('添加成功');
                }else{
                    $this->error('添加失败');
                }
            } else {
                $parentid = I("get.parentid",0,'intval');
                $select_categorys = bumen_option( $parentid, 0);
                $this->assign("select_categorys", $select_categorys);
                $this->display();
            }
        }
        public function editBumen(){
            $is_rbac = _rbac_node_show(118);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $id=I('id');
                $_POST['parentid']=I('parentid',0,'intval');
                $s = count(get_options('bumen_options','bumen_array'));
                $level = M('bumen')->where(array('id'=>$_POST['parentid']))->getField('level');
                if ($s<=$level) {
                    $this->error('父级部门已是最后一级部门，不能修改为此部门的子级部门。');
                }
                if ($level > 5) {
                    $this->error('当前部门的级别超出六级');
                }
                $_POST['level']=$level+1;//重要的等级
                if (M('bumen')->where(array('id'=>$id,'gongsiid'=>session('gongsiid')))->save($_POST)) {
                    $this->success('修改成功'); 
                }else{
                    $this->error('修改失败');
                }
            } else {
                $id = I("get.id",0,'intval');
                $this->bumen = M('bumen')->where(array('id'=>$id))->find();
                $parentid = $this->bumen['parentid'];
                $select_categorys = bumen_option( $parentid, 0);
                $this->assign("select_categorys", $select_categorys);
                $this->bm=M('bumen')->where(array('id'=>$id))->find();
                $this->yonghu=M('yonghu')->where(array('bumen'=>$id,'gongsiid'=>session('gongsiid')))->select();
                $this->display();
            }
        }
        public function delBumen(){
            $is_rbac = _rbac_node_show(120);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $id = I('id');
            $level = M('bumen')->where(array('id'=>$id))->getField('level');
            $isok=M('bumen')->where(array('id'=>$id))->delete();
            if ($isok) {
                $bumen[$level] = M('bumen')->where(array('parentid'=>$id))->select();
                if ($bumen[$level]) {
                    M('bumen')->where(array('parentid'=>$id))->delete();
                    foreach ($bumen[$level] as $key => $value) {
                        $bumen[$value['level']] = M('bumen')->where(array('parentid'=>$id))->select();
                        if ($bumen[$value['level']]) {
                            M('bumen')->where(array('parentid'=>$value['id']))->delete();
                            foreach ($bumen[$value['level']] as $ke => $valu) {
                                $bumen[$valu['level']] = M('bumen')->where(array('parentid'=>$id))->select();
                                if ($bumen[$valu['level']]) {
                                    M('bumen')->where(array('parentid'=>$valu['id']))->delete();
                                    foreach ($bumen[$valu['level']] as $k => $val) {
                                        $bumen[$val['level']] = M('bumen')->where(array('parentid'=>$id))->select();
                                        if ($bumen[$val['level']]) {
                                            M('bumen')->where(array('parentid'=>$val['id']))->delete();
                                            foreach ($bumen[$val['level']] as $x => $v) {
                                                M('bumen')->where(array('parentid'=>$v['id']))->delete();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                $this->success('删除成功'); 
            }else{
                $this->error('删除失败');
            }
        }
        public function xxzhuanyi(){
            $is_rbac = _rbac_btn_show(414,0,I('id'));
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $xxzy=I('xxzy');
            if (IS_POST) {
                $yid = I('yid');
                $uid = I('uid1');
                $bumen = I('bumen');
                $fkyid = I('fkyid');
                if(!$uid){
                    $this->error("请选择客源维护人！");
                }
                if($yid == $uid){
                    $this->error("不能转移给自己！");
                }
                if($fkyid==''){
                    $this->error("请先选中");
                }
                $yh = M('yonghu')->where(array('id'=>$yid))->getField('ygmingcheng');
                $name = M('yonghu')->where(array('id'=>$uid))->getField('ygmingcheng');
                if(is_array($fkyid)){
                    $where = 'id in('.implode(',',$fkyid).')';
                }else{
                    $where = 'id='.$fkyid;
                }
                if($xxzy == 1) {
                    $xxzyb=M('fangyuan');
                    $zys=$xxzyb->where($where)->count();
                    $zy=$xxzyb->where($where)->select();
                    foreach ($zy as $key => $value) {
                        $zybh.=$value['bianhao'].';';
                        $zyid.=$value['id'];
                    }
                    $zyzy="房源";
                } elseif ($xxzy == 2) {
                    $xxzyb=M('keyuan');
                    $zys=$xxzyb->where(array($where))->count();
                    $zy=$xxzyb->where(array($where))->select();
                    foreach ($zy as $key => $value) {
                        $zybh.=$value['xqbianhao'].';';
                        $zyid.=$value['id'];
                    }
                    $zyzy="客源";
                }
                $xiugai.="将用户[".$yh."]的".$zyzy."[".$zybh."]转移给[".$name."]";
                $data['weihurenid'] = $uid;
                $data['weihuren'] = $name;
                $list=$xxzyb->where($where)->save($data);
                $data_rizhi['zy_type']=8;
                $data_rizhi['uid']=session("uid");
                $data_rizhi['addtime']=time();
                $data_rizhi['cz_type']=23;
                $data_rizhi['zy_id']=$yid;
                $data_rizhi['neirong']=$xiugai;
                M('rizhi')->add($data_rizhi);
                $this->success("成功转移".$zyzy.$zys."条");
            }else{
                $uid=I('id');
                if (!$uid) {
                    $this->error('未找到用户');
                }
                if($xxzy == 1) {
                    $Data=M('fangyuan');
                    $field=",bianhao,xiaoqum";
                } elseif ($xxzy == 2) {
                    $Data=M('keyuan');
                    $field=",xqbianhao,khxingming,kehulx";
                }
                $condition=" weihurenid=".$uid;
                $shijian = str_replace("+"," ",I('shijian'));
                if ($shijian) {
                    $this->shijian = $shijian;
                    $time_s = explode(' - ',$shijian);
                    $time_s1 = strtotime($time_s[0]);
                    $time_s2 = strtotime($time_s[1])+86400;
                    $condition .= " and lurusj>=".$time_s1." and lurusj<".$time_s2;
                }
                $count=$Data->where($condition)->count();
                $page= new\Think\Page($count,30);
                $show=$page->show();
                $fkyzy=$Data->where($condition)->field('id,weihurenid,lurusj'.$field)->order('lurusj desc')->limit($page->firstRow.','.$page->listRows)->select();
                $this->assign('firstRow',$Page->firstRow);
                $this->assign('fkyzy',$fkyzy);
                $this->assign('count',$count);
                $this->assign('page',$show);
                $bumen = I("get.bumen",0,'intval');
                $select_categorys = bumen_option( $bumen, 414);
                $this->assign("select_categorys", $select_categorys);
                $this->display();
            }
        }
        // 员工日志
        public function rizhi(){
            if (I('is_ajax')) {
                $condition = "e.gongsiid=".session('gongsiid')." and a.zy_type = 8";
                $x = _rbac_lists_where(442,0);
                if ($x && $x != "all" && $x != "me") {
                    $condition .= " and e.bumen in ({$x})";
                } elseif ($x == "me") {
                    $condition .= " and e.id=".session('uid');
                } elseif ($x == false) {
                    $condition .= " and e.id=0";
                }
                $bumen = I('bumen');
                $sousuo = I('sousuo');
                $shijian = I('shijian');
                if ($bumen) {
                    $string = get_bm_sz($bumen,2);
                    $condition .= " and e.bumen in ($string)";
                }
                if ($shijian) {
                    $time_s = explode(' - ',$shijian);
                    $time_s1 = strtotime($time_s[0]);
                    $time_s2 = strtotime($time_s[1])+86400;
                    $condition .= " and a.addtime>=".$time_s1." and a.addtime<".$time_s2;
                }
                if ($sousuo) {
                    $condition .= " and (e.ygmingcheng like '%$sousuo%' or e.pinyinjs like '%$sousuo%' or e.dianhua like '%$sousuo%' or a.zy_bianhao like '%$sousuo%')";
                }
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                if ($field && $order) {
                    $rzpx = "a.".$field." ".$order;
                } else {
                    $rzpx = "a.addtime desc";
                }
                $count = M('rizhi')->alias('a')->join('jjrxt_yonghu e on a.uid=e.id')->where($condition)->count();
                $Page = I('p');
                $data = M('rizhi')->alias('a')->join('jjrxt_yonghu e on a.uid=e.id')->field('a.*,e.ygmingcheng,e.dianhua,e.bumen')->where($condition)->order($rzpx)->page($Page,$limit)->select();
                foreach ($data as $key => $value) {
                    $data[$key]['addtime'] = date('Y-m-d H:i:s',$value['addtime']);
                    $data[$key]['bmming'] = zym($value['bumen'],6);
                    $zybh = explode("-", $value['zy_bianhao']);
                    $data[$key]['zybh'] = $value['zy_bianhao'] ? $value['zy_bianhao'] : "——";
                    $data[$key]['zy_bianhao'] = $zybh[1];
                    $data[$key]['zylx'] = "用户";
                    switch ($value['cz_type']) {
                        case 1:
                            $cz_type = "新增";
                            break;
                        case 2:
                            $cz_type = "基础修改";
                            break;
                        case 8:
                            $cz_type = "删除";
                            break;
                        case 21:
                            $cz_type = "停用";
                            break;
                        case 22:
                            $cz_type = "启用";
                            break;
                        case 23:
                            $cz_type = "信息转移";
                            break;
                        default:
                            $cz_type = "——";
                            break;
                    }
                    $data[$key]['cz_type'] = $cz_type;
                    $data[$key]['neirong'] = $value['neirong'] ? $value['neirong'] : "——";
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count,
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $select_categorys = bumen_option( $bumen, 442);
                $this->assign("select_categorys", $select_categorys);
                $this->display();
            }
        }
        //电脑审核
        public function mac(){
            $is_rbac = _rbac_node_show(245);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (I('is_ajax')) {
                $shlx = I('shlx');
                $sousuo = I('sousuo');
                $shijian = I('shijian');
                switch ($shlx) {
                    case 1:
                        $condition = "id > 0";
                        break;
                    case 2:
                        $condition = "shenhe = 1";
                        break;
                    case 3:
                        $condition = "shenhe is null";
                        break;
                    default:
                        $condition = "shenhe is null";
                        break;
                }
                if ($shijian) {
                    $time_s = explode(' - ',$shijian);
                    $time_s1 = strtotime($time_s[0]);
                    $time_s2 = strtotime($time_s[1])+86400;
                    $condition .= " and tjsj>=".$time_s1." and tjsj<".$time_s2;
                }
                if ($sousuo) {
                    $condition .= " and ((xm like '%$sousuo%') or (phone like '%$sousuo%'))";
                }
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                if ($field && $order) {
                    $zcpx = "order by ".$field." ".$order;
                } else {
                    $zcpx = "order by id desc";
                }
                $Model = new \Think\Model();
                $count = $Model->query("select count(*) from __MAC__ where {$condition}");
                $Page = new \Think\Page($count['0']['count(*)'],$limit);
                $list = "select * from __MAC__ where {$condition} ".$zcpx." limit ".$Page->firstRow.','.$Page->listRows;
                $data = $Model->query($list);
                foreach ($data as $key => $value) {
                    $data[$key]['tjsj'] = $value['tjsj'] ? date('Y-m-d H:i:s',$value['tjsj']) : "——";
                    if ($value['shenhe'] == 1) {
                        $shenhe = "已通过";
                    } else {
                        $is_rbacsh = _rbac_node_show(246);
                        $shenhe = "待审核";
                    }
                    $data[$key]['shenhe'] = $shenhe;
                    $data[$key]['macid'] = $value['macid'] ? $value['macid'] : "——";
                    $data[$key]['xm'] = $value['xm'] ? $value['xm'] : "——";
                    $data[$key]['phone'] = $value['phone'] ? $value['phone'] : "——";
                    $data[$key]['bm'] = $value['bm'] ? $value['bm'] : "——";
                    $data[$key]['dnbh'] = $value['dnbh'] ? $value['dnbh'] : "——";
                    $data[$key]['beizhu'] = $value['beizhu'] ? $value['beizhu'] : "——";
                    $data[$key]['remark'] = $value['remark'] ? $value['remark'] : "——";
                    $is_rbacsc = _rbac_node_show(247);
                    $data[$key]['rbacsh'] = $is_rbacsh ? 1 : 0;
                    $data[$key]['rbacsc'] = $is_rbacsc ? 1 : 0;
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count['0']['count(*)'],
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $this->display();
            }
        }
        //通过审核
        public function macShenhe(){
            $is_rbac = _rbac_node_show(246);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $isok = M('Mac')->where(array('id'=>I('id')))->setField('shenhe',1);
            if ($isok) {
                $this->success('成功');
            }else{
                $this->error('失败');
            }
        }
        //删除审核
        public function macShanchu(){
            $is_rbac = _rbac_node_show(247);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $isok = M('Mac')->where(array('id'=>I('id')))->delete();
            if ($isok) {
                $this->success('成功');
            }else{
                $this->error('失败');
            }
        }
        //可选岗位
        public function kxrole(){
            $is_rbac = _rbac_btn_show(586,0);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $id=I('id');
            if (IS_POST) {
                $roleids=I('duoxuan');
                foreach ($roleids as $key => $value) {
                    $arr[]=$value;
                }
                $ids=implode(",",$arr);
                $isok=M('role')->where(array('id'=>$id))->setField('kxrole',$ids);
                if ($isok) {
                    $this->success('配置成功');
                }else{
                    $this->error('配置失败');
                }
            }else{
                $this->role=yhkxrole(0,1);
                $this->roleid=yhkxrole($id,2);
                $this->rolefl=get_peizhi('rolefl',0,1);
                $this->display();
            }
        }
    }
?>