<?php

    /***************************************************************\
    |                                                               |
    |   开单大师 - 专业的房产ERP管理                                  |
    |                                                               |
    |   © 2019 http://www.kaidandashi.com All rights reserved.      |
    |                                                               |
    |   开单大师由淮南市银泰软件科技有限公司提供技术                    |
    |                                                               |
    |   QQ:984784483                                                |
    |                                                               |
    \***************************************************************/

    namespace Admin\Controller;
    use Think\Controller;
    class WeibanController extends CommonController {
        public function index(){
            if (I('is_ajax')) {
                /*权限控制开始*/
                $condition = "e.gongsiid=".session('gongsiid');
                $x = _rbac_lists_where(744,0);
                if ($x && $x != "all" && $x != "me") {
                    $condition .= " and e.bumen in ({$x})";
                }elseif ($x == "me") {
                    $condition .= " and e.id=".session('uid');
                }elseif ($x == false) {
                    $condition .= " and e.id=0";
                }
                /*权限控制结束*/
                $sousuo = I('sousuo');
                $bumen = I("get.bumen",0,'intval');
                if ($bumen) {
                    $string = get_bm_sz($bumen,2);
                    $condition .= " and e.bumen in ($string)";
                }
                $shijian = I('shijian');
                if ($shijian) {
                    $time_s = explode(' - ',$shijian);
                    $time_s1 = strtotime($time_s[0]);
                    $time_s2 = strtotime($time_s[1])+86400;
                    $condition .= " and a.addtime>=".$time_s1." and a.addtime<".$time_s2;
                }
                if ($sousuo) {
                    $condition .= " and ((e.pinyinjs like '%$sousuo%') or (e.ygmingcheng like '%$sousuo%') or (e.dianhua like '%$sousuo%') or (a.fybianhao like '%$sousuo%') or (a.xieyibh like '%$sousuo%'))";
                }
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                if ($field && $order) {
                    $yspx = "order by a.".$field." ".$order;
                } else {
                    $yspx = "order by a.id desc";
                }
                $Model = new \Think\Model();
                $sqlcount = "select count(*) from __WEIBAN__ a join __YONGHU__ e on a.uid=e.id where {$condition}";
                $Page = new \Think\Page($count['0']['count(*)'],$limit);
                $list = "select a.*,e.ygmingcheng,e.bumen from __WEIBAN__ a join __YONGHU__ e on a.uid=e.id where {$condition} ".$yspx." limit ".$Page->firstRow.','.$Page->listRows;
                $data = $Model->query($list);
                foreach ($data as $key => $value) {
                    $data[$key]['status'] = $value['status'] ? '有效' : '待审核';
                    $data[$key]['fyxqlj'] = U('fangyuan/neirong',array('bianhao'=>$value['fybianhao']));
                    $fy = M('fangyuan')->where(array('bianhao'=>$value['fybianhao']))->field('xiaoqu,zuodong,danyuan,louceng,fanghao,weihurenid,zhuangtai')->find();
                    $data[$key]['xiaoqum'] = zym($fy['xiaoqu'],3);
                    $data[$key]['dizhi'] = $fy['zuodong'].'号楼'.$fy['danyuan'].'单元'.$fy['louceng'].'层'.$fy['fanghao'];
                    $data[$key]['fyxqqx'] = _rbac_btn_show(46,$fy['zhuangtai'],$fy['weihurenid']) == true ? '1' : '0';
                    $data[$key]['rbacxq'] = _rbac_btn_show(748,0,$value['ys_uid']) ? '1' : '0';
                    $data[$key]['rbacgx'] = _rbac_btn_show(749,0,$value['ys_uid']) ? '1' : '0';
                    $data[$key]['rbacsc'] = _rbac_btn_show(752,0,$value['ys_uid']) ? '1' : '0';
                    $fybh = explode("-", $value['fybianhao']);
                    $data[$key]['fybh'] = $value['fybianhao'];
                    $data[$key]['fybianhao'] = $fybh[1];
                    $data[$key]['shijian'] = date('Y-m-d',$value['startunix']).'至'.date('Y-m-d',$value['endunix']);
                    $data[$key]['bumen'] = zym($value['bumen'],6);
                    $data[$key]['addtime'] = date('Y-m-d H:i:s',$value['addtime']);
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count['0']['count(*)'],
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            }else{
                $select_categorys = bumen_option(0,744);
                $this->assign("select_categorys", $select_categorys);
                $this->display();
            }
        }
        public function editweiban(){
            $id = I('id',0,'int');
            $uid = M('weiban')->where(array('id'=>$id))->getField('uid');
            $is_rbac = _rbac_btn_show(746,0,$uid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            if (IS_POST) {
                $wbtps=M('photos')->where(array('data_table'=>'weiban','data_id'=>$id))->count();
                $file_arr = I('file_path');
                if (count($file_arr) > (6-$wbtps)) {
                    $this->error('最多上传6张！');
                }
                $data['wbtime'] = strtotime(I('wbtime'));
                $time_s = explode(' - ',I('shijian'));
                $time_s1 = strtotime($time_s[0]);
                $time_s2 = strtotime($time_s[1])+86400;
                $wb_uid = M('yonghu')->where(array('ygmingcheng'=>I('wb_user')))->getField('id');
                if (!$wb_uid) {
                    $this->error('查找不到该用户！');
                }
                $data['uid'] = $wb_uid;
                $data['xieyibh'] = I('xieyibh');
                $data['jiage'] = I('jiage');
                $data['baozhengjin'] = I('baozhengjin');
                $data['startunix'] = $time_s1;
                $data['endunix'] = $time_s2;
                $data['beizhu'] = I('beizhu');
                $isok = M('weiban')->where(array('id'=>$id))->save($data);
                if ($isok) {
                    foreach ($file_arr as $value) {
                        $file_img_arr[] = array(
                            'data_id' => $id,
                            'img_path' => $value,
                            'addtime' => time(),
                            'adduid' => session('uid'),
                            'gongsiid' => session('gongsiid'),
                            'data_table' => 'weiban'
                        );
                    }
                    M('photos')->addAll($file_img_arr);
                    $this->success('保存成功!');
                } else {
                    $this->error('保存失败!');
                }
            }else{
                $weiban = M('weiban')->where(array('id'=>$id))->find();
                $weiban['wb_user'] = M('yonghu')->where(array('id'=>$weiban['uid']))->getField('ygmingcheng');
                $this->weiban = $weiban;
                $this->display();
            }
        }
        public function content(){
            $id = I('get.id',0 ,'int');
            $find = M('weiban')->where(array('id'=>$id))->find();
            if (!$find) {
                echo "没找到资源！ -400";
                die;
            }
            $is_rbac = _rbac_btn_show(745,0,$find['uid']);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $imgs = M('photos')->where(array('data_id'=>$id,'data_table'=>'weiban','status'=>1))->select();
            $fangyuan = M('fangyuan')->where(array('bianhao'=>$find['fybianhao']))->find();
            $user = M('yonghu')->where(array('id'=>$find['uid']))->field('ygmingcheng,bumen')->find();
            $this->user = $user;
            $this->fangyuan = $fangyuan;
            $this->find = $find;
            $this->imgs = $imgs;
            $this->display();
        }
        public function delweiban(){
            $id = I('post.id',0 ,'int');
            $uid = M('weiban')->where(array('id'=>$id))->getField('uid');
            $is_rbac = _rbac_btn_show(751,0,$uid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $isok = M('weiban')->where(array('id'=>$id))->delete();
            if ($isok) {
                $this->success('删除成功！');
            }else{
                $this->error('删除失败！');
            }
        }
    }
?>