<?php

	/**
		+---------------------------------------------------------------
		| 开单大师（专业的房产中介管理系统）
		+---------------------------------------------------------------
		| © 2017-2023 http://www.kaidandashi.com/ All rights reserved
		+---------------------------------------------------------------
		| 本系统由淮南市银泰软件科技有限公司提供技术支持
		+---------------------------------------------------------------
		| QQ号：984784483
		+---------------------------------------------------------------
	*/

	/*-----------------------------------权限函数开始-------------------------------------*/

		function bumen_option($selected,$node_id){
			$x = $node_id ? _rbac_lists_where($node_id,0) : "null";
			$tree = new \Org\Util\Tree();
			$parentid = $selected;
			$result = M('bumen')->order(array("sort" => "ASC"))->select();
			foreach ($result as $key => $r) {
				$r['selected'] = $r['id'] == $parentid ? 'selected' : '';
				if ($x && $x != "all" && $x != "me" && $x != "null") {
					$b = explode(",",$x);
					if (in_array($r['id'],$b)) {
						$array[] = $r;
					}
				}elseif($x == 'me' || $x == false){
					$array = "";
				}elseif($x == 'all' || $x == 'null'){
					$array[] = $r;
				}
			}
			$a = 0;
			$l = 999;
			if ($x && $x != "all" && $x != "me" && $x != "null") {
				foreach ($array as $key => $value) {
					if ($value['level'] < $l) {
						$a = $value['parentid'];
						$l = $value['level'];
					}
				}
			}
			$str = "<option value='\$id' title='\$bmming' \$selected>\$spacer \$bmming</option>";
			$tree->init($array);
			$select_categorys = $tree->get_tree($a, $str);
			return $select_categorys;
		}

		function bumen_idsz($node_id){
			if ($node_id) {
				$bumen = _rbac_bumen_show($node_id,0);
				if (!$bumen) {
					$bumen = -1;
				}
				$arr_string = get_bm_sz($bumen,1);
				return $arr_string;
			}
		}

		/**
			* 二维数组排序
			* @param $arr
			* @param $keys
			* @param string $type
			* @return array
		*/

		function array_sort($arr, $keys, $type = 'desc') {
			$key_value = $new_array = array();
			foreach ($arr as $k => $v) {
				$key_value[$k] = $v[$keys];
			}
			if ($type == 'asc') {
				asort($key_value);
			} else {
				arsort($key_value);
			}
			reset($key_value);
			foreach ($key_value as $k => $v) {
				$new_array[$k] = $arr[$k];
			}
			return $new_array;
		}

		/*设置权限页面是否选中*/
		function _is_have_node($config,$role_id,$fanwei,$zhuangtai,$type){
			foreach ($config as $key => $value) {
				if ($value['zhuangtai'] == $zhuangtai && $value['fanwei'] == $fanwei) {
					if ($type == 1) {
						return "checked";
					}else{
						return "selected";
					}
				}
			}
			return "";
		}

		function _rbac_bumen_show($node_id,$zhuangtai){
			$fanwei = _rbac_range($node_id,$zhuangtai);
			if (!$fanwei) {
				return false;
			}elseif ($fanwei=='all') {
				return 'all';
			}elseif ($fanwei=='me') {
				return 'me';
			}
			$arr =_rbac_bumen_top_id($fanwei);
			if (!$arr) {
				return false;
			}
			return $arr["id"];
		}

		function _rbac_bumen_top_id($val){
			$b_id = M('yonghu')->where(array('id'=>session('uid')))->getField('bumen');
			$find = M('bumen')->where(array('id'=>$b_id))->find();
			$i = $find['level'];
			if ($find['level']<$val) {
				return false;
			}elseif ($find['level']==$val) {
				return $find;
			}elseif ($find['level']>$val) {
				$u = $find['level']-$val;
				for ($i=0; $i < $u; $i++) { 
					$find = M('bumen')->where(array('id'=>$find['parentid']))->find();
				}
				return $find;
			}
		}

		function _rbac_bumen_array($array,$id=0){
			$arr = array();
			foreach ($array as $v) {
				if ($v['parentid']==$id) {
					$arr[] = $v['id'];
					$a = _rbac_bumen_array($array,$v['id']);
					$arr = array_merge($arr, $a); 
				}
			}
			return $arr;
		}

		//获取相应节点和状态的 范围值
		function _rbac_range($node_id,$zhuangtai){
			if(session(C('ADMIN_AUTH_KEY'))){
				return 'all';
			}
			$where['node_id'] = $node_id;
			$where['role_id'] = get_yh_role(session('uid'),1);
			$where['zhuangtai'] = $zhuangtai;
			$fanwei = M('access')->where($where)->find();
			if (!$fanwei) {
				return false;
			}
			if (!$fanwei['fanwei']){
				return 'all';
			}
			$me_level = _rbac_me_level();
			if ($fanwei['fanwei']==$me_level) {
				return 'me';
			}
			return $fanwei['fanwei'];
		}

		//获取范围生成逗号分隔的字符串
		function _rbac_in_bumen_string($node_id,$zhuangtai){
			$fanwei = _rbac_range($node_id,$zhuangtai);
			if (!$fanwei) {
				return false;
			}elseif ($fanwei=='all') {
				return 'all';
			}elseif ($fanwei=='me') {
				return 'me';
			}
			$arr =_rbac_bumen_top_id($fanwei);
			if (!$arr) {
				return false;
			}
			$string = get_bm_sz($arr['id'],2);
			return $string;
		}

		//根据节点状态和对应的人物 查看是否有权限
		function _rbac_btn_show($node_id,$zhuangtai,$uid){
			$string = _rbac_in_bumen_string($node_id,$zhuangtai);
			if (!$string) {
				return false;
			}elseif ($string=='all') {
				return true;
			}elseif ($string=='me') {
				if ($uid==session('uid')) {
					return true;
				} else {
					return false;
				}
			}
			$map['bumen'] = array('in',$string);
			$map['id'] = $uid;
			$find = M('yonghu')->where($map)->find();
			if ($find) {
				return true;
			}else{
				return false;
			}
		}

		function _rbac_node_show($node_id){
			if(session(C('ADMIN_AUTH_KEY'))){
				return true;
			}
			$where['node_id'] = $node_id;
			$where['role_id'] = get_yh_role(session('uid'),1);
			$find = M('access')->where($where)->find();
			if ($find) {
				return true;
			}else{
				return false;
			}
		}

		function _rbac_me_level(){
			$count = count(get_options('bumen_options','bumen_array'));
			return $count+1;
		}

		function _rbac_lists_where($node_id,$zhuangtai){
			$string = _rbac_in_bumen_string($node_id,$zhuangtai);
			if (!$string) {
				return false;
			}elseif ($string=='all') {
				return 'all';
			}elseif ($string=='me') {
				return 'me';
			}
			return $string;
		}

	/*-----------------------------------权限函数结束-------------------------------------*/

	// 分析枚举类型配置值 格式 a:名称1,b:名称2
	function parse_config_attr($string) {
		$array = preg_split('/[,;\r\n]+/', trim($string, ",;\r\n"));
		if(strpos($string,':')){
			$value = array();
			foreach ($array as $val) {
				list($k, $v) = explode(':', $val);
				$value[$k] = $v;
			}
		}else{
			$value = $array;
		}
		return $value;
	}

	/**
		* 获取数据库中的配置列表
		* @return array 配置数组
	*/

	function lists(){
		$data = M('Configure')->where(array('status'=>1))->field('type,name,value')->select();
		$config = array();
		if($data && is_array($data)){
			foreach ($data as $value) {
				$config[$value['name']] =parse($value['type'], $value['value']);
			}
		}
		return $config;
	}

	/**
		* 根据配置类型解析配置
		* @param integer $type 配置类型
		* @param string $value 配置值
	*/

	function parse($type, $value){
		switch ($type) {
			//解析数组
			case 3:
				$array = preg_split('/[,;\r\n]+/', trim($value, ",;\r\n"));
				if(strpos($value,':')){
					$value = array();
					foreach ($array as $val) {
						list($k, $v) = explode(':', $val);
						$value[$k] = $v;
					}
				}else{
					$value = $array;
				}
				break;
		}
		return $value;
	}

	//获取资源名
	function zym($zyid,$zylx){
		switch ($zylx) {
			case '1':
				$zym = M('xingzhengqu')->where(array('id'=>$zyid))->getField('xzqming');
				break;
			case '2':
				$zym = M('pianqu')->where(array('id'=>$zyid))->getField('pianqum');
				break;
			case '3':
				$zym = M('xiaoqu')->where(array('id'=>$zyid))->getField('xiaoqum');
				break;
			case '4':
				$zym = M('xuequ')->where(array('id'=>$zyid))->getField('xuexiaom');
				break;
			case '5':
				$zym = M('yonghu')->where(array('id'=>$zyid))->getField('ygmingcheng');
				break;
			case '6':
				$find = M('bumen')->where(array('id'=>$zyid))->find();
				$zym = $find['bmming'];
				$u = $find['level'];
				for ($i=0; $i < $u; $i++) { 
					$find = M('bumen')->where(array('id'=>$find['parentid']))->find();
					if ($find['bmming']) {
						$zym = $find['bmming']."—".$zym;
					}
				}
				break;
			case '7':
				$zym = M('bumen')->where(array('id'=>$zyid))->getField('bmming');
				break;
			case '8':
				$zym = M('role')->where(array('id'=>$zyid))->getField('remark');
				break;
			case '9':
				$options = get_options('bumen_options','bumen_array');
				$zym = $options[$zyid];
				break;
			case '14':
				$zym = M('yonghu')->where(array('id'=>$zyid))->getField('dianhua');
				break;
			case '15':
				$zym = M('yonghu')->where(array('id'=>$zyid))->getField('ygbianhao');
				break;
			default:
				$zym = "";
				break;
		}
		return $zym;
	}

	//获取部门及下级部门的数组
	function get_bm_sz($bmid,$lx){
		$result = M('bumen')->order('sort asc')->select();
		if ($bmid) {
			$arr_string = _rbac_bumen_array($result,$bmid);
			$arr_string[] = $bmid;
			if ($lx == 1) {
				$bm=$arr_string;
			} elseif ($lx == 2) {
				$bm = implode(',',$arr_string);
			}
			return $bm;
		}
	}

	//获取用户部门
	function yhbm($id,$lx){
		$bm=M('yonghu')->where(array('id'=>$id))->getField('bumen');
		if ($lx == 1) {
			$yhbm=$bm;
		} elseif ($lx == 2) {
			$yhbm=zym($bm,7);
		} elseif ($lx == 3) {
			$yhbm=zym($bm,6);
		}
		return $yhbm;
	}

	//获取用户角色（岗位）
	function get_yh_role($id,$lx){
		$role_id=M('role_user')->where(array('user_id'=>$id))->getField('role_id');
		if ($lx == 1) {
			return $role_id;
		} elseif ($lx == 2) {
			$remark=zym($role_id,8);
			return $remark;
		}
	}

	//获取用户可选角色（岗位）
	function yhkxrole($id,$lx){
		if (!$id) {
			$id=get_yh_role(session('uid'),1);
		}
		if ($lx == 1) {
			if (session(C('ADMIN_AUTH_KEY'))) {
				$role=M('role')->where(array('gongsiid'=>session('gongsiid')))->order('rolefl asc,xsshunxu asc')->select();
			} else {
				$kxrole=M('role')->where(array('id'=>$id))->getField('kxrole');
				if (!$kxrole) {
					$kxrole="0";
				}
				$role=M('role')->where(array('gongsiid'=>session('gongsiid'),'id'=>array('in',$kxrole)))->order('rolefl asc,xsshunxu asc')->select();
			}
		} elseif ($lx == 2) {
			$kxrole=M('role')->where(array('id'=>$id))->getField('kxrole');
			$roleids=explode(",",$kxrole);
			foreach ($roleids as $key => $value) {
				$role[$value]=$value;
			}
		}
		return $role;
	}

	//获取二手房源图片
	function get_s_img($id){
		$img_urlf=M('photo')->where(array('fybh'=>$id,'fengmian'=>1))->getField('image');
		$img_url=M('photo')->where(array('fybh'=>$id))->order('create_time desc')->limit(1)->getField('image');
		if ($img_urlf) {
			return $img_urlf;
		}else{
			return $img_url;
		}
	}

	//获取楼盘图片
	function get_x_img($id){
		$img_urlf=M('xqphoto')->where(array('xqid'=>$id,'fengmian'=>1))->getField('image');
		$img_url=M('xqphoto')->where(array('xqid'=>$id))->order('create_time desc')->limit(1)->getField('image');
		if ($img_urlf) {
			return $img_urlf;
		}else{
			return $img_url;
		}
	}

	//获取配置信息
	function get_peizhi($pzm,$cxz,$lx){
		if ($lx == 1) {
			$peizhi=M('peizhi')->where(array('pzming'=>$pzm,'zhuangtai'=>1))->order('xsshunxu asc')->select();
		} elseif ($lx == 2) {
			$peizhi=M('peizhi')->where(array('pzming'=>$pzm,'zhuangtai'=>1))->order('xsshunxu asc')->field($cxz)->select();
		} elseif ($lx == 3) {
			$peizhi=M('peizhi')->where(array('pzming'=>$pzm,'lxid'=>$cxz))->getField('lxming');
		} elseif ($lx == 4) {
			$peizhi=M('peizhi')->where(array('pzming'=>$pzm,'zhuangtai'=>1))->order('lxid asc')->limit(1)->getField('lxming');
		} elseif ($lx == 5) {
			$peizhi=M('peizhi')->where(array('pzming'=>$pzm,'zhuangtai'=>1))->order('lxid asc')->limit(1)->getField('lxid');
		} elseif ($lx == 6) {
			$peizhi=M('peizhi')->where(array('pzming'=>$pzm,'lxming'=>$cxz,'zhuangtai'=>1))->getField('lxid');
		}
		return $peizhi;
	}

	//获取配置名或注释
	function get_pzmzs($pz,$lx){
		if ($lx == 1) {
			$pzmzs=M('peizhi')->where(array('id'=>$pz))->getField('pzming');
		} elseif ($lx == 2) {
			$pzmzs=M('peizhi')->where(array('id'=>$pz))->getField('zhushi');
		} elseif ($lx == 3) {
			$pzmzs=M('peizhi')->where(array('pzming'=>$pz))->getField('pzming');
		} elseif ($lx == 4) {
			$pzmzs=M('peizhi')->where(array('pzming'=>$pz))->getField('zhushi');
		} elseif ($lx == 5) {
			$pzmzs=M('peizhi')->where(array('zhushi'=>$pz))->getField('pzming');
		} elseif ($lx == 6) {
			$pzmzs=M('peizhi')->where(array('zhushi'=>$pz))->getField('zhushi');
		}
		return $pzmzs;
	}

	//获取全站配置
	function get_options($val,$zd){
		$value = M('options')->where(array('option_name'=>$val))->getField('option_value');
		$options=json_decode($value,true);
		if ($zd) {
			$options=$options[$zd];
		}
		return $options;
	}

	//递归数组
	function node_merge($node, $access = null,$pid=0){
		$arr = array();
		foreach ($node as $v) {
			if (is_array($access)) {
				$v['access'] = in_array($v['id'],$access) ? 1 : 0;
			}
			if ($v['pid']==$pid) {
				$v['child'] = node_merge($node,$access,$v['id']);
				$arr[]=$v;
			}
		}
		return $arr;
	}

	//打印
	function p ($arr){
		echo '<pre>' . print_r($arr,true) . '</pre>';
	}

	/**
		* 获取客户端浏览器类型
		* @return string 浏览器类型返回字符串 unknown为未知浏览器类型
	*/

	function getBrowser(){
		$agent=$_SERVER["HTTP_USER_AGENT"];
		if(strpos($agent,'MSIE')!==false || strpos($agent,'rv:11.0')) //ie11判断
			return "ie";
		else if(strpos($agent,'Firefox')!==false)
			return "firefox";
		else if(strpos($agent,'Chrome')!==false)
			return "chrome";
		else if(strpos($agent,'Opera')!==false)
			return 'opera';
		else if((strpos($agent,'Chrome')==false)&&strpos($agent,'Safari')!==false)
			return 'safari';
		else
			return 'unknown';
	}

	/**
		* 上传文件类型控制 此方法仅限ajax上传使用
		* @param string $path 字符串 保存文件路径示例： /Upload/image/
		* @param string $format 文件格式限制
		* @param integer $maxSize 允许的上传文件最大值 52428800
		* @return booler 返回ajax的json格式数据
	*/

	//上传房源图片
	function ajax_upload($path='file',$format='image',$maxSize='52428800'){
		ini_set('max_execution_time', '0');
		// 去除两边的/
		$path=trim($path,'/');
		// 添加Upload根目录
		$path=strtolower(substr($path, 0,6))==='upload' ? ucfirst($path) : 'Upload/'.$path;
		// 上传文件类型控制
		$ext_arr= array(
			'image' => array('gif', 'jpg', 'jpeg', 'png', 'bmp'),
			'photo' => array('jpg', 'jpeg', 'png'),
			'flash' => array('swf', 'flv'),
			'media' => array('swf', 'flv', 'mp3', 'wav', 'wma', 'wmv', 'mid', 'avi', 'mpg', 'asf', 'rm', 'rmvb'),
			'file' => array('doc', 'docx', 'xls', 'xlsx', 'ppt', 'htm', 'html', 'txt', 'zip', 'rar', 'gz', 'bz2','pdf')
		);
		if(!empty($_FILES)){
			// 上传文件配置
			$config=array(
				'maxSize' => $maxSize, // 上传文件最大为50M
				'rootPath' => './', // 文件上传保存的根路径
				'savePath' => './'.$path.'/', // 文件上传的保存路径（相对于根路径）
				'saveName' => array('uniqid',''), // 上传文件的保存规则，支持数组和字符串方式定义
				'autoSub' => false, // 自动使用子目录保存上传文件 默认为true
				'exts' => ''//isset($ext_arr[$format])?$ext_arr[$format]:'',
			);
			// 实例化上传
			$upload=new \Think\Upload($config);
			// 调用上传方法
			$info=$upload->upload();
			$data=array();
			$Img = D('Photo');  
			if(!$info){
				// 返回错误信息
				$error=$upload->getError();
				$data['error_info']=$error;
				echo json_encode($data);
			}else{
				// 返回成功信息
				foreach($info as $file){
					//上传的图片同步保存到数据库表
					$d['gongsiid'] = session('gongsiid');  
					$d['uid'] = session('uid');
					$d['image'] = $file['savename'];
					$d['fybh'] = $_POST['fybh'];
					$d['create_time'] = time();
					$Img->add($d);
					//把fangyuan表tupian字段更新为 1
					M('Fangyuan')->where(array('bianhao'=>$_POST['fybh']))->setField('tupian',1);
					M('fangyuan')->where(array('bianhao'=>$_POST['fybh']))->setField('xiugaisj',time());
					$data_rizhi['zy_type']=1;
					$data_rizhi['uid']=session("uid");
					$data_rizhi['addtime']=time();
					$data_rizhi['cz_type']=12;
					$fyid=M('fangyuan')->where(array('bianhao'=>$_POST['fybh']))->getField('id');
					$data_rizhi['zy_id']=$fyid;
					$data_rizhi['zy_bianhao']=$_POST['fybh'];
					$neirong="上传图片";
					$data_rizhi['neirong']=$neirong;
					M('rizhi')->add($data_rizhi);
					//为上传成功的图片生成缩略图
					$timg = new \Think\Image();
					$timg->open(trim($file['savepath'].$file['savename']));
					$newpathbig =  trim($file['savepath']).'b_'.substr($file['savename'],0,strrpos($file['savename'], '.')).'.'.$file['ext'];
					$newpath =  trim($file['savepath']).'t_'.substr($file['savename'],0,strrpos($file['savename'], '.')).'.'.$file['ext'];
					$timg->thumb(900,600)->save($newpathbig);
					$timg->thumb(450,300)->save($newpath);
					if (C('IS_PHOTO_JSY')==1) {
						// 给原图添加水印
						$timg->open($newpathbig)->water('./Upload/shuiyin/shuiyin1.png',\Think\Image::IMAGE_WATER_CENTER,C('IS_PHOTO_TOUMING'))->save($newpathbig);
						$timg->open($newpath)->water('./Upload/shuiyin/shuiyin1.png',\Think\Image::IMAGE_WATER_CENTER,C('IS_PHOTO_TOUMING'))->save($newpath);
					}
					//删除原图
					unlink('./Upload/'.session('gongsiid').'/'.$_POST['fybh'].'/'.$file['savename']);
					rename($newpathbig,'./Upload/'.session('gongsiid').'/'.$_POST['fybh'].'/'.$file['savename']);
					//返回给AJAX
					$data['name']=trim($file['savepath'].$file['savename'],'.');
					echo json_encode($data);
				}
			}
		}
	}

	//上传小区图片
	function ajax_upload_xq($path='file',$format='image',$maxSize='52428800'){
		ini_set('max_execution_time', '0');
		// 去除两边的/
		$path=trim($path,'/');
		// 添加Upload根目录
		$path=strtolower(substr($path, 0,6))==='upload' ? ucfirst($path) : 'Upload/'.$path;
		// 上传文件类型控制
		$ext_arr= array(
			'image' => array('gif', 'jpg', 'jpeg', 'png', 'bmp'),
			'photo' => array('jpg', 'jpeg', 'png'),
			'flash' => array('swf', 'flv'),
			'media' => array('swf', 'flv', 'mp3', 'wav', 'wma', 'wmv', 'mid', 'avi', 'mpg', 'asf', 'rm', 'rmvb'),
			'file' => array('doc', 'docx', 'xls', 'xlsx', 'ppt', 'htm', 'html', 'txt', 'zip', 'rar', 'gz', 'bz2','pdf')
		);
		if(!empty($_FILES)){
			// 上传文件配置
			$config=array(
				'maxSize' => $maxSize, // 上传文件最大为50M
				'rootPath' => './', // 文件上传保存的根路径
				'savePath' => './'.$path.'/', // 文件上传的保存路径（相对于根路径）
				'saveName' => array('uniqid',''), // 上传文件的保存规则，支持数组和字符串方式定义
				'autoSub' => false, // 自动使用子目录保存上传文件 默认为true
				'exts' => '' //isset($ext_arr[$format])?$ext_arr[$format]:'',
			);
			// 实例化上传
			$upload=new \Think\Upload($config);
			// 调用上传方法
			$info=$upload->upload();
			$data=array();
			$Img = D('xqphoto');
			if(!$info){
				// 返回错误信息
				$error=$upload->getError();
				$data['error_info']=$error;
				echo json_encode($data);
			}else{
				// 返回成功信息
				foreach($info as $file){
					//上传的图片同步保存到数据库表
					$d['gongsiid'] = session('gongsiid');  
					$d['uid'] = session('uid');
					$d['image'] = $file['savename'];
					$d['xqid'] = $_POST['xqid'];
					$d['create_time'] = time();
					$Img->add($d);
					//把fangyuan表tupian字段更新为 1
					M('Xiaoqu')->where(array('id'=>$_POST['xqid']))->setField('tupian',1);
					//为上传成功的图片生成缩略图
					$timg = new \Think\Image();
					$timg->open(trim($file['savepath'].$file['savename']));
					$newpathbig =  trim($file['savepath']).'b_'.substr($file['savename'],0,strrpos($file['savename'], '.')).'.'.$file['ext'];
					$newpath =  trim($file['savepath']).'t_'.substr($file['savename'],0,strrpos($file['savename'], '.')).'.'.$file['ext'];
					$timg->thumb(900,600)->save($newpathbig); 
					$timg->thumb(450,300)->save($newpath);
					if (C('IS_PHOTO_JSY')==1) {
						// 给原图添加水印
						$timg->open($newpathbig)->water('./Upload/shuiyin/shuiyin1.png',\Think\Image::IMAGE_WATER_CENTER,C('IS_PHOTO_TOUMING'))->save($newpathbig);
						$timg->open($newpath)->water('./Upload/shuiyin/shuiyin1.png',\Think\Image::IMAGE_WATER_CENTER,C('IS_PHOTO_TOUMING'))->save($newpath);
					}
					//删除原图
					unlink('./Upload/'.session('gongsiid').'/xiaoqu/'.$_POST['xqid'].'/'.$file['savename']);
					rename($newpathbig,'./Upload/'.session('gongsiid').'/xiaoqu/'.$_POST['xqid'].'/'.$file['savename']);
					//返回给AJAX
					$data['name']=trim($file['savepath'].$file['savename'],'.');
					echo json_encode($data);
				}			   
			}
		}
	}

	//获取配置变动信息
	function get_xiugai($xiugaiqian,$xiugaihou,$pzming){
		$xgqian=get_peizhi($pzming,$xiugaiqian,3);
		$xghou=get_peizhi($pzming,$xiugaihou,3);
		$zhushi=get_pzmzs($pzming,4);
		return $zhushi."：[".$xgqian."]=>[".$xghou."]；";
	}

	//获取配置变动信息
	function get_xiugai1($zhushi,$xiugaiqian,$xiugaihou,$pzming){
		$xgqian=get_peizhi($pzming,$xiugaiqian,3);
		$xghou=get_peizhi($pzming,$xiugaihou,3);
		return $zhushi."：[".$xgqian."]=>[".$xghou."]；";
	}

	//获取部门变动信息
	function get_xgbm($xiugaiqian,$xiugaihou,$bmming){
		$xgqian=M('bumen')->where(array('id'=>$xiugaiqian))->getField('bmming');
		$xghou=M('bumen')->where(array('id'=>$xiugaihou))->getField('bmming');
		return "部门：[".$xgqian."]=>[".$xghou."]；";
	}

	//获取岗位变动信息
	function get_xgjs($xiugaiqian,$xiugaihou,$remark){
		$xgqian=M('role')->where(array('id'=>$xiugaiqian))->getField('remark');
		$xghou=M('role')->where(array('id'=>$xiugaihou))->getField('remark');
		return "岗位：[".$xgqian."]=>[".$xghou."]；";
	}

	/**
	* 防止sql注入
	*/
	function sql_check_param($value) {
		return post_check(check_param($value));
	}

	/**
	* 防止sql注入自定义方法一
	* author: xiaochuan
	* @param: mixed $value 参数值
	*/
	function check_param($value=null) {
		$str = 'select|insert|and|or|update|delete|\'|\/\*|\*|\.\.\/|\.\/|union|into|load_file|outfile';
		if (eregi($str, $value)) {
			return '';
		}
		return $value;
	}

	/**
	* 防止sql注入自定义方法二
	* author: xiaochuan
	* @param: mixed $value 参数值
	*/
	function post_check($value) {
		if(!get_magic_quotes_gpc()) {
			// 进行过滤
			$value = addslashes($value);
		}
		$value = str_replace("_", "\_", $value);
		$value = str_replace("%", "\%", $value);
		$value = nl2br($value);
		$value = htmlspecialchars($value);
		return $value;
	}