<?php

/*******************************************************************\
|																	|
|	开单大师（专业的房产中介管理系统）								|
|																	|
|	© 2017-2023 http://www.kaidandashi.com/ All rights reserved		|
|																	|
|	本系统由淮南市银泰软件科技有限公司提供技术支持					|
|																	|
|	QQ号：984784483													|
|																	|
\*******************************************************************/

namespace Admin\Controller;
use Think\Controller;
use Think\Upload;
use Vendor\ThinkImage\ThinkImage;
class AvatarController extends Controller {
	//上传头像AJAX
	public function uploadImgAjax(){
        $gongsiid = session('gongsiid');
        $username = session('username');
        //实例化上传类
        $upload = new Upload(C('UPLOAD_CONFIG'));
        $upload->saveName = $username;
		//头像目录地址
		$path =  $gongsiid.'/';
		$upload->savePath = $path;
		$ext = "jpg";
		$info = $upload->upload();
		if(!$info) {// 上传错误提示错误信息
			$this->error($upload->getError());
		}else{// 上传成功 获取上传文件信息
			$temp_size = getimagesize('./Upload/Avatar/'.$path.$info['file']['savename']);
			if($temp_size[0] < 200 || $temp_size[1] < 200){//判断宽和高是否符合头像要求
				@unlink('./Upload/Avatar/'.$path.$info['file']['savename']);
				$this->error('图片宽或高不得小于200*200！');
			}
			//头像目录地址
			$path = './Upload/Avatar/'.session("gongsiid").'/';
			//要保存的图片
			$real_path = $path.$info['file']['savename'];			
			//实例化裁剪类
			$Think_img = new ThinkImage(THINKIMAGE_GD);
			//生成缩略图
			$Think_img->open($real_path)->thumb(200,200, 1)->save($path.$username.'_200.'.$ext);
			$Think_img->open($real_path)->thumb(100,100, 1)->save($path.$username.'_100.'.$ext);
			$Think_img->open($real_path)->thumb(60,60, 1)->save($path.$username.'_60.'.$ext);
			$Think_img->open($real_path)->thumb(30,30, 1)->save($path.$username.'_30.'.$ext);
			@unlink($real_path);
			//更新用户表头像touxiang
			$settouxiang = M('Yonghu')->where(array('id'=>session('uid')))->setField(array('touxiang'=>1));
			$this->success('上传头像成功');
		}
	}
	//上传头像
	public function uploadImg(){
        $gongsiid = I('gongsiid');
        // 实例化上传类
        $upload = new Upload(C('UPLOAD_CONFIG'));
		//头像目录地址
		$path =  $gongsiid.'/';
		$upload->savePath = $path;
		if(!$upload->upload()) {						// 上传错误提示错误信息
			$this->ajaxReturn(array('status'=>0,'info'=>$upload->getErrorMsg()));
		}else{											// 上传成功 获取上传文件信息
			$temp_size = getimagesize('./Upload/Avatar/'.$path.'/temp.jpg');
			
			if($temp_size[0] < 200 || $temp_size[1] < 200){//判断宽和高是否符合头像要求
				$this->ajaxReturn(array('status'=>0,'info'=>'图片宽或高不得小于100px！'));
			}
			$this->ajaxReturn(array('status'=>1,'path'=>__ROOT__.'/Upload/Avatar/'.$gongsiid.'/temp.jpg'));
		}
	}
	
	//裁剪并保存用户头像
	public function cropImg(){
		//图片裁剪数据
		$params = I('post.');	//裁剪参数
		if(!isset($params) && empty($params)){
			$this->error('参数错误！');
		}

		//头像目录地址
		$path = './Upload/Avatar/'.session("gongsiid").'/';
		//要保存的图片
		$real_path = $path.session('username').'.jpg';
		//临时图片地址
		$pic_path = $path.'temp.jpg';
		
		//实例化裁剪类
		$Think_img = new ThinkImage(THINKIMAGE_GD);
		//裁剪原图得到选中区域
		$Think_img->open($pic_path)->crop($params['w'],$params['h'],$params['x'],$params['y'])->save($real_path);
		
		//生成缩略图
		$Think_img->open($real_path)->thumb(200,200, 1)->save($path.session('username').'_200.jpg');
		$Think_img->open($real_path)->thumb(100,100, 1)->save($path.session('username').'_100.jpg');
		$Think_img->open($real_path)->thumb(60,60, 1)->save($path.session('username').'_60.jpg');
		$Think_img->open($real_path)->thumb(30,30, 1)->save($path.session('username').'_30.jpg');
		@unlink($real_path);
		//更新用户表头像touxiang
		$settouxiang = M('Yonghu')->where(array('id'=>session('uid')))->setField(array('touxiang'=>1));
		$this->success('上传头像成功');
	}
}