<?php

    /*******************************************************************\
    |                                                                   |
    |   开单大师（专业的房产中介管理系统）                              |
    |                                                                   |
    |   © 2017-2023 http://www.kaidandashi.com/ All rights reserved     |
    |                                                                   |
    |   本系统由淮南市银泰软件科技有限公司提供技术支持                  |
    |                                                                   |
    |   QQ号：984784483                                                 |
    |                                                                   |
    \*******************************************************************/

    namespace Admin\Controller;
    use Think\Controller;
    class FyneirongController extends CommonController {
        //收藏房源
        public function shoucang(){
            $is_rbac = _rbac_node_show(388);
            if (!$is_rbac) {
                $this->error("异常错误！");
            }
            $id=I('id');
            $data['user_id']=session("uid");
            $data['fyid']=$id;
            if (M('shoucang')->add($data)) {
                $this->success('添加成功');
            }else{
                $this->error('添加失败');
            }
        }
        //取消收藏
        public function noshoucang(){
            $is_rbac = _rbac_node_show(389);
            if (!$is_rbac) {
                $this->error("异常错误！");
            }
            $id=I('id');
            $data['user_id']=session("uid");
            $data['fyid']=$id;
            if (M('shoucang')->where('fyid='.$id.' and user_id='.session("uid"))->delete()) {
                $this->success('取消成功');
            }else{
                $this->error('取消失败');
            }
        }
        //封盘
        public function fengpan(){
            $fangyuan=M('fangyuan')->where(array('id'=>I('fyid')))->find();
            $is_rbac = _rbac_btn_show(830,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $this->error('请联系客服（19965783436）获取正式版功能！');
            }else{
                if ($fangyuan['fpdh'] == 2) {
                    $this->fdh=1;
                }
                if ($fangyuan['fpdz'] == 2) {
                    $this->fdz=1;
                }
                if ($fangyuan['fpdj'] == 2) {
                    $this->fdj=1;
                }
                if ($fangyuan['fpdq'] == 2) {
                    $this->fdq=1;
                }
                if ($fangyuan['fpck'] == 2) {
                    $this->fck=1;
                }
                $this->fyid=I('fyid');
                $this->display();
            }
        }
        //开盘
        public function kaipan(){
            $fangyuan=M('fangyuan')->where(array('id'=>I('fyid')))->find();
            $is_rbac = _rbac_btn_show(831,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $this->error('请联系客服（19965783436）获取正式版功能！');
            }else{
                if ($fangyuan['fpdh'] == 1) {
                    $this->kdh=1;
                }
                if ($fangyuan['fpdz'] == 1) {
                    $this->kdz=1;
                }
                if ($fangyuan['fpdj'] == 1) {
                    $this->kdj=1;
                }
                if ($fangyuan['fpdq'] == 1) {
                    $this->kdq=1;
                }
                if ($fangyuan['fpck'] == 1) {
                    $this->kck=1;
                }
                $this->fyid=I('fyid');
                $this->display();
            }
        }
        //封盘审核列表
        public function fpsh(){
            if (I('is_ajax')) {
                /*权限控制开始*/
                $condition = "e.gongsiid=".session('gongsiid')." and zylx=1 and czlx=1";
                $x = _rbac_lists_where(844,0);
                if ($x && $x != "all" && $x != "me") {
                    $condition .= " and e.bumen in ({$x})";
                } elseif ($x == "me") {
                    $condition .= " and e.id=".session('uid');
                } elseif ($x == false) {
                    $condition .= " and e.id=0";
                }
                /*权限控制结束*/
                $type = I('type',0,'int');
                $fplx = I('fplx',0,'int');
                $sousuo = I('sousuo');
                $shijian = I('shijian');
                if ($type) {
                    $condition .= " and a.type=".$type;
                }
                if ($fplx) {
                    $condition .= " and a.fkplx=".$fplx;
                }
                if ($sousuo) {
                    $condition .= " and (a.zybh like '%$sousuo%' or e.ygmingcheng like '%$sousuo%' or e.pinyinjs like '%$sousuo%' or e.dianhua like '%$sousuo%')";
                }
                if ($shijian) {
                    $time_s = explode(' - ',$shijian);
                    $time_s1 = strtotime($time_s[0]);
                    $time_s2 = strtotime($time_s[1])+86400;
                    $condition .= " and a.addtime>=".$time_s1." and a.addtime<".$time_s2;
                }
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                if ($field && $order) {
                    $fppx = "a.".$field." ".$order;
                } else {
                    $fppx = "a.id desc";
                }
                $count = M('fpkp')->alias('a')->join('jjrxt_yonghu e on a.uid=e.id')->where($condition)->count();
                $Page = I('p');
                $data = M('fpkp')->alias('a')->join('jjrxt_yonghu e on a.uid=e.id')->field('a.*,e.ygmingcheng,e.dianhua,e.bumen')->where($condition)->order($fppx)->page($Page,$limit)->select();
                foreach ($data as $key => $value) {
                    $data[$key]['fprxx'] = $value['ygmingcheng']."/".zym($value['bumen'],6)."（".$value['dianhua']."）";
                    $data[$key]['tjrxx'] = zym($value['adduid'],5)."（".zym($value['adduid'],14)."）";
                    $data[$key]['addtime'] = $value['addtime'] ? date('Y-m-d H:i:s',$value['addtime']) : "——";
                    $data[$key]['endunix'] = $value['endunix'] ? date('Y-m-d',$value['endunix']) : "——";
                    switch ($value['type']) {
                        case '1':
                            $shzt = "已通过";
                            break;
                        case '2':
                            $shzt = "已驳回";
                            break;
                        case '3':
                            $shzt = "待审核";
                            break;
                        default:
                            break;
                    }
                    switch ($value['fkplx']) {
                        case '1':
                            $fpcz = "封电话";
                            break;
                        case '2':
                            $fpcz = "封地址";
                            break;
                        case '3':
                            $fpcz = "封底价";
                            break;
                        case '4':
                            $fpcz = "封调取";
                            break;
                        case '5':
                            $fpcz = "封查看";
                            break;
                        default:
                            break;
                    }
                    $data[$key]['shzt'] = $shzt ? $shzt : "——";
                    $data[$key]['fpcz'] = $fpcz ? $fpcz : "——";
                    $data[$key]['fyxqlj'] = U('fangyuan/neirong',array('id'=>$value['zyid']));
                    $fyxq = "";
                    $is_rbacfy = "";
                    $is_rbacsh = "";
                    $is_rbacrz = "";
                    $fyxq = M('fangyuan')->where(array('id'=>$value['zyid']))->field('zhuangtai,weihurenid')->find();
                    if ($fyxq) {
                        $is_rbacfy = _rbac_btn_show(46,$fyxq['zhuangtai'],$fyxq['weihurenid']);
                    }
                    if ($value['type'] == 3) {
                        if ($fyxq) {
                            $is_rbacsh = _rbac_btn_show(845,$fyxq['zhuangtai'],$value['uid']);
                        }
                    } else {
                        $is_rbacrz = _rbac_btn_show(846,0,$value['uid']);
                    }
                    $data[$key]['rbacfy'] = $is_rbacfy ? 1 : 0;
                    $data[$key]['rbacsh'] = $is_rbacsh ? 1 : 0;
                    $data[$key]['rbacrz'] = $is_rbacrz ? 1 : 0;
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count,
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $this->display();
            }
        }
        //封盘审核
        public function fpshenhe(){
            $id=I('id');
            $fpkp=M('fpkp')->where(array('id'=>$id,'zylx'=>1,'czlx'=>1))->field('uid,zyid,type,fkplx')->find();
            $fyzt=M('fangyuan')->where(array('id'=>$fpkp['zyid']))->getField('zhuangtai');
            $is_rbac = _rbac_btn_show(845,$fyzt,$fpkp['uid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $this->error('请联系客服（19965783436）获取正式版功能！');
            }else{
                $this->display();
            }
        }
        //封盘日志
        public function fprizhi(){
            $rzlx = I('rzlx');
            if ($rzlx != 1 && $rzlx != 2) {
                $rzlx == 1;
            }
            switch ($rzlx) {
                case '1':
                    if (I('is_ajax')) {
                        /*权限控制开始*/
                        $condition = "e.gongsiid=".session('gongsiid')." and zylx=1 and czlx=1";
                        $x = _rbac_lists_where(846,0);
                        if ($x && $x != "all" && $x != "me") {
                            $condition .= " and e.bumen in ({$x})";
                        } elseif ($x == "me") {
                            $condition .= " and e.id=".session('uid');
                        } elseif ($x == false) {
                            $condition .= " and e.id=0";
                        }
                        /*权限控制结束*/
                        $type=I('type');
                        $fplx=I('fplx');
                        $sousuo = I('sousuo');
                        $shijian = I('shijian');
                        if ($type) {
                            $condition.=" and a.type=".$type;
                        }
                        if ($fplx) {
                            $condition.=" and a.fkplx=".$fplx;
                        }
                        if ($sousuo) {
                            $condition .= " and (a.zybh like '%$sousuo%' or e.ygmingcheng like '%$sousuo%' or e.pinyinjs like '%$sousuo%' or e.dianhua like '%$sousuo%')";
                        }
                        if ($shijian) {
                            $time_s = explode(' - ',$shijian);
                            $time_s1 = strtotime($time_s[0]);
                            $time_s2 = strtotime($time_s[1])+86400;
                            $condition .= " and a.addtime>=".$time_s1." and a.addtime<".$time_s2;
                        }
                        $field = I('field'); //排序字段名
                        $order = I('order'); //排序方式
                        $limit = I('limit',30,'int'); //每页条数
                        $limit = $limit > 150 ? 150 : $limit;
                        if ($field && $order) {
                            $rzpx = "a.".$field." ".$order;
                        } else {
                            $rzpx = "a.id desc";
                        }
                        $count = M('fpkp')->alias('a')->join('jjrxt_yonghu e on a.uid=e.id')->where($condition)->count();
                        $Page = I('p');
                        $data = M('fpkp')->alias('a')->join('jjrxt_yonghu e on a.uid=e.id')->field('a.*,e.ygmingcheng,e.dianhua,e.bumen')->where($condition)->order($rzpx)->page($Page,$limit)->select();
                        foreach ($data as $key => $value) {
                            $data[$key]['fprxx'] = $value['ygmingcheng']."/".zym($value['bumen'],6)."（".$value['dianhua']."）";
                            $data[$key]['tjrxx'] = zym($value['adduid'],5)."（".zym($value['adduid'],14)."）";
                            $data[$key]['shrxx'] = $value['shuid'] ? zym($value['shuid'],5)."（".zym($value['shuid'],14)."）" : "——";
                            $data[$key]['remark'] = $value['remark'] ? $value['remark'] : "——";
                            $data[$key]['addtime'] = $value['addtime'] ? date('Y-m-d H:i:s',$value['addtime']) : "——";
                            $data[$key]['endunix'] = $value['endunix'] ? date('Y-m-d',$value['endunix']) : "——";
                            $data[$key]['shshijian'] = $value['shshijian'] ? date('Y-m-d',$value['shshijian']) : "——";
                            switch ($value['type']) {
                                case '1':
                                    $shzt = "已通过";
                                    break;
                                case '2':
                                    $shzt = "已驳回";
                                    break;
                                case '3':
                                    $shzt = "待审核";
                                    break;
                                default:
                                    break;
                            }
                            switch ($value['fkplx']) {
                                case '1':
                                    $fpcz = "封电话";
                                    break;
                                case '2':
                                    $fpcz = "封地址";
                                    break;
                                case '3':
                                    $fpcz = "封底价";
                                    break;
                                case '4':
                                    $fpcz = "封调取";
                                    break;
                                case '5':
                                    $fpcz = "封查看";
                                    break;
                                default:
                                    break;
                            }
                            $data[$key]['shzt'] = $shzt ? $shzt : "——";
                            $data[$key]['fpcz'] = $fpcz ? $fpcz : "——";
                            $data[$key]['fyxqlj'] = U('fangyuan/neirong',array('id'=>$value['zyid']));
                            $fyxq = "";
                            $is_rbacfy = "";
                            $fyxq = M('fangyuan')->where(array('id'=>$value['zyid']))->field('zhuangtai,weihurenid')->find();
                            if ($fyxq) {
                                $is_rbacfy = _rbac_btn_show(46,$fyxq['zhuangtai'],$fyxq['weihurenid']);
                            }
                            $data[$key]['rbacfy'] = $is_rbacfy ? 1 : 0;
                        }
                        $return_data = array(
                            'code'=>0,
                            'count'=>$count,
                            'data'=>$data
                        );
                        $this->ajaxReturn($return_data);
                    } else {
                        $this->rzlx = 1;
                        $this->display();
                    }
                    break;
                case '2':
                    $fyfp=M('fpkp')->where(array('id'=>I('id'),'zylx'=>1,'czlx'=>1))->field('shuid,shshijian,remark,type')->find();
                    $shren = M('yonghu')->where(array('id'=>$fyfp['shuid']))->field('ygmingcheng,dianhua')->find();
                    switch ($fyfp['type']) {
                        case '1':
                            $shzt = "已通过";
                            break;
                        case '2':
                            $shzt = "已驳回";
                            break;
                        case '3':
                            $shzt = "待审核";
                            break;
                        default:
                            $shzt = "——";
                            break;
                    }
                    $this->shren = $shren ? $shren['ygmingcheng']."（".$shren['dianhua']."）" : "——";
                    $this->shsj = $fyfp['shshijian'] ? date('Y-m-d',$fyfp['shshijian']) : "——";
                    $this->remark = $fyfp['remark'] ? $fyfp['remark'] : "——";
                    $this->shzt = $shzt;
                    $this->rzlx = 2;
                    $this->display();
                    break;
            }
        }
        //开盘审核列表
        public function kpsh(){
            if (I('is_ajax')) {
                /*权限控制开始*/
                $condition = "e.gongsiid=".session('gongsiid')." and zylx=1 and czlx=2";
                $x = _rbac_lists_where(847,0);
                if ($x && $x != "all" && $x != "me") {
                    $condition .= " and e.bumen in ({$x})";
                } elseif ($x == "me") {
                    $condition .= " and e.id=".session('uid');
                } elseif ($x == false) {
                    $condition .= " and e.id=0";
                }
                /*权限控制结束*/
                $type = I('type',0,'int');
                $kplx = I('kplx',0,'int');
                $sousuo = I('sousuo');
                $shijian = I('shijian');
                if ($type) {
                    $condition .= " and a.type=".$type;
                }
                if ($kplx) {
                    $condition .= " and a.fkplx=".$kplx;
                }
                if ($sousuo) {
                    $condition .= " and (a.zybh like '%$sousuo%' or e.ygmingcheng like '%$sousuo%' or e.pinyinjs like '%$sousuo%' or e.dianhua like '%$sousuo%')";
                }
                if ($shijian) {
                    $time_s = explode(' - ',$shijian);
                    $time_s1 = strtotime($time_s[0]);
                    $time_s2 = strtotime($time_s[1])+86400;
                    $condition .= " and a.addtime>=".$time_s1." and a.addtime<".$time_s2;
                }
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                if ($field && $order) {
                    $kppx = "a.".$field." ".$order;
                } else {
                    $kppx = "a.id desc";
                }
                $count = M('fpkp')->alias('a')->join('jjrxt_yonghu e on a.uid=e.id')->where($condition)->count();
                $Page = I('p');
                $data = M('fpkp')->alias('a')->join('jjrxt_yonghu e on a.uid=e.id')->field('a.*,e.ygmingcheng,e.dianhua,e.bumen')->where($condition)->order($kppx)->page($Page,$limit)->select();
                foreach ($data as $key => $value) {
                    $data[$key]['kprxx'] = $value['ygmingcheng']."/".zym($value['bumen'],6)."（".$value['dianhua']."）";
                    $data[$key]['tjrxx'] = zym($value['adduid'],5)."（".zym($value['adduid'],14)."）";
                    $data[$key]['addtime'] = $value['addtime'] ? date('Y-m-d H:i:s',$value['addtime']) : "——";
                    switch ($value['type']) {
                        case '1':
                            $shzt = "已通过";
                            break;
                        case '2':
                            $shzt = "已驳回";
                            break;
                        case '3':
                            $shzt = "待审核";
                            break;
                        default:
                            break;
                    }
                    switch ($value['fkplx']) {
                        case '1':
                            $kpcz = "开电话";
                            break;
                        case '2':
                            $kpcz = "开地址";
                            break;
                        case '3':
                            $kpcz = "开底价";
                            break;
                        case '4':
                            $kpcz = "开调取";
                            break;
                        case '5':
                            $kpcz = "开查看";
                            break;
                        default:
                            break;
                    }
                    $data[$key]['shzt'] = $shzt ? $shzt : "——";
                    $data[$key]['kpcz'] = $kpcz ? $kpcz : "——";
                    $data[$key]['fyxqlj'] = U('fangyuan/neirong',array('id'=>$value['zyid']));
                    $fyxq = "";
                    $is_rbacfy = "";
                    $is_rbacsh = "";
                    $is_rbacrz = "";
                    $fyxq = M('fangyuan')->where(array('id'=>$value['zyid']))->field('zhuangtai,weihurenid')->find();
                    if ($fyxq) {
                        $is_rbacfy = _rbac_btn_show(46,$fyxq['zhuangtai'],$fyxq['weihurenid']);
                    }
                    if ($value['type'] == 3) {
                        if ($fyxq) {
                            $is_rbacsh = _rbac_btn_show(848,$fyxq['zhuangtai'],$value['uid']);
                        }
                    } else {
                        $is_rbacrz = _rbac_btn_show(849,0,$value['uid']);
                    }
                    $data[$key]['rbacfy'] = $is_rbacfy ? 1 : 0;
                    $data[$key]['rbacsh'] = $is_rbacsh ? 1 : 0;
                    $data[$key]['rbacrz'] = $is_rbacrz ? 1 : 0;
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count,
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $this->display();
            }
        }
        //开盘审核
        public function kpshenhe(){
            $id=I('id');
            $fpkp=M('fpkp')->where(array('id'=>$id,'zylx'=>1,'czlx'=>2))->field('uid,zyid,type,fkplx')->find();
            $fyzt=M('fangyuan')->where(array('id'=>$fpkp['zyid']))->getField('zhuangtai');
            $is_rbac = _rbac_btn_show(848,$fyzt,$fpkp['uid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $this->error('请联系客服（19965783436）获取正式版功能！');
            }else{
                $this->display();
            }
        }
        //开盘日志
        public function kprizhi(){
            $rzlx = I('rzlx');
            if ($rzlx != 1 && $rzlx != 2) {
                $rzlx == 1;
            }
            switch ($rzlx) {
                case '1':
                    if (I('is_ajax')) {
                        /*权限控制开始*/
                        $condition = "e.gongsiid=".session('gongsiid')." and zylx=1 and czlx=2";
                        $x = _rbac_lists_where(849,0);
                        if ($x && $x != "all" && $x != "me") {
                            $condition .= " and e.bumen in ({$x})";
                        } elseif ($x == "me") {
                            $condition .= " and e.id=".session('uid');
                        } elseif ($x == false) {
                            $condition .= " and e.id=0";
                        }
                        /*权限控制结束*/
                        $type=I('type');
                        $kplx=I('kplx');
                        $sousuo = I('sousuo');
                        $shijian = I('shijian');
                        if ($type) {
                            $condition.=" and a.type=".$type;
                        }
                        if ($kplx) {
                            $condition.=" and a.fkplx=".$kplx;
                        }
                        if ($sousuo) {
                            $condition .= " and (a.zybh like '%$sousuo%' or e.ygmingcheng like '%$sousuo%' or e.pinyinjs like '%$sousuo%' or e.dianhua like '%$sousuo%')";
                        }
                        if ($shijian) {
                            $time_s = explode(' - ',$shijian);
                            $time_s1 = strtotime($time_s[0]);
                            $time_s2 = strtotime($time_s[1])+86400;
                            $condition .= " and a.addtime>=".$time_s1." and a.addtime<".$time_s2;
                        }
                        $field = I('field'); //排序字段名
                        $order = I('order'); //排序方式
                        $limit = I('limit',30,'int'); //每页条数
                        $limit = $limit > 150 ? 150 : $limit;
                        if ($field && $order) {
                            $rzpx = "a.".$field." ".$order;
                        } else {
                            $rzpx = "a.id desc";
                        }
                        $count = M('fpkp')->alias('a')->join('jjrxt_yonghu e on a.uid=e.id')->where($condition)->count();
                        $Page = I('p');
                        $data = M('fpkp')->alias('a')->join('jjrxt_yonghu e on a.uid=e.id')->field('a.*,e.ygmingcheng,e.dianhua,e.bumen')->where($condition)->order($rzpx)->page($Page,$limit)->select();
                        foreach ($data as $key => $value) {
                            $data[$key]['kprxx'] = $value['ygmingcheng']."/".zym($value['bumen'],6)."（".$value['dianhua']."）";
                            $data[$key]['tjrxx'] = zym($value['adduid'],5)."（".zym($value['adduid'],14)."）";
                            $data[$key]['shrxx'] = $value['shuid'] ? zym($value['shuid'],5)."（".zym($value['shuid'],14)."）" : "——";
                            $data[$key]['remark'] = $value['remark'] ? $value['remark'] : "——";
                            $data[$key]['addtime'] = $value['addtime'] ? date('Y-m-d H:i:s',$value['addtime']) : "——";
                            $data[$key]['shshijian'] = $value['shshijian'] ? date('Y-m-d',$value['shshijian']) : "——";
                            switch ($value['type']) {
                                case '1':
                                    $shzt = "已通过";
                                    break;
                                case '2':
                                    $shzt = "已驳回";
                                    break;
                                case '3':
                                    $shzt = "待审核";
                                    break;
                                default:
                                    break;
                            }
                            switch ($value['fkplx']) {
                                case '1':
                                    $kpcz = "开电话";
                                    break;
                                case '2':
                                    $kpcz = "开地址";
                                    break;
                                case '3':
                                    $kpcz = "开底价";
                                    break;
                                case '4':
                                    $kpcz = "开调取";
                                    break;
                                case '5':
                                    $kpcz = "开查看";
                                    break;
                                default:
                                    break;
                            }
                            $data[$key]['shzt'] = $shzt ? $shzt : "——";
                            $data[$key]['kpcz'] = $kpcz ? $kpcz : "——";
                            $data[$key]['fyxqlj'] = U('fangyuan/neirong',array('id'=>$value['zyid']));
                            $fyxq = "";
                            $is_rbacfy = "";
                            $fyxq = M('fangyuan')->where(array('id'=>$value['zyid']))->field('zhuangtai,weihurenid')->find();
                            if ($fyxq) {
                                $is_rbacfy = _rbac_btn_show(46,$fyxq['zhuangtai'],$fyxq['weihurenid']);
                            }
                            $data[$key]['rbacfy'] = $is_rbacfy ? 1 : 0;
                        }
                        $return_data = array(
                            'code'=>0,
                            'count'=>$count,
                            'data'=>$data
                        );
                        $this->ajaxReturn($return_data);
                    } else {
                        $this->rzlx = 1;
                        $this->display();
                    }
                    break;
                case '2':
                    $fykp=M('fpkp')->where(array('id'=>I('id'),'zylx'=>1,'czlx'=>2))->field('shuid,shshijian,remark,type')->find();
                    $shren = M('yonghu')->where(array('id'=>$fykp['shuid']))->field('ygmingcheng,dianhua')->find();
                    switch ($fykp['type']) {
                        case '1':
                            $shzt = "已通过";
                            break;
                        case '2':
                            $shzt = "已驳回";
                            break;
                        case '3':
                            $shzt = "待审核";
                            break;
                        default:
                            $shzt = "——";
                            break;
                    }
                    $this->shren = $shren ? $shren['ygmingcheng']."（".$shren['dianhua']."）" : "——";
                    $this->shsj = $fykp['shshijian'] ? date('Y-m-d',$fykp['shshijian']) : "——";
                    $this->remark = $fykp['remark'] ? $fykp['remark'] : "——";
                    $this->shzt = $shzt;
                    $this->rzlx = 2;
                    $this->display();
                    break;
            }
        }
        //更新房源
        public function xiugai(){
            $id = I('id',0,'int');
            $fy1 = M('fangyuan')->where(array('id'=>$id))->field('yezhu,yezhulx,yezhugx,yezhugx2,yezhugx3,yezhudianhua,yezhudianhua2,yezhudianhua3,zuodong,danyuan,fanghao',TRUE)->find();
            $is_rbac = _rbac_btn_show(56,$fy1['zhuangtai'],$fy1['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $is_rbacfdj = _rbac_node_show(861);
            if ($is_rbacfdj || ($fy1['fpdj'] == 2)) {
                $is_rbacfdj = 1;
                $this->is_rbacfdj = 1;
            }
            if (IS_POST) {
                if (I('yongtu')) {
                    $yongtu = I('yongtu',0,'int');
                } else {
                    $this->error('请选择用途！');
                }
                switch ($fy1['leixing']) {
                    case 1:
                        if ($is_rbacfdj == 1) {
                            $chushoudj = I('chushoudj',0,'float');
                            if (!preg_match("/^([1-9][0-9]{0,4})(\.[0-9]{1,6})?$|^([0]\.[1-9][0-9]{0,5})$|^([0]\.[0][0-9]{0,4}[1-9]{1})$|^([0]\.[0]{2}[0-9]{0,3}[1-9]{1})$|^([0]\.[0]{3}[0-9]{0,2}[1-9]{1})$|^([0]\.[0]{4}[0-9]{0,1}[1-9]{1})$|^([0]\.[0]{5}[1-9]{1})$|^(1[0]{5})(\.[0][0]{0,5})?$/",$chushoudj)) {
                                $this->error('出售底价请输入＞0且≤十亿的数字（限六位小数）！');
                            }
                        }
                        $shoujia = I('shoujia',0,'float');
                        if (!preg_match("/^([1-9][0-9]{0,4})(\.[0-9]{1,6})?$|^([0]\.[1-9][0-9]{0,5})$|^([0]\.[0][0-9]{0,4}[1-9]{1})$|^([0]\.[0]{2}[0-9]{0,3}[1-9]{1})$|^([0]\.[0]{3}[0-9]{0,2}[1-9]{1})$|^([0]\.[0]{4}[0-9]{0,1}[1-9]{1})$|^([0]\.[0]{5}[1-9]{1})$|^(1[0]{5})(\.[0][0]{0,5})?$/",$shoujia)) {
                            $this->error('售价请输入＞0且≤十亿的数字（限六位小数）！');
                        }
                        break;
                    case 2:
                        if ($is_rbacfdj == 1) {
                            $chuzudj = I('chuzudj',0,'float');
                            if (!preg_match("/^([1-9][0-9]{0,4})(\.[0-9]{1,2})?$|^([0]\.[1-9][0-9]{0,1})$|^([0]\.[0][1-9]{1})$|^(1[0]{5})(\.[0][0]{0,1})?$/",$chuzudj)) {
                                $this->error('出租底价请输入＞0且≤十万的数字（限两位小数）！');
                            }
                        }
                        $zujia = I('zujia',0,'float');
                        if (!preg_match("/^([1-9][0-9]{0,4})(\.[0-9]{1,2})?$|^([0]\.[1-9][0-9]{0,1})$|^([0]\.[0][1-9]{1})$|^(1[0]{5})(\.[0][0]{0,1})?$/",$zujia)) {
                            $this->error('租价请输入＞0且≤十万的数字（限两位小数）！');
                        }
                        $zujialx = I('zujialx',0,'int');
                        break;
                    default:
                        $this->error('类型异常！');
                        break;
                }
                if (I('shi')) {
                    $shi = I('shi',0,'int');
                } else {
                    $this->error('请输入卧室数！');
                }
                if (!preg_match("/^([1-9]{1})$|^(1[0]{1})$/",$shi)) {
                    $this->error('户型-室请输入＞0≤10的整数！');
                }
                if (I('ting')) {
                    $ting = I('ting',0,'int');
                } else {
                    $this->error('请输入客厅数！');
                }
                if (!preg_match("/^([1-9]{1})$|^(1[0]{1})$/",$ting)) {
                    $this->error('户型-厅请输入＞0≤10的整数！');
                }
                if (I('wei')) {
                    $wei = I('wei',0,'int');
                }
                if (!preg_match("/^$|^([0]{1})$|^([1-9]{1})$|^(1[0]{1})$/",$wei)) {
                    $this->error('户型-卫请输入＞0≤10的整数！');
                }
                if (I('chu')) {
                    $chu = I('chu',0,'int');
                }
                if (!preg_match("/^$|^([0]{1})$|^([1-9]{1})$|^(1[0]{1})$/",$chu)) {
                    $this->error('户型-厨请输入＞0≤10的整数！');
                }
                if (I('yangtai')) {
                    $yangtai = I('yangtai',0,'int');
                }
                if (!preg_match("/^$|^([0]{1})$|^([1-9]{1})$|^(1[0]{1})$/",$yangtai)) {
                    $this->error('户型-阳台请输入＞0≤10的整数！');
                }
                if (I('mianji')) {
                    $mianji = I('mianji',0,'float');
                } else {
                    $this->error('请输入建筑面积！');
                }
                if (!preg_match("/^([1-9][0-9]{0,3})(\.[0-9]{1,2})?$|^([0]\.[1-9][0-9]{0,1})$|^([0]\.[0][1-9]{1})$|^(1[0]{4})(\.[0][0]{0,1})?$/",$mianji)) {
                    $this->error('建筑面积请输入＞0且≤一万的数字（限两位小数）！');
                }
                if ($fy1['leixing'] == 1) {
                    if ($shoujia && $mianji) {
                        $num1 = $shoujia*10000;
                        $num2 = $mianji;
                        $num = $num1/$num2;
                        $danjia = number_format($num,2,".","");
                    }
                }
                if (I('symianji')) {
                    $symianji = I('symianji',0,'float');
                }
                if (!preg_match("/^$|^([0]{1})$|^([1-9][0-9]{0,3})(\.[0-9]{1,2})?$|^([0]\.[1-9][0-9]{0,1})$|^([0]\.[0][1-9]{1})$|^(1[0]{4})(\.[0][0]{0,1})?$/",$symianji)) {
                    $this->error('使用面积请输入＞0且≤一万的数字（限两位小数）！');
                }
                if (I('laiyuan')) {
                    $laiyuan = I('laiyuan',0,'int');
                } else {
                    $this->error('请选择来源！');
                }
                if (I('zhuangxiu')) {
                    $zhuangxiu = I('zhuangxiu',0,'int');
                } else {
                    $this->error('请选择装修！');
                }
                if (I('louceng')) {
                    $louceng = I('louceng');
                } else {
                    $this->error('请输入楼层！');
                }
                if (!preg_match("/^[a-zA-Z1-9][0-9]{0,6}$/",$louceng)) {
                    $this->error('楼层首字符可以是非零整数或字母，除首字符外必须为非负整数（限六位整数）！');
                }
                if (I('zlouceng')) {
                    $zlouceng = I('zlouceng',0,'int');
                } else {
                    $this->error('请输入总楼层！');
                }
                if (!preg_match("/^([1-9]{1})$|^([1-9][0-9]{1})$|^(1[0-9]{2})$|^(2[0]{2})$/",$zlouceng)) {
                    $this->error('总楼层请输入＞0≤200的整数！');
                }
                if (I('chaoxiang')) {
                    $chaoxiang = I('chaoxiang',0,'int');
                } else {
                    $this->error('请选择朝向！');
                }
                if (I('xianzhuang')) {
                    $xianzhuang = I('xianzhuang',0,'int');
                } else {
                    $this->error('请选择现状！');
                }
                if (I('fwleixing')){
                    $fwleixing = I('fwleixing',0,'int');
                } else {
                    $this->error('请选择房屋类型！');
                }
                $jiegou = I('jiegou',0,'int');
                if ($fy1['leixing'] == 1) {
                    if (I('chanquanzheng')) {
                        $chanquanzheng = I('chanquanzheng',0,'int');
                    } else {
                        $this->error('请选择产权证！');
                    }
                    if (I('kanfangfs')) {
                        $kanfangfs = I('kanfangfs',0,'int');
                    } else {
                        $this->error('请选择看房方式！');
                    }
                    if (I('budongchanzheng')) {
                        $budongchanzheng = I('budongchanzheng',0,'int');
                    } else {
                        $this->error('请选择不动产证！');
                    }
                    $tudizheng = I('tudizheng',0,'int');
                }
                $pt1 = array_keys(I('peitao'));
                $pt2 = implode(',',$pt1);
                $fukuanfs = I('fukuanfs',0,'int');
                $fydengji = I('fydengji',0,'int');
                if (I('wushui')) {
                    $wushui = 1;
                    $geshui = 0;
                    $zengshui = 0;
                } else {
                    $wushui = 0;
                    if (I('geshui')) {
                        $geshui = 1;
                    } else {
                        $geshui = 0;
                    }
                    if (I('zengshui')) {
                        $zengshui = 1;
                    } else {
                        $zengshui = 0;
                    }
                }
                if (I('waiwangtb')) {
                    $waiwangtb = 1;
                } else {
                    $waiwangtb = 0;
                }
                $ti = I('ti',0,'int');
                if (!preg_match("/^$|^([0]{1})$|^([1-9][0-9]{0,1})$|^(1[0]{2})$/",$ti)) {
                    $this->error('梯户请输入＞0≤100的整数！');
                }
                $hu = I('hu',0,'int');
                if (!preg_match("/^$|^([0]{1})$|^([1-9][0-9]{0,1})$|^(1[0]{2})$/",$hu)) {
                    $this->error('梯户请输入＞0≤100的整数！');
                }
                $niandai = I('niandai',0,'int');
                if ($fy1['leixing'] == 1) {
                    $czriqi = strtotime(I('czriqi'));
                    if (I('man5')) {
                        $man5 = 1;
                    } else {
                        $man5 = 0;
                    }
                    if (I('man2')) {
                        $man2 = 1;
                    } else {
                        $man2 = 0;
                    }
                    if (I('weiyi')) {
                        $weiyi = 1;
                    } else {
                        $weiyi = 0;
                    }
                    if (I('jishou')) {
                        $jishou = 1;
                    } else {
                        $jishou = 0;
                    }
                    $cqxingzhi = I('cqxingzhi',0,'int');
                    $cqnianxian = I('cqnianxian',0,'int');
                    if (!preg_match("/^$|^([0]{1})$|^([1-9][0-9]{0,2})$|^(1[0]{3})$/",$cqnianxian)) {
                        $this->error('产权年限请输入＞0≤1000的整数！');
                    }
                    if (I('heyan')) {
                        $heyan = 1;
                    } else {
                        $heyan = 0;
                    }
                    if (I('quankuan')) {
                        $quankuan = 1;
                    } else {
                        $quankuan = 0;
                    }
                    if (I('youdaikuan')) {
                        $youdaikuan = 1;
                    } else {
                        $youdaikuan = 0;
                    }
                    if (I('xinzheng')) {
                        $xinzheng = 1;
                    } else {
                        $xinzheng = 0;
                    }
                }
                $beizhu = preg_replace("/\s(?=\s)/","\\1",I('beizhu'));
                if (!preg_match("/^$|^[\s\S]{0,300}$/",$beizhu)) {
                    $this->error('备注只能输入300个字符！');
                }
                $data['yongtu'] = $yongtu;
                switch ($fy1['leixing']) {
                    case 1:
                        $data['shoujia'] = $shoujia;
                        if ($is_rbacfdj == 1) {
                            $data['chushoudj'] = $chushoudj;
                        }
                        $data['danjia'] = $danjia;
                        break;
                    case 2:
                        $data['zujia'] = $zujia;
                        if ($is_rbacfdj == 1) {
                            $data['chuzudj'] = $chuzudj;
                        }
                        $data['zujialx'] = $zujialx;
                        break;
                }
                $data['shi'] = $shi;
                $data['ting'] = $ting;
                $data['wei'] = $wei;
                $data['chu'] = $chu;
                $data['yangtai'] = $yangtai;
                $data['mianji'] = $mianji;
                $data['symianji'] = $symianji;
                $data['laiyuan'] = $laiyuan;
                $data['zhuangxiu'] = $zhuangxiu;
                $data['louceng'] = $louceng;
                $data['zlouceng'] = $zlouceng;
                $data['chaoxiang'] = $chaoxiang;
                $data['xianzhuang'] = $xianzhuang;
                $data['fwleixing'] = $fwleixing;
                $data['jiegou'] = $jiegou;
                if ($fy1['leixing'] == 1) {
                    $data['chanquanzheng'] = $chanquanzheng;
                    $data['kanfangfs'] = $kanfangfs;
                    $data['budongchanzheng'] = $budongchanzheng;
                    $data['tudizheng'] = $tudizheng;
                }
                $data['peitao'] = $pt2;
                $data['fukuanfs'] = $fukuanfs;
                $data['fydengji'] = $fydengji;
                $data['wushui'] = $wushui;
                $data['geshui'] = $geshui;
                $data['zengshui'] = $zengshui;
                $data['fybiaoti'] = I('fybiaoti');
                $data['waiwangtb'] = $waiwangtb;
                $data['ti'] = $ti;
                $data['hu'] = $hu;
                $data['niandai'] = $niandai;
                if ($fy1['leixing'] == 1) {
                    $data['czriqi'] = $czriqi;
                    $data['man5'] = $man5;
                    $data['man2'] = $man2;
                    $data['weiyi'] = $weiyi;
                    $data['jishou'] = $jishou;
                    $data['cqxingzhi'] = $cqxingzhi;
                    $data['cqnianxian'] = $cqnianxian;
                    $data['heyan'] = $heyan;
                    $data['quankuan'] = $quankuan;
                    $data['youdaikuan'] = $youdaikuan;
                    $data['xinzheng'] = $xinzheng;
                }
                $data['beizhu'] = $beizhu;
                $data['xiugaisj'] = time();
                $xiugai = "";
                if ($fy1['yongtu'] != $yongtu && ($fy1['yongtu'] == true || $yongtu == true)) {
                    $xiugai .= get_xiugai($fy1['yongtu'],$yongtu,'yongtu');
                }
                switch ($fy1['leixing']) {
                    case 1:
                        if ($is_rbacfdj == 1 && $fy1['chushoudj'] != $chushoudj && ($fy1['chushoudj'] == true || $chushoudj == true)) {
                            $xiugai .= "出售底价：[".floatval($fy1['chushoudj'])."万元]=>[".floatval($chushoudj)."万元]；";
                        }
                        if ($fy1['shoujia'] != $shoujia && ($fy1['shoujia'] == true || $shoujia == true)) {
                            $xiugai .= "售价：[".floatval($fy1['shoujia'])."万元]=>[".floatval($shoujia)."万元]；";
                        }
                        if ($fy1['danjia'] != $danjia && ($fy1['danjia'] == true || $danjia == true)) {
                            $xiugai .= "单价：[".floatval($fy1['danjia'])."元/m²]=>[".floatval($danjia)."元/m²]；";
                        }
                        break;
                    case 2:
                        if ($fy1['zujialx'] != $zujialx && ($fy1['zujialx'] == true || $zujialx == true)) {
                            $zjlxbd = 1;
                            $zjlxbdq = get_peizhi('zujialx',$fy1['zujialx'],3);
                            $zjlxbdh = get_peizhi('zujialx',$zujialx,3);
                        }
                        if ($is_rbacfdj == 1 && (($fy1['chuzudj'] != $chuzudj && ($fy1['chuzudj'] == true || $chuzudj == true)) || $zjlxbd == 1)) {
                            $xiugai .= "出租底价：[".floatval($fy1['chuzudj']).$zjlxbdq."]=>[".floatval($chuzudj).$zjlxbdh."]；";
                        }
                        if (($fy1['zujia'] != $zujia && ($fy1['zujia'] == true || $zujia == true)) || $zjlxbd == 1) {
                            $xiugai .= "租价：[".floatval($fy1['zujia']).$zjlxbdq."]=>[".floatval($zujia).$zjlxbdh."]；";
                        }
                        break;
                }
                if ($fy1['shi'] != $shi && ($fy1['shi'] == true || $shi == true)) {
                    $xiugai .= "室：[".$fy1['shi']."室]=>[".$shi."室]；";
                }
                if ($fy1['ting'] != $ting && ($fy1['ting'] == true || $ting == true)) {
                    $xiugai .= "厅：[".$fy1['ting']."厅]=>[".$ting."厅]；";
                }
                if ($fy1['wei'] != $wei && ($fy1['wei'] == true || $wei == true)) {
                    $xiugai .= "卫：[".$fy1['wei']."卫]=>[".$wei."卫]；";
                }
                if ($fy1['chu'] != $chu && ($fy1['chu'] == true || $chu == true)) {
                    $xiugai .= "厨：[".$fy1['chu']."厨]=>[".$chu."厨]；";
                }
                if ($fy1['yangtai'] != $yangtai && ($fy1['yangtai'] == true || $yangtai == true)) {
                    $xiugai .= "阳台：[".$fy1['yangtai']."阳台]=>[".$yangtai."阳台]；";
                }
                if ($fy1['mianji'] != $mianji && ($fy1['mianji'] == true || $mianji == true)) {
                    $xiugai .= "面积：[".floatval($fy1['mianji'])."m²]=>[".floatval($mianji)."m²]；";
                }
                if ($fy1['symianji'] != $symianji && ($fy1['symianji'] == true || $symianji == true)) {
                    $xiugai .= "使用面积：[".floatval($fy1['symianji'])."m²]=>[".floatval($symianji)."m²]；";
                }
                if ($fy1['laiyuan'] != $laiyuan && ($fy1['laiyuan'] == true || $laiyuan == true)) {
                    $xiugai .= get_xiugai($fy1['laiyuan'],$laiyuan,'laiyuan');
                }
                if ($fy1['zhuangxiu'] != $zhuangxiu && ($fy1['zhuangxiu'] == true || $zhuangxiu == true)) {
                    $xiugai .= get_xiugai($fy1['zhuangxiu'],$zhuangxiu,'zhuangxiu');
                }
                if ($fy1['louceng'] != $louceng && ($fy1['louceng'] == true || $louceng == true)) {
                    $xiugai .= "楼层：[".$fy1['louceng']."层]=>[".$louceng."层]；";
                }
                if ($fy1['zlouceng'] != $zlouceng && ($fy1['zlouceng'] == true || $zlouceng == true)) {
                    $xiugai .= "总楼层：[".$fy1['zlouceng']."层]=>[".$zlouceng."层]；";
                }
                if ($fy1['chaoxiang'] != $chaoxiang && ($fy1['chaoxiang'] == true || $chaoxiang == true)) {
                    $xiugai .= get_xiugai($fy1['chaoxiang'],$chaoxiang,'chaoxiang');
                }
                if ($fy1['xianzhuang'] != $xianzhuang && ($fy1['xianzhuang'] == true || $xianzhuang == true)) {
                    $xiugai .= get_xiugai($fy1['xianzhuang'],$xianzhuang,'xianzhuang');
                }
                if ($fy1['fwleixing'] != $fwleixing && ($fy1['fwleixing'] == true || $fwleixing == true)) {
                    $xiugai .= get_xiugai($fy1['fwleixing'],$fwleixing,'fwleixing');
                }
                if ($fy1['jiegou'] != $jiegou && ($fy1['jiegou'] == true || $jiegou == true)) {
                    $xiugai .= get_xiugai($fy1['jiegou'],$jiegou,'jiegou');
                }
                if ($fy1['leixing'] == 1) {
                    if ($fy1['chanquanzheng'] != $chanquanzheng && ($fy1['chanquanzheng'] == true || $chanquanzheng == true)) {
                        $xiugai .= get_xiugai1('产权证',$fy1['chanquanzheng'],$chanquanzheng,'iszheng');
                    }
                    if ($fy1['kanfangfs'] != $kanfangfs && ($fy1['kanfangfs'] == true || $kanfangfs == true)) {
                        $xiugai .= get_xiugai($fy1['kanfangfs'],$kanfangfs,'kanfangfs');
                    }
                    if ($fy1['budongchanzheng'] != $budongchanzheng && ($fy1['budongchanzheng'] == true || $budongchanzheng == true)) {
                        $xiugai .= get_xiugai1('不动产证',$fy1['budongchanzheng'],$budongchanzheng,'iszheng');
                    }
                    if ($fy1['tudizheng'] != $tudizheng && ($fy1['tudizheng'] == true || $tudizheng == true)) {
                        $xiugai .= get_xiugai1('土地证',$fy1['tudizheng'],$tudizheng,'iszheng');
                    }
                }
                if ($fy1['peitao'] != $pt2) {
                    if ($fy1['peitao']) {
                        $condition1 = " pzming = 'peitao' and lxid in (".$fy1['peitao'].")";
                        $peitao1 = M('peizhi')->where($condition1)->order('xsshunxu asc')->select();
                        foreach ($peitao1 AS $key => $val) {
                            $fypt1 .= ",".$val['lxming'];
                        }
                    }
                    if ($pt2) {
                        $condition2 = " pzming = 'peitao' and lxid in (".$pt2.")";
                        $peitao2 = M('peizhi')->where($condition2)->order('xsshunxu asc')->select();
                        foreach ($peitao2 AS $key => $val) {
                            $fypt2 .= $val['lxming'].",";
                        }
                    }
                    $xiugai .= "配套：[".$fypt1."]=>[".$fypt2."]；";
                }
                if ($fy1['fukuanfs'] != $fukuanfs && ($fy1['fukuanfs'] == true || $fukuanfs == true)) {
                    switch ($fy1['leixing']) {
                        case 1:
                            $fuk = "fukuan";
                            break;
                        case 2:
                            $fuk = "zlfukuan";
                            break;
                    }
                    $xiugai .= get_xiugai1('付款方式',$fy1['fukuanfs'],$fukuanfs,$fuk);
                }
                if ($fy1['fydengji'] != $fydengji && ($fy1['fydengji'] == true || $fydengji == true)) {
                    $xiugai .= get_xiugai($fy1['fydengji'],$fydengji,'fydengji');
                }
                if (($fy1['wushui'] != $wushui && ($fy1['wushui'] == true || $wushui == true)) || ($fy1['geshui'] != $geshui && ($fy1['geshui'] == true || $geshui == true)) || ($fy1['zengshui'] != $zengshui && ($fy1['zengshui'] == true || $zengshui == true))) {
                    $shui = $fy1['wushui'] ? "无税" : "";
                    $shui1 = $wushui ? "无税" : "";
                    $shui2 = $fy1['geshui'] ? "个税;" : "";
                    $shui3 = $geshui ? "个税;" : "";
                    $shui4 = $fy1['zengshui'] ? "增值税;" : "";
                    $shui5 = $zengshui ? "增值税;" : "";
                    $xiugai .= "税收：[".$shui.$shui2.$shui4."]=>[".$shui1.$shui3.$shui5."]；";
                }
                if ($fy1['fybiaoti'] != I('fybiaoti') && ($fy1['fybiaoti'] == true || I('fybiaoti') == true)) {
                    $xiugai .= "房源标题：[".$fy1['fybiaoti']."]=>[".I('fybiaoti')."]；";
                }
                if ($fy1['waiwangtb'] != $waiwangtb && ($fy1['waiwangtb'] == true || $waiwangtb == true)) {
                    $wai = $fy1['waiwangtb']?"是":"否";
                    $wai1 = $waiwangtb?"是":"否";
                    $xiugai .= "外网同步：[".$wai."]=>[".$wai1."]；";
                }
                if ($fy1['ti'] != $ti && ($fy1['ti'] == true || $ti == true)) {
                    $xiugai .= "梯：[".$fy1['ti']."梯]=>[".$ti."梯]；";
                }
                if ($fy1['hu'] != $hu && ($fy1['hu'] == true || $hu == true)) {
                    $xiugai .= "户：[".$fy1['hu']."户]=>[".$hu."户]；";
                }
                if ($fy1['niandai'] != $niandai && ($fy1['niandai'] == true || $niandai == true)) {
                    $xiugai .= "建筑年代：[".$fy1['niandai']."年]=>[".$niandai."年]；";
                }
                if ($fy1['leixing'] == 1) {
                    if ($fy1['czriqi'] != $czriqi && ($fy1['czriqi'] == true || $czriqi == true)) {
                        $xiugai .= "产证日期：[".date('Y-m-d',$fy1['czriqi'])."]=>[".date('Y-m-d',$czriqi)."]；";
                    }
                    if ($fy1['man5'] != $man5 && ($fy1['man5'] == true || $man5 == true)) {
                        $man51 = $fy1['man5']?"是":"否";
                        $man52 = $man5?"是":"否";
                        $xiugai .= "满五年：[".$man51."]=>[".$man52."]；";
                    }
                    if ($fy1['man2'] != $man2 && ($fy1['man2'] == true || $man2 == true)) {
                        $man21 = $fy1['man2']?"是":"否";
                        $man22 = $man2?"是":"否";
                        $xiugai .= "满两年：[".$man21."]=>[".$man22."]；";
                    }
                    if ($fy1['weiyi'] != $weiyi && ($fy1['weiyi'] == true || $weiyi == true)) {
                        $wei1 = $fy1['weiyi']?"是":"否";
                        $wei2 = $weiyi?"是":"否";
                        $xiugai .= "唯一住房：[".$wei1."]=>[".$wei2."]；";
                    }
                    if ($fy1['jishou'] != $jishou && ($fy1['jishou'] == true || $jishou == true)) {
                        $jis = $fy1['jishou']?"是":"否";
                        $jis1 = $jishou?"是":"否";
                        $xiugai .= "急售：[".$jis."]=>[".$jis1."]；";
                    }
                    if ($fy1['cqxingzhi'] != $cqxingzhi && ($fy1['cqxingzhi'] == true || $cqxingzhi == true)) {
                        $xiugai .= get_xiugai($fy1['cqxingzhi'],$cqxingzhi,'chanquan');
                    }
                    if ($fy1['cqnianxian'] != $cqnianxian && ($fy1['cqnianxian'] == true || $cqnianxian == true)) {
                        $xiugai .= "产权年限：[".$fy1['cqnianxian']."年]=>[".$cqnianxian."年]；";
                    }
                    if ($fy1['heyan'] != $heyan && ($fy1['heyan'] == true || $heyan == true)) {
                        $jis = $fy1['heyan']?"是":"否";
                        $jis1 = $heyan?"是":"否";
                        $xiugai .= "核验：[".$jis."]=>[".$jis1."]；";
                    }
                    if ($fy1['quankuan'] != $quankuan && ($fy1['quankuan'] == true || $quankuan == true)) {
                        $quan = $fy1['quankuan']?"是":"否";
                        $quan1 = $quankuan?"是":"否";
                        $xiugai .= "全款：[".$quan."]=>[".$quan1."]；";
                    }
                    if ($fy1['youdaikuan'] != $youdaikuan && ($fy1['youdaikuan'] == true || $youdaikuan == true)) {
                        $youdaik1 = $fy1['youdaikuan']?"是":"否";
                        $youdaik2 = $youdaikuan?"是":"否";
                        $xiugai .= "有贷款：[".$youdaik1."]=>[".$youdaik2."]；";
                    }
                    if ($fy1['xinzheng'] != $xinzheng && ($fy1['xinzheng'] == true || $xinzheng == true)) {
                        $xin1 = $fy1['xinzheng']?"是":"否";
                        $xin2 = $xinzheng?"是":"否";
                        $xiugai .= "新证：[".$xin1."]=>[".$xin2."]；";
                    }
                }
                if ($fy1['beizhu'] != $beizhu && ($fy1['beizhu'] == true || $beizhu == true)) {
                    $xiugai .= "备注：[".$fy1['beizhu']."]=>[".$beizhu."]；";
                }
                $data_rizhi = array(
                    'zy_type'=>1,
                    'uid'=>session('uid'),
                    'addtime'=>time(),
                    'cz_type'=>2,
                    'zy_bianhao'=>$fy1['bianhao'],
                    'zy_id'=>$fy1['id'],
                    'neirong'=>$xiugai,
                );
                $isok = M('fangyuan')->where(array('id'=>$fy1['id']))->save($data);
                if ($isok) {
                    M('rizhi')->add($data_rizhi);
                    $this->success('修改成功');
                } else {
                    $this->error('修改失败');
                }
            } else {
                switch ($fy1['leixing']) {
                    case 1:
                        $fukuan = "fukuan";
                        $this->kanfangfs = get_peizhi('kanfangfs',0,1);
                        $this->iszheng = get_peizhi('iszheng',0,1);
                        $this->chanquan = get_peizhi('chanquan',0,1);
                        break;
                    case 2:
                        $fukuan = "zlfukuan";
                        $this->zujialx = get_peizhi('zujialx',0,1);
                        break;
                    default:
                        $this->error('类型异常！');
                        break;
                }
                $this->yongtu = get_peizhi('yongtu',0,1);
                $this->laiyuan = get_peizhi('laiyuan',0,1);
                $this->zhuangxiu = get_peizhi('zhuangxiu',0,1);
                $this->chaoxiang = get_peizhi('chaoxiang',0,1);
                $this->xianzhuang = get_peizhi('xianzhuang',0,1);
                $this->fwleixing = get_peizhi('fwleixing',0,1);
                $this->jiegou = get_peizhi('jiegou',0,1);
                $this->peitao = get_peizhi('peitao',0,1);
                $this->peitao2 = explode(",",$fy1['peitao']);
                $this->fukuan = get_peizhi($fukuan,0,1);
                $this->fydengji = get_peizhi('fydengji',0,1);
                $this->fangyuan = $fy1;
                $this->display();
            }
        }
        //变更状态
        public function bgfyzt(){
            $id=I('id');
            $fangyuan=M('fangyuan')->where(array('id'=>$id))->find();
            $is_rbac = _rbac_btn_show(695,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $chengjiao_options=M('options')->where(array('option_name'=>'chengjiao_options'))->find();
            $options_arr = json_decode($chengjiao_options['option_value'],true);
            if (IS_POST) {
                if ($fangyuan['zhuangtai'] == $options_arr['fychengjiao_zhuangtai']){
                    $this->error('房源已成交');
                }
                $data['zhuangtai']=I('zhuangtai');
                $data['xiugaisj']=time();
                $yzt=M('peizhi')->where(array('pzming'=>'zhuangtai','lxid'=>$fangyuan['zhuangtai']))->getField('lxming');
                $xzt=M('peizhi')->where(array('pzming'=>'zhuangtai','lxid'=>I('zhuangtai')))->getField('lxming');
                $isok=M("fangyuan")->where(array('id'=>I('id')))->save($data);
                if ($isok){
                    $data_rizhi['zy_type']=1;
                    $data_rizhi['uid']=session("uid");
                    $data_rizhi['addtime']=time();
                    $data_rizhi['cz_type']=24;
                    $data_rizhi['zy_id']=I('id');
                    $data_rizhi['zy_bianhao']=$fangyuan['bianhao'];
                    $neirong="变更状态:[".$yzt."]=>[".$xzt."]";
                    $data_rizhi['neirong']=$neirong;
                    M('rizhi')->add($data_rizhi);
                    $this->success('变更成功');
                }else{
                    $this->error('变更失败');
                }
            }else{
                $this->fyzt=$fangyuan['zhuangtai'];
                $this->zhuangtai=M('Peizhi')->where(array('pzming'=>'zhuangtai','zhuangtai'=>1))->order('xsshunxu asc')->select();
                $this->display();
            }
        }
        //调取
    	public function diaoqu() {
            $id=I('id');
            $fangyuan=M('fangyuan')->where(array('id'=>I('id')))->find();
            $is_rbac = _rbac_btn_show(58,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->error('您没有权限!');
            }
            $is_rbacfdq = _rbac_node_show(862);
            if (!$is_rbacfdq && ($fangyuan['fpdq'] != 2)) {
                $this->error('您没有权限!');
            }
            $is_rbacfdh = _rbac_node_show(859);
            $is_rbacfdz = _rbac_node_show(860);
            if (!$is_rbacfdh && !$is_rbacfdz && ($fangyuan['fpdh'] == 1) && ($fangyuan['fpdz'] == 1)) {
                $this->error('您没有权限!');
            }
            $guohu_options=M('options')->where(array('option_name'=>'diaoqu_options'))->find();
            $diaoqu_arr = json_decode($guohu_options['option_value'],true);
            if ($diaoqu_arr['sz_ytpe'] == 1 && session('username') != C('RBAC_SUPERADMIN')) {
                switch ($diaoqu_arr['sz_ytpe1']['type']) {
                    case '1':
                        $startUnix = strtotime(date('Y-m-d',time()));
                        break;
                    case '2':
                        $startUnix = strtotime(date('Y-m-d', strtotime('this week')));
                        break;
                    case '3':
                        $startUnix = strtotime(date('Y-m', time()) . '-01 00:00:00');
                        break;
                    case '4':
                        $season = ceil((date('n'))/3);
                        $startUnix = mktime(0, 0, 0,$season*3-3+1,1,date('Y'));
                        break;
                    case '5':
                        $startUnix = strtotime(date('Y', time()) . '-01-01 00:00:00');
                        break;
                    default:
                        $startUnix = strtotime(date('Y-m-d',time()));
                        break;
                }
                $find = M('xianzhi')->where(array('fyid'=>$id,'uid'=>session('uid'),'shijian'=>array('gt',$startUnix)))->find();
                $map = 'uid='.session('uid');
                $map .= ' and  shijian>="'.$startUnix.'"';
                $sql = "select count(*) from (select * from __XIANZHI__ where $map group by fyid) as a";
                $Model = new \Think\Model;
                $count=$Model->query($sql);
                if ($count[0]['count(*)'] >= $diaoqu_arr['sz_ytpe1']['count']) {
                    $this->error('调取次数已用完!');
                }
                $sycishu = $diaoqu_arr['sz_ytpe1']['count'] - $count[0]['count(*)'] - 1;
            }elseif ($diaoqu_arr['sz_ytpe'] == 2 && session('username') != C('RBAC_SUPERADMIN')) {
                $role_id=M('role_user')->where(array('user_id'=>session('uid')))->getField('role_id');
                switch ($diaoqu_arr['sz_ytpe2'][$role_id]['type']) {
                    case '1':
                        $startUnix = strtotime(date('Y-m-d',time()));
                        break;
                    case '2':
                        $startUnix = strtotime(date('Y-m-d', strtotime('this week')));
                        break;
                    case '3':
                        $startUnix = strtotime(date('Y-m', time()) . '-01 00:00:00');
                        break;
                    case '4':
                        $season = ceil((date('n'))/3);
                        $startUnix = mktime(0, 0, 0,$season*3-3+1,1,date('Y'));
                        break;
                    case '5':
                        $startUnix = $startUnix = strtotime(date('Y', time()) . '-01-01 00:00:00');
                        break;
                    default:
                        $startUnix = strtotime(date('Y-m-d',time()));
                        break;
                }
                $find = M('xianzhi')->where(array('fyid'=>$id,'uid'=>session('uid'),'shijian'=>array('gt',$startUnix)))->find();
                $map = 'uid='.session('uid');
                $map .= ' and  shijian>="'.$startUnix.'"';
                $sql = "select count(*) from (select * from __XIANZHI__ where $map group by fyid) as a";
                $Model = new \Think\Model;
                $count=$Model->query($sql);
                if ($count[0]['count(*)'] >= $diaoqu_arr['sz_ytpe2'][$role_id]['count']) {
                    $this->error('调取次数已用完!');
                }
                $sycishu = $diaoqu_arr['sz_ytpe2'][$role_id]['count'] - $count[0]['count(*)'] - 1;
            }
            $data['fyid']=$id;
            $data['uid']=session('uid');
            $data['time']=date("Y-m");
            $data['shijian']=time();
            M('xianzhi')->add($data);
            if ($is_rbacfdh || ($fangyuan['fpdh'] == 2)) {
                $yezhulx=M('Peizhi')->where(array('pzming'=>'yezhulx','zhuangtai'=>1,'lxid'=>$fangyuan['yezhulx']))->order('xsshunxu asc')->getField('lxming');
                $yezhugx=M('Peizhi')->where(array('pzming'=>'yezhugx','zhuangtai'=>1,'lxid'=>$fangyuan['yezhugx']))->order('xsshunxu asc')->getField('lxming');
                $yezhugx2=M('Peizhi')->where(array('pzming'=>'yezhugx','zhuangtai'=>1,'lxid'=>$fangyuan['yezhugx2']))->order('xsshunxu asc')->getField('lxming');
                $yezhugx3=M('Peizhi')->where(array('pzming'=>'yezhugx','zhuangtai'=>1,'lxid'=>$fangyuan['yezhugx3']))->order('xsshunxu asc')->getField('lxming');
                if ($yezhugx) {
                    $yzguanxi = "（".$yezhugx."）";
                } else {
                    $yzguanxi = "";
                }
                if ($yezhugx2) {
                    $yzguanxi2 = "（".$yezhugx2."）";
                } else {
                    $yzguanxi2 = "";
                }
                if ($yezhugx3) {
                    $yzguanxi3 = "（".$yezhugx3."）";
                } else {
                    $yzguanxi3 = "";
                }
                $diaoqu['yezhu']=$fangyuan['yezhu'].$yezhulx;
                $diaoqu['yezhudianhua']=$fangyuan['yezhudianhua'].$yzguanxi;
                $diaoqu['yezhudianhua2']=$fangyuan['yezhudianhua2'].$yzguanxi2;
                $diaoqu['yezhudianhua3']=$fangyuan['yezhudianhua3'].$yzguanxi3;
            }
            if ($is_rbacfdz || ($fangyuan['fpdz'] == 2)) {
                $diaoqu['zuodong']=$fangyuan['zuodong'];
                $diaoqu['danyuan']=$fangyuan['danyuan'];
                $diaoqu['fanghao']=$fangyuan['fanghao'];
            }
            if ($sycishu) {
                $info="剩余调取数为".$sycishu."次";
            }
            $data1=array('status'=>1,'diaoqu1'=>$diaoqu,'info'=>$info);
            header("Content-type: application/json");
            exit(json_encode($data1));
        }
        //写跟进
        public function genjin(){
            $fangyuan=M('fangyuan')->where(array('id'=>I('fyid')))->find();
            $is_rbac = _rbac_btn_show(61,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $gjid = I('gjid');
            $gongsiid = session('gongsiid');
            //音频操作ajax（上传，删除）
            switch (I('gt')) {
                case '1':
                    //语音上传
                    $upload = new \Think\Upload();
                    $upload->maxSize = 2097152;
                    $upload->exts = array('mp3'); //array('mp3','ogg');
                    $upload->rootPath = './Upload/';
                    $upload->savePath = './Genjin/'.$gongsiid.'/'.$fangyuan['bianhao'].'/';
                    $upload->autoSub = false;
                    $uplaod->replace = true;    //存在同名文件是否是覆盖，默认为false
                    $upload->saveName = $gjid;
                    //开始上传音频文件
                    $info = $upload->upload();
                    if (!$info) {
                        $this->error($upload->getError());
                    }else{
                        M('fygenjin')->where(array('id'=>$gjid))->setField(array('gjvoice'=>1));
                        $this->success($info);
                    }
                    break;
                case '2':
                    $isok = unlink('./Upload/Genjin/'.$gongsiid.'/'.$fangyuan['bianhao'].'/'.$gjid.'.mp3');
                    if ($isok) {
                        M('fygenjin')->where(array('id'=>$gjid))->setField(array('gjvoice'=>null)); 
                    }
                    $this->success('删除语音成功！');
                    break;
                default:
                    break;
            }
            if (IS_POST) {
                $data['gongsiid']=session("gongsiid");
                $data['fybh']=I('fybh');
                $data['fyid']=I('fyid');
                $data['uid']=session("uid");
                $data['genjinfs']=I('genjinfs');
                $data['neirong']=I('neirong');
                $data['shijian']=strtotime(I('gjshijian'));
                $data['time']=time();
                $isok = M('fygenjin')->add($data);
                if ($isok) {
                    $data_rizhi['zy_type']=1;
                    $data_rizhi['uid']=session("uid");
                    $data_rizhi['addtime']=time();
                    $data_rizhi['cz_type']=5;
                    $data_rizhi['zy_id']=$data['fyid'];
                    $data_rizhi['zy_bianhao']=$data['fybh'];
                    $data_rizhi['neirong']=$data['neirong'];
                    M('rizhi')->add($data_rizhi);
                    $data_genjin['zhgjsj']=time();
                    $data_genjin['xiugaisj']=time();
                    $this->success('添加成功');
                }else{
                    $this->error('添加失败');
                }
            }else{
                $this->genjinfs=M('Peizhi')->where(array('pzming'=>'genjinfs','zhuangtai'=>1))->order('xsshunxu asc')->select();
                $this->display();
            }
        }
        //设置全景地址处理
        public function quanjingHandle(){
        	$id=I('id');
            $fangyuan=M('fangyuan')->where(array('id'=>$id))->find();
            $is_rbac = _rbac_btn_show(76,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
        	$data['vr_url']=I('text');
            $data['xiugaisj']=time();
        	$isok=M('fangyuan')->where(array('id'=>$id))->save($data);
            if ($isok) {
                $data_rizhi['zy_type']=1;
                $data_rizhi['uid']=session("uid");
                $data_rizhi['addtime']=time();
                $data_rizhi['cz_type']=6;
                $data_rizhi['zy_id']=$id;
                $data_rizhi['zy_bianhao']=$fangyuan['bianhao'];
                $neirong="全景设置:[".$fangyuan['vr_url']."]=>[".$data['vr_url']."]";
                $data_rizhi['neirong']=$neirong;
                M('rizhi')->add($data_rizhi);
                $this->success('添加成功');
            }else{
                $this->error('添加失败');
            }
        }
        //修改门牌号
        public function xgzuodong(){
            $id = I('id',0,'int');
            $fangyuan = M('fangyuan')->where(array('id'=>$id))->field('id,bianhao,leixing,zhuangtai,weihurenid,yezhu,yezhulx,yezhudianhua,yezhugx,yezhudianhua2,yezhugx2,yezhudianhua3,yezhugx3,xiaoqu,zuodong,danyuan,fanghao,fpdh,fpdz')->find();
            $is_rbac = _rbac_btn_show(150,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $is_rbacfdh = _rbac_node_show(859);
            $is_rbacfdz = _rbac_node_show(860);
            if (!$is_rbacfdh && !$is_rbacfdz && ($fangyuan['fpdh'] == 1) && ($fangyuan['fpdz'] == 1)) {
                $this->redirect('Index/error');
            }
            if ($is_rbacfdh || ($fangyuan['fpdh'] == 2)) {
                $this->is_rbacfdh = 1;
            }
            if ($is_rbacfdz || ($fangyuan['fpdz'] == 2)) {
                $this->is_rbacfdz = 1;
            }
            if (IS_POST) {
                if ($is_rbacfdh || ($fangyuan['fpdh'] == 2)) {
                    $dianhua1 = I('dianhua1');
                    $dianhua2 = I('dianhua2');
                    $dianhua3 = I('dianhua3');
                    if (!preg_match("/^(13[0-9]|14[0-1,4-9]|15[0-3,5-9]|16[2567]|17[0-8]|18[0-9]|19[0-3,5-9])\d{8}$/",$dianhua1) && !preg_match("/^0\d{2,3}-?\d{7,8}$/",$dianhua1)) {
                        $this->error('请输出正确的手机号码或电话号码！');
                    }
                    if ($dianhua2) {
                        if (!preg_match("/^(13[0-9]|14[0-1,4-9]|15[0-3,5-9]|16[2567]|17[0-8]|18[0-9]|19[0-3,5-9])\d{8}$/",$dianhua2) && !preg_match("/^0\d{2,3}-?\d{7,8}$/",$dianhua2)) {
                            $this->error('请输出正确的手机号码或电话号码！');
                        }
                    }
                    if ($dianhua3) {
                        if (!preg_match("/^(13[0-9]|14[0-1,4-9]|15[0-3,5-9]|16[2567]|17[0-8]|18[0-9]|19[0-3,5-9])\d{8}$/",$dianhua3) && !preg_match("/^0\d{2,3}-?\d{7,8}$/",$dianhua3)) {
                            $this->error('请输出正确的手机号码或电话号码！');
                        }
                    }
                    if (($dianhua1 == true && $dianhua2 == true && $dianhua1 == $dianhua2) || ($dianhua1 == true && $dianhua3 == true && $dianhua1 == $dianhua3) || ($dianhua1 == true && $dianhua2 == true && $dianhua2 == $dianhua3)) {
                        $this->error('手机号码或电话号码重复！');
                    }
                    $yezhulx = I('yezhulx',0,'int');
                    $yezhugx1 = I('yezhugx1',0,'int');
                    $yezhugx2 = I('yezhugx2',0,'int');
                    $yezhugx3 = I('yezhugx3',0,'int');
                    $yezhulxq = get_peizhi('yezhulx',$fangyuan['yezhulx'],3);
                    $yezhulxh = get_peizhi('yezhulx',$yezhulx,3);
                    $yezhugxq = get_peizhi('yezhugx',$fangyuan['yezhugx'],3);
                    $yezhugxh = get_peizhi('yezhugx',$yezhugx1,3);
                    $yezhugx2q = get_peizhi('yezhugx',$fangyuan['yezhugx2'],3);
                    $yezhugx2h = get_peizhi('yezhugx',$yezhugx2,3);
                    $yezhugx3q = get_peizhi('yezhugx',$fangyuan['yezhugx3'],3);
                    $yezhugx3h = get_peizhi('yezhugx',$yezhugx3,3);
                }
                if ($is_rbacfdz || ($fangyuan['fpdz'] == 2)) {
                    $zuodong = I('zuodong');
                    $danyuan = I('danyuan');
                    $fanghao = I('fanghao');
                    if (!preg_match("/^[a-zA-Z1-9][0-9]{0,6}$/",$zuodong)) {
                        $this->error('座栋首字符可以是非零整数或字母，除首字符外必须为非负整数（限六位整数）！');
                    }
                    if (!preg_match("/^[a-zA-Z1-9][0-9]{0,6}$/",$danyuan)) {
                        $this->error('单元首字符可以是非零整数或字母，除首字符外必须为非负整数（限六位整数）！');
                    }
                    if (!preg_match("/^[a-zA-Z1-9][0-9]{0,6}$/",$fanghao)) {
                        $this->error('房号首字符可以是非零整数或字母，除首字符外必须为非负整数（限六位整数）！');
                    }
                    $condition['gongsiid'] = session('gongsiid');
                    $condition['zhuangtai'] = array('neq',get_options('chengjiao_options','fychengjiao_zhuangtai'));
                    $condition['id'] = array('neq',$id);
                    $condition['isdel'] = 2;
                    $condition['xiaoqu'] = $fangyuan['xiaoqu'];
                    $condition['zuodong'] = $zuodong;
                    $condition['danyuan'] = $danyuan;
                    $condition['fanghao'] = $fanghao;
                    $condition['leixing'] = $fangyuan['leixing'];
                    $cffy = M('fangyuan')->where($condition)->find();
                    if ($cffy) {
                        $this->error('房源已存在');
                    }
                }
                if (($is_rbacfdh || ($fangyuan['fpdh'] == 2)) && ($is_rbacfdz || ($fangyuan['fpdz'] == 2))) {
                    $xiugaiqian = '业主：'.$fangyuan['yezhu'].$yezhulxq.'。电话：'.$fangyuan['yezhudianhua'].'（'.$yezhugxq.'）；'.$fangyuan['yezhudianhua2'].'（'.$yezhugx2q.'）；'.$fangyuan['yezhudianhua3'].'（'.$yezhugx3q.'）。座栋：'.$fangyuan['zuodong'].'。单元：'.$fangyuan['danyuan'].'。房号：'.$fangyuan['fanghao'];
                    $xiugaihou = '业主：'.I('yezhu').$yezhulxh.'。电话：'.$dianhua1.'（'.$yezhugxh.'）；'.$dianhua2.'（'.$yezhugx2h.'）；'.$dianhua3.'（'.$yezhugx3h.'）。座栋：'.$zuodong.'。单元：'.$danyuan.'。房号：'.$fanghao;
                } elseif ($is_rbacfdh || ($fangyuan['fpdh'] == 2)) {
                    $xiugaiqian = '业主：'.$fangyuan['yezhu'].$yezhulxq.'。电话：'.$fangyuan['yezhudianhua'].'（'.$yezhugxq.'）；'.$fangyuan['yezhudianhua2'].'（'.$yezhugx2q.'）；'.$fangyuan['yezhudianhua3'].'（'.$yezhugx3q.'）。';
                    $xiugaihou = '业主：'.I('yezhu').$yezhulxh.'。电话：'.$dianhua1.'（'.$yezhugxh.'）；'.$dianhua2.'（'.$yezhugx2h.'）；'.$dianhua3.'（'.$yezhugx3h.'）。';
                } elseif ($is_rbacfdz || ($fangyuan['fpdz'] == 2)) {
                    $xiugaiqian = '座栋：'.$fangyuan['zuodong'].'。单元：'.$fangyuan['danyuan'].'。房号：'.$fangyuan['fanghao'];
                    $xiugaihou = '座栋：'.$zuodong.'。单元：'.$danyuan.'。房号：'.$fanghao;
                }
                $map['xiugaiqian'] = $xiugaiqian;
                $map['xiugaihou'] = $xiugaihou;
                $map['time'] = time();
                $map['fybianhao'] = $fangyuan['bianhao'];
                $map['uid'] = session('uid');
                M('fyxiugai')->add($map);
                if ($is_rbacfdh || ($fangyuan['fpdh'] == 2)) {
                    $data['yezhu'] = I('yezhu');
                    $data['yezhulx'] = $yezhulx;
                    $data['yezhugx'] = $yezhugx1;
                    $data['yezhugx2'] = $yezhugx2;
                    $data['yezhugx3'] = $yezhugx3;
                    $data['yezhudianhua'] = $dianhua1;
                    $data['yezhudianhua2'] = $dianhua2;
                    $data['yezhudianhua3'] = $dianhua3;
                }
                if ($is_rbacfdz || ($fangyuan['fpdz'] == 2)) {
                    $data['zuodong'] = $zuodong;
                    $data['danyuan'] = $danyuan;
                    $data['fanghao'] = $fanghao;
                }
                $data['xiugaisj'] = time();
                $isok = M('fangyuan')->where(array('id'=>$id))->save($data);
                if ($isok) {
                    $data_rizhi['zy_type'] = 1;
                    $data_rizhi['uid'] = session("uid");
                    $data_rizhi['addtime'] = time();
                    $data_rizhi['cz_type'] = 7;
                    $data_rizhi['zy_id'] = $id;
                    $data_rizhi['zy_bianhao'] = $fangyuan['bianhao'];
                    $neirong = "核心修改";
                    $data_rizhi['neirong'] = $neirong;
                    M('rizhi')->add($data_rizhi);
                    $this->success('修改成功');
                } else {
                    $this->error('修改失败');
                }
            } else {
                $this->fangyuan = $fangyuan;
                if ($is_rbacfdh || ($fangyuan['fpdh'] == 2)) {
                    $this->yezhulx = get_peizhi('yezhulx',0,1);
                    $this->yezhugx = get_peizhi('yezhugx',0,1);
                }
                if ($is_rbacfdz || ($fangyuan['fpdz'] == 2)) {
                    $this->leixing = $fangyuan['leixing'];
                    $this->xiaoqu = $fangyuan['xiaoqu'];
                }
                $this->display();
            }
        }
        public function delEsfy(){
            $id=I('id');
            $fangyuan=M('fangyuan')->where(array('id'=>$id))->find();
            $is_rbac = _rbac_btn_show(416,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $this->error('请联系客服（19965783436）获取正式版功能！');
        }
        public function huifufy(){
            $id=I('id');
            $fangyuan=M('fangyuan')->where(array('id'=>$id))->find();
            $is_rbac = _rbac_btn_show(766,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $this->error('请联系客服（19965783436）获取正式版功能！');
        }
        public function yjdelfy(){
            $id=I('id');
            $fangyuan=M('fangyuan')->where(array('id'=>$id))->find();
            $is_rbac = _rbac_btn_show(767,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $this->error('请联系客服（19965783436）获取正式版功能！');
        }
        public function sipanHandle(){
            $id=I('id');
            $fangyuan=M('fangyuan')->where(array('id'=>$id))->find();
            $is_rbac = _rbac_btn_show(379,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $chengjiao_options=M('options')->where(array('option_name'=>'chengjiao_options'))->find();
            $options_arr = json_decode($chengjiao_options['option_value'],true);
            if ($fangyuan['zhuangtai'] == $options_arr['fychengjiao_zhuangtai']){
                $this->error('房源已成交');
            }
            $data['gspan']=1;
			$data['zhuangtai']=$options_arr['fysipan_zhuangtai'];
			$data['weihurenid']=session('uid');
			$data['weihuren']=session('ygmingcheng');
            $data['xiugaisj']=time();
			$isok=M('fangyuan')->where(array('id'=>$id))->save($data);
            if ($isok) {
                $data_rizhi['zy_type']=1;
                $data_rizhi['uid']=session("uid");
                $data_rizhi['addtime']=time();
                $data_rizhi['cz_type']=3;
                $data_rizhi['zy_id']=$id;
                $data_rizhi['zy_bianhao']=$fangyuan['bianhao'];
                $neirong="转为私盘";
                $data_rizhi['neirong']=$neirong;
                $rizhi=M('rizhi')->add($data_rizhi);
                $this->success('修改成功');
            }else{
                $this->error('修改失败');
            }
        }
        public function gongpanHandle(){
            $id=I('id');
            $fangyuan=M('fangyuan')->where(array('id'=>$id))->find();
            $is_rbac = _rbac_btn_show(380,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $chengjiao_options=M('options')->where(array('option_name'=>'chengjiao_options'))->find();
            $options_arr = json_decode($chengjiao_options['option_value'],true);
            if ($fangyuan['zhuangtai'] == $options_arr['fychengjiao_zhuangtai']){
                $this->error('房源已成交');
            }
			$data['gspan']=2;
			$data['zhuangtai']=$options_arr['fygongpan_zhuangtai'];
            $data['xiugaisj']=time();
            $isok=M('fangyuan')->where(array('id'=>$id))->save($data);
			if ($isok) {
				$data_rizhi['zy_type']=1;
				$data_rizhi['uid']=session("uid");
				$data_rizhi['addtime']=time();
				$data_rizhi['cz_type']=4;
				$data_rizhi['zy_id']=$id;
				$data_rizhi['zy_bianhao']=$fangyuan['bianhao'];
				$neirong="转为公盘";
				$data_rizhi['neirong']=$neirong;
				M('rizhi')->add($data_rizhi);
				$this->success('修改成功');
			}else{
				$this->error('修改失败');
			}
        }
        //变更维护人
        public function bgwhr(){
            $id=I('id');
            $fangyuan=M('fangyuan')->where(array('id'=>$id))->find();
            $is_rbac = _rbac_btn_show(381,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $data['weihurenid']=I('weihurenid');
                $xweihu=M('Yonghu')->where(array('id'=>I('weihurenid')))->getField('ygmingcheng');
                $fangyuan1=M('fangyuan')->where(array('id'=>$id))->find();
                $data['weihuren']=$xweihu;
                $data['xiugaisj']=time();
                $fangyuan=M("fangyuan")->where(array('id'=>$id))->save($data);
                if ($fangyuan){
                    $fyxgsj=M('fangyuan')->where(array('id'=>$id))->setField('xiugaisj',time());
                    $data_rizhi['zy_type']=1;
                    $data_rizhi['uid']=session("uid");
                    $data_rizhi['addtime']=time();
                    $data_rizhi['cz_type']=9;
                    $data_rizhi['zy_id']=I('id');
                    $data_rizhi['zy_bianhao']=$fangyuan1['bianhao'];
                    $neirong="变更维护人:[".$fangyuan1['weihuren']."]=>[".$xweihu."]";
                    $data_rizhi['neirong']=$neirong;
                    M('rizhi')->add($data_rizhi);
                    $this->success('修改成功');
                }else{
                    $this->error('修改失败');
                }
            }else{
                $this->weihuren=M('fangyuan')->where(array('id'=>$id,'gongsiid'=>session('gongsiid')))->getField('weihuren');
                $this->display();
            }
        }
        //编辑视频
        public function editshipin(){
            $id=I('id');
            $fangyuan=M('fangyuan')->where(array('id'=>$id))->field('zhuangtai,weihurenid')->find();
            $is_rbac = _rbac_btn_show(498,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                if (preg_match_all('/src=&quot;(.*?)&quot;/', I('shipin_url'), $matches)) {
                    $s1 = $matches[1][0];
                    $shipin_url='<iframe src="'.$s1.'" frameborder="0" allowfullscreen="true" width="100%" height="100%"></iframe>';
                }elseif (preg_match_all('/src=\'(.*?)\'/', I('shipin_url'), $matches)) {
                    $s1 = $matches[1][0];
                    $shipin_url='<iframe src="'.$s1.'" frameborder="0" allowfullscreen="true" width="100%" height="100%"></iframe>';
                }else{
                    $this->error('视频通用地址格式错误（在视频网站打开视频，点击分享，可以复制视频的通用代码）！');
                }
                $isok=M('fangyuan')->where(array('id'=>$id))->setField('shipin_url',$shipin_url);
                if ($isok) {
                    $fyxgsj=M('fangyuan')->where(array('id'=>$id))->setField('xiugaisj',time());
                    $this->success('修改成功!');
                }else{
                    $this->error('修改失败!');
                }
            }else{
                $this->shipin_url=M('fangyuan')->where(array('id'=>$id))->getField('shipin_url');
                $this->display();
            }
        }
        //实勘
        public function shikan(){
            $id = I('id');
            $fangyuan=M('fangyuan')->where(array('id'=>$id))->field('zhuangtai,weihurenid')->find();
            $is_rbac = _rbac_btn_show(565,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $bianhao = M('fangyuan')->where(array('id'=>$id))->getField('bianhao');
            $isshikan = M('shikan')->where(array('fybh'=>$bianhao))->find();
            if ($isshikan) {
                $this->error('已有人实勘！');
            }
            $this->error('请联系客服（19965783436）获取正式版功能！');
        }
        //委办
        public function weiban(){
            $fangyuan=M('fangyuan')->where(array('bianhao'=>I('fybianhao')))->field('zhuangtai,weihurenid')->find();
            $is_rbac = _rbac_btn_show(564,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $this->error('请联系客服（19965783436）获取正式版功能！');
            } else {
                $this->display();
            }
        }
        //添加钥匙
        public function yaoshi(){
            $fangyuan = M('fangyuan')->where(array('bianhao' => I('fybianhao')))->field('zhuangtai,weihurenid')->find();
            $is_rbac = _rbac_btn_show(750, $fangyuan['zhuangtai'], $fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $this->error('请联系客服（19965783436）获取正式版功能！');
            } else {
                $parentid = I("get.parentid",0,'intval');
                $select_categorys = bumen_option( $parentid, 739);
                $this->assign("select_categorys", $select_categorys);
                $this->display();
            }
        }
        //移动钥匙
        public function ydyaoshi(){
            $fybianhao = I('fybianhao');
            $fangyuan = M('fangyuan')->where(array('bianhao' => $fybianhao))->field('zhuangtai,weihurenid')->find();
            $is_rbac = _rbac_btn_show(753, $fangyuan['zhuangtai'], $fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $this->error('请联系客服（19965783436）获取正式版功能！');
            }else{
                $this->yaoshi = M('yaoshi')->where(array('fybianhao'=>$fybianhao,'status'=>1))->select();
                $parentid = I("get.parentid",0,'intval');
                $select_categorys = bumen_option( $parentid, 739);
                $this->assign("select_categorys", $select_categorys);
                $this->display();
            }
        }
        //上传附件
        public function fujianimg(){
            $data = array(
                'info' => '请联系客服（19965783436）获取正式版功能！',
                'data' => '',
                'status' => 0
            );
            $this->ajaxReturn($data);
        }
        //认证房源
        public function renzheng(){
            $id = I('id');
            $fangyuan=M('fangyuan')->where(array('id'=>$id))->field('zhuangtai,weihurenid')->find();
            $is_rbac = _rbac_btn_show(618,$fangyuan['zhuangtai'],$fangyuan['weihurenid']);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $this->error('请联系客服（19965783436）获取正式版功能！');
        }
    }
?>