<?php

    /*******************************************************************\
    |                                                                   |
    |   开单大师（专业的房产中介管理系统）                              |
    |                                                                   |
    |   © 2017-2023 http://www.kaidandashi.com/ All rights reserved     |
    |                                                                   |
    |   本系统由淮南市银泰软件科技有限公司提供技术支持                  |
    |                                                                   |
    |   QQ号：984784483                                                 |
    |                                                                   |
    \*******************************************************************/

    namespace Admin\Controller;
    use Think\Controller;
    class ZiyuanController extends CommonController {
        // 中介黑名单管理
        public function zjhmd(){
            if (I('is_ajax')) {
                /*权限控制开始*/
                $condition = "e.gongsiid=".session('gongsiid');
                $x = _rbac_lists_where(223,0);
                if ($x && $x != "all" && $x != "me") {
                    $condition .= " and e.bumen in ({$x})";
                } elseif ($x == "me") {
                    $condition .= " and e.id=".session('uid');
                } elseif ($x == false) {
                    $condition .= " and e.id=0";
                }
                /*权限控制结束*/
                $sousuo = I('sousuo');
                $shijian = I('shijian');
                if ($sousuo) {
                    $condition .= " and (a.sjh like '%$sousuo%' or a.xm like '%$sousuo%')";
                }
                if ($shijian) {
                    $time_s = explode(' - ',$shijian);
                    $condition .= " and a.tjsj>=".strtotime($time_s[0])." and a.tjsj<".strtotime($time_s[0])+86400;
                }
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                if ($field && $order) {
                    $dlpx = "order by a.".$field." ".$order;
                } else {
                    $dlpx = "order by a.id desc";
                }
                $Model = new \Think\Model();
                $count = $Model->query("select count(*) from __QTJJR__ a join __YONGHU__ e on a.adduid=e.id where {$condition}");
                $Page = new \Think\Page($count['0']['count(*)'],$limit);
                $list = "select a.*,e.ygmingcheng,e.bumen from __QTJJR__ a join __YONGHU__ e on a.adduid=e.id where {$condition} ".$dlpx." limit ".$Page->firstRow.','.$Page->listRows;
                $data = $Model->query($list);
                foreach ($data as $key => $value) {
                    $data[$key]['tjsj'] = $value['tjsj'] ? date('Y-m-d H:i:s',$value['tjsj']) : "——";
                    $is_rbacgx = _rbac_btn_show(228,0,$value['adduid']);
                    $is_rbacsc = _rbac_btn_show(225,0,$value['adduid']);
                    $data[$key]['rbacgx'] = $is_rbacgx ? 1 : 0;
                    $data[$key]['rbacsc'] = $is_rbacsc ? 1 : 0;
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count['0']['count(*)'],
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $this->display();
            }
        }
        // 删除中介黑名单
        public function delzjhmd(){
            $id=I('id');
            $adduid=M('Qtjjr')->where(array('id'=>$id))->getField('adduid');
            $is_rbac = _rbac_btn_show(225,0,$adduid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $isok=M('Qtjjr')->where(array('id'=>$id))->delete();
            if ($isok){
                $this->success('删除成功');
            }else{
                $this->error('删除失败');
            }
        }
        // 添加中介黑名单
        public function addzjhmd(){
            $is_rbac = _rbac_node_show(226);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $data['xm']=I('xm');
                $data['sjh']=I('sjh');
                $data['gs']=I('gs');
                $data['bz']=I('bz');
                $data['tjsj']=time();
                $data['gongsiid']=session('gongsiid');
                $data['adduid']=session('uid');
                $isok=M('Qtjjr')->add($data);
                if ($isok) {
                    $this->success('添加成功');
                }else{
                    $this->error('添加失败');
                }
            } else {
                $this->display();
            }
        }
        // 更新中介黑名单
        public function editzjhmd(){
            $id=I('id');
            $adduid=M('Qtjjr')->where(array('id'=>$id))->getField('adduid');
            $is_rbac = _rbac_btn_show(228,0,$adduid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $data['xm']=I('xm');
                $data['sjh']=I('sjh');
                $data['gs']=I('gs');
                $data['bz']=I('bz');
                $isok=M("Qtjjr")->where(array('id'=>$id))->save($data);
                if ($isok){
                    $this->success('更新成功');
                }else{
                    $this->error('更新失败');
                }
            } else {
                $this->zjhmd=M('Qtjjr')->where(array('id'=>$id))->find();
                $this->display();
            }
        }
        // 房源打印模板管理
        public function fydayinsz(){
            if (I('is_ajax')) {
                /*权限控制开始*/
                $condition = "e.gongsiid=".session('gongsiid');
                $x = _rbac_lists_where(217,0);
                if ($x && $x != "all" && $x != "me") {
                    $condition .= " and e.bumen in ({$x})";
                } elseif ($x == "me") {
                    $condition .= " and e.id=".session('uid');
                } elseif ($x == false) {
                    $condition .= " and e.id=0";
                }
                /*权限控制结束*/
                $condition = "a.gongsiid=".session('gongsiid');
                $sousuo = I('sousuo');
                $shijian = I('shijian');
                if ($sousuo) {
                    $condition .= " and (a.mbmingcheng like '%$sousuo%' or e.mbmingcheng like '%$sousuo%' or e.pinyinjs like '%$sousuo%' or e.dianhua like '%$sousuo%')";
                }
                if ($shijian) {
                    $time_s = explode(' - ',$shijian);
                    $condition .= " and a.gxsj>=".strtotime($time_s[0])." and a.gxsj<".strtotime($time_s[0])+86400;
                }
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                if ($field && $order) {
                    $dlpx = "order by a.".$field." ".$order;
                } else {
                    $dlpx = "order by a.id desc";
                }
                $Model = new \Think\Model();
                $count = $Model->query("select count(*) from __FYDAYIN__ a left join __YONGHU__ e on a.adduid=e.id where {$condition}");
                $Page = new \Think\Page($count['0']['count(*)'],$limit);
                $list = "select a.*,e.ygmingcheng,e.bumen from __FYDAYIN__ a left join __YONGHU__ e on a.adduid=e.id where {$condition} ".$dlpx." limit ".$Page->firstRow.','.$Page->listRows;
                $data = $Model->query($list);
                foreach ($data as $key => $value) {
                    $data[$key]['gxsj'] = $value['gxsj'] ? date('Y-m-d H:i:s',$value['gxsj']) : "——";
                    $data[$key]['mbzt'] = '已启用';
                    $data[$key]['mblx'] = $value['mbleixing'] ? get_peizhi("leixing",$value['mbleixing'],3) : "——";
                    $mbyl = $value['mbyulan'] ? $value['mbyulan'] : $value['mbbj'];
                    $data[$key]['mbyl'] = '<img src="/Upload/'.$value['gongsiid'].'/dayinmoban/'.$mbyl.'" width="210px" height="158px">';
                    $is_rbacgx = _rbac_btn_show(221,0,$value['adduid']);
                    $is_rbacsc = _rbac_btn_show(218,0,$value['adduid']);
                    $data[$key]['rbacgx'] = $is_rbacgx ? 1 : 0;
                    $data[$key]['rbacsc'] = $is_rbacsc ? 1 : 0;
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count['0']['count(*)'],
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $this->display();
            }
        }
        // 删除房源打印模板
        public function delmoban(){
            $id=I('id');
            $adduid=M('Fydayin')->where(array('id'=>$id))->getField('adduid');
            $is_rbac = _rbac_btn_show(218,0,$adduid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $mbbj=M('Fydayin')->where(array('id'=>$id))->getField('mbbj');
            $isok=M('Fydayin')->where(array('id'=>$id))->delete();
            if ($isok){
                unlink('./Upload/'.session('gongsiid').'/dayinmoban/'.$mbbj);
                $this->success('删除成功');
            }else{
                $this->error('删除失败');
            }
        }
        // 添加房源打印模板
        public function addmoban(){
            $is_rbac = _rbac_node_show(219);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $data['mbmingcheng']=I('mbmingcheng');
                $data['mbbj']=I('mbbj');
                $data['mbleixing']=I('mbleixing');
                $data['mobancss']=I('mobancss');
                $data['gxsj']=time();
                $data['gongsiid']=session('gongsiid');
                $data['adduid']=session('uid');
                $isok=M('Fydayin')->add($data);
                if ($isok) {
                    $this->success('添加成功');
                }else{
                    $this->error('添加失败');
                }
            } else {
                $this->mbleixing=get_peizhi('leixing',0,1);
                $this->display();
            }
        }
        // 更新房源打印模板
        public function editmoban(){
            $id=I('id');
            $adduid=M('Fydayin')->where(array('id'=>$id))->getField('adduid');
            $is_rbac = _rbac_btn_show(221,0,$adduid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $data['mbmingcheng']=I('mbmingcheng');
                $data['mbbj']=I('mbbj');
                $data['mbleixing']=I('mbleixing');
                $data['mobancss']=I('mobancss');
                $data['gxsj']=time();
                $isok=M("Fydayin")->where(array('id'=>$id))->save($data);
                if ($isok){
                    $this->success('更新成功');
                }else{
                    $this->error('更新失败');
                }
            } else {
                $this->mbleixing=get_peizhi('leixing',0,1);
                $this->moban=M('Fydayin')->where(array('id'=>$id))->find();
                $this->display();
            }
        }
        // 行政区列表
        public function xingzhengqu() {
            if (I('is_ajax')) {
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                $map .= " where gongsiid=".session('gongsiid');
                $x = _rbac_lists_where(372,0);
                if ($x && $x != "all" && $x != "me") {
                    $map .= " and bumen in ({$x})";
                }elseif ($x == "me") {
                    $map .= " and id=".session('uid');
                }elseif ($x == false) {
                    $map .= " and id=0";
                }
                $condition="gongsiid=".session('gongsiid');
                $sousuo=I('sousuo');
                if ($sousuo) {
                    $condition.=" and ((xzqming like '%$sousuo%') or (pinyinjs like '%$sousuo%'))";
                }
                if ($field && $order) {
                    $xzqpx.="order by ".$field." ".$order;
                } else {
                    $xzqpx.="order by id DESC";
                }
                $db = M('xingzhengqu');
                $count = $db->query("select count(*) from (select * from __XINGZHENGQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id");
                $Page = new \Think\Page($count['0']['count(*)'],$limit);
                $list="select a.*,e.* from (select * from __XINGZHENGQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id ".$xzqpx." limit ".$Page->firstRow.','.$Page->listRows;
                $data = $db->query($list);
                foreach ($data as $key => $value) {
                    $data[$key]['ssbm'] = zym($value['bumen'],6);
                    $data[$key]['whbm'] = yhbm($value['whrid'],3);
                    $data[$key]['whr'] = zym($value['whrid'],5);
                    $data[$key]['tjr'] = zym($value['adduid'],5);
                    $is_rbacgx = _rbac_btn_show(375,0,$value['whrid']);
                    $is_rbaczy = _rbac_btn_show(533,0,$value['whrid']);
                    $is_rbacsc = _rbac_btn_show(377,0,$value['whrid']);
                    $data[$key]['rbacgx'] = $is_rbacgx ? 1 : 0;
                    $data[$key]['rbaczy'] = $is_rbaczy ? 1 : 0;
                    $data[$key]['rbacsc'] = $is_rbacsc ? 1 : 0;
                    $data[$key]['pinyinjs'] = $value['pinyinjs'] ? $value['pinyinjs'] : "——";
                    $data[$key]['dituzb'] = $value['dituzb'] ? $value['dituzb'] : "——";
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count['0']['count(*)'],
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $this->display();
            }
        }
        // 添加行政区
        public function addxzq(){
            $is_rbac = _rbac_node_show(373);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $condition['gongsiid']=session('gongsiid');
                $xzqming=I('xzqming');
                $condition['xzqming']=$xzqming;
                $cfxzq=M('xingzhengqu')->where($condition)->find();
                if($cfxzq){
                    $this->error('行政区已存在');
                }
                $whrid=I('whrid');
                $yhbm=yhbm($whrid,1);
                $yh = _rbac_btn_show(373,0,$whrid);
                if (!$yh || !$whrid) {
                    $this->error('异常错误！');
                }
                $data['shijian']=time();
                $data['xzqming']=I('xzqming');
                $data['pinyinjs']=I('pinyinjs');
                $data['dituzb']=I('zuobiao');
                $data['whrid']=$whrid;
                $data['bumen']=$yhbm;
                $data['adduid']=session('uid');
                $data['gongsiid']=session('gongsiid');
                $isok=M('xingzhengqu')->add($data);
                if ($isok) {
                    $this->success('添加成功');
                }else{
                    $this->error('添加失败');
                }
            } else {
                $this->display();
            }
        }
        // 更新行政区
        public function editxzq(){
            $id=I('id');
            $whrid=M('xingzhengqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(375,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $condition['gongsiid']=session('gongsiid');
                $condition['id']=array('neq',$id);
                $xzqming=I('xzqming');
                $condition['xzqming']=$xzqming;
                $cfxzq=M('xingzhengqu')->where($condition)->find();
                if($cfxzq){
                    $this->error('行政区已存在');
                }
                $whrid=I('whrid');
                $yhbm=yhbm($whrid,1);
                $yh = _rbac_btn_show(375,0,$whrid);
                if (!$yh || !$whrid) {
                    $this->error('异常错误！');
                }
                $data['whrid']=$whrid;
                $data['bumen']=$yhbm;
                $data['dituzb']=I('zuobiao');
                $data['xzqming']=I('xzqming');
                $data['pinyinjs']=I('pinyinjs');
                $isok=M("xingzhengqu")->where(array('id'=>$id))->save($data);
                if ($isok){
                    $this->success('更新成功');
                }else{
                    $this->error('更新失败');
                }
            } else {
                $this->xingzhengqu=M('xingzhengqu')->where(array('id'=>$id))->find();
                $this->user=zym($this->xingzhengqu['whrid'],5);
                $this->display();
            }
        }
        // 删除行政区
        public function delxzq(){
            $id=I('id');
            $whrid=M('xingzhengqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(377,0,$whrid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $pqshu=M('pianqu')->where(array('ssxzq'=>$id))->count();
            $xqshu=M('xiaoqu')->where(array('ssxzq'=>$id))->count();
            $fyshu=M('fangyuan')->where(array('xingzhengqu'=>$id))->count();
            if ($pqshu==0 && $xqshu==0 && $fyshu==0){
                $isok=M('xingzhengqu')->where(array('id'=>$id))->delete();
            } else {
                $this->error('请先转移数据');
            }
            if ($isok){
                $this->success('删除成功');
            }else{
                $this->error('删除失败');
            }
        }
        // 片区列表
        public function Pianqu() {
            if (I('is_ajax')) {
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                $map .= " where gongsiid=".session('gongsiid');
                $x = _rbac_lists_where(123,0);
                if ($x && $x != "all" && $x != "me") {
                    $map .= " and bumen in ({$x})";
                }elseif ($x == "me") {
                    $map .= " and id=".session('uid');
                }elseif ($x == false) {
                    $map .= " and id=0";
                }
                $condition="gongsiid=".session('gongsiid');
                $sousuo=I('sousuo');
                if ($sousuo) {
                    $condition.=" and ((pianqum like '%$sousuo%') or (pinyinjs like '%$sousuo%'))";
                }
                if ($field && $order) {
                    $pqpx.="order by ".$field." ".$order;
                } else {
                    $pqpx.="order by id DESC";
                }
                $db = M('pianqu');
                $count = $db->query("select count(*) from (select * from __PIANQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id");
                $Page = new \Think\Page($count['0']['count(*)'],$limit);
                $list="select * from (select * from __PIANQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id ".$pqpx." limit ".$Page->firstRow.','.$Page->listRows;
                $data = $db->query($list);
                foreach ($data as $key => $value) {
                    $data[$key]['xzqm'] = zym($value['ssxzq'],1);
                    $data[$key]['whbm'] = yhbm($value['whrid'],3);
                    $data[$key]['whr'] = zym($value['whrid'],5);
                    $data[$key]['tjr'] = zym($value['adduid'],5);
                    $is_rbacgx = _rbac_btn_show(126,0,$value['whrid']);
                    $is_rbaczy = _rbac_btn_show(533,0,$value['whrid']);
                    $is_rbacsc = _rbac_btn_show(128,0,$value['whrid']);
                    $data[$key]['rbacgx'] = $is_rbacgx ? 1 : 0;
                    $data[$key]['rbaczy'] = $is_rbaczy ? 1 : 0;
                    $data[$key]['rbacsc'] = $is_rbacsc ? 1 : 0;
                    $data[$key]['pinyinjs'] = $value['pinyinjs'] ? $value['pinyinjs'] : "——";
                    $data[$key]['dituzb'] = $value['dituzb'] ? $value['dituzb'] : "——";
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count['0']['count(*)'],
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $this->display();
            }
        }
        // 添加片区
        public function addPianqu(){
            $is_rbac = _rbac_node_show(124);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $condition['gongsiid']=session('gongsiid');
                $ssxzq=I('ssxzq');
                $pianqum=I('pianqum');
                $condition['ssxzq']=$ssxzq;
                $condition['pianqum']=$pianqum;
                $cfpq=M('pianqu')->where($condition)->find();
                if($cfpq){
                    $this->error('片区已存在');
                }
                $whrid=I('whrid');
                $yhbm=yhbm($whrid,1);
                $yh = _rbac_btn_show(124,0,$whrid);
                if (!$yh || !$whrid) {
                    $this->error('异常错误！');
                }
                $data['shijian']=time();
                $data['pianqum']=I('pianqum');
                $data['pinyinjs']=I('pinyinjs');
                $data['ssxzq']=I('ssxzq');
                $data['dituzb']=I('zuobiao');
                $data['whrid']=$whrid;
                $data['bumen']=$yhbm;
                $data['adduid']=session('uid');
                $data['gongsiid']=session('gongsiid');
                $isok=M('pianqu')->add($data);
                if ($isok) {
                    $this->success('添加成功');
                }else{
                    $this->error('添加失败');
                }
            } else {
                $this->ssxzq=M('xingzhengqu')->where(array('gongsiid'=>session('gongsiid')))->select();
                $this->display();
            }
        }
        // 更新片区
        public function editPianqu(){
            $id=I('id');
            $whrid=M('pianqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(126,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $condition['gongsiid']=session('gongsiid');
                $condition['id']=array('neq',$id);
                $ssxzq=I('ssxzq');
                $pianqum=I('pianqum');
                $condition['ssxzq']=$ssxzq;
                $condition['pianqum']=$pianqum;
                $cfpq=M('pianqu')->where($condition)->find();
                if($cfpq){
                    $this->error('片区已存在');
                }
                $whrid=I('whrid');
                $yhbm=yhbm($whrid,1);
                $yh = _rbac_btn_show(126,0,$whrid);
                if (!$yh || !$whrid) {
                    $this->error('异常错误！');
                }
                $data['whrid']=$whrid;
                $data['bumen']=$yhbm;
                $data['pianqum']=I('pianqum');
                $data['pinyinjs']=I('pinyinjs');
                $data['ssxzq']=I('ssxzq');
                $data['dituzb']=I('zuobiao');
                $isok=M("pianqu")->where(array('id'=>$id))->save($data);
                if ($isok){
                    $this->success('更新成功');
                }else{
                    $this->error('更新失败');
                }
            } else {
                $this->pianqu=M('pianqu')->where(array('id'=>$id))->find();
                $this->user=zym($this->pianqu['whrid'],5);
                $this->ssxzq=M('xingzhengqu')->where(array('gongsiid'=>session('gongsiid')))->select();
                $this->display();
            }
        }
        // 删除片区
        public function delPianqu(){
            $id=I('id');
            $whrid=M('pianqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(128,0,$whrid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $xqshu=M('xiaoqu')->where(array('sspianqu'=>$id))->count();
            $fyshu=M('fangyuan')->where(array('pianqu'=>$id))->count();
            if ($xqshu==0 && $fyshu==0){
                $isok=M('pianqu')->where(array('id'=>$id))->delete();
            } else {
                $this->error('请先转移数据');
            }
            if ($isok){
                $this->success('删除成功');
            }else{
                $this->error('删除失败');
            }
        }
        // 小区列表
        public function Xiaoqu() {
            if (I('is_ajax')) {
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                $map .= " where gongsiid=".session('gongsiid');
                $x = _rbac_lists_where(129,0);
                if ($x && $x != "all" && $x != "me") {
                    $map .= " and bumen in ({$x})";
                }elseif ($x == "me") {
                    $map .= " and id=".session('uid');
                }elseif ($x == false) {
                    $map .= " and id=0";
                }
                $condition="gongsiid=".session('gongsiid');
                $sousuo=I('sousuo');
                if ($sousuo) {
                    $condition.=" and ((xiaoqum like '%$sousuo%') or (pinyinjs like '%$sousuo%'))";
                }
                if ($field && $order) {
                    $xqpx.="order by ".$field." ".$order;
                } else {
                    $xqpx.="order by id DESC";
                }
                $db = M('xiaoqu');
                $count = $db->query("select count(*) from (select * from __XIAOQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id");
                $Page = new \Think\Page($count['0']['count(*)'],$limit);
                $list="select * from (select * from __XIAOQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id ".$xqpx." limit ".$Page->firstRow.','.$Page->listRows;
                $data = $db->query($list);
                foreach ($data as $key => $value) {
                    $data[$key]['img'] = get_x_img($value['id']);
                    $data[$key]['pqm'] = zym($value['sspianqu'],2);
                    $data[$key]['xzqm'] = zym($value['ssxzq'],1);
                    $data[$key]['whbm'] = yhbm($value['whrid'],3);
                    $data[$key]['whr'] = zym($value['whrid'],5);
                    $data[$key]['tjr'] = zym($value['adduid'],5);
                    $is_rbacxq = _rbac_btn_show(175,0,$value['whrid']);
                    $is_rbacgx = _rbac_btn_show(132,0,$value['whrid']);
                    $is_rbaczy = _rbac_btn_show(533,0,$value['whrid']);
                    $is_rbacsc = _rbac_btn_show(134,0,$value['whrid']);
                    $data[$key]['rbacxq'] = $is_rbacxq ? 1 : 0;
                    $data[$key]['rbacgx'] = $is_rbacgx ? 1 : 0;
                    $data[$key]['rbaczy'] = $is_rbaczy ? 1 : 0;
                    $data[$key]['rbacsc'] = $is_rbacsc ? 1 : 0;
                    $data[$key]['pinyinjs'] = $value['pinyinjs'] ? $value['pinyinjs'] : "——";
                    $data[$key]['dituzb'] = $value['dituzb'] ? $value['dituzb'] : "——";
                    $data[$key]['xxm'] = $value['ssxuexiao'] ? zym($value['ssxuexiao'],4) : "——";
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count['0']['count(*)'],
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $this->display();
            }
        }
        // 添加小区
        public function addXiaoqu(){
            $is_rbac = _rbac_node_show(130);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                if (I('youzheng') && !is_numeric(I('youzheng'))) {
                    $this->error('邮政编码只能为数字！');
                } 
                
                $condition['gongsiid']=session('gongsiid');
                $ssxzq=I('ssxzq');
                $sspianqu=I('sspianqu');
                $xiaoqum=I('xiaoqum');
                $condition['ssxzq']=$ssxzq;
                $condition['sspianqu']=$sspianqu;
                $condition['xiaoqum']=$xiaoqum;
                $cfxq=M('xiaoqu')->where($condition)->find();
                if($cfxq){
                    $this->error('小区已存在');
                }
                $data['shijian']=time();
                $data['ssxzq']=$ssxzq;
                $data['dituzb']=I('dituzb');
                $data['jiedao']=I('jiedao');
                $data['jianjie']=I('jianjie');
                $data['xiaoqum']=$xiaoqum;
                if (I('csjunjia')) {
                    $data['csjunjia']=I('csjunjia');
                }
                $whrid=I('whrid');
                $yhbm=yhbm($whrid,1);
                $yh = _rbac_btn_show(130,0,$whrid);
                if (!$yh || !$whrid) {
                    $this->error('异常错误！');
                }
                $data['pinyinjs']=I('pinyinjs');
                $data['sspianqu']=$sspianqu;
                $data['xiaoqudz']=I('xiaoqudz');
                $data['youzheng']=I('youzheng');
                $data['ssxuexiao']=I('ssxuexiao');
                $data['whrid']=$whrid;
                $data['bumen']=$yhbm;
                $data['adduid']=session('uid');
                $data['gongsiid']=session('gongsiid');
                $isok=M("xiaoqu")->add($data);
                if ($isok) {
                    $this->success('添加成功');
                }else{
                    $this->error('添加失败');
                }
            } else {
                $this->xuequ=M('xuequ')->where(array('gongsiid'=>session('gongsiid')))->select();
                $this->ssxzq=M('xingzhengqu')->where(array('gongsiid'=>session('gongsiid')))->select();
                $this->display();
            }
        }
        // 更新小区
        public function editXiaoqu(){
            $id=I('id');
            $whrid=M('xiaoqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(132,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $condition['gongsiid']=session('gongsiid');
                $condition['id']=array('neq',$id);
                $ssxzq=I('ssxzq');
                $sspianqu=I('sspianqu');
                $xiaoqum=I('xiaoqum');
                $condition['ssxzq']=$ssxzq;
                $condition['sspianqu']=$sspianqu;
                $condition['xiaoqum']=$xiaoqum;
                $cfxq=M('xiaoqu')->where($condition)->find();
                if($cfxq){
                    $this->error('小区已存在');
                }
                $whrid=I('whrid');
                $yhbm=yhbm($whrid,1);
                $yh = _rbac_btn_show(132,0,$whrid);
                if (!$yh || !$whrid) {
                    $this->error('异常错误！');
                }
                $data['whrid']=$whrid;
                $data['bumen']=$yhbm;
                $data['ssxzq']=$ssxzq;
                $data['dituzb']=I('dituzb');
                $data['jiedao']=I('jiedao');
                $data['jianjie']=I('jianjie');
                $data['xiaoqum']=$xiaoqum;
                if (I('csjunjia')) {
                    $data['csjunjia']=I('csjunjia');
                }
                $data['pinyinjs']=I('pinyinjs');
                $data['sspianqu']=$sspianqu;
                $data['xiaoqudz']=I('xiaoqudz');
                $data['youzheng']=I('youzheng');
                $data['ssxuexiao']=I('ssxuexiao');
                $isok=M("xiaoqu")->where(array('id'=>$id))->save($data);
                if ($isok){
                    if (I('ssxuexiao')) {
                        M('fangyuan')->where(array('xiaoqu'=>$id))->setField('xuequ',1);
                    }
                    $this->success('更新成功');
                }else{
                    $this->error('更新失败');
                }
            } else {
                $this->xiaoqu=M('xiaoqu')->where(array('id'=>$id))->find();
                $this->user=zym($this->xiaoqu['whrid'],5);
                $this->xuequ=M('xuequ')->where(array('gongsiid'=>session('gongsiid')))->select();
                $this->ssxzq=M('xingzhengqu')->where(array('gongsiid'=>session('gongsiid')))->select();
                $this->sspianqu=M('pianqu')->where(array('gongsiid'=>session('gongsiid'),'ssxzq'=>$this->xiaoqu['ssxzq']))->select();
                $this->display();
            }
        }
        // 删除小区
        public function delXiaoqu(){
            $id=I('id');
            $whrid=M('xiaoqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(134,0,$whrid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $zdshu=M('zdxinxi')->where(array('xqid'=>$id))->count();
            $fyshu=M('fangyuan')->where(array('xiaoqu'=>$id))->count();
            if ($zdshu==0 && $fyshu==0){
                $isok=M('xiaoqu')->where(array('id'=>$id))->delete();
            } else {
                $this->error('请先转移数据');
            }
            if ($isok){
                $this->success('删除成功');
            }else{
                $this->error('删除失败');
            }
        }
        // 学区列表
        public function Xuequ() {
            if (I('is_ajax')) {
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                $map .= " where gongsiid=".session('gongsiid');
                $x = _rbac_lists_where(135,0);
                if ($x && $x != "all" && $x != "me") {
                    $map .= " and bumen in ({$x})";
                }elseif ($x == "me") {
                    $map .= " and id=".session('uid');
                }elseif ($x == false) {
                    $map .= " and id=0";
                }
                $condition="gongsiid=".session('gongsiid');
                $sousuo=I('sousuo');
                if ($sousuo) {
                    $condition.=" and ((xuexiaom like '%$sousuo%') or (pinyinjs like '%$sousuo%'))";
                }
                if ($field && $order) {
                    $pqpx.="order by ".$field." ".$order;
                } else {
                    $pqpx.="order by id DESC";
                }
                $db = M('xuequ');
                $count = $db->query("select count(*) from (select * from __XUEQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id");
                $Page = new \Think\Page($count['0']['count(*)'],$limit);
                $list="select * from (select * from __XUEQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id ".$pqpx." limit ".$Page->firstRow.','.$Page->listRows;
                $data = $db->query($list);
                foreach ($data as $key => $value) {
                    $data[$key]['ssbm'] = zym($value['bumen'],6);
                    $data[$key]['whbm'] = yhbm($value['whrid'],3);
                    $data[$key]['whr'] = zym($value['whrid'],5);
                    $data[$key]['tjr'] = zym($value['adduid'],5);
                    $is_rbacgx = _rbac_btn_show(138,0,$value['whrid']);
                    $is_rbacsc = _rbac_btn_show(140,0,$value['whrid']);
                    $data[$key]['rbacgx'] = $is_rbacgx ? 1 : 0;
                    $data[$key]['rbacsc'] = $is_rbacsc ? 1 : 0;
                    $data[$key]['duikou'] = $value['duikou'] ? $value['duikou'] : "——";
                    $data[$key]['pinyinjs'] = $value['pinyinjs'] ? $value['pinyinjs'] : "——";
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count['0']['count(*)'],
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $this->display();
            }
        }
        // 添加学区
        public function addXuequ(){
            $is_rbac = _rbac_node_show(136);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $condition['gongsiid']=session('gongsiid');
                $xuexiaom=I('xuexiaom');
                $condition['xuexiaom']=$xuexiaom;
                $cfxzq=M('xuequ')->where($condition)->find();
                if($cfxzq){
                    $this->error('学校已存在');
                }
                $whrid=I('whrid');
                $yhbm=yhbm($whrid,1);
                $yh = _rbac_btn_show(136,0,$whrid);
                if (!$yh || !$whrid) {
                    $this->error('异常错误！');
                }
                $data['xuexiaom']=$xuexiaom;
                $data['pinyinjs']=I('pinyinjs');
                $data['xuexiaodz']=I('xuexiaodz');
                $data['duikou']=I('duikou');
                $data['shijian']=time();
                $data['whrid']=$whrid;
                $data['bumen']=$yhbm;
                $data['adduid']=session('uid');
                $data['gongsiid']=session('gongsiid');
                $isok=M('Xuequ')->add($data);
                if ($isok) {
                    $this->success('添加成功');
                }else{
                    $this->error('添加失败');
                }
            } else {
                $this->display();
            }
        }
        // 更新学区
        public function editXuequ(){
            $id=I('id');
            $whrid=M('xuequ')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(138,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $condition['gongsiid']=session('gongsiid');
                $condition['id']=array('neq',$id);
                $xuexiaom=I('xuexiaom');
                $condition['xuexiaom']=$xuexiaom;
                $cfxzq=M('xuequ')->where($condition)->find();
                if($cfxzq){
                    $this->error('学校已存在');
                }
                $whrid=I('whrid');
                $yhbm=yhbm($whrid,1);
                $yh = _rbac_btn_show(138,0,$whrid);
                if (!$yh || !$whrid) {
                    $this->error('异常错误！');
                }
                $data['whrid']=$whrid;
                $data['bumen']=$yhbm;
                $data['xuexiaom']=$xuexiaom;
                $data['pinyinjs']=I('pinyinjs');
                $data['xuexiaodz']=I('xuexiaodz');
                $data['duikou']=I('duikou');
                $isok=M("Xuequ")->where(array('id'=>$id))->save($data);
                if ($isok){
                    $this->success('更新成功');
                }else{
                    $this->error('更新失败');
                }
            } else {
                $this->xuequ=M('Xuequ')->where(array('id'=>$id))->find();
                $this->user=zym($this->xuequ['whrid'],5);
                $this->display();
            }
        }
        // 删除学区
        public function delXuequ(){
            $id=I('id');
            $whrid=M('xuequ')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(140,0,$whrid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $isok=M('Xuequ')->where(array('id'=>$id))->delete();
            if ($isok){
                $this->success('删除成功');
            }else{
                $this->error('删除失败');
            }
        }
        // 小区详情
        public function xiaoqurr(){
            $id=I('id');
            $whrid=M('xiaoqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(175,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            $this->jcpz=M('jcpz')->where(array('gongsiid'=>session('gongsiid')))->field('dtmiyao,dtzuobiao')->find();
            $xiaoqu=M('xiaoqu')->where(array('id'=>$id))->find();
            $this->pianqu=M('pianqu')->where(array('id'=>$xiaoqu['sspianqu']))->getField('pianqum');
            $this->xingzhengqu=M('xingzhengqu')->where(array('id'=>$xiaoqu['ssxzq']))->getField('xzqming');
            $this->xiaoqu=$xiaoqu;
            $this->xuexiao=M('xuequ')->where(array('id'=>$xiaoqu['ssxuexiao']))->getField('xuexiaom');
            $this->zdshu=0;
            $this->fjshu=0;
            $this->wuyelx=M('peizhi')->where(array('pzming'=>'wuyelx','lxid'=>$xiaoqu['wuyelx']))->getField('lxming');
            $this->wuyezz=M('peizhi')->where(array('pzming'=>'wuyezz','lxid'=>$xiaoqu['wuyezz']))->getField('lxming');
            $this->xmjibie=M('peizhi')->where(array('pzming'=>'xmjibie','lxid'=>$xiaoqu['xmjibie']))->getField('lxming');
            $this->gongqifs=M('peizhi')->where(array('pzming'=>'gongqifs','lxid'=>$xiaoqu['gongqifs']))->getField('lxming');
            $this->kangzhen=M('peizhi')->where(array('pzming'=>'kangzhen','lxid'=>$xiaoqu['kangzhen']))->getField('lxming');
            $this->ceweizldw=M('peizhi')->where(array('pzming'=>'ceweizldw','lxid'=>$xiaoqu['ceweizldw']))->getField('lxming');
            $this->gongdianlx=M('peizhi')->where(array('pzming'=>'gongdianlx','lxid'=>$xiaoqu['gongdianlx']))->getField('lxming');
            $this->gongshuilx=M('peizhi')->where(array('pzming'=>'gongshuilx','lxid'=>$xiaoqu['gongshuilx']))->getField('lxming');
            $this->spjzleixing=M('peizhi')->where(array('pzming'=>'spjzleixing','lxid'=>$xiaoqu['spjzleixing']))->getField('lxming');
            $jiegou1=M('xiaoqu')->where(array('id'=>$id))->getField('jiegou');
            if ($jiegou1) {
                $condition="pzming = 'jiegou'";
                $condition.=" and lxid in ($jiegou1)";
                $this->jiegou=M('peizhi')->query("select * from __PEIZHI__ where {$condition}");
            }
            $yongtu1=M('xiaoqu')->where(array('id'=>$id))->getField('yongtu');
            if ($yongtu1) {
                $condition="pzming = 'yongtu'";
                $condition.=" and lxid in ($yongtu1)";
                $this->yongtu=M('peizhi')->query("select * from __PEIZHI__ where {$condition}");
            }
            $dianshi1=M('xiaoqu')->where(array('id'=>$id))->getField('dianshi');
            if ($dianshi1) {
                $condition="pzming = 'dianshi'";
                $condition.=" and lxid in ($dianshi1)";
                $this->dianshi=M('peizhi')->query("select * from __PEIZHI__ where {$condition}");
            }
            $tongxun1=M('xiaoqu')->where(array('id'=>$id))->getField('tongxun');
            if ($tongxun1) {
                $condition="pzming = 'tongxun'";
                $condition.=" and lxid in ($tongxun1)";
                $this->tongxun=M('peizhi')->query("select * from __PEIZHI__ where {$condition}");
            }
            $chanquan1=M('xiaoqu')->where(array('id'=>$id))->getField('chanquan');
            if ($chanquan1) {
                $condition="pzming = 'chanquan'";
                $condition.=" and lxid in ($chanquan1)";
                $this->chanquan=M('peizhi')->query("select * from __PEIZHI__ where {$condition}");
            }
            $sqanquan1=M('xiaoqu')->where(array('id'=>$id))->getField('sqanquan');
            if ($sqanquan1) {
                $condition="pzming = 'sqanquan'";
                $condition.=" and lxid in ($sqanquan1)";
                $this->sqanquan=M('peizhi')->query("select * from __PEIZHI__ where {$condition}");
            }
            $cainuanfs1=M('xiaoqu')->where(array('id'=>$id))->getField('cainuanfs');
            if ($cainuanfs1) {
                $condition="pzming = 'cainuanfs'";
                $condition.=" and lxid in ($cainuanfs1)";
                $this->cainuanfs=M('peizhi')->query("select * from __PEIZHI__ where {$condition}");
            }
            $fwleixing1=M('xiaoqu')->where(array('id'=>$id))->getField('fwleixing');
            if ($fwleixing1) {
                $condition="pzming = 'fwleixing'";
                $condition.=" and lxid in ($fwleixing1)";
                $this->fwleixing=M('peizhi')->query("select * from __PEIZHI__ where {$condition}");
            }
            $wldibanlx1=M('xiaoqu')->where(array('id'=>$id))->getField('wldibanlx');
            if ($wldibanlx1) {
                $condition="pzming = 'wldibanlx'";
                $condition.=" and lxid in ($wldibanlx1)";
                $this->wldibanlx=M('peizhi')->query("select * from __PEIZHI__ where {$condition}");
            }
            $gongshuifs1=M('xiaoqu')->where(array('id'=>$id))->getField('gongshuifs');
            if ($gongshuifs1) {
                $condition="pzming = 'gongshuifs'";
                $condition.=" and lxid in ($gongshuifs1)";
                $this->gongshuifs=M('peizhi')->query("select * from __PEIZHI__ where {$condition}");
            }
            $this->display();
        }
        // 修改小区详情
        public function xiugaixiaoqu(){
            $id=I('id');
            $whrid=M('xiaoqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(176,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $xgxqxq=I('xgxqxq');
                $xgxqzb=I('xgxqzb');
                $xgxqpt1=I('xgxqpt1');
                $xgxqpt2=I('xgxqpt2');
                $xgxqqs1=I('xgxqqs1');
                $xgxqqs2=I('xgxqqs2');
                if ($xgxqxq==1) {
                    if (I('chewei')) {
                        $data['chewei']=1;
                        $data['ceweizldw']=I('ceweizldw');
                        $data['dxiatcwsj']=I('dxiatcwsj');
                        $data['dxiatcwsl']=I('dxiatcwsl');
                        $data['dxiatcwzl']=I('dxiatcwzl');
                        $data['dshangtcwsj']=I('dshangtcwsj');
                        $data['dshangtcwsl']=I('dshangtcwsl');
                        $data['dshangtcwzl']=I('dshangtcwzl');
                    } else {
                        $data['chewei']=2;
                    }
                    if (I('dianti')) {
                        $data['dianti']=1;
                        $data['diantixq']=I('diantixq');
                    } else {
                        $data['dianti']=2;
                    }
                    $data['beizhu']=I('beizhu');
                    $data['jiedao']=I('jiedao');
                    $data['wuyedh']=I('wuyedh');
                    $data['wuyedz']=I('wuyedz');
                    $data['wuyemc']=I('wuyemc');
                    $data['jianjie']=I('jianjie');
                    $data['lvhualv']=I('lvhualv');
                    $data['wuyefei']=I('wuyefei');
                    $data['csjunjia']=I('csjunjia');
                    $data['gongqifs']=I('gongqifs');
                    $data['rongjilv']=I('rongjilv');
                    $data['xiaoqubm']=I('xiaoqubm');
                    $data['xiaoqudz']=I('xiaoqudz');
                    $data['youzheng']=I('youzheng');
                    $data['zhandimj']=I('zhandimj');
                    $data['jianzaond']=I('jianzaond');
                    $data['jianzhumj']=I('jianzhumj');
                    $data['ssxuexiao']=I('ssxuexiao');
                    $data['gongdianlx']=I('gongdianlx');
                    $data['gongshuilx']=I('gongshuilx');
                } elseif ($xgxqzb==1) {
                    $data['ditielx']=I('ditielx');
                    $data['jinrongjg']=I('jinrongjg');
                    $data['paichusuo']=I('paichusuo');
                    $data['ssxuexiao']=I('ssxuexiao');
                    $data['zhengfujg']=I('zhengfujg');
                    $data['gongjiaolx']=I('gongjiaolx');
                    $data['xiuxianyule']=I('xiuxianyule');
                    $data['yiliaojigou']=I('yiliaojigou');
                    $data['shangchangcs']=I('shangchangcs');
                } elseif ($xgxqpt1==1) {
                    if (I('chewei')) {
                        $data['chewei']=1;
                        $data['ceweizldw']=I('ceweizldw');
                        $data['dxiatcwsj']=I('dxiatcwsj');
                        $data['dxiatcwsl']=I('dxiatcwsl');
                        $data['dxiatcwzl']=I('dxiatcwzl');
                        $data['dshangtcwsj']=I('dshangtcwsj');
                        $data['dshangtcwsl']=I('dshangtcwsl');
                        $data['dshangtcwzl']=I('dshangtcwzl');
                    } else {
                        $data['chewei']=2;
                    }
                    if (I('dianti')) {
                        $data['dianti']=1;
                        $data['diantixq']=I('diantixq');
                    } else {
                        $data['dianti']=2;
                    }
                    $ds1=array_keys(I('dianshi'));
                    $ds2=implode(',',$ds1);
                    $data['dianshi']=$ds2;
                    $tx1=array_keys(I('tongxun'));
                    $tx2=implode(',',$tx1);
                    $data['tongxun']=$tx2;
                    $aq1=array_keys(I('sqanquan'));
                    $aq2=implode(',',$aq1);
                    $data['sqanquan']=$aq2;
                    $cn1=array_keys(I('cainuanfs'));
                    $cn2=implode(',',$cn1);
                    $data['cainuanfs']=$cn2;
                    $gs1=array_keys(I('gongshuifs'));
                    $gs2=implode(',',$gs1);
                    $data['gongshuifs']=$gs2;
                    $data['wuyedh']=I('wuyedh');
                    $data['wuyedz']=I('wuyedz');
                    $data['wuyelx']=I('wuyelx');
                    $data['wuyemc']=I('wuyemc');
                    $data['wuyezz']=I('wuyezz');
                    $data['dianfei']=I('dianfei');
                    $data['wuyefei']=I('wuyefei');
                    $data['gongqifs']=I('gongqifs');
                    $data['cainuanfy']=I('cainuanfy');
                    $data['gongdianlx']=I('gongdianlx');
                    $data['gongshuilx']=I('gongshuilx');
                } elseif ($xgxqpt2==1) {
                    if (I('yjfjzx')) {
                        $data['yjfjzx']=1;
                    } else {
                        $data['yjfjzx']=2;
                    }
                    if (I('wldiban')) {
                        $data['wldiban']=1;
                        $db1=array_keys(I('wldibanlx'));
                        $db2=implode(',',$db1);
                        $data['wldibanlx']=$db2;
                        $data['wldibangd']=I('wldibangd');
                    } else {
                        $data['wldiban']=2;
                    }
                    if (I('ygcanting')) {
                        $data['ygcanting']=1;
                        $data['ygcantingjj']=I('ygcantingjj');
                    } else {
                        $data['ygcanting']=2;
                    }
                    $data['zyktpp']=I('zyktpp');
                    $data['xfsjgyl']=I('xfsjgyl');
                    $data['zyktjsf']=I('zyktjsf');
                    $data['zyktgzsj']=I('zyktgzsj');
                } elseif ($xgxqqs1==1) {
                    $jg1=array_keys(I('jiegou'));
                    $jg2=implode(',',$jg1);
                    $data['jiegou']=$jg2;
                    $yt1=array_keys(I('yongtu'));
                    $yt2=implode(',',$yt1);
                    $data['yongtu']=$yt2;
                    $cq1=array_keys(I('chanquan'));
                    $cq2=implode(',',$cq1);
                    $data['chanquan']=$cq2;
                    $fw1=array_keys(I('fwleixing'));
                    $fw2=implode(',',$fw1);
                    $data['fwleixing']=$fw2;
                    $data['lvhualv']=I('lvhualv');
                    $data['csjunjia']=I('csjunjia');
                    $data['nianxian']=I('nianxian');
                    $data['rongjilv']=I('rongjilv');
                    $data['zhandimj']=I('zhandimj');
                    $data['jianzaond']=I('jianzaond');
                    $data['jianzhumj']=I('jianzhumj');
                    $data['ycqdanwei']=I('ycqdanwei');
                    $data['kaifashang']=I('kaifashang');
                    $data['kpshijian']=strtotime(I('kpshijian'));
                    $data['rzshijian']=strtotime(I('rzshijian'));
                } elseif ($xgxqqs2==1) {
                    if (I('5a')) {
                        $data['5a']=1;
                    } else {
                        $data['5a']=2;
                    }
                    if (I('zhuce')) {
                        $data['zhuce']=1;
                    } else {
                        $data['zhuce']=2;
                    }
                    if (I('youhui')) {
                        $data['youhui']=1;
                        $data['youhuizc']=I('youhuizc');
                    } else {
                        $data['youhui']=2;
                    }
                    $data['bzcjzmj']=I('bzcjzmj');
                    $data['wlmzxbz']=I('wlmzxbz');
                    $data['xmgaodu']=I('xmgaodu');
                    $data['xmjibie']=I('xmjibie');
                    $data['kangzhen']=I('kangzhen');
                    $data['spjzleixing']=I('spjzleixing');
                } else {
                    if (I('chewei')) {
                        $data['chewei']=1;
                        $data['ceweizldw']=I('ceweizldw');
                        $data['dxiatcwsj']=I('dxiatcwsj');
                        $data['dxiatcwsl']=I('dxiatcwsl');
                        $data['dxiatcwzl']=I('dxiatcwzl');
                        $data['dshangtcwsj']=I('dshangtcwsj');
                        $data['dshangtcwsl']=I('dshangtcwsl');
                        $data['dshangtcwzl']=I('dshangtcwzl');
                    } else {
                        $data['chewei']=2;
                    }
                    if (I('dianti')) {
                        $data['dianti']=1;
                        $data['diantixq']=I('diantixq');
                    } else {
                        $data['dianti']=2;
                    }
                    $data['beizhu']=I('beizhu');
                    $data['jiedao']=I('jiedao');
                    $data['wuyedh']=I('wuyedh');
                    $data['wuyedz']=I('wuyedz');
                    $data['wuyemc']=I('wuyemc');
                    $data['jianjie']=I('jianjie');
                    $data['lvhualv']=I('lvhualv');
                    $data['wuyefei']=I('wuyefei');
                    $data['csjunjia']=I('csjunjia');
                    $data['gongqifs']=I('gongqifs');
                    $data['rongjilv']=I('rongjilv');
                    $data['xiaoqubm']=I('xiaoqubm');
                    $data['xiaoqudz']=I('xiaoqudz');
                    $data['youzheng']=I('youzheng');
                    $data['zhandimj']=I('zhandimj');
                    $data['jianzaond']=I('jianzaond');
                    $data['jianzhumj']=I('jianzhumj');
                    $data['ssxuexiao']=I('ssxuexiao');
                    $data['gongdianlx']=I('gongdianlx');
                    $data['gongshuilx']=I('gongshuilx');
                }
                $isok=M('xiaoqu')->where(array('id'=>$id))->save($data);
                if ($isok){
                    $this->success('更新成功');
                }else{
                    $this->error('更新失败');
                }
            } else {
                $xgxqxq=I('xgxqxq');
                $xgxqzb=I('xgxqzb');
                $xgxqpt1=I('xgxqpt1');
                $xgxqpt2=I('xgxqpt2');
                $xgxqqs1=I('xgxqqs1');
                $xgxqqs2=I('xgxqqs2');
                if ($xgxqxq==1) {
                    $this->xuequ=M('xuequ')->where(array('gongsiid'=>session('gongsiid')))->select();
                    $this->gongqifs=M('peizhi')->where(array('pzming'=>'gongqifs','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->ceweizldw=M('peizhi')->where(array('pzming'=>'ceweizldw','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->gongdianlx=M('peizhi')->where(array('pzming'=>'gongdianlx','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->gongshuilx=M('peizhi')->where(array('pzming'=>'gongshuilx','zhuangtai'=>1))->order('xsshunxu asc')->select();
                } elseif ($xgxqzb==1) {
                    $this->xuequ=M('xuequ')->where(array('gongsiid'=>session('gongsiid')))->select();
                } elseif ($xgxqpt1==1) {
                    $this->wuyelx=M('peizhi')->where(array('pzming'=>'wuyelx','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->wuyezz=M('peizhi')->where(array('pzming'=>'wuyezz','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->dianshi=M('peizhi')->where(array('pzming'=>'dianshi','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->tongxun=M('peizhi')->where(array('pzming'=>'tongxun','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->gongqifs=M('peizhi')->where(array('pzming'=>'gongqifs','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->sqanquan=M('peizhi')->where(array('pzming'=>'sqanquan','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->cainuanfs=M('peizhi')->where(array('pzming'=>'cainuanfs','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->ceweizldw=M('peizhi')->where(array('pzming'=>'ceweizldw','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->gongdianlx=M('peizhi')->where(array('pzming'=>'gongdianlx','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->gongshuifs=M('peizhi')->where(array('pzming'=>'gongshuifs','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->gongshuilx=M('peizhi')->where(array('pzming'=>'gongshuilx','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $dianshi1=M('xiaoqu')->where(array('id'=>$id))->getField('dianshi');
                    $this->dianshi2=explode(",", $dianshi1);
                    $tongxun1=M('xiaoqu')->where(array('id'=>$id))->getField('tongxun');
                    $this->tongxun2=explode(",", $tongxun1);
                    $sqanquan1=M('xiaoqu')->where(array('id'=>$id))->getField('sqanquan');
                    $this->sqanquan2=explode(",", $sqanquan1);
                    $cainuanfs1=M('xiaoqu')->where(array('id'=>$id))->getField('cainuanfs');
                    $this->cainuanfs2=explode(",", $cainuanfs1);
                    $gongshuifs1=M('xiaoqu')->where(array('id'=>$id))->getField('gongshuifs');
                    $this->gongshuifs2=explode(",", $gongshuifs1);
                } elseif ($xgxqpt2==1) {
                    $this->wldibanlx=M('peizhi')->where(array('pzming'=>'wldibanlx','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $wldibanlx1=M('xiaoqu')->where(array('id'=>$id))->getField('wldibanlx');
                    $this->wldibanlx2=explode(",", $wldibanlx1);
                } elseif ($xgxqqs1==1) {
                    $this->jiegou=M('peizhi')->where(array('pzming'=>'jiegou','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->yongtu=M('peizhi')->where(array('pzming'=>'yongtu','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->chanquan=M('peizhi')->where(array('pzming'=>'chanquan','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->fwleixing=M('peizhi')->where(array('pzming'=>'fwleixing','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $jiegou1=M('xiaoqu')->where(array('id'=>$id))->getField('jiegou');
                    $this->jiegou2=explode(",", $jiegou1);
                    $yongtu1=M('xiaoqu')->where(array('id'=>$id))->getField('yongtu');
                    $this->yongtu2=explode(",", $yongtu1);
                    $chanquan1=M('xiaoqu')->where(array('id'=>$id))->getField('chanquan');
                    $this->chanquan2=explode(",", $chanquan1);
                    $fwleixing1=M('xiaoqu')->where(array('id'=>$id))->getField('fwleixing');
                    $this->fwleixing2=explode(",", $fwleixing1);
                } elseif ($xgxqqs2==1) {
                    $this->xmjibie=M('peizhi')->where(array('pzming'=>'xmjibie','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->kangzhen=M('peizhi')->where(array('pzming'=>'kangzhen','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->spjzleixing=M('peizhi')->where(array('pzming'=>'spjzleixing','zhuangtai'=>1))->order('xsshunxu asc')->select();
                } else {
                    $this->xuequ=M('xuequ')->where(array('gongsiid'=>session('gongsiid')))->select();
                    $this->gongqifs=M('peizhi')->where(array('pzming'=>'gongqifs','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->ceweizldw=M('peizhi')->where(array('pzming'=>'ceweizldw','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->gongdianlx=M('peizhi')->where(array('pzming'=>'gongdianlx','zhuangtai'=>1))->order('xsshunxu asc')->select();
                    $this->gongshuilx=M('peizhi')->where(array('pzming'=>'gongshuilx','zhuangtai'=>1))->order('xsshunxu asc')->select();
                }
                $this->xiaoqu=M('xiaoqu')->where(array('id'=>$id))->find();
                $this->display();
            }
        }
        // 调整坐标
        public function tzdtzb(){
            $id=I('id');
            $whrid=M('xiaoqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(180,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $data['dituzb']=I('dituzb');
                $isok=M("xiaoqu")->where(array('id'=>$id))->save($data);
                if ($isok){
                    $this->success('更新成功');
                }else{
                    $this->error('更新失败');
                }
            } else {
                $this->xiaoqu=M('xiaoqu')->where(array('id'=>$id))->find();
                $this->jcpz=M('jcpz')->where(array('gongsiid'=>session('gongsiid')))->field('dtmiyao,dtzuobiao')->find();
                $this->display();
            }
        }
        /**
        * webuploader 图片上传
        */
        function scxqtp() {
            $xqid=I('xqid');
            $whrid=M('xiaoqu')->where(array('id'=>$xqid))->getField('whrid');
            $is_rbac = _rbac_btn_show(186,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                // 根据自己的业务调整上传路径、允许的格式、文件大小
                $path = "/Upload/".session('gongsiid')."/xiaoqu/".$xqid;
                ajax_upload_xq($path);
            } else {
                $this->display();
            }
        }
        /**
        * [xq_pic_setfengmian 异步小区图片为封面]
        * @return [json] [description]
        */
        public function xq_pic_setfengmian(){
            $id=I('xq_pic_id');
            //根据图片id查找小区图片的小区id号xqid
            $xqid = M('xqphoto')->where(array('id'=>$id))->getField('xqid');
            $adduid=M('xqphoto')->where(array('id'=>$id))->getField('uid');
            $is_rbac = _rbac_btn_show(485,0,$adduid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            M('xqphoto')->where(array('xqid'=>$xqid,'fengmian'=>1))->setField(array('fengmian'=>0));
            $r = M('xqphoto')->where(array('id'=>$id))->setField(array('fengmian'=>1));
            if ($r) {
                $this->success('设置成功');
            }else{
                $this->error('设置失败');
            }
        }
        /**
        * [xq_pic_del 异步删除图片]
        * @return [json] [description]
        */
        public function xq_pic_del(){
            $id=I('xq_pic_id');
            //根据图片id查看当前是否还有当前小区的图片
            $xqid = M('xqphoto')->where(array('id'=>$id))->getField('xqid');
            $adduid=M('xqphoto')->where(array('id'=>$id))->getField('uid');
            $is_rbac = _rbac_btn_show(188,0,$adduid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $piccount = M('xqphoto')->where(array('xqid'=>$xqid))->count();
            $dp=M('xqphoto');
            //删除当前图片
            if($id){
                $plist = $dp->where(array('id'=>$id))->find();
                if ($plist){
                    unlink('./Upload/'.$plist['gongsiid'].'/xiaoqu/'.$plist['xqid'].'/'.$plist['image']);
                    unlink('./Upload/'.$plist['gongsiid'].'/xiaoqu/'.$plist['xqid'].'/t_'.$plist['image']);
                    $dp->where(array('id'=>$id))->delete();
                    $data=array('pics'=>$plist);
                    //删除最后一个小区图片后给xiaoqu表的tupian字段置 0
                    if ($piccount==1) {
                        M('xiaoqu')->where(array('id'=>$xqid))->setField('tupian',0);
                    } else {
                        M('xiaoqu')->where(array('id'=>$xqid))->setField('tupian',1);
                    }
                    $this->success('删除成功');
                }else{
                    $this->error('删除失败');
                }
            }
        }
        //批量删除小区图片
        public function xq_pic_dels(){
            $is_rbac = _rbac_node_show(486);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $ids=I('xq_pic_ids');
            foreach ($ids as $key => $value) {
                $adduid=M('xqphoto')->where(array('id'=>$value))->getField('uid');
                $is_rbac = _rbac_btn_show(486,0,$adduid);
                if (!$is_rbac) {
                    $this->error("您选择了权限范围之外的图片！");
                }
            }
            $xqid = M('xqphoto')->where(array('id'=>$ids[0]))->getField('xqid');
            if(is_array($ids)){
                $where = 'id in('.implode(',',$ids).')';
                $dp=M('xqphoto');
                //删除小区图片文件
                foreach ($ids as $value) {
                    $plist = $dp->where(array('id'=>$value))->find();
                    unlink('./Upload/'.$plist['gongsiid'].'/xiaoqu/'.$plist['xqid'].'/'.$plist['image']);
                    unlink('./Upload/'.$plist['gongsiid'].'/xiaoqu/'.$plist['xqid'].'/t_'.$plist['image']);
                }
                //删除图片记录
                $dp->where($where)->delete();
                //删除最后一个小区图片后给xiaoqu表的tupian字段置 0
                $nopic = M('xqphoto')->where(array('xqid'=>$xqid))->count();
                if ($nopic<=0) {
                    M('xiaoqu')->where(array('id'=>$xqid))->setField('tupian',0);
                } else {
                    M('xiaoqu')->where(array('id'=>$xqid))->setField('tupian',1);
                }
                $this->success('删除成功');
            }else{
                $this->error('删除失败'); 
            }
        }
        //批量下载小区图片
        public function xq_pic_downloads(){
            $is_rbac = _rbac_node_show(487);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $ids=I('xq_pic_ids');
            foreach ($ids as $key => $value) {
                $adduid=M('xqphoto')->where(array('id'=>$value))->getField('uid');
                $is_rbac = _rbac_btn_show(487,0,$adduid);
                if (!$is_rbac) {
                    $this->error("您选择了权限范围之外的图片！");
                }
            }
            $where = 'id in('.implode(',',$ids).')';
            $dp=M('xqphoto');
            $plist = $dp->where($where)->field('id,gongsiid,xqid,image')->select();
            $zip = new \ZipArchive; 
            if ($plist) {
                //压缩文件名(临时文件)
                $filename = './Upload/'.$plist[0]['gongsiid'].'/xiaoqu/'.$plist[0]['xqid'].'/'.md5($plist[0]['xqid']).'.zip';
                $downname = I("server.HTTP_HOST").'/Upload/'.$plist[0]['gongsiid'].'/xiaoqu/'.$plist[0]['xqid'].'/'.md5($plist[0]['xqid']).'.zip';
                //p($downname);die;
            }
            //新建zip压缩包
            $zip->open($filename,\ZipArchive::OVERWRITE | \ZipArchive::CREATE);
            //把图片一张一张加进去压缩
            foreach ($plist as $value) {
                $zip->addFile('./Upload/'.$value['gongsiid'].'/xiaoqu/'.$value['xqid'].'/'.$value['image']);
                $zip->renameName('./Upload/'.$value['gongsiid'].'/xiaoqu/'.$value['xqid'].'/'.$value['image'],$value['image']);
            }
            //打包zip
            $zip->close();
            //可以直接重定向下载
            //header('Location:'.$downname);
            $this->success($downname);
        }
        //设置图片类型
        public function settupianleixing(){
            $is_rbac = _rbac_node_show(488);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                $ids=explode(",",I('xq_pic_ids'));
                foreach ($ids as $key => $value) {
                    $adduid=M('xqphoto')->where(array('id'=>$value))->getField('uid');
                    $is_rbac = _rbac_btn_show(488,0,$adduid);
                    if (!$is_rbac) {
                        $this->error("您选择了权限范围之外的图片！");
                    }
                }
                $ids1=I('xq_pic_ids');
                $tpleixing = I('tpleixing');
                if ($tpleixing=="") {
                    $this->error("请选择图片类型");
                }
                $where = 'id in('.$ids1.')';
                $dp=M('xqphoto');
                $plist = $dp->where($where)->setField(array('leixing' => $tpleixing ));
                if ($plist) {
                    $this->success("设置成功");
                }else{
                    $this->error("设置失败");
                }
            } else {
                $this->tpleixing = M('Peizhi')->where(array('pzming'=>'xqtplx','zhuangtai'=>1))->order('xsshunxu asc')->select();
                $this->display();// 输出模板
            }
        }
        //行政区、片区、小区信息转移
        public function xxzhuanyi(){
            $xzqid=I('xzqid');
            $pqid=I('pqid');
            $xqid=I('xqid');
            if ($xzqid) {
                $whrid=M('xingzhengqu')->where(array('id'=>$xzqid))->getField('whrid');
            } elseif ($pqid) {
                $whrid=M('pianqu')->where(array('id'=>$pqid))->getField('whrid');
            } elseif ($xqid) {
                $whrid=M('xiaoqu')->where(array('id'=>$xqid))->getField('whrid');
            }
            $is_rbac = _rbac_btn_show(533,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if ($xzqid) {
                $pqshu=M('pianqu')->where(array('ssxzq'=>$xzqid))->count();
                $xqshu=M('xiaoqu')->where(array('ssxzq'=>$xzqid))->count();
                $fyshu=M('fangyuan')->where(array('xingzhengqu'=>$xzqid))->count();
            } elseif ($pqid) {
                $xqshu=M('xiaoqu')->where(array('sspianqu'=>$pqid))->count();
                $fyshu=M('fangyuan')->where(array('pianqu'=>$pqid))->count();
            } elseif ($xqid) {
                $zdshu=0;
                $fyshu=M('fangyuan')->where(array('xiaoqu'=>$xqid))->count();
            }
            if (IS_POST) {
                $xxzqid=I('xxzqid');
                $xpqid=I('xpqid');
                $xxqid=I('xxqid');
                $yxzqid=$xzqid;
                $ypqid=$pqid;
                $yxqid=$xqid;
                if ($xxzqid && $yxzqid) {
                    if($xxzqid == $yxzqid){
                        $this->error("不能转移给自己！");
                    }
                    if(($pqshu == 0) && ($xqshu == 0) && ($fyshu == 0)){
                        $this->error("行政区下无数据！");
                    }
                    M('pianqu')->where(array('ssxzq'=>$yxzqid))->setField('ssxzq',$xxzqid);
                    M('xiaoqu')->where(array('ssxzq'=>$yxzqid))->setField('ssxzq',$xxzqid);
                    M('fangyuan')->where(array('xingzhengqu'=>$yxzqid))->setField('xingzhengqu',$xxzqid);
                } elseif ($xpqid && $ypqid) {
                    if($xpqid == $ypqid){
                        $this->error("不能转移给自己！");
                    }
                    if(($xqshu == 0) && ($fyshu == 0)){
                        $this->error("片区下无数据！");
                    }
                    M('xiaoqu')->where(array('sspianqu'=>$ypqid))->setField('sspianqu',$xpqid);
                    M('fangyuan')->where(array('pianqu'=>$ypqid))->setField('pianqu',$xpqid);
                } elseif ($xxqid && $yxqid) {
                    if($xxqid == $yxqid){
                        $this->error("不能转移给自己！");
                    }
                    if(($zdshu == 0) && ($fyshu == 0)){
                        $this->error("小区下无数据！");
                    }
                    M('fangyuan')->where(array('xiaoqu'=>$yxqid))->setField('xiaoqu',$xxqid);
                }
                $this->success('转移成功');
            }else{
                if ($xzqid) {
                    $this->pqshu=$pqshu;
                    $this->xqshu=$xqshu;
                    $this->fyshu=$fyshu;
                    $this->xingzhengqu=M('xingzhengqu')->where(array('gongsiid'=>session('gongsiid'),'id'=>array('neq',$xzqid)))->order('shijian asc')->select();
                } elseif ($pqid) {
                    $this->xqshu=$xqshu;
                    $this->fyshu=$fyshu;
                    $ssxzq=M('pianqu')->where(array('gongsiid'=>session('gongsiid'),'id'=>$pqid))->getField('ssxzq');
                    $this->pianqu=M('pianqu')->where(array('gongsiid'=>session('gongsiid'),'ssxzq'=>$ssxzq,'id'=>array('neq',$pqid)))->order('ssxzq asc')->select();
                } elseif ($xqid) {
                    $this->zdshu=0;
                    $this->fyshu=$fyshu;
                    $sspianqu=M('xiaoqu')->where(array('gongsiid'=>session('gongsiid'),'id'=>$xqid))->getField('sspianqu');
                    $this->xiaoqu=M('xiaoqu')->where(array('gongsiid'=>session('gongsiid'),'sspianqu'=>$sspianqu,'id'=>array('neq',$xqid)))->order('ssxzq asc,sspianqu')->select();
                }
                $this->display();
            }
        }
        //小区视频
        public function shipin(){
            $id=I('id');
            $whrid=M('xiaoqu')->where(array('id'=>$id))->getField('whrid');
            $is_rbac = _rbac_btn_show(534,0,$whrid);
            if (!$is_rbac) {
                $this->redirect('Index/error');
            }
            if (IS_POST) {
                if (preg_match_all('/src=&quot;(.*?)&quot;/', I('shipin_url'), $matches)) {
                    $s1 = $matches[1][0];
                    $shipin_url='<iframe src="'.$s1.'" frameborder="0" allowfullscreen="true" width="100%" height="100%"></iframe>';
                }elseif (preg_match_all('/src=\'(.*?)\'/', I('shipin_url'), $matches)) {
                    $s1 = $matches[1][0];
                    $shipin_url='<iframe src="'.$s1.'" frameborder="0" allowfullscreen="true" width="100%" height="100%"></iframe>';
                }else{
                    $this->error('视频通用地址格式错误（在视频网站打开视频，点击分享，可以复制视频的通用代码）！');
                }
                $isok=M('xiaoqu')->where(array('id'=>$id))->setField('shipin_url',$shipin_url);
                if ($isok) {
                    $this->success('修改成功!');
                }else{
                    $this->error('修改失败!');
                }
            }else{
                $this->shipin_url=M('xiaoqu')->where(array('id'=>$id))->getField('shipin_url');
                $this->display();
            }
        }
    }