


local function OnTaskTick(inst, self, period)
    self:DoDec(period)
end


--
local dl = Class(function(self, inst)
	self.inst = inst
	self.current = 20
	self.max = 100

self.overridestarvefn = nil
local period = 1
self.inst:DoPeriodicTask(period, OnTaskTick, nil, self, period)
end)

function dl:DoDelta(delta)
	local oldval = self.current
	local val = self.current + delta
	if val >= self.max then
		self.current = self.max
	elseif val <= 0 then
		self.current = 0
	else
		self.current = val
	end
	local del = self.current - oldval
	self.inst:PushEvent("dl_delta", {val = self.current, oldval = oldval, delta = del})
end

--浵
function dl:OnSave()
	return 
	{
		current = self.current,
		max = self.max,
	}
end
function dl:OnLoad(data)
	if data then
		self.current = data.current
		self.max = data.max
	end
end


function dl:DoDec(dt, ignore_damage)
   

    
        if self.current > 0 then
            self:DoDelta(1 * dt * 1 * .1, true)
        elseif not ignore_damage then
            if self.overridestarvefn ~= nil then
                self.overridestarvefn(self.inst, dt)
           
            end
        end
   
end

function dl:GetPercent()
    return self.current / self.max
end


return dl