local assets=
{
	Asset("ANIM", "anim/dl.zip"),
	    
}
local UIAnim = require "widgets/uianim"
local Widget = require "widgets/widget"
local Text = require "widgets/text"

local dl = Class(Widget, function(self, owner)
	Widget._ctor(self, "dl")
	self.owner = owner

    self:SetPosition(0,60,0)

    self.point = 0
    

    self.anim = self:AddChild(UIAnim())
	self.anim:GetAnimState():SetBank("ml")
	self.anim:GetAnimState():SetBuild("dl")

    self.num = self:AddChild(Text(BODYTEXTFONT, 26))
    self.num:SetHAlign(ANCHOR_MIDDLE)
    self.num:SetPosition(3, -52, 0)

	self:StartUpdating()
end)

function dl:OnUpdate(dt)
	local newnum = self.owner.components.dl.current
	--local oldnum = self.point
	self.point = newnum
	--if newnum ~= oldnum then
		self.anim:GetAnimState():SetPercent("anim", newnum/100 * .99)
	--end

	self.num:SetString( tostring( math.ceil(newnum) ).."\0" )
end

return dl