local TUNING = GLOBAL.TUNING

TUNING.EVERGREEN_CHOPS_SMALL = GetModConfigData("EVERGREEN_CHOPS_SMALL")
TUNING.EVERGREEN_CHOPS_NORMAL = GetModConfigData("EVERGREEN_CHOPS_NORMAL")
TUNING.EVERGREEN_CHOPS_TALL = GetModConfigData("EVERGREEN_CHOPS_TALL")
TUNING.DECIDUOUS_CHOPS_SMALL = GetModConfigData("EVERGREEN_CHOPS_SMALL")
TUNING.DECIDUOUS_CHOPS_NORMAL = GetModConfigData("EVERGREEN_CHOPS_NORMAL")
TUNING.DECIDUOUS_CHOPS_TALL = GetModConfigData("EVERGREEN_CHOPS_TALL")


AddStategraphPostInit("wilson", function(sg)
	local CanEntitySeeTarget = GLOBAL.CanEntitySeeTarget

	sg.states.chop.timeline[3].fn = function(inst)
		if inst.sg.statemem.iswoodcutter and
			inst.sg.statemem.action ~= nil and
			inst.sg.statemem.action:IsValid() and
			inst.sg.statemem.action.target ~= nil and
			inst.sg.statemem.action.target.components.workable ~= nil and
			inst.sg.statemem.action.target.components.workable:CanBeWorked() and
			inst.sg.statemem.action.target:IsActionValid(inst.sg.statemem.action.action) and
			CanEntitySeeTarget(inst, inst.sg.statemem.action.target) then
			inst:ClearBufferedAction()
			inst:PushBufferedAction(inst.sg.statemem.action)
		end
	end

	sg.states.chop.timeline[7].fn = function(inst)
		if not inst.sg.statemem.iswoodcutter and
			inst.sg.statemem.action ~= nil and
			inst.sg.statemem.action:IsValid() and
			inst.sg.statemem.action.target ~= nil and
			inst.sg.statemem.action.target.components.workable ~= nil and
			inst.sg.statemem.action.target.components.workable:CanBeWorked() and
			inst.sg.statemem.action.target:IsActionValid(inst.sg.statemem.action.action) and
			CanEntitySeeTarget(inst, inst.sg.statemem.action.target) then
			inst:ClearBufferedAction()
			inst:PushBufferedAction(inst.sg.statemem.action)
		end
	end

	sg.states.mine.timeline[3].fn = function(inst)
		if inst.sg.statemem.action ~= nil and
			inst.sg.statemem.action:IsValid() and
			inst.sg.statemem.action.target ~= nil and
			inst.sg.statemem.action.target.components.workable ~= nil and
			inst.sg.statemem.action.target.components.workable:CanBeWorked() and
			inst.sg.statemem.action.target:IsActionValid(inst.sg.statemem.action.action) and
			CanEntitySeeTarget(inst, inst.sg.statemem.action.target) then
			inst:ClearBufferedAction()
			inst:PushBufferedAction(inst.sg.statemem.action)
		end
	end

	sg.states.hammer.timeline[3].fn = function(inst)
		if inst.sg.statemem.action ~= nil and
			inst.sg.statemem.action:IsValid() and
			inst.sg.statemem.action.target ~= nil and
			inst.sg.statemem.action.target.components.workable ~= nil and
			inst.sg.statemem.action.target.components.workable:CanBeWorked() and
			inst.sg.statemem.action.target:IsActionValid(inst.sg.statemem.action.action, true) and
			CanEntitySeeTarget(inst, inst.sg.statemem.action.target) then
			inst:ClearBufferedAction()
			inst:PushBufferedAction(inst.sg.statemem.action)
		end
	end

	local ACTIONS = GLOBAL.ACTIONS
	local ActionHandler = GLOBAL.ActionHandler
	local EventHandler = GLOBAL.EventHandler
	local FRAMES = GLOBAL.FRAMES
	local State = GLOBAL.State
	local TimeEvent = GLOBAL.TimeEvent

	sg.actionhandlers[ACTIONS.COOK] = ActionHandler(ACTIONS.COOK, "cooking_dolongaction")

	sg.states["cooking_dolongaction"] = State {
		name = "cooking_dolongaction",
		tags = { "doing", "busy" },

		onenter = function(inst, timeout)
			local targ = inst:GetBufferedAction() and inst:GetBufferedAction().target or nil
			if targ then targ:PushEvent("startlongaction") end

			inst.sg.statemem.action = inst.bufferedaction
			inst.sg:SetTimeout(timeout or 1)
			inst.components.locomotor:Stop()
			inst.SoundEmitter:PlaySound("dontstarve/wilson/make_trap", "make")
			inst.AnimState:PlayAnimation("build_pre")
			inst.AnimState:PushAnimation("build_loop", true)
		end,

		timeline = {
			TimeEvent(4 * FRAMES, function(inst)
				inst.sg:RemoveStateTag("busy")
			end),
		},

		ontimeout = function(inst)
			inst.SoundEmitter:KillSound("make")
			inst.AnimState:PlayAnimation("build_pst")
			inst:PerformBufferedAction()
			inst.sg.statemem.readytocook = true
		end,

		events = {
			EventHandler("animqueueover", function(inst)
				if inst.AnimState:AnimDone() then
					if inst.sg.statemem.readytocook then
						local act = inst.sg.statemem.action
						local valid_act = act and act:IsValid()
						local valid_target = valid_act and act.target and act.target:IsValid()
						local valid_invobject = valid_act and act.invobject and act.invobject:IsValid()

						if valid_act and valid_target and valid_invobject and CanEntitySeeTarget(inst, act.target) then
							inst:ClearBufferedAction()
							inst:PushBufferedAction(act)
						else
							inst.sg:GoToState("idle")
						end
					else
						inst.sg:GoToState("idle")
					end
				end
			end),
			EventHandler("newactiveitem", function(inst)
				inst.sg:GoToState("idle")
			end),
		},

		onexit = function(inst)
			inst.SoundEmitter:KillSound("make")
		end,
	}
end)