CREATE FUNCTION [dbo].[GetNames]
(
	@str nvarchar(500),
	@lang varchar(500)
)
RETURNS nvarchar(500)
AS
BEGIN
	declare @location int  
	declare @start int  
	declare @text nvarchar(500)
	set @location=charindex('||',@str)  
	if @location <> 0
		--找到存在分隔符
		begin
			if @lang = 'zh-Hans'
				--中文直接返回第一段
				begin
					set @text = substring(@str,0,@location)
				end
			else
			   begin
					set @text = ''
					while @location<>0  
						begin
							set @start=@location+1  
							set @location=charindex('||',@str,@start)
							if @location = 0 and (@lang = 'en' or @lang = 'th') and @text = ''
								begin
									set @text = substring(@str,@start+1,len(@str) - @start)
								end
							else if @location > 0 and @lang = 'en'
							    begin
									set @text = substring(@str,@start+1,@location - @start-1)
								end	 
							else if @location > 0 and @lang = 'th'
							    begin
									set @text = substring(@str,@location+2,len(@str)- @location)
								end	
						end
			   end
		end
	else
		--没找到分隔符的情况下，原字符返回
		begin
			set @text = @str
		end
return @text
END