/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.util.GDMsgFormatter;

public class GDCharCrucible {
    private static final int VERSION = 2;
    private static final int BLOCK = 10;
    private int version;
    private List<String>[] tokensPerDifficulty = new List[3];

    public GDCharCrucible() {
        for (int i = 0; i < this.tokensPerDifficulty.length; ++i) {
            this.tokensPerDifficulty[i] = new LinkedList<String>();
        }
    }

    public void read() throws IOException {
        int val = 0;
        GDReader.Block block = new GDReader.Block();
        val = GDReader.readBlockStart(block);
        if (val != 10) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.version = GDReader.readEncInt(true);
        if (this.version != 2) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        for (int i = 0; i < this.tokensPerDifficulty.length; ++i) {
            this.tokensPerDifficulty[i].clear();
            int num = GDReader.readEncInt(true);
            for (int j = 0; j < num; ++j) {
                String s = GDReader.readEncString();
                if (this.tokensPerDifficulty[i].contains(s)) continue;
                this.tokensPerDifficulty[i].add(s);
            }
        }
        GDReader.readBlockEnd(block);
    }

    public void write() throws IOException {
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 10);
        GDWriter.writeInt(this.version);
        for (int i = 0; i < this.tokensPerDifficulty.length; ++i) {
            GDWriter.writeInt(this.tokensPerDifficulty[i].size());
            for (String s : this.tokensPerDifficulty[i]) {
                GDWriter.writeString(s);
            }
        }
        GDWriter.writeBlockEnd(block);
    }

    public int getByteSize() {
        int size = 0;
        boolean val = false;
        size += 4;
        size += 4;
        size += 4;
        for (int i = 0; i < this.tokensPerDifficulty.length; ++i) {
            size += 4;
            for (String s : this.tokensPerDifficulty[i]) {
                size += 4;
                if (s == null) continue;
                size += s.length();
            }
        }
        return size += 4;
    }
}

