/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.character.GDCharFaction;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.util.GDMsgFormatter;

public class GDCharFactionList {
    private static final int VERSION = 5;
    private static final int BLOCK = 13;
    private static final int FACTION_DEVILS_CROSSING = 1;
    private static final int FACTION_AETHERIALS = 2;
    private static final int FACTION_CHTHONIANS = 3;
    private static final int FACTION_CRONLEYS_GANG = 4;
    private static final int FACTION_ROVERS = 6;
    private static final int FACTION_HOMESTEAD = 8;
    private static final int FACTION_THE_OUTCAST = 10;
    private static final int FACTION_DEATHS_VIGIL = 11;
    private static final int FACTION_UNDEAD = 12;
    private static final int FACTION_BLACK_LEGION = 13;
    private static final int FACTION_KYMONS_CHOSEN = 14;
    public static final int[] FACTIONS = new int[]{1, 6, 8, 13, 11, 14, 10, 12, 2, 3, 4};
    private int version;
    private List<GDCharFaction> factions = new LinkedList<GDCharFaction>();
    private int faction;
    protected boolean changed = false;

    public int[] getFactionReputations() {
        int[] reputations = new int[FACTIONS.length];
        int pos = 0;
        for (GDCharFaction faction : this.factions) {
            for (int i = 0; i < FACTIONS.length; ++i) {
                if (FACTIONS[i] != pos) continue;
                reputations[i] = faction.getFactionReputation();
                break;
            }
            ++pos;
        }
        return reputations;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setFactionReputations(int[] reputations) {
        int pos = 0;
        for (GDCharFaction faction : this.factions) {
            for (int i = 0; i < FACTIONS.length; ++i) {
                if (FACTIONS[i] != pos) continue;
                faction.setFactionReputation(reputations[i]);
                break;
            }
            ++pos;
        }
        this.changed = true;
    }

    public void read() throws IOException {
        int val = 0;
        GDReader.Block block = new GDReader.Block();
        val = GDReader.readBlockStart(block);
        if (val != 13) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.version = GDReader.readEncInt(true);
        if (this.version != 5) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.faction = GDReader.readEncInt(true);
        this.factions.clear();
        val = GDReader.readEncInt(true);
        for (int i = 0; i < val; ++i) {
            GDCharFaction f = new GDCharFaction();
            f.read();
            this.factions.add(f);
        }
        GDReader.readBlockEnd(block);
        this.changed = false;
    }

    public void write() throws IOException {
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 13);
        GDWriter.writeInt(5);
        GDWriter.writeInt(this.faction);
        int val = this.factions.size();
        GDWriter.writeInt(val);
        for (GDCharFaction faction : this.factions) {
            if (faction == null) continue;
            faction.write();
        }
        GDWriter.writeBlockEnd(block);
        this.changed = false;
    }

    public int getByteSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += this.factions.size() * GDCharFaction.getByteSize();
        return size += 4;
    }
}

