/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import org.gdstash.character.GDChar;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.item.GDAbstractContainer;
import org.gdstash.item.GDItem;
import org.gdstash.util.GDMsgFormatter;

public class GDCharInventorySack
extends GDAbstractContainer {
    private static final int BLOCK = 0;
    private byte tempBool;
    private GDChar gdc;
    private int sackPos;

    public GDCharInventorySack(GDChar gdc, int sackPos) {
        super(4);
        this.gdc = gdc;
        this.sackPos = sackPos;
        if (sackPos == 0) {
            this.containerType = 3;
        }
    }

    public void read() throws IOException {
        int val = 0;
        GDReader.Block block = new GDReader.Block();
        val = GDReader.readBlockStart(block);
        if (val != 0) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.tempBool = GDReader.readEncByte();
        this.items.clear();
        this.removedItems.clear();
        val = GDReader.readEncInt(true);
        for (int i = 0; i < val; ++i) {
            GDItem item = new GDItem(this.gdc.getCharName(), this.gdc.isHardcore(), 3);
            item.read();
            if (!item.hasErrors()) {
                this.items.add(item);
                continue;
            }
            this.removedItems.add(item);
        }
        GDReader.readBlockEnd(block);
        this.changed = false;
    }

    public void write() throws IOException {
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 0);
        GDWriter.writeByte(this.tempBool);
        int val = this.items.size() + this.removedItems.size();
        GDWriter.writeInt(val);
        for (GDItem item : this.items) {
            item.write();
        }
        for (GDItem item : this.removedItems) {
            item.write();
        }
        GDWriter.writeBlockEnd(block);
        this.changed = false;
    }

    public int getByteSize() {
        int size = 0;
        size += 4;
        size += 4;
        ++size;
        size += 4;
        for (GDItem item : this.items) {
            size += item.getByteSize();
        }
        for (GDItem item : this.removedItems) {
            size += item.getByteSize();
        }
        return size += 4;
    }
}

