/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharUID;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.util.GDMsgFormatter;

public class GDCharShrineList {
    private static final byte[] SHRINE_01_BURIAL_HILL = new byte[]{-102, -127, -12, 45, -87, 76, -31, 35, 71, -82, -23, -117, 40, -45, 80, 69};
    private static final byte[] SHRINE_01_DEVILS_AQUIFIER = new byte[]{97, 8, 108, -79, -49, 71, -42, -82, 79, -88, -115, -120, 45, -58, 82, 32};
    private static final byte[] SHRINE_01_WIGHTMIRE_CAVERN = new byte[]{58, -113, -123, 73, -84, 74, -91, -117, 102, -102, 124, -76, 17, 109, 33, 80};
    private static final byte[] SHRINE_01_FLOODED_PASSAGE = new byte[]{-83, 9, 86, 92, 39, 66, 43, 68, -126, 102, 64, -85, 54, 56, 123, -101};
    private static final byte[] SHRINE_01_BURIAL_CAVE = new byte[]{-54, 27, 4, 32, 54, 73, 46, 103, -105, 2, 101, -86, -100, -11, -5, 126};
    private static final byte[] SHRINE_01_BURRWITCH_ESTATES = new byte[]{-119, -19, 19, -58, 17, 73, 68, 119, -121, -27, -61, -112, -1, 7, 18, 106};
    private static final byte[] SHRINE_01_UNDERGROUND_TRANSIT = new byte[]{111, -65, 4, -14, 42, 66, 4, -81, -39, 122, -54, -122, -120, 15, -55, 10};
    private static final byte[] SHRINE_01_CRAIGS_CRAGS = new byte[]{-69, -34, -50, 89, 66, 65, 96, 114, 74, -54, 73, -87, 75, 97, 5, 16};
    private static final byte[] SHRINE_02_SPINED_COVE = new byte[]{-53, -29, 96, 55, 72, 65, 4, 31, 18, -95, 35, -108, -49, 67, -58, 51};
    private static final byte[] SHRINE_02_ROCKY_COAST = new byte[]{-99, 8, 21, 3, 33, 67, -78, 18, -57, 18, -12, -77, -40, 66, -119, 75};
    private static final byte[] SHRINE_02_CRONLEYS_HIDEOUT = new byte[]{-51, -3, -112, -122, 43, 70, 54, -47, 115, 89, 13, -67, -2, -40, 107, 61};
    private static final byte[] SHRINE_02_OLD_ARKOVIA = new byte[]{-115, 21, 10, 80, -66, 77, -86, -19, 86, -71, 57, -123, 71, 86, 77, -81};
    private static final byte[] SHRINE_02_ARKOVIAN_UNDERCITY = new byte[]{-82, 36, 110, 17, 3, 70, 67, -61, 37, 27, -73, -122, 42, 0, 78, 51};
    private static final byte[] SHRINE_02_BROKEN_HILLS = new byte[]{-99, -83, 120, 101, 6, 69, -39, -101, 125, -26, -19, -79, -61, 46, 95, -128};
    private static final byte[] SHRINE_02_STEPS_OF_TORMENT = new byte[]{50, -28, -6, 11, -81, 70, -64, 7, 77, -125, 38, -95, -70, 41, -8, -28};
    private static final byte[] SHRINE_03_MOUNTAIN_DEEPS = new byte[]{-21, 33, -60, -20, 27, 79, 55, -77, -46, 72, 50, -80, 64, -54, 41, 67};
    private static final byte[] SHRINE_03_FORGOTTEN_DEPTHS = new byte[]{62, 109, -82, -116, -18, 71, 107, -87, 34, 108, -79, -71, 72, 24, 106, 126};
    private static final byte[] SHRINE_03_TYRANTS_HOLD = new byte[]{-61, -126, -13, 108, 41, 65, 102, -96, -125, -63, -80, -76, 29, -27, -94, 42};
    private static final byte[] SHRINE_03_INFESTED_FARMS = new byte[]{-96, 78, -78, -47, -110, 67, 96, 98, -54, -36, -127, -73, -32, -110, 68, -40};
    private static final byte[] SHRINE_03_DEN_OF_THE_LOST = new byte[]{-82, -49, 65, 101, 59, 68, 119, 48, -45, 17, -13, -86, 12, 74, -57, -97};
    private static final byte[] SHRINE_03_BLOOD_GROVE = new byte[]{-27, 73, -97, -11, -114, 76, 58, 12, 22, 30, -20, -93, -10, -103, 97, -95};
    private static final byte[] SHRINE_03_VILLAGE_OF_DARKVALE = new byte[]{87, 102, 85, -2, -104, 75, -109, -56, 115, -13, 27, -71, 84, 53, 55, -86};
    private static final byte[] SHRINE_04_ASTERKARN_VALLEY = new byte[]{46, 44, 37, -84, -51, 72, 36, -65, -33, -50, -101, -112, 8, -30, -98, -87};
    private static final byte[] SHRINE_04_MOGDROGENS_SHRINE = new byte[]{13, -62, -115, 29, 40, 71, 97, 41, -22, -20, 41, -117, 4, -72, 102, 102};
    private static final byte[] SHRINE_04_TOMB_OF_THE_DAMNED = new byte[]{-125, -87, -80, -33, -51, 74, -56, 74, -30, -23, 14, -91, -85, -92, -78, -59};
    private static final byte[] SHRINE_04_GATES_OF_NECROPOLIS = new byte[]{-114, -5, -34, -106, 126, 69, -90, 49, -122, -8, -11, -120, -104, 11, 114, -112};
    private static final byte[] SHRINE_04_BLACK_SEPULCHER = new byte[]{66, -95, 91, -100, -105, 75, 62, -49, -24, -35, -97, -111, 68, -64, 24, -119};
    private static final byte[] SHRINE_04_BASTION_OF_CHAOS = new byte[]{-27, 2, 60, 14, 42, 65, -27, -102, 88, 91, 55, -121, 77, 122, 108, -86};
    private static final byte[] SHRINE_04_SANCTUM_OF_THE_IMMORTAL = new byte[]{24, -122, 98, -122, 0, 75, 72, 94, -105, -92, -26, -80, 35, 77, 77, -95};
    public static final GDCharUID UID_SHRINE_01_BURIAL_HILL = new GDCharUID(SHRINE_01_BURIAL_HILL);
    public static final GDCharUID UID_SHRINE_01_DEVILS_AQUIFIER = new GDCharUID(SHRINE_01_DEVILS_AQUIFIER);
    public static final GDCharUID UID_SHRINE_01_WIGHTMIRE_CAVERN = new GDCharUID(SHRINE_01_WIGHTMIRE_CAVERN);
    public static final GDCharUID UID_SHRINE_01_FLOODED_PASSAGE = new GDCharUID(SHRINE_01_FLOODED_PASSAGE);
    public static final GDCharUID UID_SHRINE_01_BURIAL_CAVE = new GDCharUID(SHRINE_01_BURIAL_CAVE);
    public static final GDCharUID UID_SHRINE_01_BURRWITCH_ESTATES = new GDCharUID(SHRINE_01_BURRWITCH_ESTATES);
    public static final GDCharUID UID_SHRINE_01_UNDERGROUND_TRANSIT = new GDCharUID(SHRINE_01_UNDERGROUND_TRANSIT);
    public static final GDCharUID UID_SHRINE_01_CRAIGS_CRAGS = new GDCharUID(SHRINE_01_CRAIGS_CRAGS);
    public static final GDCharUID UID_SHRINE_02_SPINED_COVE = new GDCharUID(SHRINE_02_SPINED_COVE);
    public static final GDCharUID UID_SHRINE_02_ROCKY_COAST = new GDCharUID(SHRINE_02_ROCKY_COAST);
    public static final GDCharUID UID_SHRINE_02_CRONLEYS_HIDEOUT = new GDCharUID(SHRINE_02_CRONLEYS_HIDEOUT);
    public static final GDCharUID UID_SHRINE_02_OLD_ARKOVIA = new GDCharUID(SHRINE_02_OLD_ARKOVIA);
    public static final GDCharUID UID_SHRINE_02_ARKOVIAN_UNDERCITY = new GDCharUID(SHRINE_02_ARKOVIAN_UNDERCITY);
    public static final GDCharUID UID_SHRINE_02_BROKEN_HILLS = new GDCharUID(SHRINE_02_BROKEN_HILLS);
    public static final GDCharUID UID_SHRINE_02_STEPS_OF_TORMENT = new GDCharUID(SHRINE_02_STEPS_OF_TORMENT);
    public static final GDCharUID UID_SHRINE_03_MOUNTAIN_DEEPS = new GDCharUID(SHRINE_03_MOUNTAIN_DEEPS);
    public static final GDCharUID UID_SHRINE_03_FORGOTTEN_DEPTHS = new GDCharUID(SHRINE_03_FORGOTTEN_DEPTHS);
    public static final GDCharUID UID_SHRINE_03_TYRANTS_HOLD = new GDCharUID(SHRINE_03_TYRANTS_HOLD);
    public static final GDCharUID UID_SHRINE_03_INFESTED_FARMS = new GDCharUID(SHRINE_03_INFESTED_FARMS);
    public static final GDCharUID UID_SHRINE_03_DEN_OF_THE_LOST = new GDCharUID(SHRINE_03_DEN_OF_THE_LOST);
    public static final GDCharUID UID_SHRINE_03_BLOOD_GROVE = new GDCharUID(SHRINE_03_BLOOD_GROVE);
    public static final GDCharUID UID_SHRINE_03_VILLAGE_OF_DARKVALE = new GDCharUID(SHRINE_03_VILLAGE_OF_DARKVALE);
    public static final GDCharUID UID_SHRINE_04_ASTERKARN_VALLEY = new GDCharUID(SHRINE_04_ASTERKARN_VALLEY);
    public static final GDCharUID UID_SHRINE_04_MOGDROGENS_SHRINE = new GDCharUID(SHRINE_04_MOGDROGENS_SHRINE);
    public static final GDCharUID UID_SHRINE_04_TOMB_OF_THE_DAMNED = new GDCharUID(SHRINE_04_TOMB_OF_THE_DAMNED);
    public static final GDCharUID UID_SHRINE_04_GATES_OF_NECROPOLIS = new GDCharUID(SHRINE_04_GATES_OF_NECROPOLIS);
    public static final GDCharUID UID_SHRINE_04_BLACK_SEPULCHER = new GDCharUID(SHRINE_04_BLACK_SEPULCHER);
    public static final GDCharUID UID_SHRINE_04_BASTION_OF_CHAOS = new GDCharUID(SHRINE_04_BASTION_OF_CHAOS);
    public static final GDCharUID UID_SHRINE_04_SANCTUM_OF_THE_IMMORTAL = new GDCharUID(SHRINE_04_SANCTUM_OF_THE_IMMORTAL);
    private static final int VERSION = 2;
    private static final int BLOCK = 17;
    private int version;
    private List<GDCharUID>[] uidLists = new List[6];
    private boolean changed;

    public List<GDCharUID> getDiscoveredShrinesList(int difficulty) {
        LinkedList<GDCharUID> list = new LinkedList<GDCharUID>();
        if (difficulty < 0 || difficulty > 2) {
            return list;
        }
        return this.uidLists[2 * difficulty + 1];
    }

    public List<GDCharUID> getRestoredShrinesList(int difficulty) {
        LinkedList<GDCharUID> list = new LinkedList<GDCharUID>();
        if (difficulty < 0 || difficulty > 2) {
            return list;
        }
        return this.uidLists[2 * difficulty];
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setDiscoveredShrinesList(int difficulty, List<GDCharUID> list) {
        if (difficulty < 0 || difficulty > 2) {
            return;
        }
        this.uidLists[2 * difficulty + 1] = list;
        this.changed = true;
    }

    public void setRestoredShrinesList(int difficulty, List<GDCharUID> list) {
        if (difficulty < 0 || difficulty > 2) {
            return;
        }
        this.uidLists[2 * difficulty] = list;
        this.addDiscoveredShrinesList(difficulty, list);
        this.changed = true;
    }

    private void addDiscoveredShrinesList(int difficulty, List<GDCharUID> list) {
        if (difficulty < 0 || difficulty > 2) {
            return;
        }
        List<GDCharUID> shrines = this.uidLists[2 * difficulty + 1];
        for (GDCharUID uid : list) {
            if (shrines.contains(uid)) continue;
            shrines.add(uid);
            this.changed = true;
        }
    }

    public void read() throws IOException {
        int val = 0;
        GDReader.Block block = new GDReader.Block();
        val = GDReader.readBlockStart(block);
        if (val != 17) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.version = GDReader.readEncInt(true);
        if (this.version != 2) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        for (int i = 0; i < this.uidLists.length; ++i) {
            this.uidLists[i] = new LinkedList<GDCharUID>();
            GDChar.readUIDList(this.uidLists[i]);
        }
        GDReader.readBlockEnd(block);
        this.changed = false;
    }

    public void write() throws IOException {
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 17);
        GDWriter.writeInt(2);
        for (int i = 0; i < this.uidLists.length; ++i) {
            GDChar.writeUIDList(this.uidLists[i]);
        }
        GDWriter.writeBlockEnd(block);
        this.changed = false;
    }

    public int getByteSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        for (int i = 0; i < this.uidLists.length; ++i) {
            size += 4;
            size += this.uidLists[i].size() * GDCharUID.getByteSize();
        }
        return size += 4;
    }

    public void print() {
        for (int i = 0; i < this.uidLists.length; ++i) {
            System.out.println("Index : " + Integer.toString(i));
            for (GDCharUID uid : this.uidLists[i]) {
                uid.println();
            }
            System.out.println();
        }
    }
}

